/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.menus;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.util.Iterator;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.menus.MenuBuilder;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.menus.MenuContextImpl;

public class MenuItemImpl
implements MenuItem {
    private PluginInterface pi;
    private String sMenuID;
    private String sName;
    private int style = 1;
    private boolean enabled = true;
    private Object data;
    private Graphic graphic;
    private CopyOnWriteList listeners = new CopyOnWriteList(1);
    private CopyOnWriteList m_listeners = new CopyOnWriteList(1);
    private CopyOnWriteList fill_listeners = new CopyOnWriteList(1);
    private CopyOnWriteList children = new CopyOnWriteList();
    private MenuItemImpl parent = null;
    private String display_text = null;
    private boolean visible = true;
    private MenuContextImpl menu_context = null;
    private MenuBuilder builder;

    public MenuItemImpl(PluginInterface _pi, String menuID, String key) {
        this.pi = _pi;
        if (this.pi == null) {
            this.pi = PluginInitializer.getDefaultInterface();
        }
        this.sMenuID = menuID;
        this.sName = key;
    }

    public MenuItemImpl(MenuItemImpl ti, String key) {
        this.pi = ti.pi;
        this.parent = ti;
        this.parent.addChildMenuItem(this);
        this.sMenuID = this.parent.getMenuID();
        this.sName = key;
    }

    @Override
    public String getResourceKey() {
        return this.sName;
    }

    @Override
    public String getMenuID() {
        return this.sMenuID;
    }

    @Override
    public int getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(int _style) {
        if (this.style == 5 && _style != 5) {
            throw new RuntimeException("cannot revert menu style MenuItem object to another style");
        }
        this.style = _style;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object _data) {
        this.data = _data;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean _enabled) {
        this.enabled = _enabled;
    }

    @Override
    public void setGraphic(Graphic _graphic) {
        this.graphic = _graphic;
    }

    @Override
    public Graphic getGraphic() {
        return this.graphic;
    }

    public void invokeMenuWillBeShownListeners(Object target) {
        Iterator iter = this.fill_listeners.iterator();
        while (iter.hasNext()) {
            try {
                MenuItemFillListener l = (MenuItemFillListener)iter.next();
                l.menuWillBeShown(this, target);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void addFillListener(MenuItemFillListener listener) {
        this.fill_listeners.add(listener);
    }

    @Override
    public void removeFillListener(MenuItemFillListener listener) {
        this.fill_listeners.remove(listener);
    }

    public void invokeListenersMulti(Object[] rows) {
        this.invokeListenersOnList(this.m_listeners, rows);
        if (rows == null || rows.length == 0) {
            this.invokeListenersSingle(null);
            return;
        }
        for (int i = 0; i < rows.length; ++i) {
            this.invokeListenersSingle(rows[i]);
        }
    }

    @Override
    public void addMultiListener(MenuItemListener l) {
        this.m_listeners.add(l);
    }

    @Override
    public void removeMultiListener(MenuItemListener l) {
        this.m_listeners.remove(l);
    }

    private void invokeListenersSingle(Object o) {
        this.invokeListenersOnList(this.listeners, o);
    }

    @Override
    public void addListener(MenuItemListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(MenuItemListener l) {
        this.listeners.remove(l);
    }

    @Override
    public MenuItem getParent() {
        return this.parent;
    }

    @Override
    public MenuItem[] getItems() {
        if (this.style != 5) {
            return null;
        }
        return this.children.toArray(new MenuItem[this.children.size()]);
    }

    @Override
    public MenuItem getItem(String key) {
        if (this.style != 5) {
            return null;
        }
        Iterator itr = this.children.iterator();
        MenuItem result = null;
        while (itr.hasNext()) {
            result = (MenuItem)itr.next();
            if (!key.equals(result.getResourceKey())) continue;
            return result;
        }
        return null;
    }

    private void addChildMenuItem(MenuItem child) {
        if (this.style != 5) {
            throw new RuntimeException("cannot add to non-container MenuItem");
        }
        this.children.add(child);
    }

    @Override
    public String getText() {
        if (this.display_text == null) {
            return MessageText.getString(this.getResourceKey());
        }
        return this.display_text;
    }

    @Override
    public void setText(String text) {
        this.display_text = text;
    }

    protected void invokeListenersOnList(CopyOnWriteList listeners_to_notify, Object target) {
        Iterator iter = listeners_to_notify.iterator();
        while (iter.hasNext()) {
            try {
                MenuItemListener l = (MenuItemListener)iter.next();
                l.selected(this, target);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void removeWithEvents(int root_menu_event, int sub_menu_event) {
        this.removeAllChildItems();
        if (this.parent != null) {
            UIManagerImpl.fireEvent(this.pi, sub_menu_event, new Object[]{this.parent, this});
            this.parent.children.remove(this);
            this.parent = null;
        } else {
            UIManagerImpl.fireEvent(this.pi, root_menu_event, this);
        }
        this.data = null;
        this.graphic = null;
        this.listeners.clear();
        this.fill_listeners.clear();
        this.m_listeners.clear();
        if (this.menu_context != null) {
            this.menu_context.dirty();
        }
    }

    @Override
    public void remove() {
        this.removeWithEvents(19, 20);
    }

    @Override
    public void removeAllChildItems() {
        MenuItem[] children = this.getItems();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                children[i].remove();
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isSelected() {
        if (this.style != 2 && this.style != 3) {
            throw new RuntimeException("Style is not STYLE_CHECK or STYLE_RADIO");
        }
        if (this.data == null) {
            throw new RuntimeException("Item is neither selected or deselected");
        }
        if (!(this.data instanceof Boolean)) {
            throw new RuntimeException("Invalid data assigned to menu item, should be boolean: " + this.data);
        }
        return (Boolean)this.data;
    }

    public void setContext(MenuContextImpl context2) {
        this.menu_context = context2;
    }

    @Override
    public void setSubmenuBuilder(MenuBuilder builder) {
        this.builder = builder;
    }

    public MenuBuilder getSubmenuBuilder() {
        return this.builder;
    }
}

