/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.config;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.config.ConfigSection;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ConfigSectionHolder;

public class ConfigSectionRepository {
    private static ConfigSectionRepository instance;
    private static AEMonitor class_mon;
    private Map<ConfigSection, ConfigSectionHolder> items = new LinkedHashMap<ConfigSection, ConfigSectionHolder>();

    private ConfigSectionRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigSectionRepository getInstance() {
        try {
            class_mon.enter();
            if (instance == null) {
                instance = new ConfigSectionRepository();
            }
            ConfigSectionRepository configSectionRepository = instance;
            return configSectionRepository;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConfigSection(ConfigSection item, PluginInterface pi) {
        try {
            class_mon.enter();
            this.items.put(item, new ConfigSectionHolder(item, pi));
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConfigSection(ConfigSection item) {
        try {
            class_mon.enter();
            this.items.remove(item);
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ConfigSection> getList() {
        try {
            class_mon.enter();
            ArrayList<ConfigSection> arrayList = new ArrayList<ConfigSection>(this.items.keySet());
            return arrayList;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ConfigSectionHolder> getHolderList() {
        try {
            class_mon.enter();
            ArrayList<ConfigSectionHolder> arrayList = new ArrayList<ConfigSectionHolder>(this.items.values());
            return arrayList;
        }
        finally {
            class_mon.exit();
        }
    }

    static {
        class_mon = new AEMonitor("ConfigSectionRepository:class");
    }
}

