/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.components;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.plugins.ui.components.UIPropertyChangeListener;
import org.gudy.azureus2.plugins.ui.components.UITextArea;
import org.gudy.azureus2.pluginsimpl.local.ui.components.UIComponentImpl;

public class UITextAreaImpl
extends UIComponentImpl
implements UITextArea {
    private final boolean enable_history = System.getProperty("az.logging.keep.ui.history", "true").equals("true");
    private int max_size = 60000;
    private int max_file_size = 20 * this.max_size;
    PoopWriter pw;
    int current_file_size;
    File poop_file;
    boolean useFile = true;
    AEMonitor file_mon = new AEMonitor("filemon");
    LinkedList<String> delay_text = new LinkedList();
    int delay_size = 0;
    FrequencyLimitedDispatcher dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        @Override
        public void runSupport() {
            UITextAreaImpl.this.delayAppend();
        }
    }, 500);

    public UITextAreaImpl() {
        this.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setText(String text) {
        if (!this.enable_history) {
            return;
        }
        if (this.useFile) {
            try {
                this.file_mon.enter();
                if (this.pw == null) {
                    this.pw = new PoopWriter();
                    this.pw.print(text);
                    this.current_file_size = text.length();
                    return;
                }
            }
            finally {
                this.file_mon.exit();
            }
        }
        if (text.length() > this.max_size) {
            int size_to_show = this.max_size - 10000;
            if (size_to_show < 0) {
                size_to_show = this.max_size;
            }
            text = text.substring(text.length() - size_to_show);
        }
        this.setProperty("value", text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendText(String text) {
        if (!this.enable_history) {
            return;
        }
        if (this.useFile && this.pw != null) {
            try {
                this.file_mon.enter();
                if (this.current_file_size > this.max_file_size) {
                    this.current_file_size = this.getFileText().length();
                }
                this.pw.print(text);
                this.current_file_size += text.length();
                return;
            }
            finally {
                this.file_mon.exit();
            }
        }
        UITextAreaImpl uITextAreaImpl = this;
        synchronized (uITextAreaImpl) {
            this.delay_text.addLast(text);
            this.delay_size += text.length();
            while (this.delay_size > this.max_size && this.delay_text.size() != 0) {
                String s = this.delay_text.removeFirst();
                this.delay_size -= s.length();
            }
        }
        this.dispatcher.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delayAppend() {
        String text;
        String str = this.getText();
        UITextAreaImpl uITextAreaImpl = this;
        synchronized (uITextAreaImpl) {
            if (this.delay_text.size() == 1) {
                text = this.delay_text.get(0);
            } else {
                StringBuilder sb = new StringBuilder(this.delay_size);
                Iterator it = this.delay_text.iterator();
                while (it.hasNext()) {
                    sb.append((String)it.next());
                }
                text = sb.toString();
            }
            this.delay_text.clear();
            this.delay_size = 0;
        }
        if (str == null) {
            this.setText(text);
        } else {
            this.setText(str + text);
        }
    }

    @Override
    public String getText() {
        if (!this.enable_history) {
            return "";
        }
        if (this.useFile && this.pw != null) {
            return this.getFileText();
        }
        return (String)this.getProperty("value");
    }

    @Override
    public void setMaximumSize(int _max_size) {
        this.max_size = _max_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileText() {
        try {
            this.file_mon.enter();
            String text = null;
            if (this.pw != null) {
                this.pw.close();
                text = this.pw.getText();
            }
            if (text == null) {
                text = "";
            }
            this.pw = null;
            if (this.useFile) {
                this.pw = new PoopWriter();
                this.pw.print(text);
                this.current_file_size = text.length();
            }
            String string = text;
            return string;
        }
        finally {
            this.file_mon.exit();
        }
    }

    @Override
    public void addPropertyChangeListener(UIPropertyChangeListener l) {
        if (this.useFile) {
            this.useFile = false;
            this.setText(this.getFileText());
        }
        super.addPropertyChangeListener(l);
    }

    protected class PoopWriter {
        private StringBuffer buffer = new StringBuffer(256);
        private PrintWriter pw;

        protected PoopWriter() {
        }

        private void print(String text) {
            if (this.pw == null) {
                this.buffer.append(text);
                if (this.buffer.length() > 8192) {
                    if (UITextAreaImpl.this.poop_file == null) {
                        try {
                            UITextAreaImpl.this.poop_file = AETemporaryFileHandler.createTempFile();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    if (UITextAreaImpl.this.poop_file != null) {
                        try {
                            this.pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(UITextAreaImpl.this.poop_file), "UTF-8"));
                            this.pw.print(this.buffer.toString());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    this.buffer.setLength(0);
                }
            } else {
                this.pw.print(text);
            }
        }

        private String getText() {
            if (UITextAreaImpl.this.poop_file == null) {
                return this.buffer.toString();
            }
            try {
                return FileUtil.readFileEndAsString(UITextAreaImpl.this.poop_file, UITextAreaImpl.this.max_size, "UTF-8");
            }
            catch (Throwable e) {
                return "";
            }
        }

        private void close() {
            if (this.pw != null) {
                this.pw.close();
                this.pw = null;
            }
        }
    }
}

