/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.tracker.host.TRHostAuthenticationListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerListener2;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageGenerator;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWebPageRequestImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWebPageResponseImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public abstract class TrackerWCHelper
implements TrackerWebContext,
TRHostAuthenticationListener {
    private PluginInterface plugin_interface;
    private Tracker tracker;
    private List generators = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("TrackerWCHelper");

    protected TrackerWCHelper() {
        this.plugin_interface = UtilitiesImpl.getPluginThreadContext();
    }

    protected void setTracker(Tracker _tracker) {
        this.tracker = _tracker;
    }

    public boolean handleExternalRequest(final TRTrackerServerListener2.ExternalRequest external_request) throws IOException {
        return UtilitiesImpl.callWithPluginThreadContext(this.plugin_interface, new UtilitiesImpl.runnableWithReturnAndException<Boolean, IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean run() throws IOException {
                TrackerWebPageRequestImpl request2 = new TrackerWebPageRequestImpl(TrackerWCHelper.this.tracker, TrackerWCHelper.this, external_request);
                TrackerWebPageResponseImpl reply = new TrackerWebPageResponseImpl(request2);
                for (int i = 0; i < TrackerWCHelper.this.generators.size(); ++i) {
                    TrackerWebPageGenerator generator;
                    try {
                        TrackerWCHelper.this.this_mon.enter();
                        if (i >= TrackerWCHelper.this.generators.size()) break;
                        generator = (TrackerWebPageGenerator)TrackerWCHelper.this.generators.get(i);
                    }
                    finally {
                        TrackerWCHelper.this.this_mon.exit();
                    }
                    if (!generator.generate(request2, reply)) continue;
                    reply.complete();
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public TrackerWebPageGenerator[] getPageGenerators() {
        TrackerWebPageGenerator[] res = new TrackerWebPageGenerator[this.generators.size()];
        this.generators.toArray(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPageGenerator(TrackerWebPageGenerator generator) {
        try {
            this.this_mon.enter();
            this.generators.add(generator);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePageGenerator(TrackerWebPageGenerator generator) {
        try {
            this.this_mon.enter();
            this.generators.remove(generator);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void destroy() {
        this.generators.clear();
    }
}

