/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.tracker;

import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.tracker.host.TRHost;
import org.gudy.azureus2.core3.tracker.host.TRHostAuthenticationListener;
import org.gudy.azureus2.core3.tracker.host.TRHostFactory;
import org.gudy.azureus2.core3.tracker.host.TRHostListener2;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.TrackerListener;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationAdapter;
import org.gudy.azureus2.plugins.tracker.web.TrackerAuthenticationListener;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebContext;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerTorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWCHelper;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerWebContextImpl;

public class TrackerImpl
extends TrackerWCHelper
implements Tracker,
TRHostListener2,
TRHostAuthenticationListener {
    private static TrackerImpl singleton;
    private static AEMonitor class_mon;
    private List listeners = new ArrayList();
    private TRHost host;
    private List<TrackerAuthenticationListener> auth_listeners = new ArrayList<TrackerAuthenticationListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tracker getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TrackerImpl(TRHostFactory.getSingleton());
            }
            TrackerImpl trackerImpl = singleton;
            return trackerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected TrackerImpl(TRHost _host) {
        this.setTracker(this);
        this.host = _host;
        this.host.addListener2(this);
    }

    @Override
    public String getName() {
        return this.host.getName();
    }

    @Override
    public void setEnableKeepAlive(boolean enable) {
        Debug.out("Keep alive setting ignored for tracker");
    }

    @Override
    public URL[] getURLs() {
        URL[][] url_sets = TRTrackerUtils.getAnnounceURLs();
        URL[] res = new URL[url_sets.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = url_sets[i][0];
        }
        return res;
    }

    @Override
    public InetAddress getBindIP() {
        return this.host.getBindIP();
    }

    @Override
    public TrackerTorrent host(Torrent _torrent, boolean _persistent) throws TrackerException {
        return this.host(_torrent, _persistent, false);
    }

    @Override
    public TrackerTorrent host(Torrent _torrent, boolean _persistent, boolean _passive) throws TrackerException {
        TorrentImpl torrent = (TorrentImpl)_torrent;
        try {
            return new TrackerTorrentImpl(this.host.hostTorrent(torrent.getTorrent(), _persistent, _passive));
        }
        catch (Throwable e) {
            throw new TrackerException("Tracker: host operation fails", e);
        }
    }

    @Override
    public TrackerTorrent publish(Torrent _torrent) throws TrackerException {
        TorrentImpl torrent = (TorrentImpl)_torrent;
        try {
            return new TrackerTorrentImpl(this.host.publishTorrent(torrent.getTorrent()));
        }
        catch (Throwable e) {
            throw new TrackerException("Tracker: publish operation fails", e);
        }
    }

    @Override
    public TrackerTorrent[] getTorrents() {
        TRHostTorrent[] hts = this.host.getTorrents();
        TrackerTorrent[] res = new TrackerTorrent[hts.length];
        for (int i = 0; i < hts.length; ++i) {
            res[i] = new TrackerTorrentImpl(hts[i]);
        }
        return res;
    }

    @Override
    public TrackerTorrent getTorrent(Torrent torrent) {
        TRHostTorrent ht = this.host.getHostTorrent(((TorrentImpl)torrent).getTorrent());
        if (ht == null) {
            return null;
        }
        return new TrackerTorrentImpl(ht);
    }

    @Override
    public TrackerWebContext createWebContext(int port, int protocol) throws TrackerException {
        return new TrackerWebContextImpl(this, null, port, protocol, null, null);
    }

    @Override
    public TrackerWebContext createWebContext(String name, int port, int protocol) throws TrackerException {
        return new TrackerWebContextImpl(this, name, port, protocol, null, null);
    }

    @Override
    public TrackerWebContext createWebContext(String name, int port, int protocol, InetAddress bind_ip) throws TrackerException {
        return new TrackerWebContextImpl(this, name, port, protocol, bind_ip, null);
    }

    @Override
    public TrackerWebContext createWebContext(String name, int port, int protocol, InetAddress bind_ip, Map<String, Object> properties) throws TrackerException {
        return new TrackerWebContextImpl(this, name, port, protocol, bind_ip, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void torrentAdded(TRHostTorrent t) {
        try {
            this.this_mon.enter();
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TrackerListener)this.listeners.get(i)).torrentAdded(new TrackerTorrentImpl(t));
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void torrentChanged(TRHostTorrent t) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TrackerListener)this.listeners.get(i)).torrentChanged(new TrackerTorrentImpl(t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void torrentRemoved(TRHostTorrent t) {
        try {
            this.this_mon.enter();
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((TrackerListener)this.listeners.get(i)).torrentRemoved(new TrackerTorrentImpl(t));
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(TrackerListener listener) {
        try {
            this.this_mon.enter();
            this.listeners.add(listener);
            TrackerTorrent[] torrents = this.getTorrents();
            for (int i = 0; i < torrents.length; ++i) {
                listener.torrentAdded(torrents[i]);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(TrackerListener listener) {
        try {
            this.this_mon.enter();
            this.listeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public boolean authenticate(String headers, URL resource, String user, String password) {
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                TrackerAuthenticationListener listener = this.auth_listeners.get(i);
                boolean res = listener instanceof TrackerAuthenticationAdapter ? ((TrackerAuthenticationAdapter)listener).authenticate(headers, resource, user, password) : listener.authenticate(resource, user, password);
                if (!res) continue;
                return true;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return false;
    }

    @Override
    public byte[] authenticate(URL resource, String user) {
        for (int i = 0; i < this.auth_listeners.size(); ++i) {
            try {
                byte[] res = this.auth_listeners.get(i).authenticate(resource, user);
                if (res == null) continue;
                return res;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAuthenticationListener(TrackerAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.add(l);
            if (this.auth_listeners.size() == 1) {
                this.host.addAuthenticationListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAuthenticationListener(TrackerAuthenticationListener l) {
        try {
            this.this_mon.enter();
            this.auth_listeners.remove(l);
            if (this.auth_listeners.size() == 0) {
                this.host.removeAuthenticationListener(this);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.auth_listeners.clear();
        this.host.removeAuthenticationListener(this);
        this.listeners.clear();
        this.host.close();
    }

    static {
        class_mon = new AEMonitor("Tracker");
    }
}

