/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.torrent;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenOptions;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentCreator;
import org.gudy.azureus2.plugins.torrent.TorrentCreatorListener;
import org.gudy.azureus2.plugins.torrent.TorrentDownloader;
import org.gudy.azureus2.plugins.torrent.TorrentEncodingException;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.torrent.TorrentManagerEvent;
import org.gudy.azureus2.plugins.torrent.TorrentManagerListener;
import org.gudy.azureus2.plugins.torrent.TorrentOptions;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeCategoryImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeDisplayNameImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeNetworksImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributePeerSourcesImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributePluginImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeRelativeSavePathImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeSharePropertiesImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeTrackerClientExtImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentAttributeUserCommentImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentDownloaderImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class TorrentManagerImpl
implements TorrentManager,
TOTorrentProgressListener {
    private static TorrentManagerImpl singleton;
    private static AEMonitor class_mon;
    private static TorrentAttribute category_attribute;
    private static TorrentAttribute share_properties_attribute;
    private static TorrentAttribute networks_attribute;
    private static TorrentAttribute peer_sources_attribute;
    private static TorrentAttribute tr_ext_attribute;
    private static TorrentAttribute disp_name_attribute;
    private static TorrentAttribute comment_attribute;
    private static TorrentAttribute relative_save_path_attribute;
    private static Map<String, TorrentAttribute> attribute_map;
    protected static CopyOnWriteList<TorrentManagerListener> listeners;
    protected PluginInterface plugin_interface;
    private Map<TorrentOpenOptions, TorrentOptionsImpl> too_state = new HashMap<TorrentOpenOptions, TorrentOptionsImpl>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TorrentManagerImpl getSingleton() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TorrentManagerImpl(null);
            }
            TorrentManagerImpl torrentManagerImpl = singleton;
            return torrentManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected TorrentManagerImpl(PluginInterface _pi) {
        this.plugin_interface = _pi;
    }

    public TorrentManager specialise(PluginInterface _pi) {
        return new TorrentManagerImpl(_pi);
    }

    @Override
    public TorrentDownloader getURLDownloader(URL url) throws TorrentException {
        return new TorrentDownloaderImpl(this, url);
    }

    @Override
    public TorrentDownloader getURLDownloader(URL url, String user_name, String password) throws TorrentException {
        return new TorrentDownloaderImpl(this, url, user_name, password);
    }

    @Override
    public Torrent createFromBEncodedFile(File file) throws TorrentException {
        return this.createFromBEncodedFile(file, false);
    }

    @Override
    public Torrent createFromBEncodedFile(File file, boolean for_seeding) throws TorrentException {
        try {
            TOTorrent torrent = for_seeding ? TorrentUtils.readFromFile(file, true, true) : TorrentUtils.readFromFile(file, false);
            return new TorrentImpl(this.plugin_interface, torrent);
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromBEncodedFile Fails", e);
        }
    }

    @Override
    public Torrent createFromBEncodedInputStream(InputStream data) throws TorrentException {
        try {
            return new TorrentImpl(this.plugin_interface, TorrentUtils.readFromBEncodedInputStream(data));
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromBEncodedFile Fails", e);
        }
    }

    @Override
    public Torrent createFromBEncodedData(byte[] data) throws TorrentException {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(data);
            TorrentImpl torrentImpl = new TorrentImpl(this.plugin_interface, TorrentUtils.readFromBEncodedInputStream(is));
            return torrentImpl;
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromBEncodedData Fails", e);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public Torrent createFromDataFile(File data, URL announce_url) throws TorrentException {
        return this.createFromDataFile(data, announce_url, false);
    }

    @Override
    public Torrent createFromDataFile(File data, URL announce_url, boolean include_other_hashes) throws TorrentException {
        try {
            TOTorrentCreator c = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(data, announce_url, include_other_hashes);
            c.addListener(this);
            return new TorrentImpl(this.plugin_interface, c.create());
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromDataFile Fails", e);
        }
    }

    @Override
    public TorrentCreator createFromDataFileEx(File data, URL announce_url, boolean include_other_hashes) throws TorrentException {
        try {
            final TOTorrentCreator c = TOTorrentFactory.createFromFileOrDirWithComputedPieceLength(data, announce_url, include_other_hashes);
            return new TorrentCreator(){
                private CopyOnWriteList<TorrentCreatorListener> listeners = new CopyOnWriteList();

                @Override
                public void start() {
                    c.addListener(new TOTorrentProgressListener(){

                        @Override
                        public void reportProgress(int percent_complete) {
                            Iterator it = listeners.iterator();
                            while (it.hasNext()) {
                                ((TorrentCreatorListener)it.next()).reportPercentageDone(percent_complete);
                            }
                        }

                        @Override
                        public void reportCurrentTask(String task_description) {
                            Iterator it = listeners.iterator();
                            while (it.hasNext()) {
                                ((TorrentCreatorListener)it.next()).reportActivity(task_description);
                            }
                        }
                    });
                    new AEThread2("TorrentManager::create"){

                        @Override
                        public void run() {
                            try {
                                TOTorrent t = c.create();
                                TorrentImpl torrent = new TorrentImpl(TorrentManagerImpl.this.plugin_interface, t);
                                Iterator it = listeners.iterator();
                                while (it.hasNext()) {
                                    ((TorrentCreatorListener)it.next()).complete(torrent);
                                }
                            }
                            catch (TOTorrentException e) {
                                Iterator it = listeners.iterator();
                                while (it.hasNext()) {
                                    ((TorrentCreatorListener)it.next()).failed(new TorrentException(e));
                                }
                            }
                        }
                    }.start();
                }

                @Override
                public void cancel() {
                    c.cancel();
                }

                @Override
                public void addListener(TorrentCreatorListener listener) {
                    this.listeners.add(listener);
                }

                @Override
                public void removeListener(TorrentCreatorListener listener) {
                    this.listeners.remove(listener);
                }
            };
        }
        catch (TOTorrentException e) {
            throw new TorrentException("TorrentManager::createFromDataFile Fails", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TorrentAttribute[] getDefinedAttributes() {
        try {
            class_mon.enter();
            Collection<TorrentAttribute> entries = attribute_map.values();
            TorrentAttribute[] res = new TorrentAttribute[entries.size()];
            entries.toArray(res);
            TorrentAttribute[] torrentAttributeArray = res;
            return torrentAttributeArray;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TorrentAttribute getAttribute(String name) {
        try {
            class_mon.enter();
            TorrentAttribute res = attribute_map.get(name);
            if (res == null && name.startsWith("Plugin.")) {
                res = new TorrentAttributePluginImpl(name);
                attribute_map.put(name, res);
            }
            if (res == null) {
                throw new IllegalArgumentException("No such attribute: \"" + name + "\"");
            }
            TorrentAttribute torrentAttribute = res;
            return torrentAttribute;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TorrentAttribute getPluginAttribute(String name) {
        name = "Plugin." + this.plugin_interface.getPluginID() + "." + name;
        try {
            class_mon.enter();
            TorrentAttribute res = attribute_map.get(name);
            if (res != null) {
                TorrentAttribute torrentAttribute = res;
                return torrentAttribute;
            }
            res = new TorrentAttributePluginImpl(name);
            attribute_map.put(name, res);
            TorrentAttribute torrentAttribute = res;
            return torrentAttribute;
        }
        finally {
            class_mon.exit();
        }
    }

    @Override
    public Torrent createFromBEncodedData(byte[] data, int preserve) throws TorrentException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(bais);
            TorrentImpl torrentImpl = new TorrentImpl(this.plugin_interface, this.preserveFields(torrent, preserve));
            return torrentImpl;
        }
        catch (TOTorrentException e) {
            throw new TorrentException("Failed to read TorrentData", e);
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException e) {}
        }
    }

    @Override
    public Torrent createFromBEncodedFile(File file, int preserve) throws TorrentException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(fis);
            TorrentImpl torrentImpl = new TorrentImpl(this.plugin_interface, this.preserveFields(torrent, preserve));
            return torrentImpl;
        }
        catch (FileNotFoundException e) {
            throw new TorrentException("Failed to read from TorrentFile", e);
        }
        catch (TOTorrentException e) {
            throw new TorrentException("Failed to read TorrentData", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public Torrent createFromBEncodedInputStream(InputStream data, int preserve) throws TorrentException {
        try {
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedInputStream(data);
            return new TorrentImpl(this.plugin_interface, this.preserveFields(torrent, preserve));
        }
        catch (TOTorrentException e) {
            throw new TorrentException("Failed to read TorrentData", e);
        }
    }

    private TOTorrent preserveFields(TOTorrent torrent, int preserve) {
        if (preserve == -1) {
            return torrent;
        }
        if ((preserve & 1) > 0) {
            String encoding = torrent.getAdditionalStringProperty("encoding");
            torrent.removeAdditionalProperties();
            if (encoding != null) {
                torrent.setAdditionalStringProperty("encoding", encoding);
            }
        } else if (preserve == 0) {
            torrent.removeAdditionalProperties();
        }
        return torrent;
    }

    @Override
    public void reportProgress(int percent_complete) {
    }

    @Override
    public void reportCurrentTask(final String task_description) {
        Iterator<TorrentManagerListener> it = listeners.iterator();
        while (it.hasNext()) {
            it.next().event(new TorrentManagerEvent(){

                @Override
                public int getType() {
                    return 1;
                }

                @Override
                public Object getData() {
                    return task_description;
                }
            });
        }
    }

    protected void tryToSetTorrentEncoding(TOTorrent torrent, String encoding) throws TorrentEncodingException {
        try {
            LocaleTorrentUtil.setTorrentEncoding(torrent, encoding);
        }
        catch (LocaleUtilEncodingException e) {
            String[] charsets = e.getValidCharsets();
            if (charsets == null) {
                throw new TorrentEncodingException("Failed to set requested encoding", e);
            }
            throw new TorrentEncodingException(charsets, e.getValidTorrentNames());
        }
    }

    protected void tryToSetDefaultTorrentEncoding(TOTorrent torrent) throws TorrentException {
        try {
            LocaleTorrentUtil.setDefaultTorrentEncoding(torrent);
        }
        catch (LocaleUtilEncodingException e) {
            String[] charsets = e.getValidCharsets();
            if (charsets == null) {
                throw new TorrentEncodingException("Failed to set default encoding", e);
            }
            throw new TorrentEncodingException(charsets, e.getValidTorrentNames());
        }
    }

    private void fireEvent(final int type, final Object data) {
        TorrentManagerEvent ev = new TorrentManagerEvent(){

            @Override
            public int getType() {
                return type;
            }

            @Override
            public Object getData() {
                return data;
            }
        };
        for (TorrentManagerListener l : listeners) {
            try {
                l.event(ev);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionsAdded(TorrentOpenOptions options) {
        TorrentOptionsImpl my_options = new TorrentOptionsImpl(options);
        Map<TorrentOpenOptions, TorrentOptionsImpl> map = this.too_state;
        synchronized (map) {
            this.too_state.put(options, my_options);
            this.fireEvent(2, my_options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionsAccepted(TorrentOpenOptions options) {
        Map<TorrentOpenOptions, TorrentOptionsImpl> map = this.too_state;
        synchronized (map) {
            TorrentOptionsImpl my_options = this.too_state.remove(options);
            if (my_options != null) {
                this.fireEvent(3, my_options);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optionsRemoved(TorrentOpenOptions options) {
        Map<TorrentOpenOptions, TorrentOptionsImpl> map = this.too_state;
        synchronized (map) {
            TorrentOptionsImpl my_options = this.too_state.remove(options);
            if (my_options != null) {
                this.fireEvent(4, my_options);
            }
        }
    }

    @Override
    public void addListener(TorrentManagerListener l) {
        listeners.add(l);
    }

    @Override
    public void removeListener(TorrentManagerListener l) {
        listeners.remove(l);
    }

    static {
        class_mon = new AEMonitor("TorrentManager");
        category_attribute = new TorrentAttributeCategoryImpl();
        share_properties_attribute = new TorrentAttributeSharePropertiesImpl();
        networks_attribute = new TorrentAttributeNetworksImpl();
        peer_sources_attribute = new TorrentAttributePeerSourcesImpl();
        tr_ext_attribute = new TorrentAttributeTrackerClientExtImpl();
        disp_name_attribute = new TorrentAttributeDisplayNameImpl();
        comment_attribute = new TorrentAttributeUserCommentImpl();
        relative_save_path_attribute = new TorrentAttributeRelativeSavePathImpl();
        attribute_map = new HashMap<String, TorrentAttribute>();
        attribute_map.put("Category", category_attribute);
        attribute_map.put("ShareProperties", share_properties_attribute);
        attribute_map.put("Networks", networks_attribute);
        attribute_map.put("PeerSources", peer_sources_attribute);
        attribute_map.put("TrackerClientExtensions", tr_ext_attribute);
        attribute_map.put("DisplayName", disp_name_attribute);
        attribute_map.put("UserComment", comment_attribute);
        attribute_map.put("RelativePath", relative_save_path_attribute);
        listeners = new CopyOnWriteList();
    }

    private static class TorrentOptionsImpl
    implements TorrentOptions {
        private TorrentOpenOptions options;

        private TorrentOptionsImpl(TorrentOpenOptions _options) {
            this.options = _options;
        }

        @Override
        public Torrent getTorrent() {
            return PluginCoreUtils.wrap(this.options.getTorrent());
        }

        @Override
        public void accept() {
            this.options.setCompleteAction(1);
        }

        @Override
        public void cancel() {
            this.options.setCompleteAction(2);
        }

        @Override
        public List<org.gudy.azureus2.plugins.tag.Tag> getTags() {
            ArrayList<org.gudy.azureus2.plugins.tag.Tag> tags = new ArrayList<org.gudy.azureus2.plugins.tag.Tag>(this.options.getInitialTags());
            return tags;
        }

        @Override
        public void addTag(org.gudy.azureus2.plugins.tag.Tag tag) {
            List<Tag> tags = this.options.getInitialTags();
            if (!tags.contains(tag)) {
                tags.add((Tag)tag);
                this.options.setInitialTags(tags);
                this.options.setDirty();
            }
        }

        @Override
        public void removeTag(org.gudy.azureus2.plugins.tag.Tag tag) {
            List<Tag> tags = this.options.getInitialTags();
            if (tags.contains(tag)) {
                tags.remove((Tag)tag);
                this.options.setInitialTags(tags);
                this.options.setDirty();
            }
        }
    }
}

