/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;
import org.gudy.azureus2.plugins.sharing.ShareResourceListener;
import org.gudy.azureus2.plugins.sharing.ShareResourceWillBeDeletedListener;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceImpl;

public class ShareResourceDirContentsImpl
extends ShareResourceImpl
implements ShareResourceDirContents {
    private final File root;
    private final boolean recursive;
    private final Map<String, String> properties;
    private final byte[] personal_key;
    protected ShareResource[] children = new ShareResource[0];

    protected ShareResourceDirContentsImpl(ShareManagerImpl _manager, File _dir, boolean _recursive, boolean _personal, Map<String, String> _properties, boolean _async_check) throws ShareException {
        super(_manager, 3);
        this.root = _dir;
        this.recursive = _recursive;
        this.properties = _properties;
        if (!this.root.exists()) {
            throw new ShareException("Dir '" + this.root.getName() + "' not found");
        }
        if (this.root.isFile()) {
            throw new ShareException("Not a directory");
        }
        Object object = this.personal_key = (Object)(_personal ? RandomUtils.nextSecureHash() : null);
        if (_async_check) {
            new AEThread2("SM:asyncCheck", true){

                @Override
                public void run() {
                    try {
                        ShareResourceDirContentsImpl.this.checkConsistency();
                    }
                    catch (Throwable e) {
                        Debug.out("Failed to update consistency", e);
                    }
                }
            }.start();
        } else {
            this.checkConsistency();
        }
    }

    protected ShareResourceDirContentsImpl(ShareManagerImpl _manager, File _dir, boolean _recursive, Map _map) throws ShareException {
        super(_manager, 3, _map);
        this.root = _dir;
        this.recursive = _recursive;
        if (!this.root.exists()) {
            Debug.out("Dir '" + this.root.getName() + "' not found");
        } else if (this.root.isFile()) {
            throw new ShareException("Not a directory");
        }
        this.personal_key = (byte[])_map.get("per_key");
        this.properties = BDecoder.decodeStrings((Map)_map.get("props"));
    }

    @Override
    public boolean canBeDeleted() throws ShareResourceDeletionVetoException {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i].canBeDeleted()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void checkConsistency() throws ShareException {
        List kids = this.checkConsistency(this.root);
        if (kids != null) {
            this.children = new ShareResource[kids.size()];
            kids.toArray(this.children);
        } else {
            this.children = new ShareResource[0];
        }
    }

    protected List checkConsistency(File dir) throws ShareException {
        ArrayList<ShareResource> kids = new ArrayList<ShareResource>();
        File[] files = dir.listFiles();
        if (files == null || !dir.exists()) {
            if (!this.isPersistent()) {
                if (dir == this.root) {
                    return null;
                }
                this.manager.delete(this, true);
            }
        } else {
            int i;
            for (i = 0; i < files.length; ++i) {
                ShareResource res;
                File file = files[i];
                String file_name = file.getName();
                if (file_name.equals(".") || file_name.equals("..")) continue;
                if (file.isDirectory()) {
                    if (this.recursive) {
                        List child = this.checkConsistency(file);
                        kids.add(new shareNode(this, file, child));
                        continue;
                    }
                    try {
                        res = this.manager.getDir(file);
                        if (res == null) {
                            res = this.manager.addDir(this, file, this.personal_key != null, this.properties);
                        }
                        kids.add(res);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    continue;
                }
                try {
                    res = this.manager.getFile(file);
                    if (res == null) {
                        res = this.manager.addFile(this, file, this.personal_key != null, this.properties);
                    }
                    kids.add(res);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            for (i = 0; i < kids.size(); ++i) {
                Object o = kids.get(i);
                if (o instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)o).setParent(this);
                    continue;
                }
                ((shareNode)o).setParent(this);
            }
        }
        return kids;
    }

    @Override
    protected void deleteInternal() {
        for (int i = 0; i < this.children.length; ++i) {
            try {
                if (this.children[i] instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)this.children[i]).delete(true);
                    continue;
                }
                ((shareNode)this.children[i]).delete(true);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    protected void serialiseResource(Map map) {
        super.serialiseResource(map);
        map.put("type", new Long(this.getType()));
        map.put("recursive", new Long(this.recursive ? 1L : 0L));
        try {
            map.put("file", this.root.toString().getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
        }
        if (this.personal_key != null) {
            map.put("per_key", this.personal_key);
        }
        if (this.properties != null) {
            map.put("props", this.properties);
        }
    }

    protected static ShareResourceImpl deserialiseResource(ShareManagerImpl manager, Map map) throws ShareException {
        try {
            File root = new File(new String((byte[])map.get("file"), "UTF8"));
            boolean recursive = (Long)map.get("recursive") == 1L;
            ShareResourceDirContentsImpl res = new ShareResourceDirContentsImpl(manager, root, recursive, map);
            return res;
        }
        catch (UnsupportedEncodingException e) {
            throw new ShareException("internal error", e);
        }
    }

    @Override
    public String getName() {
        return this.root.toString();
    }

    @Override
    public File getRoot() {
        return this.root;
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public ShareResource[] getChildren() {
        return this.children;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    protected class shareNode
    implements ShareResourceDirContents {
        protected ShareResourceDirContents node_parent;
        protected File node;
        protected ShareResource[] node_children;

        protected shareNode(ShareResourceDirContents _parent, File _node, List kids) {
            this.node_parent = _parent;
            this.node = _node;
            this.node_children = new ShareResource[kids.size()];
            kids.toArray(this.node_children);
            for (int i = 0; i < this.node_children.length; ++i) {
                ShareResource o = this.node_children[i];
                if (o instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)o).setParent(this);
                    continue;
                }
                ((shareNode)o).setParent(this);
            }
        }

        @Override
        public ShareResourceDirContents getParent() {
            return this.node_parent;
        }

        protected void setParent(ShareResourceDirContents _parent) {
            this.node_parent = _parent;
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public String getName() {
            return this.node.toString();
        }

        @Override
        public void setAttribute(TorrentAttribute attribute, String value) {
            for (int i = 0; i < this.node_children.length; ++i) {
                this.node_children[i].setAttribute(attribute, value);
            }
        }

        @Override
        public String getAttribute(TorrentAttribute attribute) {
            return null;
        }

        @Override
        public TorrentAttribute[] getAttributes() {
            return new TorrentAttribute[0];
        }

        @Override
        public void delete() throws ShareResourceDeletionVetoException {
            throw new ShareResourceDeletionVetoException(MessageText.getString("plugin.sharing.remove.veto"));
        }

        @Override
        public void delete(boolean force) throws ShareException, ShareResourceDeletionVetoException {
            for (int i = 0; i < this.node_children.length; ++i) {
                ShareResource o = this.node_children[i];
                if (o instanceof ShareResourceImpl) {
                    ((ShareResourceImpl)o).delete(force);
                    continue;
                }
                ((shareNode)o).delete(force);
            }
        }

        @Override
        public boolean canBeDeleted() throws ShareResourceDeletionVetoException {
            for (int i = 0; i < this.node_children.length; ++i) {
                this.node_children[i].canBeDeleted();
            }
            return true;
        }

        @Override
        public File getRoot() {
            return this.node;
        }

        @Override
        public boolean isRecursive() {
            return ShareResourceDirContentsImpl.this.recursive;
        }

        @Override
        public ShareResource[] getChildren() {
            return this.node_children;
        }

        @Override
        public Map<String, String> getProperties() {
            return null;
        }

        @Override
        public boolean isPersistent() {
            return false;
        }

        @Override
        public void addChangeListener(ShareResourceListener l) {
        }

        @Override
        public void removeChangeListener(ShareResourceListener l) {
        }

        @Override
        public void addDeletionListener(ShareResourceWillBeDeletedListener l) {
        }

        @Override
        public void removeDeletionListener(ShareResourceWillBeDeletedListener l) {
        }
    }
}

