/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.sharing;

import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDeletionVetoException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareItemImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceDirContentsImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceDirImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceFileImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceFileOrDirImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareResourceImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;

public class ShareManagerImpl
implements ShareManager,
TOTorrentProgressListener,
ParameterListener,
AEDiagnosticsEvidenceGenerator {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    public static final String TORRENT_STORE = "shares";
    public static final String TORRENT_SUBSTORE = "cache";
    public static final int MAX_FILES_PER_DIR = 1000;
    public static final int MAX_DIRS = 1000;
    protected static ShareManagerImpl singleton;
    private static AEMonitor class_mon;
    private static boolean persistent_shares;
    protected AEMonitor this_mon = new AEMonitor("ShareManager");
    protected TOTorrentCreator to_creator;
    private volatile boolean initialised;
    private volatile boolean initialising;
    private File share_dir;
    private URL[] announce_urls;
    private ShareConfigImpl config;
    private Map<String, ShareResourceImpl> shares = new HashMap<String, ShareResourceImpl>();
    private shareScanner current_scanner;
    private boolean scanning;
    private List<ShareManagerListener> listeners = new ArrayList<ShareManagerListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShareManagerImpl getSingleton() throws ShareException {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new ShareManagerImpl();
            }
            ShareManagerImpl shareManagerImpl = singleton;
            return shareManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected ShareManagerImpl() throws ShareException {
        COConfigurationManager.addListener(new COConfigurationListener(){

            @Override
            public void configurationSaved() {
                ShareManagerImpl.access$102(ShareManagerImpl.this, null);
            }
        });
        AEDiagnostics.addEvidenceGenerator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialise() throws ShareException {
        block14: {
            try {
                this.this_mon.enter();
                if (this.initialised) break block14;
                try {
                    this.initialising = true;
                    this.initialised = true;
                    this.share_dir = FileUtil.getUserFile(TORRENT_STORE);
                    FileUtil.mkdirs(this.share_dir);
                    this.config = new ShareConfigImpl();
                    try {
                        this.config.suspendSaving();
                        this.config.loadConfig(this);
                    }
                    finally {
                        for (ShareResourceImpl resource : this.shares.values()) {
                            if (resource.getType() != 3) continue;
                            for (int i = 0; i < this.listeners.size(); ++i) {
                                try {
                                    this.listeners.get(i).resourceAdded(resource);
                                    continue;
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                        }
                        this.config.resumeSaving();
                    }
                    this.readAZConfig();
                    this.initialising = false;
                }
                catch (Throwable throwable) {
                    this.initialising = false;
                    new AEThread2("ShareManager:initScan", true){

                        @Override
                        public void run() {
                            try {
                                ShareManagerImpl.this.scanShares();
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }.start();
                    throw throwable;
                }
                new /* invalid duplicate definition of identical inner class */.start();
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    @Override
    public boolean isInitialising() {
        return this.initialising;
    }

    protected void readAZConfig() {
        COConfigurationManager.addParameterListener("Sharing Rescan Enable", (ParameterListener)this);
        this.readAZConfigSupport();
    }

    @Override
    public void parameterChanged(String name) {
        this.readAZConfigSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readAZConfigSupport() {
        try {
            this.this_mon.enter();
            boolean scan_enabled = COConfigurationManager.getBooleanParameter("Sharing Rescan Enable");
            if (!scan_enabled) {
                this.current_scanner = null;
            } else if (this.current_scanner == null) {
                this.current_scanner = new shareScanner();
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    protected ShareConfigImpl getShareConfig() {
        return this.config;
    }

    protected void checkConsistency() throws ShareException {
        for (ShareResourceImpl resource : new HashSet<ShareResourceImpl>(this.shares.values())) {
            try {
                resource.checkConsistency();
            }
            catch (ShareException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void deserialiseResource(Map map) {
        try {
            ShareResourceImpl new_resource = null;
            int type = ((Long)map.get("type")).intValue();
            new_resource = type == 1 || type == 2 ? ShareResourceFileOrDirImpl.deserialiseResource(this, map, type) : ShareResourceDirContentsImpl.deserialiseResource(this, map);
            if (new_resource != null) {
                ShareResourceImpl old_resource = this.shares.get(new_resource.getName());
                if (old_resource != null) {
                    old_resource.delete(true);
                }
                this.shares.put(new_resource.getName(), new_resource);
                if (type != 3) {
                    for (int i = 0; i < this.listeners.size(); ++i) {
                        try {
                            this.listeners.get(i).resourceAdded(new_resource);
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected String getNewTorrentLocation() throws ShareException {
        for (int i = 1; i <= 1000; ++i) {
            String cache_dir_str = this.share_dir + File.separator + TORRENT_SUBSTORE + i;
            File cache_dir = new File(cache_dir_str);
            if (!cache_dir.exists()) {
                FileUtil.mkdirs(cache_dir);
            }
            if (cache_dir.listFiles().length >= 1000) continue;
            for (int j = 0; j < 1000; ++j) {
                long file = RandomUtils.nextAbsoluteLong();
                File file_name = new File(cache_dir_str + File.separator + file + ".torrent");
                if (file_name.exists()) continue;
                return TORRENT_SUBSTORE + i + File.separator + file + ".torrent";
            }
        }
        throw new ShareException("ShareManager: Failed to allocate cache file");
    }

    protected void writeTorrent(ShareItemImpl item) throws ShareException {
        try {
            item.getTorrent().writeToFile(this.getTorrentFile(item));
        }
        catch (TorrentException e) {
            throw new ShareException("ShareManager: Torrent write fails", e);
        }
    }

    protected void readTorrent(ShareItemImpl item) throws ShareException {
        try {
            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedFile(this.getTorrentFile(item));
            item.setTorrent(new TorrentImpl(torrent));
        }
        catch (TOTorrentException e) {
            throw new ShareException("ShareManager: Torrent read fails", e);
        }
    }

    protected void deleteTorrent(ShareItemImpl item) {
        File torrent_file = this.getTorrentFile(item);
        torrent_file.delete();
    }

    protected boolean torrentExists(ShareItemImpl item) {
        return this.getTorrentFile(item).exists();
    }

    protected File getTorrentFile(ShareItemImpl item) {
        return new File(this.share_dir + File.separator + item.getTorrentLocation());
    }

    protected URL[] getAnnounceURLs() throws ShareException {
        if (this.announce_urls == null) {
            String protocol = COConfigurationManager.getStringParameter("Sharing Protocol");
            if (protocol.equalsIgnoreCase("DHT")) {
                this.announce_urls = new URL[]{TorrentUtils.getDecentralisedEmptyURL()};
            } else {
                URL[][] tracker_url_sets = TRTrackerUtils.getAnnounceURLs();
                if (tracker_url_sets.length == 0) {
                    throw new ShareException("ShareManager: Tracker must be configured");
                }
                for (int i = 0; i < tracker_url_sets.length; ++i) {
                    URL[] tracker_urls = tracker_url_sets[i];
                    if (!tracker_urls[0].getProtocol().equalsIgnoreCase(protocol)) continue;
                    this.announce_urls = tracker_urls;
                    break;
                }
                if (this.announce_urls == null) {
                    throw new ShareException("ShareManager: Tracker must be configured for protocol '" + protocol + "'");
                }
            }
        }
        return this.announce_urls;
    }

    protected boolean getAddHashes() {
        return COConfigurationManager.getBooleanParameter("Sharing Add Hashes");
    }

    @Override
    public ShareResource[] getShares() {
        ShareResource[] res = new ShareResource[this.shares.size()];
        this.shares.values().toArray(res);
        return res;
    }

    protected ShareResourceImpl getResource(File file) throws ShareException {
        try {
            return this.shares.get(file.getCanonicalFile().toString());
        }
        catch (IOException e) {
            throw new ShareException("getCanonicalFile fails", e);
        }
    }

    @Override
    public ShareResource getShare(File file_or_dir) {
        try {
            return this.getResource(file_or_dir);
        }
        catch (ShareException e) {
            return null;
        }
    }

    private boolean getBooleanProperty(Map<String, String> properties, String name) {
        if (properties == null) {
            return false;
        }
        String value = properties.get(name);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase("true");
    }

    @Override
    public ShareResourceFile addFile(File file) throws ShareException, ShareResourceDeletionVetoException {
        return this.addFile(file, null);
    }

    @Override
    public ShareResourceFile addFile(File file, Map<String, String> properties) throws ShareException, ShareResourceDeletionVetoException {
        return this.addFile(null, file, this.getBooleanProperty(properties, "personal"), properties);
    }

    protected ShareResourceFile addFile(ShareResourceDirContentsImpl parent, File file, boolean personal, Map<String, String> properties) throws ShareException, ShareResourceDeletionVetoException {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "ShareManager: addFile '" + file.toString() + "'"));
        }
        try {
            return (ShareResourceFile)this.addFileOrDir(parent, file, 1, personal, properties);
        }
        catch (ShareException e) {
            this.reportError(e);
            throw e;
        }
    }

    public ShareResourceFile getFile(File file) throws ShareException {
        return ShareResourceFileImpl.getResource(this, file);
    }

    @Override
    public ShareResourceDir addDir(File dir) throws ShareException, ShareResourceDeletionVetoException {
        return this.addDir(dir, null);
    }

    @Override
    public ShareResourceDir addDir(File dir, Map<String, String> properties) throws ShareException, ShareResourceDeletionVetoException {
        return this.addDir(null, dir, this.getBooleanProperty(properties, "personal"), properties);
    }

    public ShareResourceDir addDir(ShareResourceDirContentsImpl parent, File dir, boolean personal, Map<String, String> properties) throws ShareException, ShareResourceDeletionVetoException {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "ShareManager: addDir '" + dir.toString() + "'"));
        }
        try {
            this.this_mon.enter();
            ShareResourceDir shareResourceDir = (ShareResourceDir)this.addFileOrDir(parent, dir, 2, personal, properties);
            return shareResourceDir;
        }
        catch (ShareException e) {
            this.reportError(e);
            throw e;
        }
        finally {
            this.this_mon.exit();
        }
    }

    public ShareResourceDir getDir(File file) throws ShareException {
        return ShareResourceDirImpl.getResource(this, file);
    }

    protected ShareResource addFileOrDir(ShareResourceDirContentsImpl parent, File file, int type, boolean personal, Map<String, String> properties) throws ShareException, ShareResourceDeletionVetoException {
        properties = this.setPropertyDefaults(properties);
        try {
            ShareResourceFileOrDirImpl new_resource;
            boolean modified;
            this.this_mon.enter();
            String name = file.getCanonicalFile().toString();
            ShareResourceImpl old_resource = this.shares.get(name);
            boolean bl = modified = old_resource != null;
            if (modified) {
                if (old_resource.isPersistent()) {
                    ShareResourceImpl shareResourceImpl = old_resource;
                    return shareResourceImpl;
                }
                old_resource.delete(true, false);
            }
            if (type == 1) {
                this.reportCurrentTask("Adding file '" + name + "'");
                new_resource = new ShareResourceFileImpl(this, parent, file, personal, properties);
            } else {
                this.reportCurrentTask("Adding dir '" + name + "'");
                new_resource = new ShareResourceDirImpl(this, parent, file, personal, properties);
            }
            this.shares.put(name, new_resource);
            this.config.saveConfig();
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    if (modified) {
                        this.listeners.get(i).resourceModified(old_resource, new_resource);
                        continue;
                    }
                    this.listeners.get(i).resourceAdded(new_resource);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            ShareResourceFileOrDirImpl shareResourceFileOrDirImpl = new_resource;
            return shareResourceFileOrDirImpl;
        }
        catch (IOException e) {
            throw new ShareException("getCanoncialFile fails", e);
        }
        finally {
            this.this_mon.exit();
        }
    }

    @Override
    public ShareResourceDirContents addDirContents(File dir, boolean recursive) throws ShareException, ShareResourceDeletionVetoException {
        return this.addDirContents(dir, recursive, null);
    }

    @Override
    public ShareResourceDirContents addDirContents(File dir, boolean recursive, Map<String, String> properties) throws ShareException, ShareResourceDeletionVetoException {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "ShareManager: addDirContents '" + dir.toString() + "'"));
        }
        properties = this.setPropertyDefaults(properties);
        try {
            this.this_mon.enter();
            String name = dir.getCanonicalFile().toString();
            this.reportCurrentTask("Adding dir contents '" + name + "', recursive = " + recursive);
            ShareResource old_resource = this.shares.get(name);
            if (old_resource != null) {
                if (old_resource.isPersistent() && old_resource instanceof ShareResourceDirContents) {
                    ShareResourceDirContents shareResourceDirContents = (ShareResourceDirContents)old_resource;
                    return shareResourceDirContents;
                }
                old_resource.delete(true);
            }
            ShareResourceDirContentsImpl new_resource = new ShareResourceDirContentsImpl(this, dir, recursive, this.getBooleanProperty(properties, "personal"), properties, true);
            this.shares.put(name, new_resource);
            this.config.saveConfig();
            for (int i = 0; i < this.listeners.size(); ++i) {
                try {
                    this.listeners.get(i).resourceAdded(new_resource);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            ShareResourceDirContentsImpl shareResourceDirContentsImpl = new_resource;
            return shareResourceDirContentsImpl;
        }
        catch (IOException e) {
            this.reportError(e);
            throw new ShareException("getCanoncialFile fails", e);
        }
        catch (ShareException e) {
            this.reportError(e);
            throw e;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void delete(ShareResourceImpl resource, boolean fire_listeners) throws ShareException {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "ShareManager: resource '" + resource.getName() + "' deleted"));
        }
        try {
            this.this_mon.enter();
            this.shares.remove(resource.getName());
            resource.deleteInternal();
            this.config.saveConfig();
            if (fire_listeners) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    try {
                        this.listeners.get(i).resourceDeleted(resource);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanShares() throws ShareException {
        try {
            this.this_mon.enter();
            if (this.scanning) {
                return;
            }
            this.scanning = true;
        }
        finally {
            this.this_mon.exit();
        }
        try {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "ShareManager: scanning resources for changes"));
            }
            this.checkConsistency();
        }
        finally {
            try {
                this.this_mon.enter();
                this.scanning = false;
            }
            finally {
                this.this_mon.exit();
            }
        }
    }

    protected void setTorrentCreator(TOTorrentCreator _to_creator) {
        this.to_creator = _to_creator;
    }

    private Map<String, String> setPropertyDefaults(Map<String, String> properties) {
        if (persistent_shares) {
            if (properties == null) {
                properties = new HashMap<String, String>();
            }
            if (!properties.containsKey("persistent")) {
                properties.put("persistent", persistent_shares ? "true" : "false");
            }
        }
        return properties;
    }

    @Override
    public void cancelOperation() {
        TOTorrentCreator temp = this.to_creator;
        if (temp != null) {
            temp.cancel();
        }
    }

    @Override
    public void reportProgress(int percent_complete) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).reportProgress(percent_complete);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public void reportCurrentTask(String task_description) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                this.listeners.get(i).reportCurrentTask(task_description);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected void reportError(Throwable e) {
        String message = e.getMessage();
        if (message != null) {
            this.reportCurrentTask(Debug.getNestedExceptionMessage(e));
        } else {
            this.reportCurrentTask(e.toString());
        }
    }

    @Override
    public void addListener(ShareManagerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(ShareManagerListener l) {
        this.listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("Shares");
        try {
            writer.indent();
            ShareResource[] shares = this.getShares();
            HashSet<ShareResource> share_map = new HashSet<ShareResource>();
            for (int i = 0; i < shares.length; ++i) {
                ShareResource share = shares[i];
                if (share instanceof ShareResourceDirContents) {
                    share_map.add(share);
                    continue;
                }
                if (share.getParent() != null) continue;
                writer.println(this.getDebugName(share));
            }
            Iterator it = share_map.iterator();
            if (!AzureusCoreFactory.isCoreAvailable()) {
                writer.println("No Core");
                return;
            }
            TorrentManager tm = PluginInitializer.getDefaultInterface().getTorrentManager();
            TorrentAttribute category_attribute = tm.getAttribute("Category");
            TorrentAttribute props_attribute = tm.getAttribute("ShareProperties");
            while (it.hasNext()) {
                ShareResourceDirContents root = (ShareResourceDirContents)it.next();
                String cat = root.getAttribute(category_attribute);
                String props = root.getAttribute(props_attribute);
                String extra = cat == null ? "" : ",cat=" + cat;
                extra = extra + (props == null ? "" : ",props=" + props);
                extra = extra + ",rec=" + root.isRecursive();
                writer.println(root.getName() + extra);
                this.generate(writer, root);
            }
        }
        finally {
            writer.exdent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generate(IndentWriter writer, ShareResourceDirContents node) {
        try {
            writer.indent();
            ShareResource[] kids = node.getChildren();
            for (int i = 0; i < kids.length; ++i) {
                ShareResource kid = kids[i];
                writer.println(this.getDebugName(kid));
                if (!(kid instanceof ShareResourceDirContents)) continue;
                this.generate(writer, (ShareResourceDirContents)kid);
            }
        }
        finally {
            writer.exdent();
        }
    }

    protected String getDebugName(ShareResource _share) {
        Torrent torrent = null;
        try {
            if (_share instanceof ShareResourceFile) {
                ShareResourceFile share = (ShareResourceFile)_share;
                torrent = share.getItem().getTorrent();
            } else if (_share instanceof ShareResourceDir) {
                ShareResourceDir share = (ShareResourceDir)_share;
                torrent = share.getItem().getTorrent();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (torrent == null) {
            return Debug.secretFileName(_share.getName());
        }
        return Debug.secretFileName(torrent.getName()) + "/" + ByteFormatter.encodeString(torrent.getHash());
    }

    static /* synthetic */ URL[] access$102(ShareManagerImpl x0, URL[] x1) {
        x0.announce_urls = x1;
        return x1;
    }

    static {
        class_mon = new AEMonitor("ShareManager:class");
        COConfigurationManager.addAndFireParameterListener("Sharing Is Persistent", new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                persistent_shares = COConfigurationManager.getBooleanParameter("Sharing Is Persistent");
            }
        });
    }

    protected class shareScanner {
        protected shareScanner() {
            ShareManagerImpl.this.current_scanner = this;
            new AEThread2("ShareManager::scanner", true){

                @Override
                public void run() {
                    while (ShareManagerImpl.this.current_scanner == shareScanner.this) {
                        try {
                            int scan_period = COConfigurationManager.getIntParameter("Sharing Rescan Period");
                            if (scan_period < 1) {
                                scan_period = 1;
                            }
                            Thread.sleep(scan_period * 1000);
                            if (ShareManagerImpl.this.current_scanner != shareScanner.this) continue;
                            ShareManagerImpl.this.scanShares();
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
            }.start();
        }
    }
}

