/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.network.ConnectionStub;
import org.gudy.azureus2.plugins.network.RateLimiter;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerEvent;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerListener2;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerReadRequest;
import org.gudy.azureus2.plugins.peers.PeerStats;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageAdapter;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerForeignDelegate;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public class PeerImpl
extends LogRelation
implements Peer {
    protected PeerManagerImpl manager;
    protected PEPeer delegate;
    private HashMap<Object, PEPeerListener> peer_listeners;
    private UtilitiesImpl.PluginLimitedRateGroupListener up_rg_listener;
    private UtilitiesImpl.PluginLimitedRateGroupListener down_rg_listener;
    private volatile boolean closed;

    protected PeerImpl(PEPeer _delegate) {
        this.delegate = _delegate;
        this.manager = PeerManagerImpl.getPeerManager(this.delegate.getManager());
    }

    @Override
    public void bindConnection(ConnectionStub stub) {
    }

    @Override
    public PeerManager getManager() {
        return this.manager;
    }

    public PEPeer getDelegate() {
        return this.delegate;
    }

    @Override
    public Connection getConnection() {
        return this.delegate.getPluginConnection();
    }

    @Override
    public boolean supportsMessaging() {
        return this.delegate.supportsMessaging();
    }

    @Override
    public Message[] getSupportedMessages() {
        com.aelitis.azureus.core.peermanager.messaging.Message[] core_msgs = this.delegate.getSupportedMessages();
        Message[] plug_msgs = new Message[core_msgs.length];
        for (int i = 0; i < core_msgs.length; ++i) {
            plug_msgs[i] = new MessageAdapter(core_msgs[i]);
        }
        return plug_msgs;
    }

    @Override
    public int getState() {
        int state = this.delegate.getPeerState();
        switch (state) {
            case 10: {
                return 10;
            }
            case 50: {
                return 50;
            }
            case 20: {
                return 20;
            }
            case 30: {
                return 30;
            }
        }
        return -1;
    }

    @Override
    public byte[] getId() {
        byte[] id = this.delegate.getId();
        if (id == null) {
            return new byte[0];
        }
        byte[] copy = new byte[id.length];
        System.arraycopy(id, 0, copy, 0, copy.length);
        return copy;
    }

    @Override
    public String getIp() {
        return this.delegate.getIp();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public int getTCPListenPort() {
        return this.delegate.getTCPListenPort();
    }

    @Override
    public int getUDPListenPort() {
        return this.delegate.getUDPListenPort();
    }

    @Override
    public int getUDPNonDataListenPort() {
        return this.delegate.getUDPNonDataListenPort();
    }

    @Override
    public final boolean[] getAvailable() {
        BitFlags bf = this.delegate.getAvailable();
        if (bf == null) {
            return null;
        }
        return bf.flags;
    }

    @Override
    public boolean isPieceAvailable(int pieceNumber) {
        return this.delegate.isPieceAvailable(pieceNumber);
    }

    @Override
    public boolean isTransferAvailable() {
        return this.delegate.transferAvailable();
    }

    @Override
    public boolean isDownloadPossible() {
        return this.delegate.isDownloadPossible();
    }

    @Override
    public boolean isChoked() {
        return this.delegate.isChokingMe();
    }

    @Override
    public boolean isChoking() {
        return this.delegate.isChokedByMe();
    }

    @Override
    public boolean isInterested() {
        return this.delegate.isInteresting();
    }

    @Override
    public boolean isInteresting() {
        return this.delegate.isInterested();
    }

    @Override
    public boolean isSeed() {
        return this.delegate.isSeed();
    }

    @Override
    public boolean isSnubbed() {
        return this.delegate.isSnubbed();
    }

    @Override
    public long getSnubbedTime() {
        return this.delegate.getSnubbedTime();
    }

    @Override
    public void setSnubbed(boolean b) {
        this.delegate.setSnubbed(b);
    }

    @Override
    public PeerStats getStats() {
        return new PeerStatsImpl(this.manager, this, this.delegate.getStats());
    }

    @Override
    public boolean isIncoming() {
        return this.delegate.isIncoming();
    }

    @Override
    public int getPercentDone() {
        return this.delegate.getPercentDoneInThousandNotation();
    }

    @Override
    public int getOutgoingRequestCount() {
        return this.delegate.getOutgoingRequestCount();
    }

    @Override
    public int[] getOutgoingRequestedPieceNumbers() {
        return this.delegate.getOutgoingRequestedPieceNumbers();
    }

    @Override
    public int getPercentDoneInThousandNotation() {
        return this.delegate.getPercentDoneInThousandNotation();
    }

    @Override
    public String getClient() {
        return this.delegate.getClient();
    }

    @Override
    public boolean isOptimisticUnchoke() {
        return this.delegate.isOptimisticUnchoke();
    }

    @Override
    public void setOptimisticUnchoke(boolean is_optimistic) {
        this.delegate.setOptimisticUnchoke(is_optimistic);
    }

    public void initialize() {
        throw new RuntimeException("not supported");
    }

    @Override
    public List getExpiredRequests() {
        throw new RuntimeException("not supported");
    }

    @Override
    public List getRequests() {
        throw new RuntimeException("not supported");
    }

    @Override
    public int getNumberOfRequests() {
        throw new RuntimeException("not supported");
    }

    @Override
    public int getMaximumNumberOfRequests() {
        throw new RuntimeException("not supported");
    }

    @Override
    public int[] getPriorityOffsets() {
        throw new RuntimeException("not supported");
    }

    @Override
    public boolean requestAllocationStarts(int[] base_priorities) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void requestAllocationComplete() {
        throw new RuntimeException("not supported");
    }

    @Override
    public void cancelRequest(PeerReadRequest request2) {
        throw new RuntimeException("not supported");
    }

    @Override
    public boolean addRequest(PeerReadRequest request2) {
        throw new RuntimeException("not supported");
    }

    private void createRGListeners() {
        this.up_rg_listener = new UtilitiesImpl.PluginLimitedRateGroupListener(){

            @Override
            public void disabledChanged(UtilitiesImpl.PluginLimitedRateGroup group, boolean is_disabled) {
                if (PeerImpl.this.closed) {
                    group.removeListener(this);
                }
                PeerImpl.this.delegate.setUploadDisabled(group, is_disabled);
            }

            @Override
            public void sync(UtilitiesImpl.PluginLimitedRateGroup group, boolean is_disabled) {
                if (PeerImpl.this.closed) {
                    group.removeListener(this);
                }
            }
        };
        this.down_rg_listener = new UtilitiesImpl.PluginLimitedRateGroupListener(){

            @Override
            public void disabledChanged(UtilitiesImpl.PluginLimitedRateGroup group, boolean is_disabled) {
                if (PeerImpl.this.closed) {
                    group.removeListener(this);
                }
                PeerImpl.this.delegate.setDownloadDisabled(group, is_disabled);
            }

            @Override
            public void sync(UtilitiesImpl.PluginLimitedRateGroup group, boolean is_disabled) {
                if (PeerImpl.this.closed) {
                    group.removeListener(this);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRateLimiter(RateLimiter limiter, boolean is_upload) {
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            if (this.closed) {
                return;
            }
            UtilitiesImpl.PluginLimitedRateGroup wrapped_limiter = UtilitiesImpl.wrapLimiter(limiter, true);
            if (this.up_rg_listener == null) {
                this.createRGListeners();
            }
            if (is_upload) {
                wrapped_limiter.addListener(this.up_rg_listener);
            } else {
                wrapped_limiter.addListener(this.down_rg_listener);
            }
            this.delegate.addRateLimiter(wrapped_limiter, is_upload);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRateLimiter(RateLimiter limiter, boolean is_upload) {
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            UtilitiesImpl.PluginLimitedRateGroup wrapped_limiter = UtilitiesImpl.wrapLimiter(limiter, true);
            if (this.up_rg_listener != null) {
                if (is_upload) {
                    wrapped_limiter.removeListener(this.up_rg_listener);
                } else {
                    wrapped_limiter.removeListener(this.down_rg_listener);
                }
            }
            this.delegate.removeRateLimiter(wrapped_limiter, is_upload);
        }
    }

    @Override
    public RateLimiter[] getRateLimiters(boolean is_upload) {
        LimitedRateGroup[] limiters = this.delegate.getRateLimiters(is_upload);
        RateLimiter[] result = new RateLimiter[limiters.length];
        int pos = 0;
        for (LimitedRateGroup l : limiters) {
            if (!(l instanceof UtilitiesImpl.PluginLimitedRateGroup)) continue;
            result[pos++] = UtilitiesImpl.unwrapLmiter((UtilitiesImpl.PluginLimitedRateGroup)l);
        }
        if (pos == result.length) {
            return result;
        }
        RateLimiter[] result_mod = new RateLimiter[pos];
        System.arraycopy(result, 0, result_mod, 0, pos);
        return result_mod;
    }

    @Override
    public void close(String reason, boolean closedOnError, boolean attemptReconnect) {
        this.manager.removePeer(this, reason);
    }

    @Override
    public int readBytes(int max) {
        throw new RuntimeException("not supported");
    }

    @Override
    public int writeBytes(int max) {
        throw new RuntimeException("not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closed() {
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            this.closed = true;
            if (this.up_rg_listener != null) {
                LimitedRateGroup[] limiters;
                for (LimitedRateGroup l : limiters = this.delegate.getRateLimiters(true)) {
                    if (l instanceof UtilitiesImpl.PluginLimitedRateGroup) {
                        ((UtilitiesImpl.PluginLimitedRateGroup)l).removeListener(this.up_rg_listener);
                    }
                    this.delegate.removeRateLimiter(l, true);
                }
                for (LimitedRateGroup l : limiters = this.delegate.getRateLimiters(false)) {
                    if (l instanceof UtilitiesImpl.PluginLimitedRateGroup) {
                        ((UtilitiesImpl.PluginLimitedRateGroup)l).removeListener(this.down_rg_listener);
                    }
                    this.delegate.removeRateLimiter(l, false);
                }
            }
        }
        if (this.delegate instanceof PeerForeignDelegate) {
            ((PeerForeignDelegate)this.delegate).stop();
        }
    }

    @Override
    public int getPercentDoneOfCurrentIncomingRequest() {
        return this.delegate.getPercentDoneOfCurrentIncomingRequest();
    }

    @Override
    public int getPercentDoneOfCurrentOutgoingRequest() {
        return this.delegate.getPercentDoneOfCurrentOutgoingRequest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(final PeerListener l) {
        PEPeerListener core_listener = new PEPeerListener(){

            @Override
            public void stateChanged(PEPeer peer, int new_state) {
                try {
                    l.stateChanged(new_state);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }

            @Override
            public void sentBadChunk(PEPeer peer, int piece_num, int total_bad_chunks) {
                try {
                    l.sentBadChunk(piece_num, total_bad_chunks);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }

            @Override
            public void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
            }

            @Override
            public void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
            }
        };
        this.delegate.addListener(core_listener);
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            if (this.peer_listeners == null) {
                this.peer_listeners = new HashMap();
            }
            this.peer_listeners.put(l, core_listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(PeerListener l) {
        PEPeerListener core_listener = null;
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            if (this.peer_listeners != null) {
                core_listener = this.peer_listeners.remove(l);
            }
        }
        if (core_listener != null) {
            this.delegate.removeListener(core_listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(final PeerListener2 l) {
        PEPeerListener core_listener = new PEPeerListener(){

            @Override
            public void stateChanged(PEPeer peer, int new_state) {
                this.fireEvent(1, new Integer(new_state));
            }

            @Override
            public void sentBadChunk(PEPeer peer, int piece_num, int total_bad_chunks) {
                this.fireEvent(2, new Integer[]{new Integer(piece_num), new Integer(total_bad_chunks)});
            }

            @Override
            public void addAvailability(PEPeer peer, BitFlags peerHavePieces) {
                this.fireEvent(3, peerHavePieces.flags);
            }

            @Override
            public void removeAvailability(PEPeer peer, BitFlags peerHavePieces) {
                this.fireEvent(4, peerHavePieces.flags);
            }

            protected void fireEvent(final int type, final Object data) {
                try {
                    l.eventOccurred(new PeerEvent(){

                        @Override
                        public int getType() {
                            return type;
                        }

                        @Override
                        public Object getData() {
                            return data;
                        }
                    });
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        };
        this.delegate.addListener(core_listener);
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            if (this.peer_listeners == null) {
                this.peer_listeners = new HashMap();
            }
            this.peer_listeners.put(l, core_listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(PeerListener2 l) {
        PEPeerListener core_listener = null;
        PeerImpl peerImpl = this;
        synchronized (peerImpl) {
            if (this.peer_listeners != null) {
                core_listener = this.peer_listeners.remove(l);
            }
        }
        if (core_listener != null) {
            this.delegate.removeListener(core_listener);
        }
    }

    @Override
    public boolean isPriorityConnection() {
        return this.delegate.isPriorityConnection();
    }

    @Override
    public void setPriorityConnection(boolean is_priority) {
        this.delegate.setPriorityConnection(is_priority);
    }

    @Override
    public void setUserData(Object key, Object value) {
        this.delegate.setUserData(key, value);
    }

    @Override
    public Object getUserData(Object key) {
        return this.delegate.getUserData(key);
    }

    public boolean equals(Object other) {
        if (other instanceof PeerImpl) {
            return this.delegate == ((PeerImpl)other).delegate;
        }
        return false;
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public PEPeer getPEPeer() {
        return this.delegate;
    }

    @Override
    public String getRelationText() {
        return this.propogatedRelationText(this.delegate);
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.delegate};
    }

    @Override
    public byte[] getHandshakeReservedBytes() {
        return this.delegate.getHandshakeReservedBytes();
    }
}

