/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.peers;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionHelper;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportBase;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.pluginsimpl.local.peers.PeerForeignDelegate;

public class PeerForeignNetworkConnection
extends NetworkConnectionHelper {
    private final PeerForeignDelegate delegate;
    private final Peer peer;
    private OutgoingMessageQueue outgoing_message_queue = new omq();
    private IncomingMessageQueue incoming_message_queue = new imq();
    private TransportBase transport_base = new tp();

    protected PeerForeignNetworkConnection(PeerForeignDelegate _delegate, Peer _peer) {
        this.delegate = _delegate;
        this.peer = _peer;
    }

    @Override
    public ConnectionEndpoint getEndpoint() {
        return new ConnectionEndpoint(new InetSocketAddress(this.peer.getIp(), this.peer.getPort()));
    }

    @Override
    public void notifyOfException(Throwable error) {
        Debug.printStackTrace(error);
    }

    @Override
    public OutgoingMessageQueue getOutgoingMessageQueue() {
        return this.outgoing_message_queue;
    }

    @Override
    public IncomingMessageQueue getIncomingMessageQueue() {
        return this.incoming_message_queue;
    }

    @Override
    public TransportBase getTransportBase() {
        return this.transport_base;
    }

    @Override
    public int getMssSize() {
        return NetworkManager.getMinMssSize();
    }

    @Override
    public boolean isIncoming() {
        return false;
    }

    @Override
    public boolean isLANLocal() {
        return false;
    }

    @Override
    public String getString() {
        String peer_str = this.peer.getClass().getName();
        int pos = peer_str.lastIndexOf(46);
        if (pos != -1) {
            peer_str = peer_str.substring(pos + 1);
        }
        peer_str = peer_str + " " + this.peer.getIp() + ":" + this.peer.getPort();
        return "peer=" + peer_str + ",in=" + this.incoming_message_queue.getPercentDoneOfCurrentMessage() + ",out=" + this.outgoing_message_queue.getTotalSize();
    }

    protected class imq
    implements IncomingMessageQueue {
        protected imq() {
        }

        @Override
        public void setDecoder(MessageStreamDecoder new_stream_decoder) {
        }

        @Override
        public MessageStreamDecoder getDecoder() {
            throw new RuntimeException("Not imp");
        }

        @Override
        public int getPercentDoneOfCurrentMessage() {
            return 0;
        }

        @Override
        public int[] receiveFromTransport(int max_bytes, boolean protocol_is_free) throws IOException {
            return new int[]{PeerForeignNetworkConnection.this.peer.readBytes(PeerForeignNetworkConnection.this.delegate.isDownloadDisabled() ? 0 : max_bytes), 0};
        }

        @Override
        public void notifyOfExternallyReceivedMessage(Message message) {
        }

        @Override
        public void resumeQueueProcessing() {
        }

        @Override
        public void registerQueueListener(IncomingMessageQueue.MessageQueueListener listener) {
        }

        @Override
        public void cancelQueueListener(IncomingMessageQueue.MessageQueueListener listener) {
        }

        @Override
        public void destroy() {
        }
    }

    protected class omq
    implements OutgoingMessageQueue {
        protected omq() {
        }

        @Override
        public void setTransport(Transport _transport) {
        }

        @Override
        public int getMssSize() {
            return PeerForeignNetworkConnection.this.getMssSize();
        }

        @Override
        public void setEncoder(MessageStreamEncoder stream_encoder) {
        }

        @Override
        public MessageStreamEncoder getEncoder() {
            throw new RuntimeException("Not imp");
        }

        @Override
        public int getPercentDoneOfCurrentMessage() {
            return 0;
        }

        @Override
        public void destroy() {
        }

        @Override
        public void flush() {
        }

        @Override
        public boolean isDestroyed() {
            return false;
        }

        @Override
        public int getTotalSize() {
            return 0;
        }

        @Override
        public int getDataQueuedBytes() {
            return 0;
        }

        @Override
        public int getProtocolQueuedBytes() {
            return 0;
        }

        @Override
        public boolean getPriorityBoost() {
            return false;
        }

        @Override
        public void setPriorityBoost(boolean boost) {
        }

        @Override
        public boolean isBlocked() {
            return false;
        }

        @Override
        public boolean hasUrgentMessage() {
            return false;
        }

        @Override
        public Message peekFirstMessage() {
            return null;
        }

        @Override
        public void addMessage(Message message, boolean manual_listener_notify) {
            throw new RuntimeException("Not imp");
        }

        @Override
        public void removeMessagesOfType(Message[] message_types, boolean manual_listener_notify) {
            throw new RuntimeException("Not imp");
        }

        @Override
        public boolean removeMessage(Message message, boolean manual_listener_notify) {
            throw new RuntimeException("Not imp");
        }

        @Override
        public int[] deliverToTransport(int max_bytes, boolean protocol_is_free, boolean manual_listener_notify) throws IOException {
            throw new RuntimeException("Not imp");
        }

        @Override
        public void doListenerNotifications() {
        }

        @Override
        public void setTrace(boolean on) {
        }

        @Override
        public String getQueueTrace() {
            return "";
        }

        @Override
        public void registerQueueListener(OutgoingMessageQueue.MessageQueueListener listener) {
        }

        @Override
        public void cancelQueueListener(OutgoingMessageQueue.MessageQueueListener listener) {
        }

        @Override
        public void notifyOfExternallySentMessage(Message message) {
        }
    }

    protected class tp
    implements TransportBase {
        private long last_ready_for_read = SystemTime.getSteppedMonotonousTime();

        protected tp() {
        }

        @Override
        public boolean isReadyForWrite(EventWaiter waiter) {
            return false;
        }

        @Override
        public long isReadyForRead(EventWaiter waiter) {
            long now = SystemTime.getSteppedMonotonousTime();
            if (PeerForeignNetworkConnection.this.peer.isTransferAvailable()) {
                this.last_ready_for_read = now;
                return 0L;
            }
            long diff = now - this.last_ready_for_read + 1L;
            return diff;
        }

        @Override
        public boolean isTCP() {
            return false;
        }

        @Override
        public String getDescription() {
            return "Peer transport delegate";
        }
    }
}

