/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.nat.NATTraversalHandler;
import com.aelitis.azureus.core.nat.NATTraverser;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.messaging.Message;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.MessageManager;
import org.gudy.azureus2.plugins.messaging.MessageManagerListener;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageHandler;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageRegistration;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.plugins.peers.PeerListener;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.peers.PeerManagerListener;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionDirect;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionIndirect;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageDecoder;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEncoder;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEndpointImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageAdapter;

public class MessageManagerImpl
implements MessageManager,
NATTraversalHandler {
    private static MessageManagerImpl instance;
    private final HashMap compat_checks = new HashMap();
    private final DownloadManagerListener download_manager_listener = new DownloadManagerListener(){

        @Override
        public void downloadAdded(Download dwnld) {
            dwnld.addPeerListener(new DownloadPeerListener(){

                @Override
                public void peerManagerAdded(final Download download, PeerManager peer_manager) {
                    peer_manager.addListener(new PeerManagerListener(){

                        @Override
                        public void peerAdded(PeerManager manager, final Peer peer) {
                            peer.addListener(new PeerListener(){

                                @Override
                                public void stateChanged(int new_state) {
                                    if (new_state == 30 && peer.supportsMessaging()) {
                                        Message[] messages = peer.getSupportedMessages();
                                        for (int i = 0; i < messages.length; ++i) {
                                            Message msg = messages[i];
                                            for (Map.Entry entry : MessageManagerImpl.this.compat_checks.entrySet()) {
                                                Message message = (Message)entry.getKey();
                                                if (!msg.getID().equals(message.getID())) continue;
                                                MessageManagerListener listener = (MessageManagerListener)entry.getValue();
                                                listener.compatiblePeerFound(download, peer, message);
                                            }
                                        }
                                    }
                                }

                                @Override
                                public void sentBadChunk(int piece_num, int total_bad_chunks) {
                                }
                            });
                        }

                        @Override
                        public void peerRemoved(PeerManager manager, Peer peer) {
                            for (MessageManagerListener listener : MessageManagerImpl.this.compat_checks.values()) {
                                listener.peerRemoved(download, peer);
                            }
                        }
                    });
                }

                @Override
                public void peerManagerRemoved(Download download, PeerManager peer_manager) {
                }
            });
        }

        @Override
        public void downloadRemoved(Download download) {
        }
    };
    private AzureusCore core;
    private Map message_handlers = new HashMap();

    public static synchronized MessageManagerImpl getSingleton(AzureusCore core) {
        if (instance == null) {
            instance = new MessageManagerImpl(core);
        }
        return instance;
    }

    private MessageManagerImpl(AzureusCore _core) {
        this.core = _core;
        this.core.getNATTraverser().registerHandler(this);
    }

    public NATTraverser getNATTraverser() {
        return this.core.getNATTraverser();
    }

    @Override
    public void registerMessageType(Message message) throws MessageException {
        try {
            com.aelitis.azureus.core.peermanager.messaging.MessageManager.getSingleton().registerMessageType(new MessageAdapter(message));
        }
        catch (com.aelitis.azureus.core.peermanager.messaging.MessageException me) {
            throw new MessageException(me.getMessage());
        }
    }

    @Override
    public void deregisterMessageType(Message message) {
        com.aelitis.azureus.core.peermanager.messaging.MessageManager.getSingleton().deregisterMessageType(new MessageAdapter(message));
    }

    @Override
    public void locateCompatiblePeers(PluginInterface plug_interface, Message message, MessageManagerListener listener) {
        this.compat_checks.put(message, listener);
        if (this.compat_checks.size() == 1) {
            plug_interface.getDownloadManager().addListener(this.download_manager_listener);
        }
    }

    @Override
    public void cancelCompatiblePeersLocation(MessageManagerListener orig_listener) {
        Iterator it = this.compat_checks.values().iterator();
        while (it.hasNext()) {
            MessageManagerListener listener = (MessageManagerListener)it.next();
            if (listener != orig_listener) continue;
            it.remove();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericMessageRegistration registerGenericMessageType(String _type, final String description, final int stream_crypto, final GenericMessageHandler handler) throws MessageException {
        final String type = "AEGEN:" + _type;
        final byte[] type_bytes = type.getBytes();
        final byte[][] shared_secrets = new byte[][]{new SHA1Simple().calculateHash(type_bytes)};
        Map map = this.message_handlers;
        synchronized (map) {
            this.message_handlers.put(type, handler);
        }
        final NetworkManager.ByteMatcher matcher = new NetworkManager.ByteMatcher(){

            @Override
            public int matchThisSizeOrBigger() {
                return this.maxSize();
            }

            @Override
            public int maxSize() {
                return type_bytes.length;
            }

            @Override
            public int minSize() {
                return this.maxSize();
            }

            @Override
            public Object matches(TransportHelper transport, ByteBuffer to_compare, int port) {
                int old_limit = to_compare.limit();
                to_compare.limit(to_compare.position() + this.maxSize());
                boolean matches = to_compare.equals(ByteBuffer.wrap(type_bytes));
                to_compare.limit(old_limit);
                return matches ? "" : null;
            }

            @Override
            public Object minMatches(TransportHelper transport, ByteBuffer to_compare, int port) {
                return this.matches(transport, to_compare, port);
            }

            @Override
            public byte[][] getSharedSecrets() {
                return shared_secrets;
            }

            @Override
            public int getSpecificPort() {
                return -1;
            }
        };
        NetworkManager.getSingleton().requestIncomingConnectionRouting(matcher, new NetworkManager.RoutingListener(){

            @Override
            public void connectionRouted(NetworkConnection connection, Object routing_data) {
                try {
                    ByteBuffer[] skip_buffer = new ByteBuffer[]{ByteBuffer.allocate(type_bytes.length)};
                    connection.getTransport().read(skip_buffer, 0, 1);
                    if (skip_buffer[0].remaining() != 0) {
                        Debug.out("incomplete read");
                    }
                    GenericMessageEndpointImpl endpoint = new GenericMessageEndpointImpl(connection.getEndpoint());
                    GenericMessageConnectionDirect direct_connection = GenericMessageConnectionDirect.receive(endpoint, type, description, stream_crypto, shared_secrets);
                    GenericMessageConnectionImpl new_connection = new GenericMessageConnectionImpl(MessageManagerImpl.this, direct_connection);
                    direct_connection.connect(connection);
                    if (handler.accept(new_connection)) {
                        new_connection.accepted();
                    } else {
                        connection.close("connection not accepted");
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    connection.close(e == null ? null : Debug.getNestedExceptionMessage(e));
                }
            }

            @Override
            public boolean autoCryptoFallback() {
                return stream_crypto != 3;
            }
        }, new MessageStreamFactory(){

            @Override
            public MessageStreamEncoder createEncoder() {
                return new GenericMessageEncoder();
            }

            @Override
            public MessageStreamDecoder createDecoder() {
                return new GenericMessageDecoder(type, description);
            }
        });
        return new GenericMessageRegistration(){

            @Override
            public GenericMessageEndpoint createEndpoint(InetSocketAddress notional_target) {
                return new GenericMessageEndpointImpl(notional_target);
            }

            @Override
            public GenericMessageConnection createConnection(GenericMessageEndpoint endpoint) throws MessageException {
                return new GenericMessageConnectionImpl(MessageManagerImpl.this, type, description, (GenericMessageEndpointImpl)endpoint, stream_crypto, shared_secrets);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancel() {
                NetworkManager.getSingleton().cancelIncomingConnectionRouting(matcher);
                Map map = MessageManagerImpl.this.message_handlers;
                synchronized (map) {
                    MessageManagerImpl.this.message_handlers.remove(type);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GenericMessageHandler getHandler(String type) {
        Map map = this.message_handlers;
        synchronized (map) {
            return (GenericMessageHandler)this.message_handlers.get(type);
        }
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getName() {
        return "Generic Messaging";
    }

    @Override
    public Map process(InetSocketAddress originator, Map message) {
        return GenericMessageConnectionIndirect.receive(this, originator, message);
    }
}

