/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.messaging;

import com.aelitis.azureus.core.nat.NATTraversalObserver;
import com.aelitis.azureus.core.nat.NATTraverser;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.messaging.MessageException;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnection;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageConnectionListener;
import org.gudy.azureus2.plugins.messaging.generic.GenericMessageEndpoint;
import org.gudy.azureus2.plugins.network.RateLimiter;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessage;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionAdapter;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionDirect;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageConnectionIndirect;
import org.gudy.azureus2.pluginsimpl.local.messaging.GenericMessageEndpointImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class GenericMessageConnectionImpl
implements GenericMessageConnection {
    private static final boolean TRACE = false;
    private static final boolean TEST_TUNNEL = false;
    private MessageManagerImpl message_manager;
    private String msg_id;
    private String msg_desc;
    private GenericMessageEndpointImpl endpoint;
    private int stream_crypto;
    byte[][] shared_secrets;
    private boolean incoming;
    private volatile GenericMessageConnectionAdapter delegate;
    private volatile boolean closing;
    private volatile boolean closed;
    private volatile boolean connecting;
    private List listeners = new ArrayList();
    private int connect_method_count;
    private List inbound_rls;
    private List outbound_rls;

    protected GenericMessageConnectionImpl(MessageManagerImpl _message_manager, GenericMessageConnectionAdapter _delegate) {
        this.message_manager = _message_manager;
        this.delegate = _delegate;
        this.incoming = true;
        this.connect_method_count = 1;
        this.delegate.setOwner(this);
    }

    protected GenericMessageConnectionImpl(MessageManagerImpl _message_manager, String _msg_id, String _msg_desc, GenericMessageEndpointImpl _endpoint, int _stream_crypto, byte[][] _shared_secrets) {
        this.message_manager = _message_manager;
        this.msg_id = _msg_id;
        this.msg_desc = _msg_desc;
        this.endpoint = _endpoint;
        this.stream_crypto = _stream_crypto;
        this.shared_secrets = _shared_secrets;
        this.connect_method_count = this.endpoint.getConnectionEndpoint().getProtocols().length;
        this.incoming = false;
    }

    @Override
    public GenericMessageEndpoint getEndpoint() {
        return this.endpoint == null ? this.delegate.getEndpoint() : this.endpoint;
    }

    @Override
    public int getMaximumMessageSize() {
        return this.delegate == null ? 32768 : this.delegate.getMaximumMessageSize();
    }

    @Override
    public String getType() {
        if (this.delegate == null) {
            return "";
        }
        return this.delegate.getType();
    }

    @Override
    public int getTransportType() {
        if (this.delegate == null) {
            return 0;
        }
        return this.delegate.getTransportType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInboundRateLimiter(RateLimiter limiter) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            if (this.delegate != null) {
                this.delegate.addInboundRateLimiter(limiter);
            } else {
                if (this.inbound_rls == null) {
                    this.inbound_rls = new ArrayList();
                }
                this.inbound_rls.add(limiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInboundRateLimiter(RateLimiter limiter) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            if (this.delegate != null) {
                this.delegate.removeInboundRateLimiter(limiter);
            } else if (this.inbound_rls != null) {
                this.inbound_rls.remove(limiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addOutboundRateLimiter(RateLimiter limiter) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            if (this.delegate != null) {
                this.delegate.addOutboundRateLimiter(limiter);
            } else {
                if (this.outbound_rls == null) {
                    this.outbound_rls = new ArrayList();
                }
                this.outbound_rls.add(limiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeOutboundRateLimiter(RateLimiter limiter) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            if (this.delegate != null) {
                this.delegate.removeOutboundRateLimiter(limiter);
            } else if (this.outbound_rls != null) {
                this.outbound_rls.remove(limiter);
            }
        }
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    public int getConnectMethodCount() {
        return this.connect_method_count;
    }

    @Override
    public void connect() throws MessageException {
        this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDelegate(GenericMessageConnectionAdapter _delegate) {
        GenericMessageConnectionImpl genericMessageConnectionImpl = this;
        synchronized (genericMessageConnectionImpl) {
            int i;
            this.delegate = _delegate;
            if (this.inbound_rls != null) {
                for (i = 0; i < this.inbound_rls.size(); ++i) {
                    this.delegate.addInboundRateLimiter((RateLimiter)this.inbound_rls.get(i));
                }
                this.inbound_rls = null;
            }
            if (this.outbound_rls != null) {
                for (i = 0; i < this.outbound_rls.size(); ++i) {
                    this.delegate.addOutboundRateLimiter((RateLimiter)this.outbound_rls.get(i));
                }
                this.outbound_rls = null;
            }
        }
    }

    public void connect(ByteBuffer initial_data) throws MessageException {
        if (this.incoming) {
            throw new MessageException("Already connected");
        }
        if (this.connecting) {
            throw new MessageException("Connect already performed");
        }
        this.connecting = true;
        if (this.closed) {
            throw new MessageException("Connection has been closed");
        }
        InetSocketAddress tcp_ep = this.endpoint.getTCP();
        if (tcp_ep != null) {
            this.connectTCP(initial_data, tcp_ep);
        } else {
            InetSocketAddress udp_ep = this.endpoint.getUDP();
            if (udp_ep != null) {
                this.connectUDP(initial_data, udp_ep, false);
            } else {
                throw new MessageException("No protocols availabld");
            }
        }
    }

    protected void connectTCP(final ByteBuffer initial_data, InetSocketAddress tcp_ep) {
        GenericMessageEndpointImpl gen_tcp = new GenericMessageEndpointImpl(this.endpoint.getNotionalAddress());
        gen_tcp.addTCP(tcp_ep);
        final GenericMessageConnectionDirect tcp_delegate = new GenericMessageConnectionDirect(this.msg_id, this.msg_desc, gen_tcp, this.stream_crypto, this.shared_secrets);
        tcp_delegate.setOwner(this);
        tcp_delegate.connect(initial_data, new GenericMessageConnectionAdapter.ConnectionListener(){
            private boolean connected;

            @Override
            public void connectSuccess() {
                this.connected = true;
                GenericMessageConnectionImpl.this.setDelegate(tcp_delegate);
                if (GenericMessageConnectionImpl.this.closed) {
                    try {
                        GenericMessageConnectionImpl.this.delegate.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                } else {
                    GenericMessageConnectionImpl.this.reportConnected();
                }
            }

            @Override
            public void connectFailure(Throwable failure_msg) {
                InetSocketAddress udp_ep = GenericMessageConnectionImpl.this.endpoint.getUDP();
                if (udp_ep != null && !this.connected) {
                    initial_data.rewind();
                    GenericMessageConnectionImpl.this.connectUDP(initial_data, udp_ep, false);
                } else {
                    GenericMessageConnectionImpl.this.reportFailed(failure_msg);
                }
            }
        });
    }

    protected void connectUDP(final ByteBuffer initial_data, final InetSocketAddress udp_ep, boolean nat_traversal) {
        final GenericMessageEndpointImpl gen_udp = new GenericMessageEndpointImpl(this.endpoint.getNotionalAddress());
        gen_udp.addUDP(udp_ep);
        final GenericMessageConnectionDirect udp_delegate = new GenericMessageConnectionDirect(this.msg_id, this.msg_desc, gen_udp, this.stream_crypto, this.shared_secrets);
        udp_delegate.setOwner(this);
        if (nat_traversal) {
            NATTraverser nat_traverser = this.message_manager.getNATTraverser();
            HashMap request2 = new HashMap();
            nat_traverser.attemptTraversal(this.message_manager, udp_ep, request2, false, new NATTraversalObserver(){

                @Override
                public void succeeded(final InetSocketAddress rendezvous, final InetSocketAddress target, Map reply) {
                    if (GenericMessageConnectionImpl.this.closed) {
                        GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                    } else {
                        GenericMessageConnectionImpl.this.connect_method_count++;
                        udp_delegate.connect(initial_data, new GenericMessageConnectionAdapter.ConnectionListener(){
                            private boolean connected;

                            @Override
                            public void connectSuccess() {
                                this.connected = true;
                                GenericMessageConnectionImpl.this.setDelegate(udp_delegate);
                                if (GenericMessageConnectionImpl.this.closed) {
                                    try {
                                        GenericMessageConnectionImpl.this.delegate.close();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                                } else {
                                    GenericMessageConnectionImpl.this.reportConnected();
                                }
                            }

                            @Override
                            public void connectFailure(Throwable failure_msg) {
                                if (this.connected) {
                                    GenericMessageConnectionImpl.this.reportFailed(failure_msg);
                                } else {
                                    initial_data.rewind();
                                    GenericMessageConnectionImpl.this.connectTunnel(initial_data, gen_udp, rendezvous, target);
                                }
                            }
                        });
                    }
                }

                @Override
                public void failed(int failure_type) {
                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("UDP connection attempt failed - NAT traversal failed (" + NATTraversalObserver.FT_STRINGS[failure_type] + ")"));
                }

                @Override
                public void failed(Throwable cause) {
                    GenericMessageConnectionImpl.this.reportFailed(cause);
                }

                @Override
                public void disabled() {
                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("UDP connection attempt failed as DDB is disabled"));
                }
            });
        } else {
            udp_delegate.connect(initial_data, new GenericMessageConnectionAdapter.ConnectionListener(){
                private boolean connected;

                @Override
                public void connectSuccess() {
                    this.connected = true;
                    GenericMessageConnectionImpl.this.setDelegate(udp_delegate);
                    if (GenericMessageConnectionImpl.this.closed) {
                        try {
                            GenericMessageConnectionImpl.this.delegate.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                    } else {
                        GenericMessageConnectionImpl.this.reportConnected();
                    }
                }

                @Override
                public void connectFailure(Throwable failure_msg) {
                    if (this.connected) {
                        GenericMessageConnectionImpl.this.reportFailed(failure_msg);
                    } else {
                        initial_data.rewind();
                        GenericMessageConnectionImpl.this.connectUDP(initial_data, udp_ep, true);
                    }
                }
            });
        }
    }

    protected void connectTunnel(ByteBuffer initial_data, GenericMessageEndpoint ep, InetSocketAddress rendezvous, InetSocketAddress target) {
        final GenericMessageConnectionIndirect tunnel_delegate = new GenericMessageConnectionIndirect(this.message_manager, this.msg_id, this.msg_desc, ep, rendezvous, target);
        tunnel_delegate.setOwner(this);
        tunnel_delegate.connect(initial_data, new GenericMessageConnectionAdapter.ConnectionListener(){

            @Override
            public void connectSuccess() {
                GenericMessageConnectionImpl.this.setDelegate(tunnel_delegate);
                if (GenericMessageConnectionImpl.this.closed) {
                    try {
                        GenericMessageConnectionImpl.this.delegate.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    GenericMessageConnectionImpl.this.reportFailed(new MessageException("Connection has been closed"));
                } else {
                    GenericMessageConnectionImpl.this.reportConnected();
                }
            }

            @Override
            public void connectFailure(Throwable failure_msg) {
                GenericMessageConnectionImpl.this.reportFailed(failure_msg);
            }
        });
    }

    protected void accepted() {
        this.delegate.accepted();
    }

    @Override
    public void send(PooledByteBuffer message) throws MessageException {
        int size = ((PooledByteBufferImpl)message).getBuffer().remaining((byte)1);
        if (size > this.getMaximumMessageSize()) {
            throw new MessageException("Message is too large: supplied is " + size + ", maximum is " + this.getMaximumMessageSize());
        }
        this.delegate.send(message);
    }

    protected void receive(GenericMessage message) {
        boolean handled = false;
        for (int i = 0; i < this.listeners.size(); ++i) {
            PooledByteBufferImpl buffer = new PooledByteBufferImpl(message.getPayload());
            try {
                ((GenericMessageConnectionListener)this.listeners.get(i)).receive(this, buffer);
                handled = true;
                continue;
            }
            catch (Throwable f) {
                buffer.returnToPool();
                if (f instanceof MessageException) continue;
                Debug.printStackTrace(f);
            }
        }
        if (!(handled || this.closed || this.closing)) {
            Debug.out("GenericMessage: incoming message not handled");
        }
    }

    public void closing() {
        this.closing = true;
    }

    @Override
    public void close() throws MessageException {
        this.closed = true;
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    protected void reportConnected() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((GenericMessageConnectionListener)this.listeners.get(i)).connected(this);
                continue;
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
        }
    }

    protected void reportFailed(Throwable e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((GenericMessageConnectionListener)this.listeners.get(i)).failed(this, e);
                continue;
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
        }
    }

    @Override
    public void addListener(GenericMessageConnectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(GenericMessageConnectionListener listener) {
        this.listeners.remove(listener);
    }
}

