/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.launch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.PluginManagerArgumentHandler;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;

public class PluginSingleInstanceHandler {
    private static boolean active;
    private static int port;
    private static PluginManagerArgumentHandler handler;

    public static void initialise(int _port, PluginManagerArgumentHandler _handler) {
        port = _port;
        handler = _handler;
        String multi_instance = System.getProperty("MULTI_INSTANCE");
        if (multi_instance != null && multi_instance.equalsIgnoreCase("true")) {
            return;
        }
        active = true;
    }

    public static boolean initialiseAndProcess(int _port, PluginManagerArgumentHandler _handler, String[] _args) {
        PluginSingleInstanceHandler.initialise(_port, _handler);
        return PluginSingleInstanceHandler.process(null, _args);
    }

    protected static boolean process(LoggerChannelListener log, String[] args) {
        if (active) {
            if (PluginSingleInstanceHandler.startListener(log)) {
                return false;
            }
            PluginSingleInstanceHandler.sendArguments(log, args);
            return true;
        }
        return false;
    }

    protected static boolean startListener(final LoggerChannelListener log) {
        try {
            final ServerSocket server_socket = new ServerSocket(port, 50, InetAddress.getByName("127.0.0.1"));
            if (log != null) {
                log.messageLogged(1, "SingleInstanceHandler: listening on 127.0.0.1:" + port + " for passed arguments");
            }
            Thread t = new Thread("Single Instance Handler"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        Socket socket = null;
                        ObjectInputStream ois = null;
                        try {
                            socket = server_socket.accept();
                            String address = socket.getInetAddress().getHostAddress();
                            if (!address.equals("localhost") && !address.equals("127.0.0.1")) {
                                socket.close();
                                continue;
                            }
                            ois = new ObjectInputStream(socket.getInputStream());
                            ois.readInt();
                            String header = (String)ois.readObject();
                            if (!header.equals(PluginSingleInstanceHandler.getHeader())) {
                                if (log == null) continue;
                                log.messageLogged(3, "SingleInstanceHandler: invalid header - " + header);
                                continue;
                            }
                            String[] args = (String[])ois.readObject();
                            String config_dir = System.getProperty("azureus.config.path", null);
                            if (config_dir != null) {
                                String config_path = (String)ois.readObject();
                                String file_name = (String)ois.readObject();
                                if (!config_path.equals(config_dir)) {
                                    throw new Exception("Called supplied incorrect config path: " + config_path);
                                }
                                File cmd_file = new File(new File(config_dir, "tmp"), file_name).getCanonicalFile();
                                if (!cmd_file.getParentFile().getParentFile().equals(new File(config_dir))) {
                                    throw new Exception("Called supplied invalid file name: " + file_name);
                                }
                                ObjectInputStream ois2 = new ObjectInputStream(new FileInputStream(cmd_file));
                                try {
                                    args = (String[])ois2.readObject();
                                }
                                finally {
                                    ois2.close();
                                    cmd_file.delete();
                                }
                            }
                            handler.processArguments(args);
                            continue;
                        }
                        catch (Throwable e) {
                            if (log == null) continue;
                            log.messageLogged("SingleInstanceHandler: receive error", e);
                            continue;
                        }
                        finally {
                            if (ois != null) {
                                try {
                                    ois.close();
                                }
                                catch (Throwable e) {}
                            }
                            if (socket == null) continue;
                            try {
                                socket.close();
                            }
                            catch (Throwable e) {}
                            continue;
                        }
                        break;
                    }
                }
            };
            t.setDaemon(true);
            t.start();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void sendArguments(LoggerChannelListener log, String[] args) {
        Socket socket = null;
        try {
            socket = new Socket("127.0.0.1", port);
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            oos.writeInt(0);
            oos.writeObject(PluginSingleInstanceHandler.getHeader());
            oos.writeObject(args);
            String config_dir = System.getProperty("azureus.config.path", null);
            if (config_dir != null) {
                File file = new File(config_dir, "tmp");
                file.mkdirs();
                file = File.createTempFile("AZU" + RandomUtils.nextSecureAbsoluteLong(), ".tmp", file);
                ObjectOutputStream oos2 = new ObjectOutputStream(new FileOutputStream(file));
                try {
                    oos2.writeObject(args);
                }
                finally {
                    oos2.close();
                }
                oos.writeObject(config_dir);
                oos.writeObject(file.getName());
            }
            oos.flush();
            if (log != null) {
                log.messageLogged(1, "SingleInstanceHandler: arguments passed to existing process");
            }
        }
        catch (Throwable e) {
            if (log != null) {
                log.messageLogged("SingleInstanceHandler: send error", e);
            }
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    protected static String getHeader() {
        return SystemProperties.getApplicationName() + " Single Instance Handler";
    }
}

