/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.installer;

import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.pluginsimpl.local.installer.PluginInstallerImpl;
import org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin;

public abstract class InstallablePluginImpl
implements InstallablePlugin {
    private PluginInstallerImpl installer;

    protected InstallablePluginImpl(PluginInstallerImpl _installer) {
        this.installer = _installer;
    }

    @Override
    public boolean isAlreadyInstalled() {
        PluginInterface pi = this.getAlreadyInstalledPlugin();
        if (pi == null) {
            return false;
        }
        String version = this.getVersion();
        if (version == null || version.length() == 0) {
            return false;
        }
        String existing_version = pi.getPluginVersion();
        if (existing_version == null) {
            return true;
        }
        return Constants.compareVersions(existing_version, version) >= 0;
    }

    @Override
    public PluginInterface getAlreadyInstalledPlugin() {
        return this.installer.getAlreadyInstalledPlugin(this.getId());
    }

    @Override
    public void install(boolean shared) throws PluginException {
        this.installer.install(this, shared);
    }

    @Override
    public void install(boolean shared, boolean low_noise, final boolean wait_until_done) throws PluginException {
        final AESemaphore sem = new AESemaphore("FPI");
        final PluginException[] error = new PluginException[]{null};
        this.installer.install(new InstallablePlugin[]{this}, shared, low_noise, null, new PluginInstallationListener(){

            @Override
            public void completed() {
                sem.release();
            }

            @Override
            public void cancelled() {
                this.failed(new PluginException("Install cancelled"));
            }

            @Override
            public void failed(PluginException e) {
                error[0] = e;
                sem.release();
                if (!wait_until_done) {
                    Debug.out("Install failed", e);
                }
            }
        });
        if (wait_until_done) {
            sem.reserve();
            if (error[0] != null) {
                throw error[0];
            }
        }
    }

    @Override
    public void uninstall() throws PluginException {
        this.installer.uninstall(this);
    }

    @Override
    public PluginInstaller getInstaller() {
        return this.installer;
    }

    public abstract void addUpdate(UpdateCheckInstance var1, PluginUpdatePlugin var2, Plugin var3, PluginInterface var4);
}

