/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.download;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.download.DownloadManagerStateFactory;
import org.gudy.azureus2.core3.download.impl.DownloadManagerDefaultPaths;
import org.gudy.azureus2.core3.download.impl.DownloadManagerMoveHandler;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadWillBeRemovedListener;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadEventNotifier;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadManagerListener;
import org.gudy.azureus2.plugins.download.DownloadManagerStats;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.download.DownloadStubEvent;
import org.gudy.azureus2.plugins.download.DownloadStubListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeAddedListener;
import org.gudy.azureus2.plugins.download.savelocation.DefaultSaveLocationManager;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentException;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadEventNotifierImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerStatsImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadStubImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;

public class DownloadManagerImpl
implements DownloadManager,
DownloadManagerInitialisationAdapter {
    protected static DownloadManagerImpl singleton;
    protected static AEMonitor class_mon;
    private final GlobalManager global_manager;
    private final DownloadManagerStats stats;
    private final DownloadEventNotifierImpl global_dl_notifier;
    private final TagManager tag_manager;
    private List<DownloadManagerListener> listeners = new ArrayList<DownloadManagerListener>();
    private CopyOnWriteList<DownloadWillBeAddedListener> dwba_listeners = new CopyOnWriteList();
    private AEMonitor listeners_mon = new AEMonitor("DownloadManager:L");
    private List<Download> downloads = new ArrayList<Download>();
    private Map<org.gudy.azureus2.core3.download.DownloadManager, DownloadImpl> pending_dls = new IdentityHashMap<org.gudy.azureus2.core3.download.DownloadManager, DownloadImpl>();
    private Map<org.gudy.azureus2.core3.download.DownloadManager, DownloadImpl> download_map = new IdentityHashMap<org.gudy.azureus2.core3.download.DownloadManager, DownloadImpl>();
    private static final String STUB_CONFIG_FILE = "dlarchive.config";
    private static final File ARCHIVE_DIR;
    private List<DownloadStubImpl> download_stubs = new ArrayList<DownloadStubImpl>();
    private ByteArrayHashMap<DownloadStubImpl> download_stub_map = new ByteArrayHashMap();
    private CopyOnWriteList<DownloadStubListener> download_stub_listeners = new CopyOnWriteList();
    private FrequencyLimitedDispatcher dirty_stub_dispatcher = new FrequencyLimitedDispatcher(new AERunnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runSupport() {
            List list = DownloadManagerImpl.this.download_stubs;
            synchronized (list) {
                DownloadManagerImpl.this.writeStubConfig();
            }
        }
    }, 10000);
    private boolean dirty_stubs = false;
    private Set<DownloadStub> informing_of_add = new HashSet<DownloadStub>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DownloadManagerImpl getSingleton(AzureusCore azureus_core) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new DownloadManagerImpl(azureus_core);
            }
            DownloadManagerImpl downloadManagerImpl = singleton;
            return downloadManagerImpl;
        }
        finally {
            class_mon.exit();
        }
    }

    protected DownloadManagerImpl(AzureusCore _azureus_core) {
        this.global_manager = _azureus_core.getGlobalManager();
        this.stats = new DownloadManagerStatsImpl(this.global_manager);
        this.global_dl_notifier = new DownloadEventNotifierImpl(this);
        this.tag_manager = TagManagerFactory.getTagManager();
        this.readStubConfig();
        this.global_manager.addListener(new GlobalManagerListener(){

            @Override
            public void downloadManagerAdded(org.gudy.azureus2.core3.download.DownloadManager dm) {
                DownloadManagerImpl.this.addDownloadManager(dm);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void downloadManagerRemoved(org.gudy.azureus2.core3.download.DownloadManager dm) {
                List listeners_ref = null;
                DownloadImpl dl = null;
                try {
                    DownloadManagerImpl.this.listeners_mon.enter();
                    dl = (DownloadImpl)DownloadManagerImpl.this.download_map.get(dm);
                    if (dl == null) {
                        System.out.println("DownloadManager:unknown manager removed");
                    } else {
                        DownloadManagerImpl.this.downloads.remove(dl);
                        DownloadManagerImpl.this.download_map.remove(dm);
                        DownloadManagerImpl.this.pending_dls.remove(dm);
                        dl.destroy();
                        listeners_ref = DownloadManagerImpl.this.listeners;
                    }
                }
                finally {
                    DownloadManagerImpl.this.listeners_mon.exit();
                }
                if (dl != null) {
                    for (int i = 0; i < listeners_ref.size(); ++i) {
                        try {
                            ((DownloadManagerListener)listeners_ref.get(i)).downloadRemoved(dl);
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            }

            @Override
            public void destroyInitiated() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void destroyed() {
                List list = DownloadManagerImpl.this.download_stubs;
                synchronized (list) {
                    if (DownloadManagerImpl.this.dirty_stubs) {
                        DownloadManagerImpl.this.writeStubConfig();
                    }
                }
            }

            @Override
            public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
            }
        });
        this.global_manager.addDownloadWillBeRemovedListener(new GlobalManagerDownloadWillBeRemovedListener(){

            @Override
            public void downloadWillBeRemoved(org.gudy.azureus2.core3.download.DownloadManager dm, boolean remove_torrent, boolean remove_data) throws GlobalManagerDownloadRemovalVetoException {
                DownloadImpl download = (DownloadImpl)DownloadManagerImpl.this.download_map.get(dm);
                if (download != null) {
                    try {
                        download.isRemovable();
                    }
                    catch (DownloadRemovalVetoException e) {
                        throw new GlobalManagerDownloadRemovalVetoException(e.getMessage(), e.isSilent());
                    }
                }
            }
        });
    }

    @Override
    public void addDownload(File fileName) {
        UIManagerImpl.fireEvent(null, 2, fileName);
    }

    @Override
    public void addDownload(URL url) {
        this.addDownload(url, null, true, null);
    }

    @Override
    public void addDownload(URL url, boolean auto_download) throws DownloadException {
        this.addDownload(url, null, auto_download, null);
    }

    @Override
    public void addDownload(URL url, URL referrer) {
        this.addDownload(url, referrer, true, null);
    }

    @Override
    public void addDownload(URL url, Map request_properties) {
        this.addDownload(url, null, true, request_properties);
    }

    public void addDownload(URL url, URL referrer, boolean auto_download, Map request_properties) {
        UIManagerImpl.fireEvent(null, 3, new Object[]{url, referrer, auto_download, request_properties});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDownloadManager(org.gudy.azureus2.core3.download.DownloadManager dm) {
        List<DownloadManagerListener> listeners_ref = null;
        DownloadImpl dl = null;
        try {
            this.listeners_mon.enter();
            if (this.download_map.get(dm) == null) {
                dl = this.pending_dls.remove(dm);
                if (dl == null) {
                    dl = new DownloadImpl(this, dm);
                }
                this.downloads.add(dl);
                this.download_map.put(dm, dl);
                listeners_ref = this.listeners;
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        if (dl != null) {
            for (int i = 0; i < listeners_ref.size(); ++i) {
                try {
                    ((DownloadManagerListener)listeners_ref.get(i)).downloadAdded(dl);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    @Override
    public Download addDownload(Torrent torrent) throws DownloadException {
        return this.addDownload(torrent, null, null);
    }

    @Override
    public Download addDownload(Torrent torrent, File torrent_file, File data_location) throws DownloadException {
        return this.addDownload(torrent, torrent_file, data_location, this.getInitialState());
    }

    public Download addDownload(Torrent torrent, File torrent_file, File data_location, int initial_state) throws DownloadException {
        if (torrent_file == null) {
            String torrent_dir = null;
            if (COConfigurationManager.getBooleanParameter("Save Torrent Files")) {
                try {
                    torrent_dir = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
                }
                catch (Exception egnore) {
                    // empty catch block
                }
            }
            if (torrent_dir == null || torrent_dir.length() == 0) {
                throw new DownloadException("DownloadManager::addDownload: default torrent save directory must be configured");
            }
            torrent_file = new File(torrent_dir + File.separator + torrent.getName() + ".torrent");
            try {
                torrent.writeToFile(torrent_file);
            }
            catch (TorrentException e) {
                throw new DownloadException("DownloadManager::addDownload: failed to write torrent to '" + torrent_file.toString() + "'", e);
            }
        }
        if (!torrent_file.exists()) {
            throw new DownloadException("DownloadManager::addDownload: torrent file does not exist - " + torrent_file.toString());
        }
        if (!torrent_file.isFile()) {
            throw new DownloadException("DownloadManager::addDownload: torrent filepath given is not a file - " + torrent_file.toString());
        }
        if (data_location == null) {
            String data_dir = COConfigurationManager.getStringParameter("Default save path");
            if (data_dir == null || data_dir.length() == 0) {
                throw new DownloadException("DownloadManager::addDownload: default data save directory must be configured");
            }
            data_location = new File(data_dir);
            FileUtil.mkdirs(data_location);
        }
        byte[] hash = null;
        try {
            hash = torrent.getHash();
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean for_seeding = torrent.isComplete();
        org.gudy.azureus2.core3.download.DownloadManager dm = this.global_manager.addDownloadManager(torrent_file.toString(), hash, data_location.toString(), initial_state, true, for_seeding, null);
        if (dm == null) {
            throw new DownloadException("DownloadManager::addDownload - failed, download may already in the process of being added");
        }
        this.addDownloadManager(dm);
        return this.getDownload(dm);
    }

    @Override
    public Download addDownloadStopped(Torrent torrent, File torrent_location, File data_location) throws DownloadException {
        return this.addDownload(torrent, torrent_location, data_location, 70);
    }

    @Override
    public Download addNonPersistentDownload(Torrent torrent, File torrent_file, File data_location) throws DownloadException {
        byte[] hash = null;
        try {
            hash = torrent.getHash();
        }
        catch (Exception e) {
            // empty catch block
        }
        org.gudy.azureus2.core3.download.DownloadManager dm = this.global_manager.addDownloadManager(torrent_file.toString(), hash, data_location.toString(), this.getInitialState(), false);
        if (dm == null) {
            throw new DownloadException("DownloadManager::addDownload - failed");
        }
        this.addDownloadManager(dm);
        return this.getDownload(dm);
    }

    @Override
    public Download addNonPersistentDownloadStopped(Torrent torrent, File torrent_file, File data_location) throws DownloadException {
        byte[] hash = null;
        try {
            hash = torrent.getHash();
        }
        catch (Exception e) {
            // empty catch block
        }
        org.gudy.azureus2.core3.download.DownloadManager dm = this.global_manager.addDownloadManager(torrent_file.toString(), hash, data_location.toString(), 70, false);
        if (dm == null) {
            throw new DownloadException("DownloadManager::addDownload - failed");
        }
        this.addDownloadManager(dm);
        return this.getDownload(dm);
    }

    @Override
    public void clearNonPersistentDownloadState(byte[] hash) {
        this.global_manager.clearNonPersistentDownloadState(hash);
    }

    protected int getInitialState() {
        boolean default_start_stopped = COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped");
        return default_start_stopped ? 70 : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DownloadImpl getDownload(org.gudy.azureus2.core3.download.DownloadManager dm) throws DownloadException {
        DownloadImpl dl = this.download_map.get(dm);
        if (dl == null) {
            try {
                this.listeners_mon.enter();
                dl = this.download_map.get(dm);
                if (dl != null) {
                    DownloadImpl downloadImpl = dl;
                    return downloadImpl;
                }
                dl = this.pending_dls.get(dm);
            }
            finally {
                this.listeners_mon.exit();
            }
            if (dl != null) {
                long now = SystemTime.getMonotonousTime();
                while (true) {
                    DownloadImpl dl2;
                    if ((dl2 = this.download_map.get(dm)) != null) {
                        return dl2;
                    }
                    if (SystemTime.getMonotonousTime() - now > 5000L) break;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Throwable e) {}
                }
                return dl;
            }
            throw new DownloadException("DownloadManager::getDownload: download not found");
        }
        return dl;
    }

    public static DownloadImpl[] getDownloadStatic(org.gudy.azureus2.core3.download.DownloadManager[] dm) {
        ArrayList<DownloadImpl> res = new ArrayList<DownloadImpl>(dm.length);
        for (int i = 0; i < dm.length; ++i) {
            try {
                res.add(DownloadManagerImpl.getDownloadStatic(dm[i]));
                continue;
            }
            catch (DownloadException downloadException) {
                // empty catch block
            }
        }
        return res.toArray(new DownloadImpl[res.size()]);
    }

    public static DownloadImpl getDownloadStatic(org.gudy.azureus2.core3.download.DownloadManager dm) throws DownloadException {
        if (singleton != null) {
            return singleton.getDownload(dm);
        }
        throw new DownloadException("DownloadManager not initialised");
    }

    public static Download getDownloadStatic(DiskManager dm) throws DownloadException {
        if (singleton != null) {
            return singleton.getDownload(dm);
        }
        throw new DownloadException("DownloadManager not initialised");
    }

    public Download getDownload(DiskManager dm) throws DownloadException {
        List<org.gudy.azureus2.core3.download.DownloadManager> dls = this.global_manager.getDownloadManagers();
        for (int i = 0; i < dls.size(); ++i) {
            org.gudy.azureus2.core3.download.DownloadManager man = dls.get(i);
            if (man.getDiskManager() != dm) continue;
            return this.getDownload(man.getTorrent());
        }
        return null;
    }

    protected Download getDownload(TOTorrent torrent) throws DownloadException {
        if (torrent != null) {
            for (int i = 0; i < this.downloads.size(); ++i) {
                Download dl = this.downloads.get(i);
                TorrentImpl t = (TorrentImpl)dl.getTorrent();
                if (t == null || !t.getTorrent().hasSameHashAs(torrent)) continue;
                return dl;
            }
        }
        throw new DownloadException("DownloadManager::getDownload: download not found");
    }

    public static Download getDownloadStatic(TOTorrent torrent) throws DownloadException {
        if (singleton != null) {
            return singleton.getDownload(torrent);
        }
        throw new DownloadException("DownloadManager not initialised");
    }

    @Override
    public Download getDownload(Torrent _torrent) {
        TorrentImpl torrent = (TorrentImpl)_torrent;
        try {
            return this.getDownload(torrent.getTorrent());
        }
        catch (DownloadException downloadException) {
            return null;
        }
    }

    @Override
    public Download getDownload(byte[] hash) {
        org.gudy.azureus2.core3.download.DownloadManager manager = this.global_manager.getDownloadManager(new HashWrapper(hash));
        if (manager != null) {
            try {
                return this.getDownload(manager);
            }
            catch (DownloadException e) {
                // empty catch block
            }
        }
        List<org.gudy.azureus2.core3.download.DownloadManager> dls = this.global_manager.getDownloadManagers();
        for (int i = 0; i < dls.size(); ++i) {
            org.gudy.azureus2.core3.download.DownloadManager man = dls.get(i);
            TOTorrent torrent = man.getTorrent();
            if (torrent == null) continue;
            try {
                if (!Arrays.equals(torrent.getHash(), hash)) continue;
                return this.getDownload(torrent);
            }
            catch (DownloadException e) {
                continue;
            }
            catch (TOTorrentException e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Download[] getDownloads() {
        LinkedHashSet<Download> res_l;
        List<org.gudy.azureus2.core3.download.DownloadManager> dms = this.global_manager.getDownloadManagers();
        try {
            int i;
            this.listeners_mon.enter();
            res_l = new LinkedHashSet<Download>(this.downloads.size());
            for (i = 0; i < dms.size(); ++i) {
                DownloadImpl dl = this.download_map.get(dms.get(i));
                if (dl == null) continue;
                res_l.add(dl);
            }
            if (res_l.size() < this.downloads.size()) {
                for (i = 0; i < this.downloads.size(); ++i) {
                    Download download = this.downloads.get(i);
                    if (res_l.contains(download)) continue;
                    res_l.add(download);
                }
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        Download[] res = new Download[res_l.size()];
        res_l.toArray(res);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Download[] getDownloads(boolean bSorted) {
        if (bSorted) {
            return this.getDownloads();
        }
        try {
            this.listeners_mon.enter();
            Download[] res = new Download[this.downloads.size()];
            this.downloads.toArray(res);
            Download[] downloadArray = res;
            return downloadArray;
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    @Override
    public void pauseDownloads() {
        this.global_manager.pauseDownloads();
    }

    @Override
    public boolean canPauseDownloads() {
        return this.global_manager.canPauseDownloads();
    }

    @Override
    public void resumeDownloads() {
        this.global_manager.resumeDownloads();
    }

    @Override
    public boolean canResumeDownloads() {
        return this.global_manager.canResumeDownloads();
    }

    @Override
    public void startAllDownloads() {
        this.global_manager.startAllDownloads();
    }

    @Override
    public void stopAllDownloads() {
        this.global_manager.stopAllDownloads();
    }

    @Override
    public DownloadManagerStats getStats() {
        return this.stats;
    }

    @Override
    public boolean isSeedingOnly() {
        return this.global_manager.isSeedingOnly();
    }

    @Override
    public void addListener(DownloadManagerListener l) {
        this.addListener(l, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(DownloadManagerListener l, boolean notify_of_current_downloads) {
        ArrayList<Download> downloads_copy = null;
        try {
            this.listeners_mon.enter();
            ArrayList<DownloadManagerListener> new_listeners = new ArrayList<DownloadManagerListener>(this.listeners);
            new_listeners.add(l);
            this.listeners = new_listeners;
            if (notify_of_current_downloads) {
                downloads_copy = new ArrayList<Download>(this.downloads);
                Collections.shuffle(downloads_copy);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        if (downloads_copy != null) {
            for (int i = 0; i < downloads_copy.size(); ++i) {
                try {
                    l.downloadAdded((Download)downloads_copy.get(i));
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    @Override
    public void removeListener(DownloadManagerListener l) {
        this.removeListener(l, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(DownloadManagerListener l, boolean notify_of_current_downloads) {
        ArrayList<Download> downloads_copy = null;
        try {
            this.listeners_mon.enter();
            ArrayList<DownloadManagerListener> new_listeners = new ArrayList<DownloadManagerListener>(this.listeners);
            new_listeners.remove(l);
            this.listeners = new_listeners;
            if (notify_of_current_downloads) {
                downloads_copy = new ArrayList<Download>(this.downloads);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
        if (downloads_copy != null) {
            for (int i = 0; i < downloads_copy.size(); ++i) {
                try {
                    l.downloadRemoved((Download)downloads_copy.get(i));
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialised(org.gudy.azureus2.core3.download.DownloadManager manager, boolean for_seeding) {
        DownloadImpl dl;
        try {
            this.listeners_mon.enter();
            dl = new DownloadImpl(this, manager);
            this.pending_dls.put(manager, dl);
        }
        finally {
            this.listeners_mon.exit();
        }
        Iterator<DownloadWillBeAddedListener> it = this.dwba_listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().initialised(dl);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public int getActions() {
        if (this.dwba_listeners.size() > 0) {
            return 1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDownloadWillBeAddedListener(DownloadWillBeAddedListener listener) {
        try {
            this.listeners_mon.enter();
            this.dwba_listeners.add(listener);
            if (this.dwba_listeners.size() == 1) {
                this.global_manager.addDownloadManagerInitialisationAdapter(this);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDownloadWillBeAddedListener(DownloadWillBeAddedListener listener) {
        try {
            this.listeners_mon.enter();
            this.dwba_listeners.remove(listener);
            if (this.dwba_listeners.size() == 0) {
                this.global_manager.removeDownloadManagerInitialisationAdapter(this);
            }
        }
        finally {
            this.listeners_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExternalDownload(Download download) {
        List<DownloadManagerListener> listeners_ref = null;
        try {
            this.listeners_mon.enter();
            if (this.downloads.contains(download)) {
                return;
            }
            this.downloads.add(download);
            listeners_ref = this.listeners;
        }
        finally {
            this.listeners_mon.exit();
        }
        for (int i = 0; i < listeners_ref.size(); ++i) {
            try {
                listeners_ref.get(i).downloadAdded(download);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExternalDownload(Download download) {
        List<DownloadManagerListener> listeners_ref = null;
        try {
            this.listeners_mon.enter();
            if (!this.downloads.contains(download)) {
                return;
            }
            this.downloads.remove(download);
            listeners_ref = this.listeners;
        }
        finally {
            this.listeners_mon.exit();
        }
        for (int i = 0; i < listeners_ref.size(); ++i) {
            try {
                listeners_ref.get(i).downloadRemoved(download);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    @Override
    public DownloadEventNotifier getGlobalDownloadEventNotifier() {
        return this.global_dl_notifier;
    }

    @Override
    public void setSaveLocationManager(SaveLocationManager manager) {
        if (manager == null) {
            manager = this.getDefaultSaveLocationManager();
        }
        DownloadManagerMoveHandler.CURRENT_HANDLER = manager;
    }

    @Override
    public SaveLocationManager getSaveLocationManager() {
        return DownloadManagerMoveHandler.CURRENT_HANDLER;
    }

    @Override
    public DefaultSaveLocationManager getDefaultSaveLocationManager() {
        return DownloadManagerDefaultPaths.DEFAULT_HANDLER;
    }

    private void readStubConfig() {
        Map map;
        List list;
        if (FileUtil.resilientConfigFileExists(STUB_CONFIG_FILE) && (list = (List)(map = FileUtil.readResilientConfigFile(STUB_CONFIG_FILE)).get("stubs")) != null) {
            for (Map m : list) {
                DownloadStubImpl stub = new DownloadStubImpl(this, m);
                this.download_stubs.add(stub);
                this.download_stub_map.put(stub.getTorrentHash(), stub);
            }
        }
    }

    private void writeStubConfig() {
        if (this.download_stubs.size() == 0) {
            FileUtil.deleteResilientConfigFile(STUB_CONFIG_FILE);
        } else {
            HashMap map = new HashMap();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(this.download_stubs.size());
            map.put("stubs", list);
            for (DownloadStubImpl stub : this.download_stubs) {
                list.add(stub.exportToMap());
            }
            FileUtil.writeResilientConfigFile(STUB_CONFIG_FILE, map);
        }
        this.dirty_stubs = false;
    }

    public boolean canStubbify(DownloadImpl download) {
        if (download.getState() != 7) {
            return false;
        }
        if (!download.isPersistent()) {
            return false;
        }
        if (download.getTorrent() == null) {
            return false;
        }
        if (download.getFlag(16L) || download.getFlag(512L)) {
            return false;
        }
        return download.isComplete(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DownloadStub stubbify(DownloadImpl download) throws DownloadException, DownloadRemovalVetoException {
        List<Tag> tag_list;
        if (!this.canStubbify(download)) {
            throw new DownloadException("Download not in stubbifiable state");
        }
        org.gudy.azureus2.core3.download.DownloadManager core_dm = PluginCoreUtils.unwrap(download);
        Map<String, Object> gm_data = this.global_manager.exportDownloadStateToMap(core_dm);
        try {
            gm_data = BDecoder.decode(BEncoder.encode(gm_data));
        }
        catch (IOException e) {
            Debug.out(e);
        }
        Object[] manual_tags = null;
        if (this.tag_manager.isEnabled() && (tag_list = this.tag_manager.getTagType(3).getTagsForTaggable(core_dm)) != null && tag_list.size() > 0) {
            String restored_tag_name = MessageText.getString("label.restored");
            tag_list = new ArrayList<Tag>(tag_list);
            Iterator<Tag> it = tag_list.iterator();
            while (it.hasNext()) {
                Tag t = it.next();
                if (t.isTagAuto()[0]) {
                    it.remove();
                    continue;
                }
                if (!t.getTagName(true).equals(restored_tag_name)) continue;
                it.remove();
            }
            if (tag_list.size() > 0) {
                manual_tags = new String[tag_list.size()];
                for (int i = 0; i < manual_tags.length; ++i) {
                    manual_tags[i] = tag_list.get(i).getTagName(true);
                }
                Arrays.sort(manual_tags);
            }
        }
        DownloadStubImpl stub = new DownloadStubImpl(this, download, (String[])manual_tags, gm_data);
        try {
            this.informAdded(stub, true);
        }
        finally {
            stub.setStubbified();
        }
        boolean added = false;
        try {
            core_dm.getDownloadState().exportState(ARCHIVE_DIR);
            download.remove(false, false);
            List<DownloadStubImpl> list = this.download_stubs;
            synchronized (list) {
                this.download_stubs.add(stub);
                this.download_stub_map.put(stub.getTorrentHash(), stub);
                this.writeStubConfig();
            }
            added = true;
            this.informAdded(stub, false);
        }
        finally {
            if (!added) {
                this.informRemoved(stub, true);
            }
        }
        return stub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Download destubbify(DownloadStubImpl stub) throws DownloadException {
        boolean removed = false;
        this.informRemoved(stub, true);
        try {
            byte[] torrent_hash = stub.getTorrentHash();
            try {
                DownloadManagerStateFactory.importDownloadState(ARCHIVE_DIR, torrent_hash);
            }
            catch (Throwable e) {
                throw new DownloadException("Failed to import download state", e);
            }
            org.gudy.azureus2.core3.download.DownloadManager core_dm = this.global_manager.importDownloadStateFromMap(stub.getGMMap());
            if (core_dm == null) {
                try {
                    DownloadManagerStateFactory.deleteDownloadState(torrent_hash);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
                throw new DownloadException("Failed to add download");
            }
            try {
                DownloadManagerStateFactory.deleteDownloadState(ARCHIVE_DIR, torrent_hash);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            List<DownloadStubImpl> e = this.download_stubs;
            synchronized (e) {
                this.download_stubs.remove(stub);
                this.download_stub_map.remove(stub.getTorrentHash());
                this.writeStubConfig();
            }
            String[] manual_tags = stub.getManualTags();
            if (manual_tags != null && this.tag_manager.isEnabled()) {
                TagType tt = this.tag_manager.getTagType(3);
                for (String name : manual_tags) {
                    Tag tag = tt.getTag(name, true);
                    if (tag == null) {
                        try {
                            tag = tt.createTag(name, true);
                        }
                        catch (Throwable e2) {
                            Debug.out(e2);
                        }
                    }
                    if (tag == null) continue;
                    tag.addTaggable(core_dm);
                }
            }
            removed = true;
            this.informRemoved(stub, false);
            Download download = PluginCoreUtils.wrap(core_dm);
            return download;
        }
        finally {
            if (!removed) {
                this.informAdded(stub, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(DownloadStubImpl stub) {
        boolean removed = false;
        this.informRemoved(stub, true);
        try {
            try {
                DownloadManagerStateFactory.deleteDownloadState(ARCHIVE_DIR, stub.getTorrentHash());
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            List<DownloadStubImpl> list = this.download_stubs;
            synchronized (list) {
                this.download_stubs.remove(stub);
                this.download_stub_map.remove(stub.getTorrentHash());
                this.writeStubConfig();
            }
            removed = true;
            this.informRemoved(stub, false);
        }
        finally {
            if (!removed) {
                this.informAdded(stub, true);
            }
        }
    }

    public static TOTorrent getStubTorrent(byte[] hash) {
        File torrent_file = new File(ARCHIVE_DIR, ByteFormatter.encodeString(hash) + ".dat");
        if (torrent_file.exists()) {
            try {
                return TOTorrentFactory.deserialiseFromBEncodedFile(torrent_file);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return null;
    }

    protected TOTorrent getTorrent(DownloadStubImpl stub) {
        File torrent_file = new File(ARCHIVE_DIR, ByteFormatter.encodeString(stub.getTorrentHash()) + ".dat");
        if (torrent_file.exists()) {
            try {
                return TOTorrentFactory.deserialiseFromBEncodedFile(torrent_file);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updated(DownloadStubImpl stub) {
        List<DownloadStubImpl> list = this.download_stubs;
        synchronized (list) {
            this.dirty_stubs = true;
        }
        this.dirty_stub_dispatcher.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadStub[] getDownloadStubs() {
        List<DownloadStubImpl> list = this.download_stubs;
        synchronized (list) {
            return this.download_stubs.toArray(new DownloadStub[this.download_stubs.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDownloadStubCount() {
        List<DownloadStubImpl> list = this.download_stubs;
        synchronized (list) {
            return this.download_stubs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadStub lookupDownloadStub(byte[] hash) {
        List<DownloadStubImpl> list = this.download_stubs;
        synchronized (list) {
            return this.download_stub_map.get(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informAdded(DownloadStub stub, final boolean preparing) {
        Set<DownloadStub> set = this.informing_of_add;
        synchronized (set) {
            if (this.informing_of_add.contains(stub)) {
                Debug.out("Already informing of addition, ignoring");
                return;
            }
            this.informing_of_add.add(stub);
        }
        try {
            final ArrayList<DownloadStub> list = new ArrayList<DownloadStub>();
            list.add(stub);
            for (DownloadStubListener l : this.download_stub_listeners) {
                try {
                    l.downloadStubEventOccurred(new DownloadStubEvent(){

                        @Override
                        public int getEventType() {
                            return preparing ? 3 : 1;
                        }

                        @Override
                        public List<DownloadStub> getDownloadStubs() {
                            return list;
                        }
                    });
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        finally {
            set = this.informing_of_add;
            synchronized (set) {
                this.informing_of_add.remove(stub);
            }
        }
    }

    private void informRemoved(DownloadStub stub, final boolean preparing) {
        final ArrayList<DownloadStub> list = new ArrayList<DownloadStub>();
        list.add(stub);
        for (DownloadStubListener l : this.download_stub_listeners) {
            try {
                l.downloadStubEventOccurred(new DownloadStubEvent(){

                    @Override
                    public int getEventType() {
                        return preparing ? 4 : 2;
                    }

                    @Override
                    public List<DownloadStub> getDownloadStubs() {
                        return list;
                    }
                });
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDownloadStubListener(DownloadStubListener l, boolean inform_of_current) {
        this.download_stub_listeners.add(l);
        if (inform_of_current) {
            ArrayList<DownloadStubImpl> existing;
            List<DownloadStubImpl> list = this.download_stubs;
            synchronized (list) {
                existing = new ArrayList<DownloadStubImpl>(this.download_stubs);
            }
            try {
                l.downloadStubEventOccurred(new DownloadStubEvent(){

                    @Override
                    public int getEventType() {
                        return 1;
                    }

                    @Override
                    public List<DownloadStub> getDownloadStubs() {
                        return existing;
                    }
                });
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void removeDownloadStubListener(DownloadStubListener l) {
        this.download_stub_listeners.remove(l);
    }

    static {
        class_mon = new AEMonitor("DownloadManager:class");
        ARCHIVE_DIR = FileUtil.getUserFile("dlarchive");
        if (!ARCHIVE_DIR.exists()) {
            FileUtil.mkdirs(ARCHIVE_DIR);
        }
    }
}

