/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.disk;

import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequestListener;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.disk.DiskManagerException;
import org.gudy.azureus2.plugins.disk.DiskManagerWriteRequest;
import org.gudy.azureus2.plugins.disk.DiskManagerWriteRequestListener;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.utils.PooledByteBufferImpl;

public class DiskManagerImpl
implements DiskManager {
    private org.gudy.azureus2.core3.disk.DiskManager disk_manager;

    public DiskManagerImpl(org.gudy.azureus2.core3.disk.DiskManager _disk_manager) {
        this.disk_manager = _disk_manager;
    }

    public org.gudy.azureus2.core3.disk.DiskManager getDiskmanager() {
        return this.disk_manager;
    }

    @Override
    public org.gudy.azureus2.plugins.disk.DiskManagerReadRequest read(int piece_number, int offset, int length, final org.gudy.azureus2.plugins.disk.DiskManagerReadRequestListener listener) throws DiskManagerException {
        if (!this.disk_manager.checkBlockConsistencyForRead("plugin", false, piece_number, offset, length)) {
            throw new DiskManagerException("read invalid - parameters incorrect or piece incomplete");
        }
        final DMRR request2 = new DMRR(this.disk_manager.createReadRequest(piece_number, offset, length));
        this.disk_manager.enqueueReadRequest(request2.getDelegate(), new DiskManagerReadRequestListener(){

            @Override
            public void readCompleted(DiskManagerReadRequest _request, DirectByteBuffer _data) {
                listener.complete(request2, new PooledByteBufferImpl(_data));
            }

            @Override
            public void readFailed(DiskManagerReadRequest _request, Throwable _cause) {
                listener.failed(request2, new DiskManagerException("read failed", _cause));
            }

            @Override
            public int getPriority() {
                return 0;
            }

            @Override
            public void requestExecuted(long bytes) {
            }
        });
        return request2;
    }

    @Override
    public DiskManagerWriteRequest write(final int piece_number, final int offset, PooledByteBuffer data, final DiskManagerWriteRequestListener listener) throws DiskManagerException {
        DirectByteBuffer buffer = ((PooledByteBufferImpl)data).getBuffer();
        if (!this.disk_manager.checkBlockConsistencyForWrite("plugin", piece_number, offset, buffer)) {
            throw new DiskManagerException("write invalid - parameters incorrect");
        }
        final int length = buffer.remaining((byte)1);
        final DMWR request2 = new DMWR(this.disk_manager.createWriteRequest(piece_number, offset, buffer, null), length);
        this.disk_manager.enqueueWriteRequest(request2.getDelegate(), new org.gudy.azureus2.core3.disk.DiskManagerWriteRequestListener(){

            @Override
            public void writeCompleted(org.gudy.azureus2.core3.disk.DiskManagerWriteRequest _request) {
                DiskManagerPiece[] dm_pieces = DiskManagerImpl.this.disk_manager.getPieces();
                DiskManagerPiece dm_piece = dm_pieces[piece_number];
                if (!dm_piece.isDone()) {
                    int current_offset = offset;
                    for (int i = 0; i < length; i += 16384) {
                        dm_piece.setWritten(current_offset / 16384);
                        current_offset += 16384;
                    }
                }
                listener.complete(request2);
            }

            @Override
            public void writeFailed(org.gudy.azureus2.core3.disk.DiskManagerWriteRequest _request, Throwable _cause) {
                listener.failed(request2, new DiskManagerException("read failed", _cause));
            }
        });
        return request2;
    }

    private static class DMRR
    implements org.gudy.azureus2.plugins.disk.DiskManagerReadRequest {
        private DiskManagerReadRequest request;

        private DMRR(DiskManagerReadRequest _request) {
            this.request = _request;
        }

        private DiskManagerReadRequest getDelegate() {
            return this.request;
        }

        @Override
        public int getPieceNumber() {
            return this.request.getPieceNumber();
        }

        @Override
        public int getOffset() {
            return this.request.getOffset();
        }

        @Override
        public int getLength() {
            return this.request.getLength();
        }
    }

    private static class DMWR
    implements DiskManagerWriteRequest {
        private org.gudy.azureus2.core3.disk.DiskManagerWriteRequest request;
        private int length;

        private DMWR(org.gudy.azureus2.core3.disk.DiskManagerWriteRequest _request, int _length) {
            this.request = _request;
        }

        private org.gudy.azureus2.core3.disk.DiskManagerWriteRequest getDelegate() {
            return this.request;
        }

        @Override
        public int getPieceNumber() {
            return this.request.getPieceNumber();
        }

        @Override
        public int getOffset() {
            return this.request.getOffset();
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

