/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginState;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.installer.PluginInstallerImpl;
import org.gudy.azureus2.update.UpdaterUtils;

public class PluginStateImpl
implements PluginState {
    private PluginInterfaceImpl pi;
    private PluginInitializer initialiser;
    private boolean disabled;
    boolean operational;
    boolean failed;

    public PluginStateImpl(PluginInterfaceImpl pi, PluginInitializer initialiser) {
        this.pi = pi;
        this.initialiser = initialiser;
    }

    @Override
    public void setLoadedAtStartup(boolean load_at_startup) {
        String param_name = "PluginInfo." + this.pi.getPluginID() + ".enabled";
        COConfigurationManager.setParameter(param_name, load_at_startup);
    }

    @Override
    public boolean isLoadedAtStartup() {
        String param_name = "PluginInfo." + this.pi.getPluginID() + ".enabled";
        if (!COConfigurationManager.hasParameter(param_name, false)) {
            return true;
        }
        return COConfigurationManager.getBooleanParameter(param_name);
    }

    @Override
    public boolean hasFailed() {
        return this.failed;
    }

    @Override
    public void setDisabled(boolean _disabled) {
        this.disabled = _disabled;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public boolean isBuiltIn() {
        String dir = this.pi.getPluginDirectoryName();
        if (dir == null) {
            return PluginInitializer.isLoadingBuiltin();
        }
        return dir.length() == 0 || this.pi.getPluginID().equals(UpdaterUtils.AZUPDATER_PLUGIN_ID) || this.pi.getPluginID().equals(UpdaterUtils.AZUPDATERPATCHER_PLUGIN_ID);
    }

    @Override
    public boolean isMandatory() {
        if (this.pi.getPluginID().equals(UpdaterUtils.AZUPDATER_PLUGIN_ID) || this.pi.getPluginID().equals(UpdaterUtils.AZUPDATERPATCHER_PLUGIN_ID)) {
            return true;
        }
        String mand = this.pi.getPluginProperties().getProperty("plugin.mandatory");
        return mand != null && mand.trim().toLowerCase().equals("true");
    }

    void setOperational(boolean b, boolean reloading) {
        this.operational = b;
        if (!reloading) {
            this.initialiser.fireOperational(this.pi, this.operational);
        }
    }

    @Override
    public boolean isOperational() {
        return this.operational;
    }

    @Override
    public boolean isShared() {
        String shared_dir = FileUtil.getApplicationFile("plugins").toString();
        String plugin_dir = this.pi.getPluginDirectoryName();
        return plugin_dir.startsWith(shared_dir);
    }

    @Override
    public boolean isInitialisationComplete() {
        return this.initialiser.isInitialisationComplete();
    }

    @Override
    public void reload() throws PluginException {
        if (this.isUnloadable() || this.isOperational()) {
            this.unload(true);
        }
        this.initialiser.reloadPlugin(this.pi);
    }

    @Override
    public void uninstall() throws PluginException {
        PluginInstallerImpl.getSingleton(this.pi.getPluginManager()).uninstall(this.pi);
    }

    @Override
    public boolean isUnloaded() {
        return this.pi.class_loader == null;
    }

    @Override
    public void unload() throws PluginException {
        this.unload(false);
    }

    protected void unload(boolean for_reload) throws PluginException {
        if (!this.isUnloadable()) {
            throw new PluginException("Plugin isn't unloadable");
        }
        String dir = this.pi.getPluginDirectoryName();
        if (dir == null || dir.length() == 0) {
            try {
                ((UnloadablePlugin)this.pi.getPlugin()).unload();
            }
            catch (Throwable e) {
                Debug.out("Plugin unload operation failed", e);
            }
            this.initialiser.unloadPlugin(this.pi);
        } else {
            ArrayList<PluginInterfaceImpl> pis = new ArrayList<PluginInterfaceImpl>(PluginInitializer.getPluginInterfaces());
            for (int i = 0; i < pis.size(); ++i) {
                PluginInterfaceImpl pi = (PluginInterfaceImpl)pis.get(i);
                String other_dir = pi.getPluginDirectoryName();
                if (other_dir == null || other_dir.length() == 0 || !dir.equals(other_dir)) continue;
                try {
                    ((UnloadablePlugin)pi.getPlugin()).unload();
                }
                catch (Throwable e) {
                    Debug.out("Plugin unload operation failed", e);
                }
                this.initialiser.unloadPlugin(pi);
            }
        }
        for (int i = 0; i < this.pi.children.size(); ++i) {
            ((PluginStateImpl)((PluginInterface)this.pi.children.get(i)).getPluginState()).unload(for_reload);
        }
        this.setOperational(false, for_reload);
        this.pi.destroy();
    }

    @Override
    public boolean isUnloadable() {
        int i;
        String dir = this.pi.getPluginDirectoryName();
        boolean disable_unload = this.pi.getPluginProperties().getProperty("plugin.unload.disabled", "").equalsIgnoreCase("true");
        if (disable_unload) {
            return false;
        }
        if (dir == null || dir.length() == 0) {
            return this.pi.getPlugin() instanceof UnloadablePlugin;
        }
        List<PluginInterfaceImpl> pis = PluginInitializer.getPluginInterfaces();
        for (i = 0; i < pis.size(); ++i) {
            PluginInterface pi = pis.get(i);
            String other_dir = pi.getPluginDirectoryName();
            if (other_dir == null || other_dir.length() == 0 || !dir.equals(other_dir) || pi.getPlugin() instanceof UnloadablePlugin) continue;
            return false;
        }
        for (i = 0; i < this.pi.children.size(); ++i) {
            if (((PluginInterface)this.pi.children.get(i)).getPluginState().isUnloadable()) continue;
            return false;
        }
        return true;
    }
}

