/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginState;
import org.gudy.azureus2.plugins.clientid.ClientIDManager;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.dht.mainline.MainlineDHTManager;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.logging.Logger;
import org.gudy.azureus2.plugins.messaging.MessageManager;
import org.gudy.azureus2.plugins.network.ConnectionManager;
import org.gudy.azureus2.plugins.platform.PlatformManager;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ConfigSection;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.PluginConfigUIFactory;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.plugins.utils.ShortCuts;
import org.gudy.azureus2.plugins.utils.Utilities;
import org.gudy.azureus2.pluginsimpl.local.FailedPlugin;
import org.gudy.azureus2.pluginsimpl.local.PluginConfigImpl;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.PluginStateImpl;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.deprecate.PluginDeprecation;
import org.gudy.azureus2.pluginsimpl.local.dht.mainline.MainlineDHTManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ipc.IPCInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.ipfilter.IPFilterImpl;
import org.gudy.azureus2.pluginsimpl.local.logging.LoggerImpl;
import org.gudy.azureus2.pluginsimpl.local.messaging.MessageManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.network.ConnectionManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.sharing.ShareManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.tracker.TrackerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ConfigSectionHolder;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ConfigSectionRepository;
import org.gudy.azureus2.pluginsimpl.local.ui.config.ParameterRepository;
import org.gudy.azureus2.pluginsimpl.local.ui.config.PluginConfigUIFactoryImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.ShortCutsImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;

public final class PluginInterfaceImpl
implements PluginInterface,
AzureusCoreComponent {
    private static final LogIDs LOGID = LogIDs.PLUGIN;
    private Plugin plugin;
    private PluginInitializer initialiser;
    private Object initialiser_key;
    protected ClassLoader class_loader;
    private CopyOnWriteList<PluginListener> listeners = new CopyOnWriteList();
    private Set<PluginListener> init_complete_fired_set = new HashSet<PluginListener>();
    private CopyOnWriteList<PluginEventListener> event_listeners = new CopyOnWriteList();
    private String key;
    private String pluginConfigKey;
    private Properties props;
    private String pluginDir;
    private PluginConfigImpl config;
    private String plugin_version;
    private Logger logger;
    private IPCInterfaceImpl ipc_interface;
    protected List children = new ArrayList();
    private PluginStateImpl state;
    private String given_plugin_id;
    private String plugin_id_to_use;

    protected PluginInterfaceImpl(Plugin _plugin, PluginInitializer _initialiser, Object _initialiser_key, ClassLoader _class_loader, List<File> _verified_files, String _key, Properties _props, String _pluginDir, String _plugin_id, String _plugin_version) throws PluginException {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        int pos = 0;
        while (!stack[pos].getClassName().equals(PluginInterfaceImpl.class.getName())) {
            ++pos;
        }
        String caller_class = stack[pos + 1].getClassName();
        if (!caller_class.equals("org.gudy.azureus2.pluginsimpl.local.PluginInitializer") && !caller_class.equals("org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl")) {
            throw new PluginException("Invalid caller");
        }
        String class_name = this.getClass().getCanonicalName();
        if (class_name == null || !class_name.equals("org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl")) {
            throw new PluginException("Subclassing not permitted");
        }
        this.plugin = _plugin;
        this.initialiser = _initialiser;
        this.initialiser_key = _initialiser_key;
        this.class_loader = _class_loader;
        this.key = _key;
        this.pluginConfigKey = "Plugin." + _key;
        this.props = new propertyWrapper(_props);
        this.pluginDir = _pluginDir;
        this.config = new PluginConfigImpl(this, this.pluginConfigKey);
        this.given_plugin_id = _plugin_id;
        this.plugin_version = _plugin_version;
        this.ipc_interface = new IPCInterfaceImpl(this.initialiser, this.plugin);
        this.state = new PluginStateImpl(this, this.initialiser);
        boolean verified = false;
        boolean bad = false;
        if (_plugin_id.endsWith("_v")) {
            File jar;
            if (this.plugin.getClass() == FailedPlugin.class) {
                verified = true;
            } else if (_verified_files != null && (jar = FileUtil.getJarFileFromClass(this.plugin.getClass())) != null) {
                for (File file : _verified_files) {
                    if (!file.equals(jar)) continue;
                    verified = true;
                }
            }
            if (!verified) {
                bad = true;
            }
        }
        PluginInitializer.setVerified(this, this.plugin, verified, bad);
    }

    @Override
    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean isOperational() {
        PluginDeprecation.call("isOperational", this.given_plugin_id);
        return this.getPluginState().isOperational();
    }

    public Object getInitializerKey() {
        return this.initialiser_key;
    }

    @Override
    public PluginManager getPluginManager() {
        return this.initialiser.getPluginManager();
    }

    @Override
    public String getApplicationName() {
        return Constants.APP_NAME;
    }

    @Override
    public String getAzureusName() {
        return "Azureus";
    }

    @Override
    public String getAzureusVersion() {
        return "5.7.5.0";
    }

    @Override
    public void addConfigSection(ConfigSection section) {
        ConfigSectionRepository.getInstance().addConfigSection(section, this);
    }

    @Override
    public void removeConfigSection(ConfigSection section) {
        ConfigSectionRepository.getInstance().removeConfigSection(section);
    }

    @Override
    public ConfigSection[] getConfigSections() {
        ArrayList<ConfigSection> list = ConfigSectionRepository.getInstance().getList();
        Iterator<ConfigSection> iter = list.iterator();
        while (iter.hasNext()) {
            ConfigSection configSection = iter.next();
            if (!(configSection instanceof ConfigSectionHolder) || ((ConfigSectionHolder)configSection).getPluginInterface() == this) continue;
            iter.remove();
        }
        return list.toArray(new ConfigSection[0]);
    }

    @Override
    public void openTorrentFile(String fileName) {
        PluginDeprecation.call("openTorrentFile", this.getPluginID());
        try {
            this.getDownloadManager().addDownload(new File(fileName));
        }
        catch (DownloadException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void openTorrentURL(String url) {
        PluginDeprecation.call("openTorrentURL", this.getPluginID());
        try {
            this.getDownloadManager().addDownload(new URL(url));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void setPluginName(String name) {
        this.props.put("plugin.name", name);
    }

    @Override
    public String getPluginName() {
        String name = null;
        if (this.props != null) {
            name = (String)this.props.get("plugin.name");
        }
        if (name == null) {
            try {
                name = new File(this.pluginDir).getName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (name == null || name.length() == 0) {
            name = this.plugin.getClass().getName();
        }
        return name;
    }

    public void setPluginVersion(String version) {
        this.props.put("plugin.version", version);
    }

    @Override
    public String getPluginVersion() {
        String version = (String)this.props.get("plugin.version");
        if (version == null) {
            version = this.plugin_version;
        }
        return version;
    }

    @Override
    public String getPluginID() {
        String id = (String)this.props.get("plugin.id");
        if (id != null && id.equals("azupdater")) {
            this.plugin_id_to_use = id;
        }
        if (this.plugin_id_to_use != null) {
            return this.plugin_id_to_use;
        }
        if (id == null) {
            id = this.given_plugin_id;
        }
        if (id == null) {
            id = "<none>";
        }
        this.plugin_id_to_use = id;
        return this.plugin_id_to_use;
    }

    @Override
    public boolean isMandatory() {
        PluginDeprecation.call("isMandatory", this.given_plugin_id);
        return this.getPluginState().isMandatory();
    }

    @Override
    public boolean isBuiltIn() {
        PluginDeprecation.call("isBuiltIn", this.given_plugin_id);
        return this.getPluginState().isBuiltIn();
    }

    @Override
    public Properties getPluginProperties() {
        return this.props;
    }

    @Override
    public String getPluginDirectoryName() {
        return this.pluginDir;
    }

    @Override
    public String getPerUserPluginDirectoryName() {
        String name = this.pluginDir == null ? this.getPluginID() : new File(this.pluginDir).getName();
        String str = new File(new File(SystemProperties.getUserPath(), "plugins"), name).getAbsolutePath();
        if (this.pluginDir == null) {
            return str;
        }
        try {
            if (new File(this.pluginDir).getCanonicalPath().equals(new File(str).getCanonicalPath())) {
                return this.pluginDir;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return str;
    }

    public void setPluginDirectoryName(String name) {
        this.initialiser_key = new File(name);
        this.pluginDir = name;
    }

    @Override
    public void addConfigUIParameters(Parameter[] parameters, String displayName) {
        ParameterRepository.getInstance().addPlugin(parameters, displayName);
    }

    @Override
    public PluginConfig getPluginconfig() {
        return this.config;
    }

    @Override
    public PluginConfigUIFactory getPluginConfigUIFactory() {
        return new PluginConfigUIFactoryImpl(this.config, this.pluginConfigKey);
    }

    public String getPluginConfigKey() {
        return this.pluginConfigKey;
    }

    @Override
    public Tracker getTracker() {
        return TrackerImpl.getSingleton();
    }

    @Override
    public ShareManager getShareManager() throws ShareException {
        return ShareManagerImpl.getSingleton();
    }

    @Override
    public DownloadManager getDownloadManager() {
        return DownloadManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    @Override
    public MainlineDHTManager getMainlineDHTManager() {
        return new MainlineDHTManagerImpl(this.initialiser.getAzureusCore());
    }

    @Override
    public TorrentManager getTorrentManager() {
        return TorrentManagerImpl.getSingleton().specialise(this);
    }

    @Override
    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = new LoggerImpl(this);
        }
        return this.logger;
    }

    @Override
    public IPFilter getIPFilter() {
        return new IPFilterImpl();
    }

    @Override
    public Utilities getUtilities() {
        return new UtilitiesImpl(this.initialiser.getAzureusCore(), this);
    }

    @Override
    public ShortCuts getShortCuts() {
        return new ShortCutsImpl(this);
    }

    @Override
    public UIManager getUIManager() {
        return new UIManagerImpl(this);
    }

    @Override
    public UpdateManager getUpdateManager() {
        return UpdateManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    protected void unloadSupport() {
        this.ipc_interface.unload();
        UIManagerImpl.unload(this);
    }

    @Override
    public boolean isUnloadable() {
        PluginDeprecation.call("unloadable", this.given_plugin_id);
        return this.getPluginState().isUnloadable();
    }

    @Override
    public void reload() throws PluginException {
        PluginDeprecation.call("reload", this.given_plugin_id);
        this.getPluginState().reload();
    }

    @Override
    public void unload() throws PluginException {
        PluginDeprecation.call("unload", this.given_plugin_id);
        this.getPluginState().unload();
    }

    @Override
    public void uninstall() throws PluginException {
        PluginDeprecation.call("uninstall", this.given_plugin_id);
        this.getPluginState().uninstall();
    }

    @Override
    public boolean isInitialisationThread() {
        return this.initialiser.isInitialisationThread();
    }

    @Override
    public ClientIDManager getClientIDManager() {
        return ClientIDManagerImpl.getSingleton();
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return ConnectionManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    @Override
    public MessageManager getMessageManager() {
        return MessageManagerImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    @Override
    public DistributedDatabase getDistributedDatabase() {
        return DDBaseImpl.getSingleton(this.initialiser.getAzureusCore());
    }

    @Override
    public PlatformManager getPlatformManager() {
        return PlatformManagerFactory.getPlatformManager();
    }

    protected void initialisationComplete() {
        Iterator<PluginListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                this.fireInitComplete(it.next());
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).initialisationComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireInitComplete(PluginListener listener) {
        Set<PluginListener> set = this.init_complete_fired_set;
        synchronized (set) {
            if (this.init_complete_fired_set.contains(listener)) {
                return;
            }
            this.init_complete_fired_set.add(listener);
        }
        try {
            listener.initializationComplete();
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    protected void closedownInitiated() {
        Iterator<PluginListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().closedownInitiated();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).closedownInitiated();
        }
    }

    protected void closedownComplete() {
        Iterator<PluginListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                it.next().closedownComplete();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).closedownComplete();
        }
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        return this.class_loader;
    }

    @Override
    public PluginInterface getLocalPluginInterface(Class plugin_class, String id) throws PluginException {
        try {
            Plugin p = (Plugin)plugin_class.newInstance();
            Properties local_props = new Properties(this.props);
            local_props.remove("plugin.id");
            if (id.endsWith("_v")) {
                throw new Exception("Verified plugins must be loaded from a jar");
            }
            PluginInterfaceImpl pi = new PluginInterfaceImpl(p, this.initialiser, this.initialiser_key, this.class_loader, null, this.key + "." + id, local_props, this.pluginDir, this.getPluginID() + "." + id, this.plugin_version);
            this.initialiser.fireCreated(pi);
            p.initialize(pi);
            this.children.add(pi);
            return pi;
        }
        catch (Throwable e) {
            if (e instanceof PluginException) {
                throw (PluginException)e;
            }
            throw new PluginException("Local initialisation fails", e);
        }
    }

    @Override
    public IPCInterfaceImpl getIPC() {
        return this.ipc_interface;
    }

    @Override
    public boolean isShared() {
        PluginDeprecation.call("isShared", this.given_plugin_id);
        return this.getPluginState().isShared();
    }

    void setAsFailed() {
        this.getPluginState().setDisabled(true);
        this.state.failed = true;
    }

    protected void destroy() {
        this.class_loader = null;
        this.plugin = new FailedPlugin("Plugin '" + this.getPluginID() + "' has been unloaded!", null);
    }

    @Override
    public void addListener(PluginListener l) {
        this.listeners.add(l);
        if (this.initialiser.isInitialisationComplete()) {
            this.fireInitComplete(l);
        }
    }

    @Override
    public void removeListener(final PluginListener l) {
        this.listeners.remove(l);
        new DelayedEvent("PIL:clear", 10000L, new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                Set set = PluginInterfaceImpl.this.init_complete_fired_set;
                synchronized (set) {
                    PluginInterfaceImpl.this.init_complete_fired_set.remove(l);
                }
            }
        });
    }

    @Override
    public void addEventListener(final PluginEventListener l) {
        this.initialiser.runPEVTask(new AERunnable(){

            @Override
            public void runSupport() {
                List<PluginEvent> events = PluginInterfaceImpl.this.initialiser.getPEVHistory();
                for (PluginEvent event2 : events) {
                    try {
                        l.handleEvent(event2);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                PluginInterfaceImpl.this.event_listeners.add(l);
            }
        });
    }

    @Override
    public void removeEventListener(final PluginEventListener l) {
        this.initialiser.runPEVTask(new AERunnable(){

            @Override
            public void runSupport() {
                PluginInterfaceImpl.this.event_listeners.remove(l);
            }
        });
    }

    @Override
    public void firePluginEvent(final PluginEvent event2) {
        this.initialiser.runPEVTask(new AERunnable(){

            @Override
            public void runSupport() {
                PluginInterfaceImpl.this.firePluginEventSupport(event2);
            }
        });
    }

    protected void firePluginEventSupport(PluginEvent event2) {
        Iterator<PluginEventListener> it = this.event_listeners.iterator();
        while (it.hasNext()) {
            try {
                PluginEventListener listener = it.next();
                listener.handleEvent(event2);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        for (int i = 0; i < this.children.size(); ++i) {
            ((PluginInterfaceImpl)this.children.get(i)).firePluginEvent(event2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateEvidence(IndentWriter writer) {
        block15: {
            writer.println(this.getPluginName());
            try {
                String[] files;
                File dir;
                String type;
                writer.indent();
                writer.println("id:" + this.getPluginID() + ",version:" + this.getPluginVersion());
                String user_dir = FileUtil.getUserFile("plugins").toString();
                String shared_dir = FileUtil.getApplicationFile("plugins").toString();
                String plugin_dir = this.getPluginDirectoryName();
                boolean built_in = false;
                if (plugin_dir.startsWith(shared_dir)) {
                    type = "shared";
                } else if (plugin_dir.startsWith(user_dir)) {
                    type = "per-user";
                } else {
                    built_in = true;
                    type = "built-in";
                }
                PluginState ps = this.getPluginState();
                String info = this.getPluginconfig().getPluginStringParameter("plugin.info");
                writer.println("type:" + type + ",enabled=" + !ps.isDisabled() + ",load_at_start=" + ps.isLoadedAtStartup() + ",operational=" + ps.isOperational() + (info == null || info.length() == 0 ? "" : ",info=" + info));
                if (ps.isOperational()) {
                    Plugin plugin = this.getPlugin();
                    if (!(plugin instanceof AEDiagnosticsEvidenceGenerator)) break block15;
                    try {
                        writer.indent();
                        ((AEDiagnosticsEvidenceGenerator)((Object)plugin)).generate(writer);
                        writer.exdent();
                        break block15;
                    }
                    catch (Throwable e) {
                        try {
                            writer.println("Failed to generate plugin-specific info: " + Debug.getNestedExceptionMessage(e));
                            break block15;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            writer.exdent();
                        }
                    }
                }
                if (!built_in && (dir = new File(plugin_dir)).exists() && (files = dir.list()) != null) {
                    String files_str = "";
                    for (String f : files) {
                        files_str = files_str + (files_str.length() == 0 ? "" : ", ") + f;
                    }
                    writer.println("    files: " + files_str);
                }
            }
            finally {
                writer.exdent();
            }
        }
    }

    @Override
    public boolean isDisabled() {
        PluginDeprecation.call("isDisabled", this.given_plugin_id);
        return this.getPluginState().isDisabled();
    }

    @Override
    public void setDisabled(boolean disabled) {
        PluginDeprecation.call("setDisabled", this.given_plugin_id);
        this.getPluginState().setDisabled(disabled);
    }

    @Override
    public PluginState getPluginState() {
        return this.state;
    }

    PluginStateImpl getPluginStateImpl() {
        return this.state;
    }

    protected class propertyWrapper
    extends Properties {
        protected boolean initialising = true;

        protected propertyWrapper(Properties _props) {
            for (Object key : _props.keySet()) {
                this.put(key, _props.get(key));
            }
            this.initialising = false;
        }

        @Override
        public Object setProperty(String str, String val) {
            if (!PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("org.gudy") && !PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("com.aelitis.") && (str.equalsIgnoreCase("plugin.id") || str.equalsIgnoreCase("plugin.version"))) {
                if (org.gudy.azureus2.core3.logging.Logger.isEnabled()) {
                    org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(LOGID, 1, "Plugin '" + PluginInterfaceImpl.this.getPluginName() + "' tried to set property '" + str + "' - action ignored"));
                }
                return null;
            }
            return super.setProperty(str, val);
        }

        @Override
        public Object put(Object key, Object value) {
            String k_str;
            if (!PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("org.gudy") && !PluginInterfaceImpl.this.plugin.getClass().getName().startsWith("com.aelitis.") && !this.initialising && key instanceof String && ((k_str = (String)key).equalsIgnoreCase("plugin.id") || k_str.equalsIgnoreCase("plugin.version"))) {
                if (org.gudy.azureus2.core3.logging.Logger.isEnabled()) {
                    org.gudy.azureus2.core3.logging.Logger.log(new LogEvent(LOGID, 1, "Plugin '" + PluginInterfaceImpl.this.getPluginName() + "' tried to set property '" + k_str + "' - action ignored"));
                }
                return null;
            }
            return super.put(key, value);
        }

        @Override
        public Object get(Object key) {
            return super.get(key);
        }
    }
}

