/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import com.aelitis.net.magneturi.MagnetURIHandler;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.StringListImpl;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginConfigListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.config.ConfigParameter;
import org.gudy.azureus2.plugins.config.PluginConfigSource;
import org.gudy.azureus2.pluginsimpl.local.config.ConfigParameterImpl;
import org.gudy.azureus2.pluginsimpl.local.config.PluginConfigSourceImpl;

public class PluginConfigImpl
implements PluginConfig {
    protected static Map<String, String> external_to_internal_key_map = new HashMap<String, String>();
    private PluginConfigSourceImpl external_source = null;
    private static Map fake_values_when_disabled;
    private static int fake_values_ref_count;
    private PluginInterface plugin_interface;
    private String key;
    private boolean allow_key_modification;

    public void checkValidCoreParam(String name) {
        if (!external_to_internal_key_map.containsKey(name)) {
            throw new IllegalArgumentException("invalid core parameter: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEnablePluginCoreConfigChange(boolean enabled) {
        Class<PluginConfigImpl> clazz = PluginConfigImpl.class;
        synchronized (PluginConfigImpl.class) {
            if (enabled) {
                if (--fake_values_ref_count == 0) {
                    fake_values_when_disabled = null;
                }
            } else if (++fake_values_ref_count == 1) {
                fake_values_when_disabled = new HashMap();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getFakeValueWhenDisabled(String key, String name) {
        if (name.startsWith(key)) {
            return null;
        }
        Class<PluginConfigImpl> clazz = PluginConfigImpl.class;
        synchronized (PluginConfigImpl.class) {
            if (fake_values_when_disabled != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return fake_values_when_disabled.get(name);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setFakeValueWhenDisabled(String key, String name, Object value) {
        if (name.startsWith(key)) {
            return false;
        }
        Class<PluginConfigImpl> clazz = PluginConfigImpl.class;
        synchronized (PluginConfigImpl.class) {
            if (fake_values_when_disabled != null) {
                fake_values_when_disabled.put(name, value);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    public PluginConfigImpl(PluginInterface _plugin_interface, String _key) {
        this.plugin_interface = _plugin_interface;
        this.key = _key + ".";
        this.allow_key_modification = true;
    }

    @Override
    public boolean isNewInstall() {
        return COConfigurationManager.isNewInstall();
    }

    @Override
    public String getPluginConfigKeyPrefix() {
        return this.key;
    }

    @Override
    public void setPluginConfigKeyPrefix(String _key) {
        if (!this.allow_key_modification) {
            throw new RuntimeException("cannot modify key prefix - already in use");
        }
        if (_key.length() <= 0 && !this.plugin_interface.getPluginState().isBuiltIn()) {
            throw new RuntimeException("Can't set Plugin Config Key Prefix to '" + _key + "'");
        }
        this.key = _key;
    }

    private boolean getBooleanParameter(String name, boolean _default, boolean map_name, boolean set_default) {
        Object obj = PluginConfigImpl.getFakeValueWhenDisabled(this.key, name);
        if (obj != null) {
            return (Boolean)obj;
        }
        if (map_name) {
            name = this.mapKeyName(name, false);
        }
        this.notifyParamExists(name);
        if (set_default) {
            COConfigurationManager.setBooleanDefault(name, _default);
        } else if (!this.hasParameter(name)) {
            return _default;
        }
        return COConfigurationManager.getBooleanParameter(name);
    }

    private int[] getColorParameter(String name, int[] _default, boolean map_name, boolean set_default) {
        int[] result;
        Object obj = PluginConfigImpl.getFakeValueWhenDisabled(this.key, name);
        if (obj != null) {
            return (int[])obj;
        }
        if (map_name) {
            name = this.mapKeyName(name, false);
        }
        if ((result = this.getColorParameter0(name, _default, set_default)) == null) {
            return null;
        }
        if (result.length == 3) {
            int[] result2 = new int[4];
            System.arraycopy(result, 0, result2, 0, 3);
            result2[3] = this.getIntParameter(name, 0, false, false);
            result = result2;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int[] getColorParameter0(String name, int[] _default, boolean set_default) {
        Object obj = PluginConfigImpl.getFakeValueWhenDisabled(this.key, name);
        if (obj != null) {
            return (int[])obj;
        }
        this.notifyRGBParamExists(name);
        if (set_default) {
            if (_default == null) throw new RuntimeException("color parameter default is null");
            COConfigurationManager.setIntDefault(name + ".red", _default[0]);
            COConfigurationManager.setIntDefault(name + ".green", _default[1]);
            COConfigurationManager.setIntDefault(name + ".blue", _default[2]);
            return new int[]{COConfigurationManager.getIntParameter(name + ".red"), COConfigurationManager.getIntParameter(name + ".green"), COConfigurationManager.getIntParameter(name + ".blue"), COConfigurationManager.getIntParameter(name + ".override")};
        } else {
            if (this.hasParameter(name + ".red")) return new int[]{COConfigurationManager.getIntParameter(name + ".red"), COConfigurationManager.getIntParameter(name + ".green"), COConfigurationManager.getIntParameter(name + ".blue"), COConfigurationManager.getIntParameter(name + ".override")};
            return _default;
        }
    }

    private byte[] getByteParameter(String name, byte[] _default, boolean map_name, boolean set_default) {
        Object obj = PluginConfigImpl.getFakeValueWhenDisabled(this.key, name);
        if (obj != null) {
            return (byte[])obj;
        }
        if (map_name) {
            name = this.mapKeyName(name, false);
        }
        this.notifyParamExists(name);
        if (set_default) {
            COConfigurationManager.setByteDefault(name, _default);
        } else if (!this.hasParameter(name)) {
            return _default;
        }
        return COConfigurationManager.getByteParameter(name);
    }

    private float getFloatParameter(String name, float _default, boolean map_name, boolean set_default) {
        Object obj = PluginConfigImpl.getFakeValueWhenDisabled(this.key, name);
        if (obj != null) {
            return ((Float)obj).floatValue();
        }
        if (map_name) {
            name = this.mapKeyName(name, false);
        }
        this.notifyParamExists(name);
        if (set_default) {
            COConfigurationManager.setFloatDefault(name, _default);
        } else if (!this.hasParameter(name)) {
            return _default;
        }
        return COConfigurationManager.getFloatParameter(name);
    }

    private int getIntParameter(String name, int _default, boolean map_name, boolean set_default) {
        Object obj = PluginConfigImpl.getFakeValueWhenDisabled(this.key, name);
        if (obj != null) {
            return ((Long)obj).intValue();
        }
        if (map_name) {
            name = this.mapKeyName(name, false);
        }
        this.notifyParamExists(name);
        if (set_default) {
            COConfigurationManager.setIntDefault(name, _default);
        } else if (!this.hasParameter(name)) {
            return _default;
        }
        return COConfigurationManager.getIntParameter(name);
    }

    private long getLongParameter(String name, long _default, boolean map_name, boolean set_default) {
        Object obj = PluginConfigImpl.getFakeValueWhenDisabled(this.key, name);
        if (obj != null) {
            return (Long)obj;
        }
        if (map_name) {
            name = this.mapKeyName(name, false);
        }
        this.notifyParamExists(name);
        if (set_default) {
            COConfigurationManager.setLongDefault(name, _default);
        } else if (!this.hasParameter(name)) {
            return _default;
        }
        return COConfigurationManager.getLongParameter(name);
    }

    private String getStringParameter(String name, String _default, boolean map_name, boolean set_default) {
        Object obj = PluginConfigImpl.getFakeValueWhenDisabled(this.key, name);
        if (obj != null) {
            return (String)obj;
        }
        if (map_name) {
            name = this.mapKeyName(name, false);
        }
        this.notifyParamExists(name);
        if (set_default) {
            COConfigurationManager.setStringDefault(name, _default);
        } else if (!this.hasParameter(name)) {
            return _default;
        }
        return COConfigurationManager.getStringParameter(name);
    }

    private boolean getDefaultedBooleanParameter(String name, boolean map_name) {
        Object obj = PluginConfigImpl.getFakeValueWhenDisabled(this.key, name);
        if (obj != null) {
            return (Boolean)obj;
        }
        return this.getBooleanParameter(name, false, map_name, false);
    }

    private byte[] getDefaultedByteParameter(String name, boolean map_name) {
        return this.getByteParameter(name, ConfigurationDefaults.def_bytes, map_name, false);
    }

    private int[] getDefaultedColorParameter(String name, boolean map_name) {
        int[] default_value = new int[]{0, 0, 0, 1};
        return this.getColorParameter(name, default_value, map_name, false);
    }

    private float getDefaultedFloatParameter(String name, boolean map_name) {
        return this.getFloatParameter(name, 0.0f, map_name, false);
    }

    private int getDefaultedIntParameter(String name, boolean map_name) {
        return this.getIntParameter(name, 0, map_name, false);
    }

    private long getDefaultedLongParameter(String name, boolean map_name) {
        return this.getLongParameter(name, 0L, map_name, false);
    }

    private String getDefaultedStringParameter(String name, boolean map_name) {
        return this.getStringParameter(name, "", map_name, false);
    }

    @Override
    public boolean getBooleanParameter(String name) {
        return this.getDefaultedBooleanParameter(name, true);
    }

    @Override
    public boolean getBooleanParameter(String name, boolean default_value) {
        return this.getBooleanParameter(name, default_value, true, false);
    }

    @Override
    public byte[] getByteParameter(String name) {
        return this.getDefaultedByteParameter(name, true);
    }

    @Override
    public byte[] getByteParameter(String name, byte[] default_value) {
        return this.getByteParameter(name, default_value, true, false);
    }

    @Override
    public float getFloatParameter(String name) {
        return this.getDefaultedFloatParameter(name, true);
    }

    @Override
    public float getFloatParameter(String name, float default_value) {
        return this.getFloatParameter(name, default_value, true, false);
    }

    @Override
    public int getIntParameter(String name) {
        return this.getDefaultedIntParameter(name, true);
    }

    @Override
    public int getIntParameter(String name, int default_value) {
        return this.getIntParameter(name, default_value, true, false);
    }

    @Override
    public long getLongParameter(String name) {
        return this.getDefaultedLongParameter(name, true);
    }

    @Override
    public long getLongParameter(String name, long default_value) {
        return this.getLongParameter(name, default_value, true, false);
    }

    @Override
    public String getStringParameter(String name) {
        return this.getDefaultedStringParameter(name, true);
    }

    @Override
    public String getStringParameter(String name, String default_value) {
        return this.getStringParameter(name, default_value, true, false);
    }

    @Override
    public boolean getCoreBooleanParameter(String name) {
        this.checkValidCoreParam(name);
        return this.getDefaultedBooleanParameter(name, true);
    }

    @Override
    public boolean getCoreBooleanParameter(String name, boolean default_value) {
        this.checkValidCoreParam(name);
        return this.getBooleanParameter(name, default_value, true, false);
    }

    @Override
    public byte[] getCoreByteParameter(String name) {
        this.checkValidCoreParam(name);
        return this.getDefaultedByteParameter(name, true);
    }

    @Override
    public byte[] getCoreByteParameter(String name, byte[] default_value) {
        this.checkValidCoreParam(name);
        return this.getByteParameter(name, default_value, true, false);
    }

    @Override
    public int[] getCoreColorParameter(String name) {
        this.checkValidCoreParam(name);
        return this.getDefaultedColorParameter(name, true);
    }

    @Override
    public int[] getCoreColorParameter(String name, int[] default_value) {
        this.checkValidCoreParam(name);
        return this.getColorParameter(name, default_value, true, false);
    }

    @Override
    public float getCoreFloatParameter(String name) {
        this.checkValidCoreParam(name);
        return this.getDefaultedFloatParameter(name, true);
    }

    @Override
    public float getCoreFloatParameter(String name, float default_value) {
        this.checkValidCoreParam(name);
        return this.getFloatParameter(name, default_value, true, false);
    }

    @Override
    public int getCoreIntParameter(String name) {
        this.checkValidCoreParam(name);
        return this.getDefaultedIntParameter(name, true);
    }

    @Override
    public int getCoreIntParameter(String name, int default_value) {
        this.checkValidCoreParam(name);
        return this.getIntParameter(name, default_value, true, false);
    }

    @Override
    public long getCoreLongParameter(String name) {
        this.checkValidCoreParam(name);
        return this.getDefaultedLongParameter(name, true);
    }

    @Override
    public long getCoreLongParameter(String name, long default_value) {
        this.checkValidCoreParam(name);
        return this.getLongParameter(name, default_value, true, false);
    }

    @Override
    public String getCoreStringParameter(String name) {
        this.checkValidCoreParam(name);
        return this.getDefaultedStringParameter(name, true);
    }

    @Override
    public String getCoreStringParameter(String name, String default_value) {
        this.checkValidCoreParam(name);
        return this.getStringParameter(name, default_value, true, false);
    }

    @Override
    public void setBooleanParameter(String name, boolean value) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, value)) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(name, true), value);
    }

    @Override
    public void setByteParameter(String name, byte[] value) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, value)) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(name, true), value);
    }

    public void setColorParameter(String name, int[] value) {
        this.setColorParameter(name, value, true);
    }

    public void setColorParameter(String name, int[] value, boolean override) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, value)) {
            return;
        }
        COConfigurationManager.setRGBParameter(this.mapKeyName(name, true), value, override);
    }

    @Override
    public void setFloatParameter(String name, float value) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, new Float(value))) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(name, true), value);
    }

    @Override
    public void setIntParameter(String name, int value) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, new Long(value))) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(name, true), value);
    }

    @Override
    public void setLongParameter(String name, long value) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, new Long(value))) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(name, true), value);
    }

    @Override
    public void setStringParameter(String name, String value) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, value)) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(name, true), value);
    }

    @Override
    public void setCoreBooleanParameter(String name, boolean value) {
        this.checkValidCoreParam(name);
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, value)) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(name, true), value);
    }

    @Override
    public void setCoreByteParameter(String name, byte[] value) {
        this.checkValidCoreParam(name);
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, value)) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(name, true), value);
    }

    @Override
    public void setCoreColorParameter(String name, int[] value) {
        this.setCoreColorParameter(name, value, true);
    }

    @Override
    public void setCoreColorParameter(String name, int[] value, boolean override) {
        this.checkValidCoreParam(name);
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, value)) {
            return;
        }
        COConfigurationManager.setRGBParameter(this.mapKeyName(name, true), value, override);
    }

    @Override
    public void setCoreFloatParameter(String name, float value) {
        this.checkValidCoreParam(name);
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, new Float(value))) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(name, true), value);
    }

    @Override
    public void setCoreIntParameter(String name, int value) {
        this.checkValidCoreParam(name);
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, new Long(value))) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(name, true), value);
    }

    @Override
    public void setCoreLongParameter(String name, long value) {
        this.checkValidCoreParam(name);
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, new Long(value))) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(name, true), value);
    }

    @Override
    public void setCoreStringParameter(String name, String value) {
        this.checkValidCoreParam(name);
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, value)) {
            return;
        }
        COConfigurationManager.setParameter(this.mapKeyName(name, true), value);
    }

    @Override
    public boolean getPluginBooleanParameter(String name) {
        return this.getDefaultedBooleanParameter(this.key + name, false);
    }

    @Override
    public boolean getPluginBooleanParameter(String name, boolean default_value) {
        return this.getBooleanParameter(this.key + name, default_value, false, true);
    }

    @Override
    public byte[] getPluginByteParameter(String name) {
        return this.getDefaultedByteParameter(this.key + name, false);
    }

    @Override
    public byte[] getPluginByteParameter(String name, byte[] default_value) {
        return this.getByteParameter(this.key + name, default_value, false, true);
    }

    @Override
    public int[] getPluginColorParameter(String name) {
        return this.getDefaultedColorParameter(this.key + name, false);
    }

    @Override
    public int[] getPluginColorParameter(String name, int[] default_value) {
        return this.getColorParameter(this.key + name, default_value, false, true);
    }

    @Override
    public float getPluginFloatParameter(String name) {
        return this.getDefaultedFloatParameter(this.key + name, false);
    }

    @Override
    public float getPluginFloatParameter(String name, float default_value) {
        return this.getFloatParameter(this.key + name, default_value, false, true);
    }

    @Override
    public int getPluginIntParameter(String name) {
        return this.getDefaultedIntParameter(this.key + name, false);
    }

    @Override
    public int getPluginIntParameter(String name, int default_value) {
        return this.getIntParameter(this.key + name, default_value, false, true);
    }

    @Override
    public long getPluginLongParameter(String name) {
        return this.getDefaultedLongParameter(this.key + name, false);
    }

    @Override
    public long getPluginLongParameter(String name, long default_value) {
        return this.getLongParameter(this.key + name, default_value, false, true);
    }

    @Override
    public String getPluginStringParameter(String name) {
        return this.getDefaultedStringParameter(this.key + name, false);
    }

    @Override
    public String getPluginStringParameter(String name, String default_value) {
        return this.getStringParameter(this.key + name, default_value, false, true);
    }

    @Override
    public void setPluginParameter(String name, boolean value) {
        this.notifyParamExists(this.key + name);
        COConfigurationManager.setParameter(this.key + name, value);
    }

    @Override
    public void setPluginParameter(String name, byte[] value) {
        this.notifyParamExists(this.key + name);
        COConfigurationManager.setParameter(this.key + name, value);
    }

    @Override
    public void setPluginParameter(String name, float value) {
        this.notifyParamExists(this.key + name);
        COConfigurationManager.setParameter(this.key + name, value);
    }

    @Override
    public void setPluginParameter(String name, int value) {
        this.notifyParamExists(this.key + name);
        COConfigurationManager.setParameter(this.key + name, value);
    }

    @Override
    public void setPluginParameter(String name, long value) {
        this.notifyParamExists(this.key + name);
        COConfigurationManager.setParameter(this.key + name, value);
    }

    @Override
    public void setPluginParameter(String name, String value) {
        this.notifyParamExists(this.key + name);
        COConfigurationManager.setParameter(this.key + name, value);
    }

    @Override
    public void setPluginColorParameter(String name, int[] value) {
        this.setPluginColorParameter(name, value, true);
    }

    @Override
    public void setPluginColorParameter(String name, int[] value, boolean override) {
        this.notifyParamExists(this.key + name);
        COConfigurationManager.setRGBParameter(this.key + name, value, override);
    }

    @Override
    public boolean getUnsafeBooleanParameter(String name) {
        return this.getDefaultedBooleanParameter(name, false);
    }

    @Override
    public boolean getUnsafeBooleanParameter(String name, boolean default_value) {
        return this.getBooleanParameter(name, default_value, false, false);
    }

    @Override
    public byte[] getUnsafeByteParameter(String name) {
        return this.getDefaultedByteParameter(name, false);
    }

    @Override
    public byte[] getUnsafeByteParameter(String name, byte[] default_value) {
        return this.getByteParameter(name, default_value, false, false);
    }

    @Override
    public int[] getUnsafeColorParameter(String name) {
        return this.getDefaultedColorParameter(name, false);
    }

    @Override
    public int[] getUnsafeColorParameter(String name, int[] default_value) {
        return this.getColorParameter(name, default_value, false, false);
    }

    @Override
    public float getUnsafeFloatParameter(String name) {
        return this.getDefaultedFloatParameter(name, false);
    }

    @Override
    public float getUnsafeFloatParameter(String name, float default_value) {
        return this.getFloatParameter(name, default_value, false, false);
    }

    @Override
    public int getUnsafeIntParameter(String name) {
        return this.getDefaultedIntParameter(name, false);
    }

    @Override
    public int getUnsafeIntParameter(String name, int default_value) {
        return this.getIntParameter(name, default_value, false, false);
    }

    @Override
    public long getUnsafeLongParameter(String name) {
        return this.getDefaultedLongParameter(name, false);
    }

    @Override
    public long getUnsafeLongParameter(String name, long default_value) {
        return this.getLongParameter(name, default_value, false, false);
    }

    @Override
    public String getUnsafeStringParameter(String name) {
        return this.getDefaultedStringParameter(name, false);
    }

    @Override
    public String getUnsafeStringParameter(String name, String default_value) {
        return this.getStringParameter(name, default_value, false, false);
    }

    @Override
    public void setUnsafeBooleanParameter(String name, boolean value) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, value)) {
            return;
        }
        this.notifyParamExists(name);
        COConfigurationManager.setParameter(name, value);
    }

    @Override
    public void setUnsafeByteParameter(String name, byte[] value) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, value)) {
            return;
        }
        this.notifyParamExists(name);
        COConfigurationManager.setParameter(name, value);
    }

    @Override
    public void setUnsafeColorParameter(String name, int[] value) {
        this.setUnsafeColorParameter(name, value, true);
    }

    @Override
    public void setUnsafeColorParameter(String name, int[] value, boolean override) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, value)) {
            return;
        }
        this.notifyRGBParamExists(name);
        COConfigurationManager.setRGBParameter(name, value, override);
    }

    @Override
    public void setUnsafeFloatParameter(String name, float value) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, new Float(value))) {
            return;
        }
        this.notifyParamExists(name);
        COConfigurationManager.setParameter(name, value);
    }

    @Override
    public void setUnsafeIntParameter(String name, int value) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, new Long(value))) {
            return;
        }
        this.notifyParamExists(name);
        COConfigurationManager.setParameter(name, value);
    }

    @Override
    public void setUnsafeLongParameter(String name, long value) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, new Long(value))) {
            return;
        }
        this.notifyParamExists(name);
        COConfigurationManager.setParameter(name, value);
    }

    @Override
    public void setUnsafeStringParameter(String name, String value) {
        if (PluginConfigImpl.setFakeValueWhenDisabled(this.key, name, value)) {
            return;
        }
        this.notifyParamExists(name);
        COConfigurationManager.setParameter(name, value);
    }

    @Override
    public String[] getPluginStringListParameter(String key) {
        this.notifyParamExists(this.key + key);
        return COConfigurationManager.getStringListParameter(this.key + key).toArray();
    }

    @Override
    public void setPluginStringListParameter(String key, String[] value) {
        this.notifyParamExists(this.key + key);
        StringListImpl list_obj = new StringListImpl(Arrays.asList(value));
        COConfigurationManager.setParameter(this.key + key, list_obj);
    }

    @Override
    public List getPluginListParameter(String key, List default_value) {
        this.notifyParamExists(this.key + key);
        return COConfigurationManager.getListParameter(this.key + key, default_value);
    }

    @Override
    public void setPluginListParameter(String key, List value) {
        this.notifyParamExists(this.key + key);
        COConfigurationManager.setParameter(this.key + key, value);
    }

    @Override
    public Map getPluginMapParameter(String key, Map default_value) {
        this.notifyParamExists(this.key + key);
        return COConfigurationManager.getMapParameter(this.key + key, default_value);
    }

    @Override
    public void setPluginMapParameter(String key, Map value) {
        this.notifyParamExists(this.key + key);
        COConfigurationManager.setParameter(this.key + key, value);
    }

    @Override
    public void setPluginParameter(String key, int value, boolean global) {
        this.notifyParamExists(this.key + key);
        COConfigurationManager.setParameter(this.key + key, value);
        if (global) {
            MagnetURIHandler.getSingleton().addInfo(this.key + key, value);
        }
    }

    @Override
    public ConfigParameter getParameter(String key) {
        return new ConfigParameterImpl(this.mapKeyName(key, false));
    }

    @Override
    public ConfigParameter getPluginParameter(String key) {
        return new ConfigParameterImpl(this.key + key);
    }

    @Override
    public boolean removePluginParameter(String key) {
        this.notifyParamExists(this.key + key);
        return COConfigurationManager.removeParameter(this.key + key);
    }

    @Override
    public boolean removePluginColorParameter(String key) {
        this.notifyParamExists(this.key + key);
        return COConfigurationManager.removeRGBParameter(this.key + key);
    }

    @Override
    public Map getUnsafeParameterList() {
        Set<String> params = COConfigurationManager.getAllowedParameters();
        Iterator<String> it = params.iterator();
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (it.hasNext()) {
            try {
                String name = it.next();
                Object val = COConfigurationManager.getParameter(name);
                if (!(val instanceof String) && !(val instanceof Long)) {
                    if (val instanceof byte[]) {
                        val = new String((byte[])val, "UTF-8");
                    } else if (val instanceof Integer) {
                        val = new Long(((Integer)val).intValue());
                    } else if (val instanceof List) {
                        val = null;
                    } else if (val instanceof Map) {
                        val = null;
                    } else if (val instanceof Boolean) {
                        val = new Long((Boolean)val != false ? 1L : 0L);
                    } else if (val instanceof Float || val instanceof Double) {
                        val = val.toString();
                    }
                }
                if (val == null) continue;
                result.put(name, val);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return result;
    }

    @Override
    public void save() {
        COConfigurationManager.save();
    }

    @Override
    public File getPluginUserFile(String name) {
        String dir = this.plugin_interface.getUtilities().getAzureusUserDir();
        File file = new File(dir, "plugins");
        String p_dir = this.plugin_interface.getPluginDirectoryName();
        if (p_dir.length() != 0) {
            int lp = p_dir.lastIndexOf(File.separatorChar);
            if (lp != -1) {
                p_dir = p_dir.substring(lp + 1);
            }
            file = new File(file, p_dir);
        } else {
            String id = this.plugin_interface.getPluginID();
            if (id.length() > 0 && !id.equals("<internal>")) {
                file = new File(file, id);
            } else {
                throw new RuntimeException("Plugin was not loaded from a directory");
            }
        }
        FileUtil.mkdirs(file);
        return new File(file, name);
    }

    @Override
    public void addListener(final PluginConfigListener l) {
        COConfigurationManager.addListener(new COConfigurationListener(){

            @Override
            public void configurationSaved() {
                l.configSaved();
            }
        });
    }

    private String mapKeyName(String key, boolean for_set) {
        String result = external_to_internal_key_map.get(key);
        if (result == null) {
            if (for_set) {
                throw new RuntimeException("No permission to set the value of core parameter: " + key);
            }
            return key;
        }
        return result;
    }

    @Override
    public boolean hasParameter(String param_name) {
        return COConfigurationManager.hasParameter(param_name, false);
    }

    @Override
    public boolean hasPluginParameter(String param_name) {
        this.notifyParamExists(this.key + param_name);
        return COConfigurationManager.hasParameter(this.key + param_name, true);
    }

    public void notifyRGBParamExists(String param) {
        this.notifyParamExists(param + ".red");
        this.notifyParamExists(param + ".blue");
        this.notifyParamExists(param + ".green");
        this.notifyParamExists(param + ".override");
    }

    public void notifyParamExists(String param) {
        if (this.allow_key_modification && param.startsWith(this.key)) {
            this.allow_key_modification = false;
        }
        if (this.external_source != null && param.startsWith(this.key)) {
            this.external_source.registerParameter(param);
        }
    }

    @Override
    public PluginConfigSource enableExternalConfigSource() {
        PluginConfigSourceImpl source = new PluginConfigSourceImpl(this, this.plugin_interface.getPluginID());
        this.setPluginConfigSource(source);
        return source;
    }

    @Override
    public PluginConfigSource getPluginConfigSource() {
        return this.external_source;
    }

    @Override
    public void setPluginConfigSource(PluginConfigSource source) {
        if (this.external_source != null) {
            throw new RuntimeException("external config source already associated!");
        }
        PluginConfigSourceImpl source_impl = (PluginConfigSourceImpl)source;
        String used_key = source_impl.getUsedKeyPrefix();
        if (used_key != null && !this.getPluginConfigKeyPrefix().startsWith(used_key)) {
            throw new RuntimeException("cannot use this config source object - incompatible prefix keys: " + used_key + " / " + this.getPluginConfigKeyPrefix());
        }
        this.external_source = (PluginConfigSourceImpl)source;
    }

    static {
        external_to_internal_key_map.put("Max Upload Speed KBs", "Max Upload Speed KBs");
        external_to_internal_key_map.put("Max Upload Speed When Only Seeding KBs", "Max Upload Speed Seeding KBs");
        external_to_internal_key_map.put("Max Download Speed KBs", "Max Download Speed KBs");
        external_to_internal_key_map.put("Max Connections Global", "Max.Peer.Connections.Total");
        external_to_internal_key_map.put("Max Connections Per Torrent", "Max.Peer.Connections.Per.Torrent");
        external_to_internal_key_map.put("Max Downloads", "max downloads");
        external_to_internal_key_map.put("Max Active Torrents", "max active torrents");
        external_to_internal_key_map.put("Max Active Torrents When Only Seeding", "StartStopManager_iMaxActiveTorrentsWhenSeeding");
        external_to_internal_key_map.put("Max Uploads", "Max Uploads");
        external_to_internal_key_map.put("Max Uploads Seeding", "Max Uploads Seeding");
        external_to_internal_key_map.put("Max Upload Speed When Only Seeding Enabled", "enable.seedingonly.upload.rate");
        external_to_internal_key_map.put("Max Active Torrents When Only Seeding Enabled", "StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled");
        external_to_internal_key_map.put("Auto Upload Speed Enabled", "Auto Upload Speed Enabled");
        external_to_internal_key_map.put("Auto Upload Speed Seeding Enabled", "Auto Upload Speed Seeding Enabled");
        external_to_internal_key_map.put("SOCKS Proxy No Inward Connection", "Proxy.Data.SOCKS.inform");
        external_to_internal_key_map.put("Newly Seeding Torrents Get First Priority", "Newly Seeding Torrents Get First Priority");
        external_to_internal_key_map.put("CORE_PARAM_STRING_LOCAL_BIND_IP", "Bind IP");
        external_to_internal_key_map.put("CORE_PARAM_BOOLEAN_FRIENDLY_HASH_CHECKING", "diskmanager.friendly.hashchecking");
        external_to_internal_key_map.put("GUI_PARAM_INT_SWT_REFRESH_IN_MS", "GUI Refresh");
        external_to_internal_key_map.put("CORE_PARAM_BOOLEAN_NEW_TORRENTS_START_AS_STOPPED", "Default Start Torrents Stopped");
        external_to_internal_key_map.put("Incoming TCP Port", "TCP.Listen.Port");
        external_to_internal_key_map.put("Incoming UDP Port", "UDP.Listen.Port");
        external_to_internal_key_map.put("Default save path", "Default save path");
        String[] passthrough_params = new String[]{"Open MyTorrents", "IconBar.enabled", "Wizard Completed", "welcome.version.lastshown"};
        for (int i = 0; i < passthrough_params.length; ++i) {
            external_to_internal_key_map.put(passthrough_params[i], passthrough_params[i]);
        }
    }
}

