/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.unix;

import com.aelitis.azureus.core.impl.AzureusCoreSingleInstanceClient;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;

public class ScriptBeforeStartup {
    private static PrintStream sysout;
    private static Object display;

    public static void main(String[] args) {
        boolean argsSent;
        boolean mi;
        System.setProperty("transitory.startup", "1");
        sysout = System.out;
        try {
            System.setOut(new PrintStream(new FileOutputStream("/dev/stderr")));
        }
        catch (FileNotFoundException e) {
            // empty catch block
        }
        String mi_str = System.getProperty("MULTI_INSTANCE");
        boolean bl = mi = mi_str != null && mi_str.equalsIgnoreCase("true");
        if (!mi && (argsSent = new AzureusCoreSingleInstanceClient().sendArgs(args, 500))) {
            String msg = "Passing startup args to already-running " + Constants.APP_NAME + " java process listening on [127.0.0.1: " + Constants.INSTANCE_PORT + "]";
            ScriptBeforeStartup.log(msg);
            sysout.println("exit");
            return;
        }
        String scriptAfterShutdown = COConfigurationManager.getStringParameter("scriptaftershutdown", null);
        COConfigurationManager.removeParameter("scriptaftershutdown.exit");
        COConfigurationManager.removeParameter("scriptaftershutdown");
        COConfigurationManager.save();
        if (scriptAfterShutdown != null) {
            ScriptBeforeStartup.log("Script after " + Constants.APP_NAME + " shutdown did not run.. running now");
            sysout.println(scriptAfterShutdown);
            if (!scriptAfterShutdown.contains("$0")) {
                sysout.println("echo \"Restarting Azureus..\"");
                sysout.println("$0\n");
            }
            sysout.println("exit");
            return;
        }
        String moz = ScriptBeforeStartup.getNewGreDir();
        if (moz != null) {
            String s = "export MOZILLA_FIVE_HOME=\"" + moz + "\"\n" + "if [ \"$LD_LIBRARY_PATH x\" = \" x\" ] ; then\n" + "\texport LD_LIBRARY_PATH=$MOZILLA_FIVE_HOME;\n" + "else\n" + "\texport LD_LIBRARY_PATH=$MOZILLA_FIVE_HOME:$LD_LIBRARY_PATH\n" + "fi\n";
            sysout.println(s);
            ScriptBeforeStartup.log("setting LD_LIBRARY_PATH to: $LD_LIBRARY_PATH");
            ScriptBeforeStartup.log("setting MOZILLA_FIVE_HOME to: $MOZILLA_FIVE_HOME");
        } else {
            ScriptBeforeStartup.log("Usable browser found");
        }
    }

    public static String getNewGreDir() {
        if (ScriptBeforeStartup.canOpenBrowser()) {
            return null;
        }
        String grePath = null;
        String[] confList = new String[]{"/etc/gre64.conf", "/etc/gre.d/gre64.conf", "/etc/gre.conf", "/etc/gre.d/gre.conf", "/etc/gre.d/xulrunner.conf", "/etc/gre.d/libxul0d.conf"};
        ScriptBeforeStartup.log("Auto-scanning for GRE/XULRunner.  You can skip this by appending the GRE path to LD_LIBRARY_PATH and setting MOZILLA_FIVE_HOME.");
        try {
            Pattern pat = Pattern.compile("GRE_PATH=(.*)", 2);
            for (int i = 0; i < confList.length; ++i) {
                String possibleGrePath;
                Matcher matcher;
                File file = new File(confList[i]);
                if (!file.isFile() || !file.canRead()) continue;
                ScriptBeforeStartup.log("  checking " + file + " for GRE_PATH");
                String fileText = FileUtil.readFileAsString(file, 16384);
                if (fileText == null || !(matcher = pat.matcher(fileText)).find() || !ScriptBeforeStartup.isValidGrePath(new File(possibleGrePath = matcher.group(1)))) continue;
                grePath = possibleGrePath;
                break;
            }
            if (grePath == null) {
                final ArrayList<File> possibleDirs = new ArrayList<File>();
                File libDir = new File("/usr");
                libDir.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        if (pathname.getName().startsWith("lib")) {
                            possibleDirs.add(pathname);
                        }
                        return false;
                    }
                });
                possibleDirs.add(new File("/usr/local"));
                possibleDirs.add(new File("/opt"));
                final String[] possibleDirNames = new String[]{"mozilla", "firefox", "seamonkey", "xulrunner"};
                FileFilter ffIsPossibleDir = new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        String name = pathname.getName().toLowerCase();
                        for (int i = 0; i < possibleDirNames.length; ++i) {
                            if (!name.startsWith(possibleDirNames[i])) continue;
                            return true;
                        }
                        return false;
                    }
                };
                for (File dir : possibleDirs) {
                    File[] possibleFullDirs = dir.listFiles(ffIsPossibleDir);
                    for (int i = 0; i < possibleFullDirs.length; ++i) {
                        ScriptBeforeStartup.log("  checking " + possibleFullDirs[i] + " for GRE");
                        if (!ScriptBeforeStartup.isValidGrePath(possibleFullDirs[i])) continue;
                        grePath = possibleFullDirs[i].getAbsolutePath();
                        break;
                    }
                    if (grePath == null) continue;
                    break;
                }
            }
            if (grePath != null) {
                ScriptBeforeStartup.log("GRE found at " + grePath + ".");
                System.setProperty("org.eclipse.swt.browser.XULRunnerPath", grePath);
            }
        }
        catch (Throwable t) {
            ScriptBeforeStartup.log("Error trying to find suitable GRE: " + Debug.getNestedExceptionMessage(t));
            grePath = null;
        }
        if (!ScriptBeforeStartup.canOpenBrowser()) {
            ScriptBeforeStartup.log("Can't create browser.  Will try to set LD_LIBRARY_PATH and hope " + Constants.APP_NAME + " has better luck.");
        }
        return grePath;
    }

    private static boolean canOpenBrowser() {
        try {
            Class<?> claDisplay = Class.forName("org.eclipse.swt.widgets.Display");
            if (display != null) {
                display = claDisplay.newInstance();
            }
            Class<?> claShell = Class.forName("org.eclipse.swt.widgets.Shell");
            Constructor<?> shellConstruct = claShell.getConstructor(claDisplay);
            Object shell = shellConstruct.newInstance(display);
            Class<?> claBrowser = Class.forName("org.eclipse.swt.browser.Browser");
            Constructor<?>[] constructors = claBrowser.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                if (constructors[i].getParameterTypes().length != 2) continue;
                Object browser = constructors[i].newInstance(shell, new Integer(0));
                Method methSetUrl = claBrowser.getMethod("setUrl", String.class);
                methSetUrl.invoke(browser, "about:blank");
                break;
            }
            Method methDisposeShell = claShell.getMethod("dispose", new Class[0]);
            methDisposeShell.invoke(shell, new Object[0]);
            return true;
        }
        catch (Throwable e) {
            ScriptBeforeStartup.log("Browser check failed with: " + Debug.getNestedExceptionMessage(e));
            return false;
        }
    }

    private static boolean isValidGrePath(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        if (new File(dir, "components/libwidget_gtk.so").exists() || new File(dir, "libwidget_gtk.so").exists()) {
            ScriptBeforeStartup.log("\tCan not use GRE from " + dir + " as it's too old (GTK2 version required).");
            return false;
        }
        if (new File(dir, "components/libwidget_gtk2.so").exists() || new File(dir, "libwidget_gtk2.so").exists()) {
            return true;
        }
        if (!new File(dir, "components/libxpcom.so").exists() && !new File(dir, "libxpcom.so").exists()) {
            ScriptBeforeStartup.log("\tCan not use GRE from " + dir + " because it's missing libxpcom.so.");
            return false;
        }
        return true;
    }

    private static void log(String string) {
        sysout.println("echo \"" + string.replaceAll("\"", "\\\"") + "\"");
    }
}

