/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.xml.util;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class XMLElement {
    protected String text_content = null;
    protected Collection<XMLElement> contents = null;
    protected Map<String, String> attributes = null;
    protected final String tag_name;
    protected boolean auto_order;
    private static final Comparator<String> ATTRIBUTE_COMPARATOR = String.CASE_INSENSITIVE_ORDER;
    private static final Comparator<XMLElement> CONTENT_COMPARATOR = new ContentComparator();

    public XMLElement(String tag_name) {
        this(tag_name, false);
    }

    public XMLElement(String tag_name, boolean auto_order) {
        this.tag_name = tag_name;
        this.auto_order = auto_order;
    }

    public String getTag() {
        return this.tag_name;
    }

    public String getAttribute(String key) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(key);
    }

    public void addAttribute(String key, String value) {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, String>(ATTRIBUTE_COMPARATOR);
        }
        this.attributes.put(key, value);
    }

    public void addAttribute(String key, int value) {
        this.addAttribute(key, String.valueOf(value));
    }

    public void addAttribute(String key, boolean value) {
        this.addAttribute(key, value ? "yes" : "no");
    }

    public void addContent(String s) {
        if (s == null) {
            throw new NullPointerException();
        }
        if (this.contents != null) {
            throw new IllegalStateException("cannot add text content to an XMLElement when it contains child XMLElement objects");
        }
        if (this.text_content != null) {
            throw new IllegalStateException("text content is already set, you cannot set it again");
        }
        this.text_content = s;
    }

    public void addContent(XMLElement e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.text_content != null) {
            throw new IllegalStateException("cannot add child XMLElement when it contains text content");
        }
        if (this.contents == null) {
            this.contents = !this.auto_order ? new ArrayList<XMLElement>() : new TreeSet<XMLElement>(CONTENT_COMPARATOR);
        }
        this.contents.add(e);
    }

    public void printTo(PrintWriter pw) {
        this.printTo(pw, 0, false);
    }

    public void printTo(PrintWriter pw, boolean spaced_out) {
        this.printTo(pw, 0, spaced_out);
    }

    public void printTo(PrintWriter pw, int indent) {
        this.printTo(pw, indent, false);
    }

    public void printTo(PrintWriter pw, int indent, boolean spaced_out) {
        int i;
        for (int i2 = 0; i2 < indent; ++i2) {
            pw.print(" ");
        }
        if (this.attributes == null && this.contents == null && this.text_content == null) {
            pw.print("<");
            pw.print(this.tag_name);
            pw.print(" />");
            return;
        }
        pw.print("<");
        pw.print(this.tag_name);
        if (this.attributes != null) {
            for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
                pw.print(" ");
                pw.print(entry.getKey());
                pw.print("=\"");
                pw.print(this.quote(entry.getValue()));
                pw.print("\"");
            }
        }
        boolean needs_indented_close = this.contents != null;
        boolean needs_close_tag = needs_indented_close || this.text_content != null;
        needs_indented_close = needs_indented_close || spaced_out;
        boolean bl = needs_close_tag = needs_close_tag || spaced_out;
        if (needs_indented_close) {
            pw.println(">");
        } else if (needs_close_tag) {
            pw.print(">");
        } else {
            pw.print(" />");
        }
        if (this.text_content != null) {
            if (spaced_out) {
                for (i = 0; i < indent + 2; ++i) {
                    pw.print(" ");
                }
                pw.print(this.quote(this.text_content));
                pw.println();
            } else {
                pw.print(this.quote(this.text_content));
            }
        }
        if (this.contents != null) {
            for (XMLElement content_element : this.contents) {
                content_element.printTo(pw, indent + 2, spaced_out);
            }
        }
        if (needs_indented_close) {
            for (i = 0; i < indent; ++i) {
                pw.print(" ");
            }
        }
        if (needs_close_tag) {
            pw.print("</");
            pw.print(this.tag_name);
            pw.println(">");
        }
    }

    private String quote(String text) {
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll(">", "&gt;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll("\"", "&quot;");
        text = text.replaceAll("--", "&#45;&#45;");
        return text;
    }

    public XMLElement makeContent(String tag_name) {
        return this.makeContent(tag_name, false);
    }

    public XMLElement makeContent(String tag_name, boolean auto_order) {
        XMLElement content = new XMLElement(tag_name, auto_order);
        this.addContent(content);
        return content;
    }

    public void clear() {
        this.text_content = null;
        this.attributes = null;
        this.contents = null;
    }

    public void setAutoOrdering(boolean mode) {
        if (mode == this.auto_order) {
            return;
        }
        this.auto_order = mode;
        if (this.contents == null) {
            return;
        }
        Collection<XMLElement> previous_contents = this.contents;
        if (this.auto_order) {
            this.contents = new TreeSet<XMLElement>(CONTENT_COMPARATOR);
            this.contents.addAll(previous_contents);
        } else {
            this.contents = new ArrayList<XMLElement>(previous_contents);
        }
    }

    public String toString() {
        return "XMLElement[" + this.tag_name + "]@" + Integer.toHexString(System.identityHashCode(this));
    }

    private static class ContentComparator
    implements Comparator<XMLElement> {
        private ContentComparator() {
        }

        @Override
        public int compare(XMLElement xe1, XMLElement xe2) {
            if (xe1 == null || xe2 == null) {
                throw new NullPointerException();
            }
            if (xe1 == xe2) {
                return 0;
            }
            int result = String.CASE_INSENSITIVE_ORDER.compare(xe1.getTag(), xe2.getTag());
            if (result != 0) {
                return result;
            }
            int xe1_index = 0;
            int xe2_index = 0;
            try {
                xe1_index = Integer.parseInt(xe1.getAttribute("index"));
                xe2_index = Integer.parseInt(xe2.getAttribute("index"));
            }
            catch (NullPointerException ne) {
                xe2_index = 0;
                xe1_index = 0;
            }
            catch (NumberFormatException ne) {
                xe2_index = 0;
                xe1_index = 0;
            }
            if (xe1_index != xe2_index) {
                return xe1_index - xe2_index;
            }
            throw new IllegalArgumentException("Shouldn't be using sorting for contents if you have tags with same name and no index attribute! (tag: " + xe1.getTag() + ")");
        }
    }
}

