/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.protocol.maggot;

import com.aelitis.net.magneturi.MagnetURIHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.protocol.magnet.MagnetConnection2;

public class Handler
extends URLStreamHandler {
    @Override
    public URLConnection openConnection(URL u) {
        return new MagnetConnection2(u, new MagnetConnection2.MagnetHandler(){

            @Override
            public void process(URL maggot, OutputStream os) throws IOException {
                String rem;
                String maggot_str = maggot.toExternalForm();
                int pos = maggot_str.indexOf(63);
                if (pos == -1) {
                    rem = "";
                } else {
                    rem = "&" + maggot_str.substring(pos + 1);
                    maggot_str = maggot_str.substring(0, pos);
                }
                pos = maggot_str.lastIndexOf("/");
                maggot_str = maggot_str.substring(pos + 1);
                String[] bits = maggot_str.split(":");
                String btih_str = bits[0];
                String sha1_str = bits[1];
                String magnet_str = "magnet:?xt=urn:btih:" + Base32.encode(ByteFormatter.decodeString(btih_str));
                magnet_str = magnet_str + rem + "&maggot_sha1=" + sha1_str;
                URL magnet = new URL(magnet_str);
                String get = "/download/" + magnet.toString().substring(7) + " HTTP/1.0\r\n\r\n";
                MagnetURIHandler.getSingleton().process(get, new ByteArrayInputStream(new byte[0]), os);
            }
        });
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        spec = spec.substring(start);
        while (spec.length() > 0 && "/?".indexOf(spec.charAt(0)) != -1) {
            spec = spec.substring(1);
        }
        this.setURL(u, "maggot", spec, -1, spec, null, "", null, null);
    }
}

