/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util.jman;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.List;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEJavaManagement;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;

public class AEMemoryMonitor
implements AEJavaManagement.MemoryStuff {
    private static AEMemoryMonitor singleton = new AEMemoryMonitor();
    private static final long MB = 0x100000L;
    private static long max_heap_mb;

    public AEMemoryMonitor() {
        try {
            List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
            MemoryPoolMXBean pool_to_monitor = null;
            long ptm_size = 0L;
            long overall_max = 0L;
            for (MemoryPoolMXBean pool : pools) {
                long max;
                long pool_max = pool.getUsage().getMax();
                if (pool_max > 0L && pool.getType() == MemoryType.HEAP) {
                    overall_max += pool_max;
                }
                if (pool.getType() != MemoryType.HEAP || !pool.isCollectionUsageThresholdSupported() || (max = pool.getUsage().getMax()) <= ptm_size) continue;
                pool_to_monitor = pool;
                ptm_size = max;
            }
            max_heap_mb = (overall_max + 0x100000L - 1L) / 0x100000L;
            if (pool_to_monitor != null) {
                long max = pool_to_monitor.getUsage().getMax();
                long threshold = max * 3L / 4L;
                threshold = Math.min(threshold, 0x500000L);
                MemoryMXBean mbean = ManagementFactory.getMemoryMXBean();
                NotificationEmitter emitter = (NotificationEmitter)((Object)mbean);
                emitter.addNotificationListener(new NotificationListener(){
                    private long last_mb_log = Long.MAX_VALUE;
                    private boolean increase_tried;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void handleNotification(Notification notification, Object handback) {
                        long mb;
                        MemoryPoolMXBean pool = (MemoryPoolMXBean)handback;
                        long used = pool.getCollectionUsage().getUsed();
                        long max = pool.getUsage().getMax();
                        long avail = max - used;
                        if (avail < 0L) {
                            avail = 0L;
                        }
                        if ((mb = (avail + 0x100000L - 1L) / 0x100000L) <= 4L) {
                            1 var12_8 = this;
                            synchronized (var12_8) {
                                if (mb >= this.last_mb_log) {
                                    return;
                                }
                                this.last_mb_log = mb;
                            }
                            Runtime runtime = Runtime.getRuntime();
                            Debug.out("MemMon: notify triggered: pool=" + pool.getName() + ", used=" + used + ", max=" + max + ": runtime free=" + runtime.freeMemory() + ", tot=" + runtime.totalMemory() + ", max=" + runtime.maxMemory());
                            Logger.logTextResource(new LogAlert(true, 1, "memmon.low.warning"), new String[]{(mb == 0L ? "< " : "") + DisplayFormatters.formatByteCountToKiBEtc(Math.max(1L, mb) * 0x100000L, true), DisplayFormatters.formatByteCountToKiBEtc(max_heap_mb * 0x100000L, true)});
                            if (mb == 1L && !this.increase_tried) {
                                PlatformManager platform;
                                this.increase_tried = true;
                                if (COConfigurationManager.getBooleanParameter("jvm.heap.auto.increase.enable", true) && (platform = PlatformManagerFactory.getPlatformManager()).hasCapability(PlatformManagerCapabilities.AccessExplicitVMOptions)) {
                                    try {
                                        String[] options = platform.getExplicitVMOptions();
                                        long max_mem = AEJavaManagement.getJVMLongOption(options, "-Xmx");
                                        if (max_mem <= 0L) {
                                            max_mem = AEMemoryMonitor.this.getMaxHeapMB() * 0x100000L;
                                        }
                                        long HEAP_AUTO_INCREASE_MAX = (long)(Constants.isJava64Bit ? 2048 : 768) * 0x100000L;
                                        long HEAP_AUTO_INCREASE_BY = 0x4000000L;
                                        if (max_mem > 0L && max_mem < HEAP_AUTO_INCREASE_MAX) {
                                            long last_increase;
                                            if ((max_mem += 0x4000000L) > HEAP_AUTO_INCREASE_MAX) {
                                                max_mem = HEAP_AUTO_INCREASE_MAX;
                                            }
                                            if (max_mem > (last_increase = COConfigurationManager.getLongParameter("jvm.heap.auto.increase.last", 0L))) {
                                                COConfigurationManager.setParameter("jvm.heap.auto.increase.last", max_mem);
                                                options = AEJavaManagement.setJVMLongOption(options, "-Xmx", max_mem);
                                                platform.setExplicitVMOptions(options);
                                                Logger.logTextResource(new LogAlert(true, 1, "memmon.heap.auto.increase.warning"), new String[]{DisplayFormatters.formatByteCountToKiBEtc(max_mem, true)});
                                            }
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.out(e);
                                    }
                                }
                            }
                        }
                    }
                }, null, pool_to_monitor);
                pool_to_monitor.setCollectionUsageThreshold(threshold);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        if (max_heap_mb == 0L) {
            max_heap_mb = (Runtime.getRuntime().maxMemory() + 0x100000L - 1L) / 0x100000L;
        }
    }

    @Override
    public long getMaxHeapMB() {
        return max_heap_mb;
    }
}

