/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAnnounceURLList;
import org.gudy.azureus2.plugins.torrent.TorrentAnnounceURLListSet;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourceuploader.ResourceUploader;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.bouncycastle.util.encoders.Base64;

public class UrlUtils {
    private static final ThreadPool connect_pool = new ThreadPool("URLConnectWithTimeout", 8, true);
    private static Pattern patMagnetHashFinder;
    private static final String[] prefixes;
    private static final int MAGNETURL_STARTS_AT = 3;
    private static final Object[] XMLescapes;
    private static String last_headers;
    private static final String default_headers = "QWNjZXB0OiB0ZXh0L2h0bWwsYXBwbGljYXRpb24veGh0bWwreG1sLGFwcGxpY2F0aW9uL3htbDtxPTAuOSwqLyo7cT0wLjgKQWNjZXB0LUNoYXJzZXQ6IElTTy04ODU5LTEsdXRmLTg7cT0wLjcsKjtxPTAuMwpBY2NlcHQtRW5jb2Rpbmc6IGd6aXAsZGVmbGF0ZQpBY2NlcHQtTGFuZ3VhZ2U6IGVuLVVTLGVuO3E9MC44CkNhY2hlLUNvbnRyb2w6IG1heC1hZ2U9MApDb25uZWN0aW9uOiBrZWVwLWFsaXZlClVzZXItQWdlbnQ6IE1vemlsbGEvNS4wIChXaW5kb3dzIE5UIDYuMTsgV09XNjQpIEFwcGxlV2ViS2l0LzUzNi4xMSAoS0hUTUwsIGxpa2UgR2Vja28pIENocm9tZS8yMC4wLjExMzIuNDcgU2FmYXJpLzUzNi4xMQ==";

    public static Map<String, String> decodeArgs(String args) {
        String[] bits;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String bit : bits = (args.startsWith("?") ? args.substring(1) : args).split("&")) {
            String[] temp = bit.split("=", 2);
            if (temp.length == 2) {
                String lhs = temp[0].toLowerCase(Locale.US);
                String rhs = UrlUtils.decode(temp[1]);
                result.put(lhs, rhs);
                continue;
            }
            result.put("", UrlUtils.decode(temp[0]));
        }
        return result;
    }

    public static String getMagnetURI(byte[] hash) {
        return "magnet:?xt=urn:btih:" + Base32.encode(hash);
    }

    public static String getMagnetURI(byte[] hash, String name, String[] networks) {
        String magnet_uri = UrlUtils.getMagnetURI(hash);
        magnet_uri = magnet_uri + UrlUtils.encodeName(name);
        magnet_uri = magnet_uri + UrlUtils.encodeNetworks(networks);
        return magnet_uri;
    }

    private static String encodeName(String name) {
        if (name == null) {
            return "";
        }
        return "&dn=" + UrlUtils.encode(name);
    }

    private static String encodeNetworks(String[] networks) {
        String net_str = "";
        if (networks != null && networks.length > 0) {
            for (String net : networks) {
                if (net == "Public" && networks.length == 1) break;
                net_str = net_str + "&net=" + net;
            }
        }
        return net_str;
    }

    public static byte[] extractHash(String magnet_uri) {
        int pos = (magnet_uri = magnet_uri.toLowerCase(Locale.US)).indexOf("btih:");
        if (pos > 0) {
            if ((pos = (magnet_uri = magnet_uri.substring(pos + 5)).indexOf(38)) != -1) {
                magnet_uri = magnet_uri.substring(0, pos);
            }
            return UrlUtils.decodeSHA1Hash(magnet_uri);
        }
        return null;
    }

    public static Set<String> extractNetworks(String[] magnet_uri) {
        String magnet_uri_in = magnet_uri[0];
        HashSet<String> result = new HashSet<String>();
        int pos = magnet_uri_in.indexOf(63);
        if (pos != -1) {
            String[] bits;
            String magnet_uri_out = magnet_uri_in.substring(0, pos + 1);
            for (String bit : bits = magnet_uri_in.substring(pos + 1).split("&")) {
                String lhs;
                String[] temp = bit.split("=", 2);
                boolean remove = false;
                if (temp.length == 2 && (lhs = temp[0]).equalsIgnoreCase("net")) {
                    String rhs = UrlUtils.decode(temp[1]);
                    result.add(AENetworkClassifier.internalise(rhs));
                    remove = true;
                }
                if (remove) continue;
                if (!magnet_uri_out.endsWith("?")) {
                    magnet_uri_out = magnet_uri_out + "&";
                }
                magnet_uri_out = magnet_uri_out + bit;
            }
            if (result.size() > 0) {
                magnet_uri[0] = magnet_uri_out;
            }
        }
        return result;
    }

    public static String getMagnetURI(Download download) {
        return UrlUtils.getMagnetURI(PluginCoreUtils.unwrap(download));
    }

    public static String getMagnetURI(Download download, int max_name_len) {
        return UrlUtils.getMagnetURI(PluginCoreUtils.unwrap(download), max_name_len);
    }

    public static String getMagnetURI(DownloadManager dm) {
        return UrlUtils.getMagnetURI(dm, Integer.MAX_VALUE);
    }

    public static String getMagnetURI(DownloadManager dm, int max_name_len) {
        if (dm == null) {
            return null;
        }
        TOTorrent to_torrent = dm.getTorrent();
        if (to_torrent == null) {
            return null;
        }
        String name = dm.getDisplayName();
        if (name.length() > max_name_len) {
            name = name.substring(0, max_name_len - 3) + "...";
        }
        String magnet_uri = UrlUtils.getMagnetURI(name, PluginCoreUtils.wrap(to_torrent));
        String[] networks = dm.getDownloadState().getNetworks();
        magnet_uri = magnet_uri + UrlUtils.encodeNetworks(networks);
        return magnet_uri;
    }

    public static String getMagnetURI(String name, Torrent torrent) {
        TorrentAnnounceURLListSet[] sets;
        String magnet_str = UrlUtils.getMagnetURI(torrent.getHash());
        magnet_str = magnet_str + UrlUtils.encodeName(name);
        ArrayList<String> tracker_urls = new ArrayList<String>();
        URL announce_url = torrent.getAnnounceURL();
        if (announce_url != null && !TorrentUtils.isDecentralised(announce_url)) {
            tracker_urls.add(announce_url.toExternalForm());
        }
        TorrentAnnounceURLList list = torrent.getAnnounceURLList();
        for (TorrentAnnounceURLListSet set : sets = list.getSets()) {
            String str;
            URL set_url;
            URL[] set_urls = set.getURLs();
            if (set_urls.length <= 0 || TorrentUtils.isDecentralised(set_url = set_urls[0]) || tracker_urls.contains(str = set_url.toExternalForm())) continue;
            tracker_urls.add(str);
        }
        for (String str : tracker_urls) {
            magnet_str = magnet_str + "&tr=" + UrlUtils.encode(str);
        }
        ArrayList<String> ws_urls = new ArrayList<String>();
        Object obj = torrent.getAdditionalProperty("url-list");
        if (obj instanceof byte[]) {
            try {
                ws_urls.add(new URL(new String((byte[])obj, "UTF-8")).toExternalForm());
            }
            catch (Throwable e) {}
        } else if (obj instanceof List) {
            for (Object o : (List)obj) {
                try {
                    if (o instanceof byte[]) {
                        ws_urls.add(new URL(new String((byte[])o, "UTF-8")).toExternalForm());
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    ws_urls.add(new URL((String)o).toExternalForm());
                }
                catch (Throwable e) {}
            }
        } else if (obj instanceof String) {
            try {
                ws_urls.add(new URL((String)obj).toExternalForm());
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        for (String str : ws_urls) {
            magnet_str = magnet_str + "&ws=" + UrlUtils.encode(str);
        }
        return magnet_str;
    }

    public static String normaliseMagnetURI(String base_hash) {
        byte[] hash = UrlUtils.decodeSHA1Hash(base_hash);
        if (hash != null) {
            return UrlUtils.getMagnetURI(hash);
        }
        return null;
    }

    public static byte[] getHashFromMagnetURI(String magnetURI) {
        if (magnetURI == null) {
            return null;
        }
        Matcher matcher = patMagnetHashFinder.matcher(magnetURI);
        if (matcher.find()) {
            return UrlUtils.decodeSHA1Hash(matcher.group(1));
        }
        return null;
    }

    public static byte[] decodeSHA1Hash(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        byte[] hash = null;
        try {
            if (str.length() == 40) {
                hash = ByteFormatter.decodeString(str);
            } else if (str.length() == 32) {
                hash = Base32.decode(str);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (hash != null && hash.length != 20) {
            hash = null;
        }
        return hash;
    }

    public static boolean isURL(String sURL) {
        return UrlUtils.parseTextForURL(sURL, true) != null;
    }

    public static boolean isURL(String sURL, boolean bGuess) {
        return UrlUtils.parseTextForURL(sURL, true, bGuess) != null;
    }

    public static String parseTextForURL(String text, boolean accept_magnets) {
        return UrlUtils.parseTextForURL(text, accept_magnets, true);
    }

    public static String getURL(String text) {
        return UrlUtils.parseTextForURL(text, false, false);
    }

    public static boolean isInternalProtocol(String url) {
        return (url = url.toLowerCase()).startsWith("magnet:") || url.startsWith("chat:") || url.startsWith("azplug:") || url.startsWith("vuze:") || url.startsWith("tor:");
    }

    public static String parseTextForURL(String text, boolean accept_magnets, boolean guess) {
        String args;
        String textLower;
        String href;
        if (text == null || text.length() < 5) {
            return null;
        }
        if ((text = text.trim()).startsWith("azplug:")) {
            return text;
        }
        if (text.startsWith("chat:")) {
            return "azplug:?id=azbuddy&arg=" + UrlUtils.encode(text);
        }
        if (text.startsWith("tor:") && (href = UrlUtils.parseTextForURL(text.substring(4), false, false)) != null) {
            return "tor:" + href;
        }
        href = UrlUtils.parseHTMLforURL(text);
        if (href != null) {
            return href;
        }
        try {
            text = text.trim();
            text = UrlUtils.decodeIfNeeded(text);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            textLower = text.toLowerCase();
        }
        catch (Throwable e) {
            textLower = text;
        }
        int max = accept_magnets ? prefixes.length : 3;
        int end = -1;
        int start = textLower.length();
        String strURL = null;
        for (int i = 0; i < max; ++i) {
            int testBegin = textLower.indexOf(prefixes[i]);
            if (testBegin < 0 || testBegin >= start) continue;
            end = text.indexOf("\n", testBegin + prefixes[i].length());
            String strURLTest = end >= 0 ? text.substring(testBegin, end - 1) : text.substring(testBegin);
            try {
                URL parsedURL = new URL(strURLTest);
                strURL = parsedURL.toExternalForm();
                continue;
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
                if (i < 3) continue;
                strURL = strURLTest;
            }
        }
        if (strURL != null) {
            return strURL;
        }
        if (new File(text).exists()) {
            return null;
        }
        try {
            URL u = new URL("http://" + text);
            String host = u.getHost();
            if (host != null && AENetworkClassifier.categoriseAddress(host) != "Public") {
                return u.toExternalForm();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (accept_magnets && (text.startsWith("bc://") || text.startsWith("bctp://"))) {
            return UrlUtils.parseTextForMagnets(text);
        }
        String text_prefix = text;
        String text_suffix = "";
        int a_pos = text_prefix.indexOf(63);
        if (a_pos == -1) {
            a_pos = text_prefix.indexOf(38);
        }
        if (a_pos != -1 && (args = text_prefix.substring(a_pos + 1).trim()).contains("=")) {
            int s_pos = args.indexOf(32);
            if (s_pos != -1) {
                args = args.substring(0, s_pos);
            }
            text_prefix = text_prefix.substring(0, a_pos);
            text_suffix = "&" + args;
        }
        if (accept_magnets) {
            if (text_prefix.matches("^[a-fA-F0-9]{40}$")) {
                byte[] infohash = ByteFormatter.decodeString(text_prefix.toUpperCase());
                return "magnet:?xt=urn:btih:" + Base32.encode(infohash) + text_suffix;
            }
            String temp_text = text_prefix.replaceAll("\\s+", "");
            if (temp_text.matches("^[a-fA-F0-9]{40}$")) {
                byte[] infohash = ByteFormatter.decodeString(temp_text.toUpperCase());
                return "magnet:?xt=urn:btih:" + Base32.encode(infohash) + text_suffix;
            }
        }
        if (accept_magnets && text_prefix.matches("^[a-zA-Z2-7]{32}$")) {
            return "magnet:?xt=urn:btih:" + text_prefix + text_suffix;
        }
        if (accept_magnets && guess) {
            Pattern pattern = Pattern.compile("[^a-zA-Z2-7][a-zA-Z2-7]{32}[^a-zA-Z2-7]");
            Matcher matcher = pattern.matcher(text);
            if (matcher.find()) {
                String hash = text.substring(matcher.start() + 1, matcher.start() + 33);
                return "magnet:?xt=urn:btih:" + hash;
            }
            pattern = Pattern.compile("[^a-fA-F0-9][a-fA-F0-9]{40}[^a-fA-F0-9]");
            matcher = pattern.matcher(text);
            if (matcher.find()) {
                String hash = text.substring(matcher.start() + 1, matcher.start() + 41);
                byte[] infohash = ByteFormatter.decodeString(hash.toUpperCase());
                return "magnet:?xt=urn:btih:" + Base32.encode(infohash);
            }
        }
        return null;
    }

    public static String parseTextForMagnets(String text) {
        String hash;
        String decodeString;
        String magnet;
        String base64;
        byte[] decode;
        if (text.startsWith("magnet:") || text.startsWith("maggot:")) {
            return text;
        }
        if (text.matches("^[a-fA-F0-9]{40}$")) {
            byte[] infohash = ByteFormatter.decodeString(text.toUpperCase());
            return "magnet:?xt=urn:btih:" + Base32.encode(infohash);
        }
        String temp_text = text.replaceAll("\\s+", "");
        if (temp_text.matches("^[a-fA-F0-9]{40}$")) {
            byte[] infohash = ByteFormatter.decodeString(temp_text.toUpperCase());
            return "magnet:?xt=urn:btih:" + Base32.encode(infohash);
        }
        if (text.matches("^[a-zA-Z2-7]{32}$")) {
            return "magnet:?xt=urn:btih:" + text;
        }
        Pattern pattern = Pattern.compile("magnet:\\?[a-z%0-9=_:&.]+", 2);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group();
        }
        pattern = Pattern.compile("maggot://[a-z0-9]+:[a-z0-9]", 2);
        matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group();
        }
        pattern = Pattern.compile("bc://bt/([a-z0-9=\\+/]+)", 2);
        matcher = pattern.matcher(text.replaceAll(" ", "+"));
        if (matcher.find() && (decode = Base64.decode(base64 = matcher.group(1))) != null && decode.length > 0) {
            try {
                String hash2;
                String magnet2;
                String decodeString2 = new String(decode, "utf8");
                pattern = Pattern.compile("AA.*/(.*)/ZZ", 2);
                matcher = pattern.matcher(decodeString2);
                if (matcher.find() && (magnet2 = UrlUtils.parseTextForMagnets(hash2 = matcher.group(1))) != null) {
                    pattern = Pattern.compile("AA/(.*)/[0-9]+", 2);
                    matcher = pattern.matcher(decodeString2);
                    if (matcher.find()) {
                        String name = matcher.group(1);
                        return magnet2 + "&dn=" + UrlUtils.encode(name);
                    }
                    return magnet2;
                }
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if ((matcher = (pattern = Pattern.compile("bctp://task/(.*)", 2)).matcher(text)).find() && (magnet = UrlUtils.parseTextForMagnets(decodeString = matcher.group(1))) != null) {
            pattern = Pattern.compile("(.*)/[0-9]+", 2);
            matcher = pattern.matcher(decodeString);
            if (matcher.find()) {
                String name = matcher.group(1);
                return magnet + "&dn=" + UrlUtils.encode(name);
            }
            return magnet;
        }
        text = "!" + text + "!";
        pattern = Pattern.compile("[^a-zA-Z2-7][a-zA-Z2-7]{32}[^a-zA-Z2-7]");
        matcher = pattern.matcher(text);
        if (matcher.find()) {
            hash = text.substring(matcher.start() + 1, matcher.start() + 33);
            return "magnet:?xt=urn:btih:" + hash;
        }
        pattern = Pattern.compile("[^a-fA-F0-9][a-fA-F0-9]{40}[^a-fA-F0-9]");
        matcher = pattern.matcher(text);
        if (matcher.find()) {
            hash = text.substring(matcher.start() + 1, matcher.start() + 41);
            byte[] infohash = ByteFormatter.decodeString(hash.toUpperCase());
            return "magnet:?xt=urn:btih:" + Base32.encode(infohash);
        }
        return null;
    }

    private static String parseHTMLforURL(String text) {
        if (text == null) {
            return null;
        }
        Pattern pat = Pattern.compile("<.*a\\s++.*href=\"?([^\\'\"\\s>]++).*", 2);
        Matcher m = pat.matcher(text);
        if (m.find()) {
            String sURL = m.group(1);
            try {
                sURL = UrlUtils.decodeIfNeeded(sURL);
            }
            catch (Exception e) {
                // empty catch block
            }
            return sURL;
        }
        return null;
    }

    public static String encode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(s).replaceAll("\\+", "%20");
        }
    }

    public static String decode(String s) {
        if (s == null) {
            return "";
        }
        try {
            try {
                return URLDecoder.decode(s, "UTF-8");
            }
            catch (IllegalArgumentException e) {
                int pos = s.lastIndexOf("%");
                if (pos >= s.length() - 2) {
                    return URLDecoder.decode(s.substring(0, pos), "UTF-8");
                }
                throw e;
            }
        }
        catch (UnsupportedEncodingException e) {
            return URLDecoder.decode(s);
        }
    }

    public static String decodeIfNeeded(String s) {
        if (s == null) {
            return "";
        }
        try {
            int q_pos = s.indexOf(63);
            int a_pos = s.indexOf(38);
            if (q_pos == -1 && a_pos == -1) {
                return UrlUtils.decode(s);
            }
            int start = Math.min(q_pos, a_pos);
            return UrlUtils.decode(s.substring(0, start)) + s.substring(start);
        }
        catch (Throwable e) {
            return s;
        }
    }

    public static String escapeXML(String s) {
        if (s == null) {
            return "";
        }
        String ret = s;
        for (int i = 0; i < XMLescapes.length; ++i) {
            String[] escapeEntry = (String[])XMLescapes[i];
            ret = ret.replaceAll(escapeEntry[0], escapeEntry[1]);
        }
        return ret;
    }

    public static String unescapeXML(String s) {
        if (s == null) {
            return "";
        }
        String ret = s;
        for (int i = 0; i < XMLescapes.length; ++i) {
            String[] escapeEntry = (String[])XMLescapes[i];
            ret = ret.replaceAll(escapeEntry[1], escapeEntry[0]);
        }
        return ret;
    }

    public static String convertIPV6Host(String host) {
        if (host.indexOf(58) != -1) {
            int zone_index = host.indexOf(37);
            if (zone_index != -1) {
                host = host.substring(0, zone_index) + UrlUtils.encode(host.substring(zone_index));
            }
            return "[" + host + "]";
        }
        return host;
    }

    public static String expandIPV6Host(String host) {
        if (host.indexOf(58) != -1) {
            try {
                return InetAddress.getByAddress(InetAddress.getByName(host).getAddress()).getHostAddress();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return host;
    }

    public static void connectWithTimeout(URLConnection connection, long connect_timeout) throws IOException {
        UrlUtils.connectWithTimeouts(connection, connect_timeout, -1L);
    }

    public static void connectWithTimeouts(URLConnection connection, long connect_timeout, long read_timeout) throws IOException {
        if (connect_timeout != -1L) {
            connection.setConnectTimeout((int)connect_timeout);
        }
        if (read_timeout != -1L) {
            connection.setReadTimeout((int)read_timeout);
        }
        connection.connect();
    }

    public static void setBrowserHeaders(ResourceDownloader rd, String referer) {
        UrlUtils.setBrowserHeaders(rd, null, referer);
    }

    public static void setBrowserHeaders(ResourceDownloader rd, String encoded_headers, String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(encoded_headers);
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos == -1) continue;
                String lhs = header.substring(0, pos).trim();
                String rhs = header.substring(pos + 1).trim();
                if (lhs.equalsIgnoreCase("Host") || lhs.equalsIgnoreCase("Referer")) continue;
                rd.setProperty("URL_" + lhs, rhs);
            }
            if (referer != null && referer.length() > 0) {
                rd.setProperty("URL_Referer", referer);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public static void setBrowserHeaders(ResourceUploader ru, String encoded_headers, String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(encoded_headers);
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos == -1) continue;
                String lhs = header.substring(0, pos).trim();
                String rhs = header.substring(pos + 1).trim();
                if (lhs.equalsIgnoreCase("Host") || lhs.equalsIgnoreCase("Referer")) continue;
                ru.setProperty("URL_" + lhs, rhs);
            }
            if (referer != null && referer.length() > 0) {
                ru.setProperty("URL_Referer", referer);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public static void setBrowserHeaders(URLConnection connection, String referer) {
        UrlUtils.setBrowserHeaders(connection, null, referer);
    }

    public static void setBrowserHeaders(URLConnection connection, String encoded_headers, String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(encoded_headers);
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos == -1) continue;
                String lhs = header.substring(0, pos).trim();
                String rhs = header.substring(pos + 1).trim();
                if (lhs.equalsIgnoreCase("Host") || lhs.equalsIgnoreCase("Referer")) continue;
                connection.setRequestProperty(lhs, rhs);
            }
            if (referer != null && referer.length() > 0) {
                connection.setRequestProperty("Referer", referer);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public static Map getBrowserHeaders(String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(null);
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos == -1) continue;
                String lhs = header.substring(0, pos).trim();
                String rhs = header.substring(pos + 1).trim();
                if (lhs.equalsIgnoreCase("Host") || lhs.equalsIgnoreCase("Referer")) continue;
                result.put(lhs, rhs);
            }
            if (referer != null && referer.length() > 0) {
                result.put("Referer", referer);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBrowserHeadersToUse(String encoded_headers) {
        String headers_to_use = encoded_headers;
        Class<UrlUtils> clazz = UrlUtils.class;
        synchronized (UrlUtils.class) {
            if (headers_to_use == null) {
                headers_to_use = last_headers != null ? last_headers : default_headers;
            } else {
                if (last_headers == null || !headers_to_use.equals(last_headers)) {
                    COConfigurationManager.setParameter("metasearch.web.last.headers", headers_to_use);
                }
                last_headers = headers_to_use;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return headers_to_use;
        }
    }

    public static boolean queryHasParameter(String query_string, String param_name, boolean case_sensitive) {
        if (!case_sensitive) {
            query_string = query_string.toLowerCase();
            param_name = param_name.toLowerCase();
        }
        if (query_string.charAt(0) == '?') {
            query_string = '&' + query_string.substring(1);
        } else if (query_string.charAt(0) != '&') {
            query_string = '&' + query_string;
        }
        return query_string.contains("&" + param_name + "=");
    }

    public static boolean containsPasskey(URL url) {
        if (url == null) {
            return false;
        }
        String url_str = url.toExternalForm();
        return url_str.matches(".*[0-9a-z]{20,40}.*");
    }

    public static URL setPort(URL u, int port) {
        if (port == -1) {
            port = u.getDefaultPort();
        }
        StringBuilder result = new StringBuilder();
        result.append(u.getProtocol());
        result.append(":");
        String authority = u.getAuthority();
        if (authority != null && authority.length() > 0) {
            result.append("//");
            int pos = authority.indexOf(64);
            if (pos != -1) {
                result.append(authority.substring(0, pos + 1));
                authority = authority.substring(pos + 1);
            }
            if ((pos = authority.lastIndexOf(58)) == -1) {
                if (port > 0) {
                    result.append(authority).append(":").append(port);
                } else {
                    result.append(authority);
                }
            } else if (port > 0) {
                result.append(authority.substring(0, pos + 1)).append(port);
            } else {
                result.append(authority.substring(0, pos));
            }
        }
        if (u.getPath() != null) {
            result.append(u.getPath());
        }
        if (u.getQuery() != null) {
            result.append('?');
            result.append(u.getQuery());
        }
        if (u.getRef() != null) {
            result.append("#");
            result.append(u.getRef());
        }
        try {
            return new URL(result.toString());
        }
        catch (Throwable e) {
            Debug.out(e);
            return u;
        }
    }

    public static URL setHost(URL u, String host) {
        StringBuilder result = new StringBuilder();
        result.append(u.getProtocol());
        result.append(":");
        String authority = u.getAuthority();
        if (authority != null && authority.length() > 0) {
            result.append("//");
            int pos = authority.indexOf(64);
            if (pos != -1) {
                result.append(authority.substring(0, pos + 1));
                authority = authority.substring(pos + 1);
            }
            if ((pos = authority.lastIndexOf(58)) == -1) {
                result.append(host);
            } else {
                result.append(host).append(authority.substring(pos));
            }
        }
        if (u.getPath() != null) {
            result.append(u.getPath());
        }
        if (u.getQuery() != null) {
            result.append('?');
            result.append(u.getQuery());
        }
        if (u.getRef() != null) {
            result.append("#");
            result.append(u.getRef());
        }
        try {
            return new URL(result.toString());
        }
        catch (Throwable e) {
            Debug.out(e);
            return u;
        }
    }

    public static URL setProtocol(URL u, String protocol) {
        String str = u.toExternalForm();
        int pos = str.indexOf(":");
        try {
            return new URL(protocol + str.substring(pos));
        }
        catch (Throwable e) {
            Debug.out(e);
            return u;
        }
    }

    public static URL getBaseURL(URL u) {
        StringBuilder result = new StringBuilder();
        result.append(u.getProtocol());
        result.append(":");
        String authority = u.getAuthority();
        if (authority != null && authority.length() > 0) {
            result.append("//");
            int pos = authority.indexOf(64);
            if (pos != -1) {
                result.append(authority.substring(0, pos + 1));
                authority = authority.substring(pos + 1);
            }
            pos = authority.lastIndexOf(58);
            int port = u.getPort();
            if (port == -1) {
                port = u.getDefaultPort();
            }
            if (pos == -1) {
                result.append(authority).append(":").append(port);
            } else {
                result.append(authority.substring(0, pos + 1)).append(port);
            }
        }
        try {
            return new URL(result.toString());
        }
        catch (Throwable e) {
            Debug.out(e);
            return u;
        }
    }

    public static String getCanonicalString(URL url) {
        String protocol = url.getProtocol();
        if (!protocol.equals(protocol.toLowerCase(Locale.US))) {
            protocol = protocol.toLowerCase(Locale.US);
            url = UrlUtils.setProtocol(url, protocol);
        }
        int port = url.getPort();
        if (protocol.equals("http") || protocol.equals("https")) {
            if (port == url.getDefaultPort()) {
                url = UrlUtils.setPort(url, 0);
            }
        } else if (port == -1) {
            url = UrlUtils.setPort(url, url.getDefaultPort());
        }
        return url.toString();
    }

    public static URL getIPV4Fallback(URL url) {
        try {
            InetAddress[] addresses = AddressUtils.getAllByName(url.getHost());
            if (addresses.length > 0) {
                InetAddress ipv4 = null;
                InetAddress ipv6 = null;
                for (InetAddress a : addresses) {
                    if (a instanceof Inet4Address) {
                        ipv4 = a;
                        continue;
                    }
                    ipv6 = a;
                }
                if (ipv4 != null && ipv6 != null) {
                    url = UrlUtils.setHost(url, ipv4.getHostAddress());
                    return url;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static long getContentLength(URLConnection con) {
        long res = con.getContentLength();
        if (res == -1L) {
            try {
                String str = con.getHeaderField("content-length");
                if (str != null) {
                    res = Long.parseLong(str);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return res;
    }

    public static boolean SSLSocketSNIHack(String host_name, SSLSocket socket) {
        try {
            Object sni_host_name = Class.forName("javax.net.ssl.SNIHostName").getConstructor(String.class).newInstance(host_name);
            ArrayList sni_host_names = new ArrayList(1);
            sni_host_names.add(sni_host_name);
            Object ssl_parameters = SSLSocket.class.getMethod("getSSLParameters", new Class[0]).invoke((Object)socket, new Object[0]);
            Class<?> ssl_parameters_class = Class.forName("javax.net.ssl.SSLParameters");
            ssl_parameters_class.getMethod("setServerNames", List.class).invoke(ssl_parameters, sni_host_names);
            socket.getClass().getMethod("setSSLParameters", ssl_parameters_class).invoke((Object)socket, ssl_parameters);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static SSLSocketFactory DHHackIt(final SSLSocketFactory factory) {
        SSLSocketFactory hack = new SSLSocketFactory(){

            @Override
            public Socket createSocket() throws IOException {
                Socket result = factory.createSocket();
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
                Socket result = factory.createSocket(address, port, localAddress, localPort);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(InetAddress host, int port) throws IOException {
                Socket result = factory.createSocket(host, port);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
                Socket result = factory.createSocket(s, host, port, autoClose);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
                Socket result = factory.createSocket(host, port);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
                Socket result = factory.createSocket(host, port, localHost, localPort);
                this.hack(result);
                return result;
            }

            @Override
            public String[] getDefaultCipherSuites() {
                String[] result = factory.getDefaultCipherSuites();
                result = this.hack(result);
                return result;
            }

            @Override
            public String[] getSupportedCipherSuites() {
                String[] result = factory.getSupportedCipherSuites();
                result = this.hack(result);
                return result;
            }

            private void hack(Socket socket) {
                SSLSocket ssl_socket = (SSLSocket)socket;
                ssl_socket.setEnabledCipherSuites(this.hack(ssl_socket.getEnabledCipherSuites()));
            }

            private String[] hack(String[] cs) {
                ArrayList<String> new_cs = new ArrayList<String>();
                for (String x : cs) {
                    if (x.contains("_DH_") || x.contains("_DHE_")) continue;
                    new_cs.add(x);
                }
                return new_cs.toArray(new String[new_cs.size()]);
            }
        };
        return hack;
    }

    public static void HTTPSURLConnectionSNIHack(final String host_name, HttpsURLConnection con) {
        final SSLSocketFactory factory = con.getSSLSocketFactory();
        SSLSocketFactory hack = new SSLSocketFactory(){

            @Override
            public Socket createSocket() throws IOException {
                Socket result = factory.createSocket();
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
                Socket result = factory.createSocket(address, port, localAddress, localPort);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(InetAddress host, int port) throws IOException {
                Socket result = factory.createSocket(host, port);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
                Socket result = factory.createSocket(s, host, port, autoClose);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
                Socket result = factory.createSocket(host, port);
                this.hack(result);
                return result;
            }

            @Override
            public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
                Socket result = factory.createSocket(host, port, localHost, localPort);
                this.hack(result);
                return result;
            }

            @Override
            public String[] getDefaultCipherSuites() {
                String[] result = factory.getDefaultCipherSuites();
                result = this.hack(result);
                return result;
            }

            @Override
            public String[] getSupportedCipherSuites() {
                String[] result = factory.getSupportedCipherSuites();
                result = this.hack(result);
                return result;
            }

            private void hack(Socket socket) {
                SSLSocket ssl_socket = (SSLSocket)socket;
                UrlUtils.SSLSocketSNIHack(host_name, ssl_socket);
            }

            private String[] hack(String[] cs) {
                return cs;
            }
        };
        con.setSSLSocketFactory(hack);
    }

    public static void DHHackIt(HttpsURLConnection ssl_con) {
        SSLSocketFactory factory = ssl_con.getSSLSocketFactory();
        SSLSocketFactory hack = UrlUtils.DHHackIt(factory);
        ssl_con.setSSLSocketFactory(hack);
    }

    public static Socket connectSocketAndWrite(boolean is_ssl, String target_host, int target_port, byte[] bytes, int connect_timeout, int read_timeout) throws Exception {
        boolean is_java_17_plus = Constants.isJava7OrHigher;
        try {
            return UrlUtils.connectSocketAndWrite(is_ssl, target_host, target_port, bytes, connect_timeout, read_timeout, false);
        }
        catch (Exception e) {
            if (is_java_17_plus) {
                throw e;
            }
            return UrlUtils.connectSocketAndWrite(is_ssl, target_host, target_port, bytes, connect_timeout, read_timeout, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Socket connectSocketAndWrite(boolean is_ssl, String target_host, int target_port, byte[] bytes, int connect_timeout, int read_timeout, boolean unconnected_socket_hack) throws Exception {
        boolean cert_hack = false;
        boolean dh_hack = false;
        boolean internal_error_hack = false;
        boolean hacks_to_do = true;
        Exception last_error = null;
        while (hacks_to_do) {
            hacks_to_do = false;
            Socket target = null;
            boolean ok = false;
            try {
                InetSocketAddress targetSockAddress = new InetSocketAddress(InetAddress.getByName(target_host), target_port);
                InetAddress bindIP = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress(targetSockAddress.getAddress() instanceof Inet6Address ? 2 : 1);
                if (is_ssl) {
                    TrustManager[] tms_delegate = SESecurityManager.getAllTrustingTrustManager();
                    SSLContext sc = SSLContext.getInstance("SSL");
                    sc.init(null, tms_delegate, RandomUtils.SECURE_RANDOM);
                    SSLSocketFactory factory = sc.getSocketFactory();
                    factory = dh_hack ? UrlUtils.DHHackIt(factory) : UrlUtils.DHHackIt(factory);
                    target = unconnected_socket_hack ? (bindIP == null ? factory.createSocket(targetSockAddress.getAddress(), targetSockAddress.getPort()) : factory.createSocket(targetSockAddress.getAddress(), targetSockAddress.getPort(), bindIP, 0)) : factory.createSocket();
                } else {
                    target = unconnected_socket_hack ? (bindIP == null ? new Socket(targetSockAddress.getAddress(), targetSockAddress.getPort()) : new Socket(targetSockAddress.getAddress(), targetSockAddress.getPort(), bindIP, 0)) : new Socket();
                }
                if (internal_error_hack) {
                    UrlUtils.SSLSocketSNIHack(target_host, (SSLSocket)target);
                }
                target.setSoTimeout(read_timeout);
                if (!unconnected_socket_hack) {
                    if (bindIP != null) {
                        target.bind(new InetSocketAddress(bindIP, 0));
                    }
                    target.connect(targetSockAddress, connect_timeout);
                }
                target.getOutputStream().write(bytes);
                ok = true;
                Socket socket = target;
                return socket;
            }
            catch (Exception e) {
                last_error = e;
                if (e instanceof SSLException) {
                    String msg = Debug.getNestedExceptionMessage(e);
                    if (msg.contains("DH keypair")) {
                        if (!dh_hack) {
                            dh_hack = true;
                            hacks_to_do = true;
                        }
                    } else if (msg.contains("internal_error") && !internal_error_hack) {
                        internal_error_hack = true;
                        hacks_to_do = true;
                    }
                    if (!cert_hack) {
                        cert_hack = true;
                        SESecurityManager.installServerCertificates(new URL("https://" + target_host + ":" + target_port + "/"));
                        hacks_to_do = true;
                    }
                }
                if (hacks_to_do) continue;
                throw e;
            }
            finally {
                if (ok || target == null) continue;
                target.close();
            }
        }
        throw last_error;
    }

    public static void main(String[] args) {
        System.out.println(URLEncoder.encode("http://a.b.c/fred?a=10&b=20"));
        byte[] infohash = ByteFormatter.decodeString("1234567890123456789012345678901234567890");
        String[] test = new String[]{"http://moo.com", "http%3A%2F/moo%2Ecom", "magnet:?moo", "magnet%3A%3Fxt=urn:btih:26", "magnet%3A//%3Fmooo", "magnet:?xt=urn:btih:" + Base32.encode(infohash), "aaaaaaaaaabbbbbbbbbbccccccccccdddddddddd", "magnet:?dn=OpenOffice.org_2.0.3_Win32Intel_install.exe&xt=urn:sha1:PEMIGLKMNFI4HZ4CCHZNPKZJNMAAORKN&xt=urn:tree:tiger:JMIJVWHCQUX47YYH7O4XIBCORNU2KYKHBBC6DHA&xt=urn:ed2k:1c0804541f34b6583a383bb8f2cec682&xl=96793015&xs=http://mirror.switch.ch/ftp/mirror/OpenOffice/stable/2.0.3/OOo_2.0.3_Win32Intel_install.exe%3Fa%3D10%26b%3D20"};
        for (int i = 0; i < test.length; ++i) {
            System.out.println(test[i]);
            System.out.println("URLDecoder.decode: -> " + URLDecoder.decode(test[i]));
            System.out.println("decode:            -> " + UrlUtils.decode(test[i]));
            System.out.println("decodeIf:          -> " + UrlUtils.decodeIfNeeded(test[i]));
            System.out.println("isURL:             -> " + UrlUtils.isURL(test[i]));
            System.out.println("parse:             -> " + UrlUtils.parseTextForURL(test[i], true));
        }
        String[] testEncode = new String[]{"a b"};
        for (int i = 0; i < testEncode.length; ++i) {
            String txt = testEncode[i];
            try {
                System.out.println("URLEncoder.encode: " + txt + " -> " + URLEncoder.encode(txt, "UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            System.out.println("URLEncoder.encode: " + txt + " -> " + URLEncoder.encode(txt));
            System.out.println("encode: " + txt + " -> " + UrlUtils.encode(txt));
        }
    }

    static {
        connect_pool.setWarnWhenFull();
        patMagnetHashFinder = Pattern.compile("xt=urn:(?:btih|sha1):([^&]+)");
        prefixes = new String[]{"http://", "https://", "ftp://", "dht://", "magnet:?", "magnet://?", "maggot://"};
        XMLescapes = new Object[]{new String[]{"&", "&amp;"}, new String[]{">", "&gt;"}, new String[]{"<", "&lt;"}, new String[]{"\"", "&quot;"}, new String[]{"'", "&apos;"}};
        last_headers = COConfigurationManager.getStringParameter("metasearch.web.last.headers", null);
    }
}

