/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class SimpleTimer {
    protected static final Timer timer;
    static final CopyOnWriteList<TimerTickReceiver> tick_receivers;

    public static TimerEvent addEvent(String name, long when, TimerEventPerformer performer) {
        TimerEvent res = timer.addEvent(name, when, performer);
        return res;
    }

    public static TimerEvent addEvent(String name, long when, boolean absolute, TimerEventPerformer performer) {
        TimerEvent res = timer.addEvent(name, when, absolute, performer);
        return res;
    }

    public static TimerEventPeriodic addPeriodicEvent(String name, long frequency, TimerEventPerformer performer) {
        TimerEventPeriodic res = timer.addPeriodicEvent(name, frequency, performer);
        return res;
    }

    public static TimerEventPeriodic addPeriodicEvent(String name, long frequency, boolean absolute, TimerEventPerformer performer) {
        TimerEventPeriodic res = timer.addPeriodicEvent(name, frequency, absolute, performer);
        return res;
    }

    public static void addTickReceiver(TimerTickReceiver receiver) {
        tick_receivers.add(receiver);
    }

    public static void removeTickReceiver(TimerTickReceiver receiver) {
        tick_receivers.remove(receiver);
    }

    static {
        tick_receivers = new CopyOnWriteList(true);
        timer = new Timer("Simple Timer", 32);
        timer.setIndestructable();
        timer.setWarnWhenFull();
        SimpleTimer.addPeriodicEvent("SimpleTimer:ticker", 1000L, new TimerEventPerformer(){
            private int tick_count;

            @Override
            public void perform(TimerEvent event2) {
                ++this.tick_count;
                if (tick_receivers.size() > 0) {
                    long mono_now = SystemTime.getMonotonousTime();
                    for (TimerTickReceiver ttr : tick_receivers) {
                        try {
                            ttr.tick(mono_now, this.tick_count);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            }
        });
    }

    public static interface TimerTickReceiver {
        public void tick(long var1, int var3);
    }
}

