/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.FileInputStream;
import java.io.IOException;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;

public class RARTOCDecoder {
    private final DataProvider provider;

    public RARTOCDecoder(DataProvider _provider) {
        this.provider = _provider;
    }

    public void analyse(TOCResultHandler result_handler) throws IOException {
        try {
            this.analyseSupport(result_handler);
            result_handler.complete();
        }
        catch (Throwable e) {
            IOException ioe = e instanceof IOException ? (IOException)e : new IOException("Analysis failed: " + Debug.getNestedExceptionMessage(e));
            result_handler.failed(ioe);
            throw ioe;
        }
    }

    private void analyseSupport(TOCResultHandler result_handler) throws IOException {
        int read;
        byte[] header_buffer = new byte[7];
        this.readFully(header_buffer);
        if (!new String(header_buffer).startsWith("Rar!")) {
            throw new IOException("Not a rar file");
        }
        this.readFully(header_buffer);
        int archive_header_size = RARTOCDecoder.getShort(header_buffer, 5);
        if (archive_header_size > 1024) {
            throw new IOException("Invalid archive header");
        }
        this.provider.skip(archive_header_size - 7);
        while ((read = this.provider.read(header_buffer)) >= 7) {
            int block_type = header_buffer[2] & 0xFF;
            int entry_flags = RARTOCDecoder.getShort(header_buffer, 3);
            int header_size = RARTOCDecoder.getShort(header_buffer, 5);
            if (block_type < 112 || block_type > 144) {
                throw new IOException("invalid header, archive corrupted");
            }
            if (block_type == 116) {
                String decoded_name;
                int name_length;
                boolean password = (entry_flags & 4) != 0;
                byte[] buffer = new byte[25];
                this.readFully(buffer);
                long comp_size = RARTOCDecoder.getInteger(buffer, 0);
                long act_size = RARTOCDecoder.getInteger(buffer, 4);
                int extended_length = 0;
                if ((entry_flags & 0x100) != 0) {
                    extended_length = 8;
                    byte[] extended_size_info = new byte[8];
                    this.readFully(extended_size_info);
                    comp_size |= RARTOCDecoder.getInteger(extended_size_info, 0) << 32;
                    act_size |= RARTOCDecoder.getInteger(extended_size_info, 4) << 32;
                }
                if ((name_length = RARTOCDecoder.getShort(buffer, 19)) > 32768) {
                    throw new IOException("name length too large: " + name_length);
                }
                byte[] name = new byte[name_length];
                this.readFully(name);
                if ((entry_flags & 0x200) != 0) {
                    int zero_pos = -1;
                    for (int i = 0; i < name.length; ++i) {
                        if (name[i] != 0) continue;
                        zero_pos = i;
                        break;
                    }
                    if (zero_pos == -1) {
                        decoded_name = new String(name, "UTF-8");
                    } else {
                        decoded_name = this.decodeName(name, zero_pos + 1);
                        if (decoded_name == null) {
                            decoded_name = new String(name, 0, zero_pos, "UTF-8");
                        }
                    }
                } else {
                    decoded_name = new String(name, "UTF-8");
                }
                if ((entry_flags & 0xE0) != 224) {
                    result_handler.entryRead(decoded_name, act_size, password);
                }
                this.provider.skip((long)(header_size - (32 + extended_length + name_length)) + comp_size);
                continue;
            }
            if (block_type == 123) break;
            this.provider.skip(archive_header_size - 7);
            if ((entry_flags & 0x8000) == 0) continue;
            this.provider.skip(4L);
        }
    }

    private String decodeName(byte[] b_data, int pos) {
        try {
            int Flags = 0;
            int FlagBits = 0;
            byte[] Name2 = b_data;
            byte[] EncName = b_data;
            int EncSize = b_data.length;
            int MaxDecSize = 4096;
            int[] NameW = new int[MaxDecSize];
            int EncPos = pos;
            int DecPos = 0;
            byte HighByte = EncName[EncPos++];
            while (EncPos < EncSize && DecPos < MaxDecSize) {
                if (FlagBits == 0) {
                    Flags = EncName[EncPos++];
                    FlagBits = 8;
                }
                switch (Flags >> 6 & 3) {
                    case 0: {
                        NameW[DecPos++] = EncName[EncPos++] & 0xFF;
                        break;
                    }
                    case 1: {
                        NameW[DecPos++] = (EncName[EncPos++] & 0xFF) + (HighByte << 8 & 0xFF00);
                        break;
                    }
                    case 2: {
                        NameW[DecPos++] = (EncName[EncPos++] & 0xFF) + (EncName[EncPos++] << 8 & 0xFF00);
                        break;
                    }
                    case 3: {
                        int Length = EncName[EncPos++] & 0xFF;
                        if ((Length & 0x80) != 0) {
                            byte Correction = EncName[EncPos++];
                            for (Length = (Length & 0x7F) + 2; Length > 0 && DecPos < MaxDecSize; --Length, ++DecPos) {
                                NameW[DecPos] = (Name2[DecPos] + Correction & 0xFF) + (HighByte << 8 & 0xFF00);
                            }
                        } else {
                            Length += 2;
                            while (Length > 0 && DecPos < MaxDecSize) {
                                NameW[DecPos] = Name2[DecPos] & 0xFF;
                                --Length;
                                ++DecPos;
                            }
                        }
                        break;
                    }
                }
                Flags <<= 2;
                FlagBits -= 2;
            }
            byte[] temp = new byte[DecPos * 2];
            for (int i = 0; i < DecPos; ++i) {
                temp[i * 2] = (byte)(NameW[i] >> 8 & 0xFF);
                temp[i * 2 + 1] = (byte)(NameW[i] & 0xFF);
            }
            return new String(temp, "UTF-16BE");
        }
        catch (Throwable e) {
            Debug.outNoStack("Failed to decode name: " + ByteFormatter.encodeString(b_data) + " - " + Debug.getNestedExceptionMessage(e));
            return null;
        }
    }

    private void readFully(byte[] buffer) throws IOException {
        if (this.provider.read(buffer) != buffer.length) {
            throw new IOException("unexpected end-of-file");
        }
    }

    public static void main(String[] args) {
        try {
            final FileInputStream fis = new FileInputStream("C:\\temp\\mp.part6.rar");
            RARTOCDecoder decoder = new RARTOCDecoder(new DataProvider(){

                @Override
                public int read(byte[] buffer) throws IOException {
                    return fis.read(buffer);
                }

                @Override
                public void skip(long bytes) throws IOException {
                    fis.skip(bytes);
                }
            });
            decoder.analyse(new TOCResultHandler(){

                @Override
                public void entryRead(String name, long size, boolean password) {
                    System.out.println(name + ": " + size + (password ? " protected" : ""));
                }

                @Override
                public void complete() {
                    System.out.println("complete");
                }

                @Override
                public void failed(IOException error) {
                    System.out.println("failed: " + Debug.getNestedExceptionMessage(error));
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static int getShort(byte[] buffer, int pos) {
        return buffer[pos + 1] << 8 & 0xFF00 | buffer[pos] & 0xFF;
    }

    private static long getInteger(byte[] buffer, int pos) {
        return (long)(buffer[pos + 3] << 24 & 0xFF000000 | buffer[pos + 2] << 16 & 0xFF0000 | buffer[pos + 1] << 8 & 0xFF00 | buffer[pos] & 0xFF) & 0xFFFFFFFFL;
    }

    public static interface DataProvider {
        public int read(byte[] var1) throws IOException;

        public void skip(long var1) throws IOException;
    }

    public static interface TOCResultHandler {
        public void entryRead(String var1, long var2, boolean var4) throws IOException;

        public void complete();

        public void failed(IOException var1);
    }
}

