/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.SystemTime;

public class PausableAverage
extends Average {
    private long offset;
    private long pause_time;

    public static PausableAverage getPausableInstance(int refreshRate, int period) {
        if (refreshRate < 100) {
            return null;
        }
        if (period * 1000 < refreshRate) {
            return null;
        }
        return new PausableAverage(refreshRate, period);
    }

    private PausableAverage(int _refreshRate, int _period) {
        super(_refreshRate, _period);
    }

    @Override
    public void addValue(long value) {
        super.addValue(value);
    }

    @Override
    public long getAverage() {
        long average = super.getAverage();
        return average;
    }

    @Override
    protected long getEffectiveTime() {
        return SystemTime.getCurrentTime() - this.offset;
    }

    public void pause() {
        if (this.pause_time == 0L) {
            this.pause_time = SystemTime.getCurrentTime();
        }
    }

    public void resume() {
        if (this.pause_time != 0L) {
            long now = SystemTime.getCurrentTime();
            if (now > this.pause_time) {
                this.offset += now - this.pause_time;
            }
            this.pause_time = 0L;
        }
    }
}

