/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.PrintWriter;

public class IndentWriter {
    private static final String INDENT_STRING = "    ";
    private static final String INDENT_STRING_HTML = "&nbsp;&nbsp;&nbsp;&nbsp;";
    private final PrintWriter pw;
    private String indent = "";
    private boolean html;
    private boolean force;

    public IndentWriter(PrintWriter _pw) {
        this.pw = _pw;
    }

    public void setHTML(boolean _html) {
        this.html = _html;
    }

    public void println(String str) {
        if (this.html) {
            this.pw.print(this.indent + str + "<br>");
        } else {
            this.pw.println(this.indent + str);
        }
        if (this.force) {
            this.pw.flush();
        }
    }

    public void indent() {
        this.indent = this.indent + (this.html ? INDENT_STRING_HTML : INDENT_STRING);
    }

    public void exdent() {
        if (this.indent.length() > 0) {
            this.indent = this.indent.substring((this.html ? INDENT_STRING_HTML : INDENT_STRING).length());
        }
    }

    public String getTab() {
        return this.html ? INDENT_STRING_HTML : INDENT_STRING;
    }

    public void setForce(boolean b) {
        this.force = b;
    }

    public void close() {
        this.pw.close();
    }
}

