/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IPToHostNameResolverListener;
import org.gudy.azureus2.core3.util.IPToHostNameResolverRequest;

public class IPToHostNameResolver {
    protected static AEThread2 resolver_thread;
    protected static final List request_queue;
    protected static final AEMonitor request_mon;
    protected static final AESemaphore request_semaphore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IPToHostNameResolverRequest addResolverRequest(String ip, IPToHostNameResolverListener l) {
        try {
            request_mon.enter();
            IPToHostNameResolverRequest request2 = new IPToHostNameResolverRequest(ip, l);
            request_queue.add(request2);
            request_semaphore.release();
            if (resolver_thread == null) {
                resolver_thread = new AEThread2("IPToHostNameResolver", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block8: while (true) {
                            try {
                                while (true) {
                                    IPToHostNameResolverRequest req;
                                    request_semaphore.reserve(30000L);
                                    try {
                                        request_mon.enter();
                                        if (request_queue.isEmpty()) {
                                            resolver_thread = null;
                                            break block8;
                                        }
                                        req = (IPToHostNameResolverRequest)request_queue.remove(0);
                                    }
                                    finally {
                                        request_mon.exit();
                                    }
                                    IPToHostNameResolverListener listener = req.getListener();
                                    if (listener == null) continue;
                                    String ip = req.getIP();
                                    if (AENetworkClassifier.categoriseAddress(ip) == "Public") {
                                        try {
                                            InetAddress addr = InetAddress.getByName(ip);
                                            req.getListener().IPResolutionComplete(addr.getHostName(), true);
                                            continue block8;
                                        }
                                        catch (Throwable e) {
                                            req.getListener().IPResolutionComplete(ip, false);
                                            continue;
                                        }
                                    }
                                    req.getListener().IPResolutionComplete(ip, true);
                                }
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                                continue;
                            }
                            break;
                        }
                    }
                };
                resolver_thread.start();
            }
            IPToHostNameResolverRequest iPToHostNameResolverRequest = request2;
            return iPToHostNameResolverRequest;
        }
        finally {
            request_mon.exit();
        }
    }

    public static String syncResolve(String ip, int timeout) throws Exception {
        final AESemaphore sem = new AESemaphore("IPToHostNameREsolver:sync");
        final Object[] result = new Object[]{null};
        IPToHostNameResolver.addResolverRequest(ip, new IPToHostNameResolverListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void IPResolutionComplete(String resolved_ip, boolean succeeded) {
                try {
                    Object[] objectArray = result;
                    synchronized (result) {
                        if (succeeded) {
                            result[0] = resolved_ip;
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                    }
                }
                finally {
                    sem.release();
                }
                {
                    return;
                }
            }
        });
        if (!sem.reserve(timeout)) {
            throw new Exception("Timeout");
        }
        Object[] objectArray = result;
        synchronized (result) {
            if (result[0] != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return (String)result[0];
            }
            throw new UnknownHostException(ip);
        }
    }

    static {
        request_queue = new ArrayList();
        request_mon = new AEMonitor("IPToHostNameResolver");
        request_semaphore = new AESemaphore("IPToHostNameResolver");
    }
}

