/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.util.AENetworkClassifierListener;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;

public class AENetworkClassifier {
    public static final String AT_PUBLIC = "Public";
    public static final String AT_I2P = "I2P";
    public static final String AT_TOR = "Tor";
    public static final String[] AT_NETWORKS = new String[]{"Public", "I2P", "Tor"};
    public static final String[] AT_NON_PUBLIC = new String[]{"I2P", "Tor"};
    private static final List listeners = new ArrayList();

    public static String categoriseAddress(String str) {
        String temp;
        if (str == null) {
            return AT_PUBLIC;
        }
        int len = str.length();
        if (len < 7) {
            return AT_PUBLIC;
        }
        char[] chars = str.toCharArray();
        char last_char = chars[len - 1];
        if (last_char >= '0' && last_char <= '9') {
            return AT_PUBLIC;
        }
        if (last_char == 'p' || last_char == 'P') {
            char c;
            if (chars[len - 2] == '2' && chars[len - 4] == '.' && ((c = chars[len - 3]) == 'i' || c == 'I')) {
                return AT_I2P;
            }
            return AT_PUBLIC;
        }
        if ((last_char == 'n' || last_char == 'N') && chars[len - 6] == '.' && (temp = new String(chars, len - 5, 4).toLowerCase(Locale.US)).equals("onio")) {
            return AT_TOR;
        }
        return AT_PUBLIC;
    }

    public static String internalise(String str) {
        if (str == null) {
            return null;
        }
        for (String net : AT_NETWORKS) {
            if (!str.equalsIgnoreCase(net)) continue;
            return net;
        }
        return null;
    }

    public static String categoriseAddress(InetSocketAddress isa) {
        return AENetworkClassifier.categoriseAddress(AddressUtils.getHostAddress(isa));
    }

    public static String[] getNetworks(TOTorrent torrent, String display_name) {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(torrent.getAnnounceURL());
        TOTorrentAnnounceURLSet[] sets = torrent.getAnnounceURLGroup().getAnnounceURLSets();
        for (int i = 0; i < sets.length; ++i) {
            URL[] u = sets[i].getAnnounceURLs();
            Collections.addAll(urls, u);
        }
        ArrayList<String> available_networks = new ArrayList<String>();
        for (int i = 0; i < urls.size(); ++i) {
            URL u = (URL)urls.get(i);
            String network = AENetworkClassifier.categoriseAddress(u.getHost());
            if (available_networks.contains(network)) continue;
            available_networks.add(network);
        }
        if (available_networks.size() == 1 && available_networks.get(0) == AT_PUBLIC) {
            return new String[]{AT_PUBLIC};
        }
        boolean prompt = COConfigurationManager.getBooleanParameter("Network Selection Prompt");
        ArrayList res = new ArrayList();
        if (prompt && listeners.size() > 0) {
            String[] t_nets = new String[available_networks.size()];
            available_networks.toArray(t_nets);
            for (int i = 0; i < listeners.size(); ++i) {
                try {
                    String[] selected = ((AENetworkClassifierListener)listeners.get(i)).selectNetworks(display_name, t_nets);
                    if (selected == null) continue;
                    Collections.addAll(res, selected);
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        } else {
            for (int i = 0; i < available_networks.size(); ++i) {
                if (!COConfigurationManager.getBooleanParameter("Network Selection Default." + (String)available_networks.get(i))) continue;
                res.add(available_networks.get(i));
            }
        }
        String[] x = new String[res.size()];
        res.toArray(x);
        return x;
    }

    public static String[] getDefaultNetworks() {
        ArrayList<String> res = new ArrayList<String>();
        for (String net : AT_NETWORKS) {
            if (!COConfigurationManager.getBooleanParameter("Network Selection Default." + net)) continue;
            res.add(net);
        }
        String[] x = new String[res.size()];
        res.toArray(x);
        return x;
    }

    public static void addListener(AENetworkClassifierListener l) {
        listeners.add(l);
    }

    public static void removeListener(AENetworkClassifierListener l) {
        listeners.remove(l);
    }

    public static void main(String[] args) {
        String[] tests;
        for (String str : tests = new String[]{null, "12345", "192.168.1.2", "fred.i2p", "fred.i2", "bill.onion", "bill.onio"}) {
            System.out.println(str + " -> " + AENetworkClassifier.categoriseAddress(str));
        }
    }
}

