/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp.blocking;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerProcessorTCP;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;

public class TRBlockingServerProcessor
extends TRTrackerServerProcessorTCP {
    protected static final int KEEP_ALIVE_SOCKET_TIMEOUT = 30000;
    private static final LogIDs LOGID = LogIDs.TRACKER;
    protected final Socket socket;
    protected int timeout_ticks = 1;
    protected String current_request;

    protected TRBlockingServerProcessor(TRTrackerServerTCP _server, Socket _socket) {
        super(_server);
        this.socket = _socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runSupport() {
        boolean keep_alive = this.getServer().isKeepAliveEnabled();
        try {
            BufferedInputStream is = new BufferedInputStream(this.socket.getInputStream());
            do {
                this.setTaskState("entry");
                try {
                    if (keep_alive) {
                        this.socket.setSoTimeout(30000);
                        this.setTimeoutsDisabled(true);
                    } else {
                        this.socket.setSoTimeout(5000);
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                this.setTaskState("reading header");
                try {
                    int url_start;
                    String lowercase_header;
                    byte[] buffer = new byte[16384];
                    int header_pos = 0;
                    while (header_pos < buffer.length) {
                        int len = ((InputStream)is).read(buffer, header_pos, 1);
                        if (len != 1) {
                            throw new Exception("Premature end of stream reading header");
                        }
                        if (++header_pos < 4 || buffer[header_pos - 4] != 13 || buffer[header_pos - 3] != 10 || buffer[header_pos - 2] != 13 || buffer[header_pos - 1] != 10) continue;
                        break;
                    }
                    String header = new String(buffer, 0, header_pos, "ISO-8859-1");
                    if (Logger.isEnabled()) {
                        String log_str = header;
                        int pos = log_str.indexOf("\r\n");
                        if (pos != -1) {
                            log_str = log_str.substring(0, pos);
                        }
                        Logger.log(new LogEvent(LOGID, "Tracker Server: received header '" + log_str + "' from " + this.socket.getRemoteSocketAddress()));
                    }
                    InputStream post_is = null;
                    File post_file = null;
                    boolean head = false;
                    if (header.startsWith("GET ")) {
                        this.timeout_ticks = 1;
                        lowercase_header = header.toLowerCase();
                        url_start = 4;
                    } else if (header.startsWith("HEAD ")) {
                        this.timeout_ticks = 1;
                        lowercase_header = header.toLowerCase();
                        url_start = 5;
                        head = true;
                    } else if (header.startsWith("POST ")) {
                        this.timeout_ticks = TRTrackerServerTCP.PROCESSING_POST_MULTIPLIER;
                        if (this.timeout_ticks == 0) {
                            this.setTimeoutsDisabled(true);
                        }
                        this.setTaskState("reading content");
                        lowercase_header = header.toLowerCase();
                        url_start = 5;
                        String cl_str = this.getHeaderField(header, lowercase_header, "content-length:");
                        boolean chunk_read = false;
                        if (cl_str == null) {
                            String transfer_encoding_str = this.getHeaderField(header, lowercase_header, "transfer-encoding: ");
                            chunk_read = transfer_encoding_str != null && transfer_encoding_str.equalsIgnoreCase("chunked");
                            cl_str = "0";
                        }
                        int content_length = Integer.parseInt(cl_str);
                        ByteArrayOutputStream baos = null;
                        FileOutputStream fos = null;
                        try {
                            OutputStream data_os;
                            block76: {
                                if (content_length <= 262144) {
                                    baos = new ByteArrayOutputStream();
                                    data_os = baos;
                                } else {
                                    post_file = AETemporaryFileHandler.createTempFile();
                                    post_file.deleteOnExit();
                                    fos = new FileOutputStream(post_file);
                                    data_os = fos;
                                }
                                if (chunk_read) {
                                    boolean bad;
                                    do {
                                        int chunkSize = -1;
                                        while (true) {
                                            int val;
                                            if ((val = ((InputStream)is).read()) == -1) {
                                                throw new TRTrackerServerException("premature end of input stream (chunksize)");
                                            }
                                            if (val == 10) break;
                                            if (val == 13) continue;
                                            chunkSize = chunkSize == -1 ? 0 : (chunkSize <<= 4);
                                            chunkSize += Character.digit(val, 16);
                                        }
                                        if (chunkSize == -1) {
                                            throw new TRTrackerServerException("invalid chunk size");
                                        }
                                        if (chunkSize == 0) {
                                            boolean bl = bad = ((InputStream)is).read() == -1 || ((InputStream)is).read() == -1;
                                            if (bad) {
                                                throw new TRTrackerServerException("premature end of input stream (NoTerminatingChunk)");
                                            }
                                            break block76;
                                        }
                                        while (chunkSize > 0) {
                                            int len = ((InputStream)is).read(buffer, 0, Math.min(chunkSize, buffer.length));
                                            if (len < 0) {
                                                throw new TRTrackerServerException("premature end of input stream");
                                            }
                                            data_os.write(buffer, 0, len);
                                            chunkSize -= len;
                                        }
                                    } while (!(bad = ((InputStream)is).read() == -1 || ((InputStream)is).read() == -1));
                                    throw new TRTrackerServerException("premature end of input stream (NoChunkEndMarker)");
                                }
                            }
                            while (content_length > 0) {
                                int len = ((InputStream)is).read(buffer, 0, Math.min(content_length, buffer.length));
                                if (len < 0) {
                                    throw new TRTrackerServerException("premature end of input stream");
                                }
                                data_os.write(buffer, 0, len);
                                content_length -= len;
                            }
                            if (baos != null) {
                                post_is = new ByteArrayInputStream(baos.toByteArray());
                            }
                            fos.close();
                            fos = null;
                            post_is = new BufferedInputStream(new FileInputStream(post_file), 262144);
                        }
                        finally {
                            if (baos != null) {
                                try {
                                    baos.close();
                                }
                                catch (Throwable e) {}
                            }
                            if (fos != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable e) {}
                            }
                            if (post_is == null && post_file != null) {
                                post_file.delete();
                            }
                        }
                    } else {
                        int pos = header.indexOf(32);
                        if (pos == -1) {
                            throw new TRTrackerServerException("header doesn't have space in right place");
                        }
                        this.timeout_ticks = 1;
                        lowercase_header = header.toLowerCase();
                        url_start = pos + 1;
                    }
                    this.setTaskState("processing request");
                    this.current_request = header;
                    try {
                        int url_end;
                        if (post_is == null) {
                            post_is = new ByteArrayInputStream(new byte[0]);
                        }
                        if ((url_end = header.indexOf(" ", url_start)) == -1) {
                            throw new TRTrackerServerException("header doesn't have space in right place");
                        }
                        String url = header.substring(url_start, url_end).trim();
                        int nl_pos = header.indexOf("\r\n", url_end);
                        if (nl_pos == -1) {
                            throw new TRTrackerServerException("header doesn't have nl in right place");
                        }
                        String http_ver = header.substring(url_end, nl_pos).trim();
                        String con_str = this.getHeaderField(header, lowercase_header, "connection:");
                        if (con_str == null) {
                            if (http_ver.equalsIgnoreCase("HTTP/1.0")) {
                                keep_alive = false;
                            }
                        } else if (con_str.equalsIgnoreCase("close")) {
                            keep_alive = false;
                        }
                        if (head) {
                            ByteArrayOutputStream head_response = new ByteArrayOutputStream(4096);
                            if (!this.processRequest(header, lowercase_header, url, (InetSocketAddress)this.socket.getLocalSocketAddress(), (InetSocketAddress)this.socket.getRemoteSocketAddress(), false, keep_alive, post_is, head_response, null)) {
                                keep_alive = false;
                            }
                            byte[] head_data = head_response.toByteArray();
                            int header_length = head_data.length;
                            for (int i = 3; i < head_data.length; ++i) {
                                if (head_data[i - 3] != 13 || head_data[i - 2] != 10 || head_data[i - 1] != 13 || head_data[i] != 10) continue;
                                header_length = i + 1;
                                break;
                            }
                            this.setTaskState("writing head response");
                            this.socket.getOutputStream().write(head_data, 0, header_length);
                            this.socket.getOutputStream().flush();
                        } else if (!this.processRequest(header, lowercase_header, url, (InetSocketAddress)this.socket.getLocalSocketAddress(), (InetSocketAddress)this.socket.getRemoteSocketAddress(), false, keep_alive, post_is, this.socket.getOutputStream(), null)) {
                            keep_alive = false;
                        }
                    }
                    finally {
                        if (post_is != null) {
                            post_is.close();
                        }
                        if (post_file != null) {
                            post_file.delete();
                        }
                    }
                }
                catch (Throwable e) {
                    keep_alive = false;
                }
            } while (keep_alive);
        }
        catch (Throwable e) {
        }
        finally {
            this.setTaskState("final socket close");
            try {
                this.socket.close();
            }
            catch (Throwable e) {}
        }
    }

    protected String getHeaderField(String header, String lc_header, String field) {
        int start = lc_header.indexOf(field);
        if (start == -1) {
            return null;
        }
        int end = header.indexOf("\r\n", start);
        if (end == -1) {
            return null;
        }
        return header.substring(start + field.length(), end).trim();
    }

    @Override
    public boolean isActive() {
        try {
            if (!this.socket.getKeepAlive()) {
                this.socket.setKeepAlive(true);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return !this.socket.isClosed();
    }

    @Override
    public void interruptTask() {
        try {
            if (!this.areTimeoutsDisabled()) {
                --this.timeout_ticks;
                if (this.timeout_ticks <= 0) {
                    System.out.println("Tracker task interrupted in state '" + this.getTaskState() + "' : processing time limit exceeded for " + this.socket.getInetAddress());
                    this.socket.close();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

