/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Locale;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.bouncycastle.util.encoders.Base64;

public abstract class TRTrackerServerProcessorTCP
extends TRTrackerServerProcessor {
    protected static final int SOCKET_TIMEOUT = 5000;
    protected static final char CR = '\r';
    protected static final char FF = '\n';
    protected static final String NL = "\r\n";
    private static final String lc_azureus_name = "Azureus".toLowerCase();
    protected static final byte[] HTTP_RESPONSE_START = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nServer: Azureus 5.7.5.0\r\nConnection: close\r\nContent-Length: ".getBytes();
    protected static final byte[] HTTP_RESPONSE_XML_START = "HTTP/1.1 200 OK\r\nContent-Type: text/xml; charset=\"utf-8\"\r\nServer: Azureus 5.7.5.0\r\nConnection: close\r\nContent-Length: ".getBytes();
    protected static final byte[] HTTP_RESPONSE_END_GZIP = "\r\nContent-Encoding: gzip\r\n\r\n".getBytes();
    protected static final byte[] HTTP_RESPONSE_END_NOGZIP = "\r\n\r\n".getBytes();
    private static String MSG_CLIENT_NOT_SUPPORTED;
    private final TRTrackerServerTCP server;
    private final String server_url;
    private boolean disable_timeouts = false;

    protected TRTrackerServerProcessorTCP(TRTrackerServerTCP _server) {
        this.server = _server;
        this.server_url = (this.server.isSSL() ? "https" : "http") + "://" + UrlUtils.convertIPV6Host(this.server.getHost()) + ":" + this.server.getPort();
    }

    public boolean areTimeoutsDisabled() {
        return this.disable_timeouts;
    }

    public void setTimeoutsDisabled(boolean d) {
        this.disable_timeouts = d;
    }

    protected TRTrackerServerTCP getServer() {
        return this.server;
    }

    /*
     * Exception decompiling
     */
    protected boolean processRequest(String input_header, String lowercase_input_header, String url_path, InetSocketAddress local_address, InetSocketAddress remote_address, boolean announce_and_scrape_only, boolean keep_alive, InputStream is, OutputStream os, AsyncController async) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [104[SIMPLE_IF_TAKEN]], but top level block is 12[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String doAuthentication(InetSocketAddress remote_ip, String url_path, String header, OutputStream os, boolean tracker) throws IOException {
        boolean apply_torrent_password;
        boolean apply_web_password = !tracker && this.server.isWebPasswordEnabled();
        boolean bl = apply_torrent_password = tracker && this.server.isTrackerPasswordEnabled();
        if (apply_web_password && this.server.isWebPasswordHTTPSOnly() && !this.server.isSSL()) {
            os.write("HTTP/1.1 403 BAD\r\n\r\nAccess Denied\r\n".getBytes());
            os.flush();
            return null;
        }
        if (apply_torrent_password || apply_web_password) {
            int x = header.indexOf("Authorization:");
            if (x == -1) {
                if (this.server.hasExternalAuthorisation()) {
                    try {
                        String resource_str = (this.server.isSSL() ? "https" : "http") + "://" + UrlUtils.convertIPV6Host(this.server.getHost()) + ":" + this.server.getPort() + url_path;
                        URL resource = new URL(resource_str);
                        if (this.server.performExternalAuthorisation(remote_ip, header, resource, "", "")) {
                            return "";
                        }
                    }
                    catch (MalformedURLException e) {
                        Debug.printStackTrace(e);
                    }
                }
            } else {
                int p1 = header.indexOf(32, x);
                int p2 = header.indexOf(32, p1 + 1);
                String body = header.substring(p2, header.indexOf(13, p2)).trim();
                String decoded = new String(Base64.decode(body));
                int cp = decoded.indexOf(58);
                String user = decoded.substring(0, cp);
                String pw = decoded.substring(cp + 1);
                boolean auth_failed = false;
                if (this.server.hasExternalAuthorisation()) {
                    try {
                        String resource_str = (this.server.isSSL() ? "https" : "http") + "://" + UrlUtils.convertIPV6Host(this.server.getHost()) + ":" + this.server.getPort() + url_path;
                        URL resource = new URL(resource_str);
                        if (this.server.performExternalAuthorisation(remote_ip, header, resource, user, pw)) {
                            return user;
                        }
                    }
                    catch (MalformedURLException e) {
                        Debug.printStackTrace(e);
                    }
                    auth_failed = true;
                }
                if (this.server.hasInternalAuthorisation() && !auth_failed) {
                    try {
                        byte[] internal_pw;
                        SHA1Hasher hasher = new SHA1Hasher();
                        byte[] password = pw.getBytes();
                        byte[] encoded = password.length > 0 ? hasher.calculateHash(password) : new byte[]{};
                        if (user.equals("<internal>") ? Arrays.equals(internal_pw = Base64.decode(pw), this.server.getPassword()) : user.equalsIgnoreCase(this.server.getUsername()) && Arrays.equals(encoded, this.server.getPassword())) {
                            return user;
                        }
                    }
                    catch (Exception e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            os.write(("HTTP/1.1 401 Not Authorized\r\nWWW-Authenticate: Basic realm=\"" + this.server.getName() + "\"" + NL + "Content-Length: 15" + NL + NL + "Access Denied" + NL).getBytes());
            os.flush();
            return null;
        }
        return "";
    }

    protected boolean isActive() {
        return true;
    }

    protected boolean handleExternalRequest(InetSocketAddress local_address, InetSocketAddress remote_address, String user, String url, String header, InputStream is, OutputStream os, AsyncController async, boolean[] keep_alive) throws IOException {
        URL absolute_url = new URL(this.server_url + (url.startsWith("/") ? url : "/" + url));
        return this.server.handleExternalRequest(this, local_address, remote_address, user, url, absolute_url, header, is, os, async, keep_alive);
    }

    static {
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            @Override
            public void localeChanged(Locale old_locale, Locale new_locale) {
                MSG_CLIENT_NOT_SUPPORTED = MessageText.getString("tracker.msg.client.not.supported");
            }
        });
    }
}

