/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import org.gudy.azureus2.core3.tracker.server.TRTrackerServerStats;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;

public class TRTrackerServerStatsImpl
implements TRTrackerServerStats {
    private final TRTrackerServerImpl server;
    private long announces;
    private long scrapes;
    private long bytes_in;
    private long bytes_out;
    private long announce_time;
    private long scrape_time;

    protected TRTrackerServerStatsImpl(TRTrackerServerImpl _server) {
        this.server = _server;
    }

    @Override
    public int getTorrentCount() {
        return this.server.getTorrentCount();
    }

    @Override
    public long getBytesIn() {
        return this.bytes_in;
    }

    @Override
    public long getBytesOut() {
        return this.bytes_out;
    }

    protected void update(int request_type, int in, int out) {
        this.bytes_in += (long)in;
        this.bytes_out += (long)out;
        if (request_type == 1 || request_type == 4) {
            ++this.announces;
        } else {
            ++this.scrapes;
        }
    }

    protected void updateTime(int request_type, long time) {
        if (request_type == 1) {
            this.announce_time += time;
        } else {
            this.scrape_time += time;
        }
    }

    @Override
    public long getAnnounceCount() {
        return this.announces;
    }

    @Override
    public long getScrapeCount() {
        return this.scrapes;
    }

    @Override
    public long getAnnounceTime() {
        return this.announce_time;
    }

    @Override
    public long getScrapeTime() {
        return this.scrape_time;
    }
}

