/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtils;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.ByteEncodedKeyHashMap;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPoolTask;

public abstract class TRTrackerServerProcessor
extends ThreadPoolTask {
    private static final boolean QUEUE_TEST = false;
    private TRTrackerServerImpl server;
    private long start;
    private int request_type;

    protected TRTrackerServerTorrentImpl processTrackerRequest(TRTrackerServerImpl _server, String request2, Map[] root_out, TRTrackerServerPeerImpl[] peer_out, int _request_type, byte[][] hashes, String link, String scrape_flags, HashWrapper peer_id, boolean no_peer_id, byte compact_mode, String key, String event2, boolean stop_to_queue, int port, int udp_port, int http_port, String real_ip_address, String original_client_ip_address, long downloaded, long uploaded, long left, int num_want, byte crypto_level, byte az_ver, int up_speed, DHTNetworkPosition network_position) throws TRTrackerServerException {
        int i;
        String client_ip_address;
        this.server = _server;
        this.request_type = _request_type;
        if (!this.server.isReady()) {
            throw new TRTrackerServerException("Tracker initialising, please wait");
        }
        this.start = SystemTime.getHighPrecisionCounter();
        boolean ip_override = real_ip_address != original_client_ip_address;
        boolean loopback = TRTrackerUtils.isLoopback(real_ip_address);
        if (loopback) {
            ip_override = false;
        }
        if ((client_ip_address = TRTrackerUtils.adjustHostFromHosting(original_client_ip_address)) != original_client_ip_address && Logger.isEnabled()) {
            Logger.log(new LogEvent(LogIDs.TRACKER, "    address adjusted: original=" + original_client_ip_address + ", real=" + real_ip_address + ", adjusted=" + client_ip_address + ", loopback=" + loopback));
        }
        if (!TRTrackerServerImpl.getAllNetworksSupported()) {
            String network = AENetworkClassifier.categoriseAddress(client_ip_address);
            String[] permitted_networks = TRTrackerServerImpl.getPermittedNetworks();
            boolean ok = false;
            for (i = 0; i < permitted_networks.length; ++i) {
                if (network != permitted_networks[i]) continue;
                ok = true;
                break;
            }
            if (!ok) {
                throw new TRTrackerServerException("Network '" + network + "' not supported");
            }
        }
        TRTrackerServerTorrentImpl torrent = null;
        if (this.request_type != 3) {
            byte[] hash;
            if (this.request_type == 1) {
                long min_interval;
                long interval;
                Set biased;
                if (hashes == null || hashes.length == 0) {
                    throw new TRTrackerServerException("Hash missing from request ");
                }
                if (hashes.length != 1) {
                    throw new TRTrackerServerException("Too many hashes for announce");
                }
                hash = hashes[0];
                torrent = this.server.getTorrent(hash);
                if (torrent == null) {
                    if (!COConfigurationManager.getBooleanParameter("Tracker Public Enable")) {
                        throw new TRTrackerServerException("Torrent unauthorised");
                    }
                    try {
                        torrent = (TRTrackerServerTorrentImpl)this.server.permit(real_ip_address, hash, false);
                    }
                    catch (Throwable e) {
                        throw new TRTrackerServerException("Torrent unauthorised", e);
                    }
                }
                if (peer_id == null) {
                    throw new TRTrackerServerException("peer_id missing from request");
                }
                boolean queue_it = stop_to_queue;
                if (queue_it && ((biased = this.server.getBiasedPeers()) == null || !biased.contains(real_ip_address)) && (loopback || ip_override)) {
                    queue_it = false;
                }
                if (queue_it) {
                    interval = this.server.getScrapeRetryInterval(torrent);
                    min_interval = this.server.getMinScrapeRetryInterval();
                } else {
                    interval = this.server.getAnnounceRetryInterval(torrent);
                    min_interval = this.server.getMinAnnounceRetryInterval();
                    if (left == 0L) {
                        long mult = this.server.getSeedAnnounceIntervalMultiplier();
                        interval *= mult;
                        min_interval *= mult;
                    }
                }
                TRTrackerServerPeerImpl peer = torrent.peerContact(request2, event2, peer_id, port, udp_port, http_port, crypto_level, az_ver, real_ip_address, client_ip_address, ip_override, loopback, key, uploaded, downloaded, left, interval, up_speed, network_position);
                if (queue_it) {
                    torrent.peerQueued(client_ip_address, port, udp_port, http_port, crypto_level, az_ver, interval, left == 0L);
                }
                HashMap pre_map = new HashMap();
                TRTrackerServerPeer pre_process_peer = peer;
                if (pre_process_peer == null) {
                    pre_process_peer = new lightweightPeer(client_ip_address, port, peer_id);
                }
                this.server.preProcess(pre_process_peer, torrent, this.request_type, request2, pre_map);
                boolean stopped = event2 != null && event2.equalsIgnoreCase("stopped");
                root_out[0] = torrent.exportAnnounceToMap(client_ip_address, pre_map, peer, left > 0L, stopped ? 0 : num_want, interval, min_interval, no_peer_id, compact_mode, crypto_level, network_position);
                peer_out[0] = peer;
            } else if (this.request_type == 4) {
                if (link == null) {
                    if (hashes == null || hashes.length == 0) {
                        throw new TRTrackerServerException("Hash missing from request ");
                    }
                    if (hashes.length != 1) {
                        throw new TRTrackerServerException("Too many hashes for query");
                    }
                    hash = hashes[0];
                    torrent = this.server.getTorrent(hash);
                } else {
                    torrent = this.server.getTorrent(link);
                }
                if (torrent == null) {
                    throw new TRTrackerServerException("Torrent unauthorised");
                }
                long interval = this.server.getAnnounceRetryInterval(torrent);
                root_out[0] = torrent.exportAnnounceToMap(client_ip_address, new HashMap(), null, true, num_want, interval, this.server.getMinAnnounceRetryInterval(), true, compact_mode, crypto_level, network_position);
            } else {
                char[] scrape_chars;
                HashMap root;
                if (hashes == null || hashes.length == 0) {
                    throw new TRTrackerServerException("Hash missing from request ");
                }
                boolean local_scrape = client_ip_address.equals("127.0.0.1");
                long max_interval = this.server.getMinScrapeRetryInterval();
                root_out[0] = root = new HashMap();
                ByteEncodedKeyHashMap files = new ByteEncodedKeyHashMap();
                root.put("files", files);
                char[] cArray = scrape_chars = scrape_flags == null ? null : scrape_flags.toCharArray();
                if (scrape_chars != null && scrape_chars.length != hashes.length) {
                    scrape_chars = null;
                }
                for (int i2 = 0; i2 < hashes.length; ++i2) {
                    long interval;
                    String str_hash;
                    byte[] hash2 = hashes[i2];
                    try {
                        str_hash = new String(hash2, "ISO-8859-1");
                        if (i2 > 0 && files.get(str_hash) != null) {
                        }
                    }
                    catch (UnsupportedEncodingException e) {}
                    continue;
                    torrent = this.server.getTorrent(hash2);
                    if (torrent == null) {
                        if (!COConfigurationManager.getBooleanParameter("Tracker Public Enable")) continue;
                        try {
                            torrent = (TRTrackerServerTorrentImpl)this.server.permit(real_ip_address, hash2, false);
                        }
                        catch (Throwable e) {
                            continue;
                        }
                    }
                    if ((interval = this.server.getScrapeRetryInterval(torrent)) > max_interval) {
                        max_interval = interval;
                    }
                    if (scrape_chars != null && !loopback && !ip_override && scrape_chars[i2] == 'Q') {
                        torrent.peerQueued(client_ip_address, port, udp_port, http_port, crypto_level, az_ver, (int)interval, true);
                    }
                    if (torrent.getRedirects() != null && hashes.length > 1) continue;
                    this.server.preProcess(new lightweightPeer(client_ip_address, port, peer_id), torrent, this.request_type, request2, null);
                    Map hash_entry = torrent.exportScrapeToMap(request2, client_ip_address, !local_scrape);
                    files.put(str_hash, hash_entry);
                }
                if (hashes.length > 1) {
                    torrent = null;
                }
                this.addScrapeInterval(max_interval, root);
            }
        } else {
            HashMap root;
            if (!TRTrackerServerImpl.isFullScrapeEnabled()) {
                throw new TRTrackerServerException("Full scrape disabled");
            }
            ByteEncodedKeyHashMap files = new ByteEncodedKeyHashMap();
            TRTrackerServerTorrentImpl[] torrents = this.server.getTorrents();
            for (i = 0; i < torrents.length; ++i) {
                TRTrackerServerTorrentImpl this_torrent = torrents[i];
                if (this_torrent.getRedirects() != null) continue;
                this.server.preProcess(new lightweightPeer(client_ip_address, port, peer_id), this_torrent, this.request_type, request2, null);
                byte[] torrent_hash = this_torrent.getHash().getHash();
                try {
                    String str_hash = new String(torrent_hash, "ISO-8859-1");
                    Map hash_entry = this_torrent.exportScrapeToMap(request2, client_ip_address, true);
                    files.put(str_hash, hash_entry);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new TRTrackerServerException("Encoding error", e);
                }
            }
            root_out[0] = root = new HashMap();
            this.addScrapeInterval(null, root);
            root.put("files", files);
        }
        return torrent;
    }

    protected void addScrapeInterval(TRTrackerServerTorrentImpl torrent, Map root) {
        long interval = this.server.getScrapeRetryInterval(torrent);
        this.addScrapeInterval(interval, root);
    }

    protected void addScrapeInterval(long interval, Map root) {
        if (interval > 0L) {
            HashMap<String, Long> flags = new HashMap<String, Long>();
            flags.put("min_request_interval", new Long(interval));
            root.put("flags", flags);
        }
    }

    @Override
    public void taskCompleted() {
        if (this.start > 0L) {
            long time = SystemTime.getHighPrecisionCounter() - this.start;
            this.server.updateTime(this.request_type, time);
        }
    }

    protected static class lightweightPeer
    implements TRTrackerServerPeer {
        private final String ip;
        private final int port;
        private final byte[] peer_id;

        public lightweightPeer(String _ip, int _port, HashWrapper _peer_id) {
            this.ip = _ip;
            this.port = _port;
            this.peer_id = _peer_id == null ? null : _peer_id.getBytes();
        }

        @Override
        public long getUploaded() {
            return -1L;
        }

        @Override
        public long getDownloaded() {
            return -1L;
        }

        @Override
        public long getAmountLeft() {
            return -1L;
        }

        @Override
        public String getIP() {
            return this.ip;
        }

        @Override
        public String getIPRaw() {
            return this.ip;
        }

        @Override
        public byte getNATStatus() {
            return 0;
        }

        @Override
        public int getTCPPort() {
            return this.port;
        }

        @Override
        public int getHTTPPort() {
            return 0;
        }

        public int getUDPPort() {
            return 0;
        }

        @Override
        public byte[] getPeerID() {
            return this.peer_id;
        }

        @Override
        public boolean isBiased() {
            return false;
        }

        @Override
        public void setBiased(boolean biased) {
        }

        @Override
        public void setUserData(Object key, Object data) {
        }

        @Override
        public Object getUserData(Object key) {
            return null;
        }

        @Override
        public int getSecsToLive() {
            return -1;
        }

        @Override
        public Map export() {
            return null;
        }
    }
}

