/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.gudy.azureus2.core3.util.ByteFormatter;

public class PRUDPPacketRequestAnnounce2
extends PRUDPPacketRequest {
    public static final int EV_STARTED = 2;
    public static final int EV_STOPPED = 3;
    public static final int EV_COMPLETED = 1;
    public static final int EV_UPDATE = 0;
    protected byte[] hash;
    protected byte[] peer_id;
    protected long downloaded;
    protected int event;
    protected int key;
    protected int num_want;
    protected long left;
    protected short port;
    protected long uploaded;
    protected int ip_address;

    public PRUDPPacketRequestAnnounce2(long con_id) {
        super(1, con_id);
    }

    protected PRUDPPacketRequestAnnounce2(DataInputStream is, long con_id, int trans_id) throws IOException {
        super(1, con_id, trans_id);
        this.hash = new byte[20];
        this.peer_id = new byte[20];
        is.read(this.hash);
        is.read(this.peer_id);
        this.downloaded = is.readLong();
        this.left = is.readLong();
        this.uploaded = is.readLong();
        this.event = is.readInt();
        this.ip_address = is.readInt();
        this.key = is.readInt();
        this.num_want = is.readInt();
        this.port = is.readShort();
    }

    public byte[] getHash() {
        return this.hash;
    }

    public byte[] getPeerId() {
        return this.peer_id;
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public int getEvent() {
        return this.event;
    }

    public int getNumWant() {
        return this.num_want;
    }

    public long getLeft() {
        return this.left;
    }

    public int getPort() {
        return this.port & 0xFFFF;
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public int getIPAddress() {
        return this.ip_address;
    }

    public int getKey() {
        return this.key;
    }

    public void setDetails(byte[] _hash, byte[] _peer_id, long _downloaded, int _event, int _ip_address, int _key, int _num_want, long _left, short _port, long _uploaded) {
        this.hash = _hash;
        this.peer_id = _peer_id;
        this.downloaded = _downloaded;
        this.event = _event;
        this.ip_address = _ip_address;
        this.key = _key;
        this.num_want = _num_want;
        this.left = _left;
        this.port = _port;
        this.uploaded = _uploaded;
    }

    @Override
    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        os.write(this.hash);
        os.write(this.peer_id);
        os.writeLong(this.downloaded);
        os.writeLong(this.left);
        os.writeLong(this.uploaded);
        os.writeInt(this.event);
        os.writeInt(this.ip_address);
        os.writeInt(this.key);
        os.writeInt(this.num_want);
        os.writeShort(this.port);
    }

    @Override
    public String getString() {
        return super.getString().concat("[").concat("hash=" + ByteFormatter.nicePrint(this.hash, true) + "peer=" + ByteFormatter.nicePrint(this.peer_id, true) + "dl=" + this.downloaded + "ev=" + this.event + "ip=" + this.ip_address + "key=" + this.key + "nw=" + this.num_want + "left=" + this.left + "port=" + this.port + "ul=" + this.uploaded + "]");
    }
}

