/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.util.StringInterner;

public class TRTrackerAnnouncerResponsePeerImpl
implements TRTrackerAnnouncerResponsePeer {
    private final String source;
    private final byte[] peer_id;
    private final String address;
    private final short tcp_port;
    private final short udp_port;
    private final short http_port;
    private final short crypto;
    private final byte az_version;
    private final short up_speed;

    public TRTrackerAnnouncerResponsePeerImpl(String _source, byte[] _peer_id, String _address, int _tcp_port, int _udp_port, int _http_port, short _crypto, byte _az_version, int _up_speed) {
        this.source = StringInterner.intern(_source);
        this.peer_id = _peer_id;
        this.address = StringInterner.intern(_address);
        this.tcp_port = (short)_tcp_port;
        this.udp_port = (short)_udp_port;
        this.http_port = (short)_http_port;
        this.crypto = _crypto;
        this.az_version = _az_version;
        this.up_speed = (short)_up_speed;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public byte[] getPeerID() {
        return this.peer_id;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public int getPort() {
        return this.tcp_port & 0xFFFF;
    }

    @Override
    public int getUDPPort() {
        return this.udp_port & 0xFFFF;
    }

    @Override
    public int getHTTPPort() {
        return this.http_port & 0xFFFF;
    }

    @Override
    public short getProtocol() {
        return this.crypto;
    }

    @Override
    public byte getAZVersion() {
        return this.az_version;
    }

    @Override
    public int getUploadSpeed() {
        return this.up_speed & 0xFFFF;
    }

    protected String getKey() {
        return this.address + ":" + this.tcp_port;
    }

    @Override
    public int compareTo(TRTrackerAnnouncerResponsePeer other) {
        return this.getString2(this).compareTo(this.getString2(other));
    }

    private String getString2(TRTrackerAnnouncerResponsePeer peer) {
        return peer.getAddress() + ":" + peer.getPort() + ":" + peer.getHTTPPort() + ":" + peer.getUDPPort();
    }

    public String getString() {
        return "ip=" + this.address + (this.tcp_port == 0 ? "" : ",tcp_port=" + this.getPort()) + (this.udp_port == 0 ? "" : ",udp_port=" + this.getUDPPort()) + (this.http_port == 0 ? "" : ",http_port=" + this.getHTTPPort()) + ",prot=" + this.crypto + (this.up_speed == 0 ? "" : ",up=" + this.getUploadSpeed()) + ",ver=" + this.az_version;
    }
}

