/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.core.tracker.TrackerPeerSourceAdapter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerHelper;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public abstract class TRTrackerAnnouncerImpl
implements TRTrackerAnnouncer {
    public static final LogIDs LOGID = LogIDs.TRACKER;
    protected static final int LDT_TRACKER_RESPONSE = 1;
    protected static final int LDT_URL_CHANGED = 2;
    protected static final int LDT_URL_REFRESH = 3;
    private static final String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private static final int key_id_length = 8;
    protected final ListenerManager<TRTrackerAnnouncerListener> listeners = ListenerManager.createManager("TrackerClient:ListenDispatcher", new ListenerManagerDispatcher<TRTrackerAnnouncerListener>(){

        @Override
        public void dispatch(TRTrackerAnnouncerListener listener, int type, Object value) {
            if (type == 1) {
                listener.receivedTrackerResponse((TRTrackerAnnouncerResponse)value);
            } else if (type == 2) {
                Object[] x = (Object[])value;
                URL old_url = (URL)x[0];
                URL new_url = (URL)x[1];
                boolean explicit = (Boolean)x[2];
                listener.urlChanged(TRTrackerAnnouncerImpl.this, old_url, new_url, explicit);
            } else {
                listener.urlRefresh();
            }
        }
    });
    final Map tracker_peer_cache = new LinkedHashMap();
    private final AEMonitor tracker_peer_cache_mon = new AEMonitor("TRTrackerClientClassic:PC");
    private int cache_peers_used;
    private final TOTorrent torrent;
    private final byte[] peer_id;
    private final String tracker_key;
    private final int udp_key;

    private static String createKeyID() {
        String key_id = "";
        for (int i = 0; i < 8; ++i) {
            int pos = RandomUtils.nextInt(chars.length());
            key_id = key_id + chars.charAt(pos);
        }
        return key_id;
    }

    protected TRTrackerAnnouncerImpl(TOTorrent _torrent) throws TRTrackerAnnouncerException {
        this.torrent = _torrent;
        this.tracker_key = TRTrackerAnnouncerImpl.createKeyID();
        this.udp_key = RandomUtils.nextInt();
        try {
            byte[] hash = null;
            try {
                hash = this.torrent.getHash();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.peer_id = ClientIDManagerImpl.getSingleton().generatePeerID(hash, false);
        }
        catch (ClientIDException e) {
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: Peer ID generation fails", e);
        }
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public Helper getHelper() {
        return new Helper(){

            @Override
            public byte[] getPeerID() {
                return TRTrackerAnnouncerImpl.this.peer_id;
            }

            @Override
            public String getTrackerKey() {
                return TRTrackerAnnouncerImpl.this.tracker_key;
            }

            @Override
            public int getUDPKey() {
                return TRTrackerAnnouncerImpl.this.udp_key;
            }

            @Override
            public void addToTrackerCache(TRTrackerAnnouncerResponsePeerImpl[] peers) {
                TRTrackerAnnouncerImpl.this.addToTrackerCache(peers);
            }

            @Override
            public TRTrackerAnnouncerResponsePeer[] getPeersFromCache(int num_want) {
                return TRTrackerAnnouncerImpl.this.getPeersFromCache(num_want);
            }

            @Override
            public void setTrackerResponseCache(Map map) {
                TRTrackerAnnouncerImpl.this.setTrackerResponseCache(map);
            }

            @Override
            public void removeFromTrackerResponseCache(String ip, int tcpPort) {
                TRTrackerAnnouncerImpl.this.removeFromTrackerResponseCache(ip, tcpPort);
            }

            @Override
            public Map getTrackerResponseCache() {
                return TRTrackerAnnouncerImpl.this.getTrackerResponseCache();
            }

            @Override
            public void informResponse(TRTrackerAnnouncerHelper helper, TRTrackerAnnouncerResponse response) {
                TRTrackerAnnouncerImpl.this.informResponse(helper, response);
            }

            @Override
            public void informURLChange(URL old_url, URL new_url, boolean explicit) {
                TRTrackerAnnouncerImpl.this.listeners.dispatch(2, new Object[]{old_url, new_url, explicit});
            }

            @Override
            public void informURLRefresh() {
                TRTrackerAnnouncerImpl.this.informURLRefresh();
            }

            @Override
            public void addListener(TRTrackerAnnouncerListener l) {
                TRTrackerAnnouncerImpl.this.addListener(l);
            }

            @Override
            public void removeListener(TRTrackerAnnouncerListener l) {
                TRTrackerAnnouncerImpl.this.removeListener(l);
            }
        };
    }

    @Override
    public byte[] getPeerId() {
        return this.peer_id;
    }

    public static byte[] getAnonymousPeerId(String my_ip, int my_port) {
        byte[] anon_peer_id = new byte[20];
        anon_peer_id[0] = 91;
        anon_peer_id[1] = 93;
        try {
            byte[] ip_bytes = my_ip.getBytes("UTF8");
            int ip_len = ip_bytes.length;
            if (ip_len > 18) {
                ip_len = 18;
            }
            System.arraycopy(ip_bytes, 0, anon_peer_id, 2, ip_len);
            int port_copy = my_port;
            for (int j = 2 + ip_len; j < 20; ++j) {
                anon_peer_id[j] = (byte)(port_copy & 0xFF);
                port_copy >>= 8;
            }
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
        }
        return anon_peer_id;
    }

    @Override
    public Map getTrackerResponseCache() {
        return this.exportTrackerCache();
    }

    @Override
    public void setTrackerResponseCache(Map map) {
        int num = this.importTrackerCache(map);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: imported " + num + " cached peers"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map exportTrackerCache() {
        LightHashMap res = new LightHashMap(1);
        ArrayList peers = new ArrayList();
        res.put("tracker_peers", peers);
        try {
            this.tracker_peer_cache_mon.enter();
            for (TRTrackerAnnouncerResponsePeer peer : this.tracker_peer_cache.values()) {
                int http_port;
                LightHashMap entry = new LightHashMap();
                entry.put("ip", peer.getAddress().getBytes());
                entry.put("src", peer.getSource().getBytes());
                entry.put("port", new Long(peer.getPort()));
                int udp_port = peer.getUDPPort();
                if (udp_port != 0) {
                    entry.put("udpport", new Long(udp_port));
                }
                if ((http_port = peer.getHTTPPort()) != 0) {
                    entry.put("httpport", new Long(http_port));
                }
                entry.put("prot", new Long(peer.getProtocol()));
                byte az_ver = peer.getAZVersion();
                if (az_ver != 1) {
                    entry.put("azver", new Long(az_ver));
                }
                entry.compactify(0.9f);
                peers.add(entry);
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: exported " + this.tracker_peer_cache.size() + " cached peers"));
            }
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int importTrackerCache(Map map) {
        if (!COConfigurationManager.getBooleanParameter("File.save.peers.enable")) {
            return 0;
        }
        if (map == null) {
            return 0;
        }
        List peers = (List)map.get("tracker_peers");
        if (peers == null) {
            return 0;
        }
        try {
            this.tracker_peer_cache_mon.enter();
            for (int i = 0; i < peers.size(); ++i) {
                Map peer = (Map)peers.get(i);
                byte[] src_bytes = (byte[])peer.get("src");
                String peer_source = src_bytes == null ? "Tracker" : new String(src_bytes);
                String peer_ip_address = new String((byte[])peer.get("ip"));
                int peer_tcp_port = ((Long)peer.get("port")).intValue();
                byte[] peer_peer_id = TRTrackerAnnouncerImpl.getAnonymousPeerId(peer_ip_address, peer_tcp_port);
                Long l_protocol = (Long)peer.get("prot");
                short protocol = l_protocol == null ? (short)1 : l_protocol.shortValue();
                Long l_udp_port = (Long)peer.get("udpport");
                int peer_udp_port = l_udp_port == null ? 0 : l_udp_port.intValue();
                Long l_http_port = (Long)peer.get("httpport");
                int peer_http_port = l_http_port == null ? 0 : l_http_port.intValue();
                Long l_az_ver = (Long)peer.get("azver");
                byte az_ver = l_az_ver == null ? (byte)1 : l_az_ver.byteValue();
                TRTrackerAnnouncerResponsePeerImpl entry = new TRTrackerAnnouncerResponsePeerImpl(peer_source, peer_peer_id, peer_ip_address, peer_tcp_port, peer_udp_port, peer_http_port, protocol, az_ver, 0);
                this.tracker_peer_cache.put(entry.getKey(), entry);
            }
            int n = this.tracker_peer_cache.size();
            this.tracker_peer_cache_mon.exit();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this.tracker_peer_cache_mon.exit();
                throw throwable;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                return this.tracker_peer_cache.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToTrackerCache(TRTrackerAnnouncerResponsePeerImpl[] peers) {
        if (!COConfigurationManager.getBooleanParameter("File.save.peers.enable")) {
            return;
        }
        int max = COConfigurationManager.getIntParameter("File.save.peers.max", 512);
        try {
            this.tracker_peer_cache_mon.enter();
            for (int i = 0; i < peers.length; ++i) {
                TRTrackerAnnouncerResponsePeerImpl peer = peers[i];
                this.tracker_peer_cache.remove(peer.getKey());
                this.tracker_peer_cache.put(peer.getKey(), peer);
            }
            Iterator it = this.tracker_peer_cache.keySet().iterator();
            if (max > 0) {
                while (this.tracker_peer_cache.size() > max) {
                    it.next();
                    it.remove();
                }
            }
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFromTrackerResponseCache(String ip, int tcp_port) {
        try {
            this.tracker_peer_cache_mon.enter();
            TRTrackerAnnouncerResponsePeerImpl peer = new TRTrackerAnnouncerResponsePeerImpl("", new byte[0], ip, tcp_port, 0, 0, 0, 0, 0);
            if (this.tracker_peer_cache.remove(peer.getKey()) != null && Logger.isEnabled()) {
                Logger.log(new LogEvent(this.getTorrent(), LOGID, "Explicit removal of peer cache for " + ip + ":" + tcp_port));
            }
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
    }

    public static Map mergeResponseCache(Map map1, Map map2) {
        List p2;
        if (map1 == null && map2 == null) {
            return new HashMap();
        }
        if (map1 == null) {
            return map2;
        }
        if (map2 == null) {
            return map1;
        }
        HashMap res = new HashMap();
        ArrayList peers = (ArrayList)map1.get("tracker_peers");
        if (peers == null) {
            peers = new ArrayList();
        }
        if ((p2 = (List)map2.get("tracker_peers")) != null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "TRTrackerClient: merged peer sets: p1 = " + peers.size() + ", p2 = " + p2.size()));
            }
            for (int i = 0; i < p2.size(); ++i) {
                peers.add(p2.get(i));
            }
        }
        res.put("tracker_peers", peers);
        return res;
    }

    protected abstract int getPeerCacheLimit();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerAnnouncerResponsePeer[] getPeersFromCache(int num_want) {
        int limit = this.getPeerCacheLimit();
        if (limit <= 0) {
            return new TRTrackerAnnouncerResponsePeer[0];
        }
        num_want = Math.min(limit, num_want);
        try {
            TRTrackerAnnouncerResponsePeer[] res;
            this.tracker_peer_cache_mon.enter();
            if (this.tracker_peer_cache.size() <= num_want) {
                res = new TRTrackerAnnouncerResponsePeerImpl[this.tracker_peer_cache.size()];
                this.tracker_peer_cache.values().toArray(res);
            } else {
                int i;
                res = new TRTrackerAnnouncerResponsePeerImpl[num_want];
                Iterator it = this.tracker_peer_cache.keySet().iterator();
                for (i = 0; i < num_want; ++i) {
                    String key = (String)it.next();
                    res[i] = (TRTrackerAnnouncerResponsePeerImpl)this.tracker_peer_cache.get(key);
                    it.remove();
                }
                for (i = 0; i < num_want; ++i) {
                    this.tracker_peer_cache.put(res[i].getKey(), res[i]);
                }
            }
            if (Logger.isEnabled()) {
                for (int i = 0; i < res.length; ++i) {
                    Logger.log(new LogEvent(this.getTorrent(), LOGID, "CACHED PEER: " + ((TRTrackerAnnouncerResponsePeerImpl)res[i]).getString()));
                }
                Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: returned " + res.length + " cached peers"));
            }
            this.cache_peers_used += res.length;
            TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray = res;
            return tRTrackerAnnouncerResponsePeerArray;
        }
        finally {
            this.tracker_peer_cache_mon.exit();
        }
    }

    @Override
    public TrackerPeerSource getCacheTrackerPeerSource() {
        return new TrackerPeerSourceAdapter(){

            @Override
            public String getName() {
                return MessageText.getString("tps.tracker.cache1", new String[]{String.valueOf(TRTrackerAnnouncerImpl.this.cache_peers_used)});
            }

            @Override
            public int getPeers() {
                return TRTrackerAnnouncerImpl.this.tracker_peer_cache.size();
            }
        };
    }

    protected void informResponse(TRTrackerAnnouncerHelper helper, TRTrackerAnnouncerResponse response) {
        this.listeners.dispatch(1, response);
    }

    protected void informURLRefresh() {
        this.listeners.dispatch(3, null);
    }

    @Override
    public void addListener(TRTrackerAnnouncerListener l) {
        this.listeners.addListener(l);
    }

    @Override
    public void removeListener(TRTrackerAnnouncerListener l) {
        this.listeners.removeListener(l);
    }

    public static interface Helper {
        public byte[] getPeerID();

        public String getTrackerKey();

        public int getUDPKey();

        public void addToTrackerCache(TRTrackerAnnouncerResponsePeerImpl[] var1);

        public TRTrackerAnnouncerResponsePeer[] getPeersFromCache(int var1);

        public void setTrackerResponseCache(Map var1);

        public void removeFromTrackerResponseCache(String var1, int var2);

        public Map getTrackerResponseCache();

        public void informResponse(TRTrackerAnnouncerHelper var1, TRTrackerAnnouncerResponse var2);

        public void informURLChange(URL var1, URL var2, boolean var3);

        public void informURLRefresh();

        public void addListener(TRTrackerAnnouncerListener var1);

        public void removeListener(TRTrackerAnnouncerListener var1);
    }
}

