/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrentdownloader.impl;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.core3.util.protocol.magnet.MagnetConnection;
import org.gudy.azureus2.core3.util.protocol.magnet.MagnetConnection2;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.xml.rss.RSSUtils;

public class TorrentDownloaderImpl
extends AEThread
implements TorrentDownloader {
    private String original_url;
    private String url_str;
    private Proxy proxy;
    private String referrer;
    private Map request_properties;
    private String file_str;
    private URL url;
    private URLConnection con;
    private String error = "Ok";
    private String status = "";
    private TorrentDownloaderCallBackInterface iface;
    private int state = -1;
    private int percentDone = 0;
    private int readTotal = 0;
    private boolean cancel = false;
    private String filename;
    private String directoryname;
    private File file = null;
    private final byte[] buf = new byte[1020];
    private int bufBytes = 0;
    private boolean deleteFileOnCancel = true;
    private boolean ignoreReponseCode = false;
    final AEMonitor this_mon = new AEMonitor("TorrentDownloader");
    private int errCode;

    public TorrentDownloaderImpl() {
        super("Torrent Downloader");
        this.setDaemon(true);
    }

    public void init(TorrentDownloaderCallBackInterface _iface, String _url, Proxy _proxy, String _referrer, Map _request_properties, String _file) {
        this.iface = _iface;
        this.original_url = _url;
        _url = _url.replace('\\', '/');
        _url = _url.replaceAll(" ", "%20");
        this.setName("TorrentDownloader: " + _url);
        this.url_str = _url;
        this.proxy = _proxy;
        this.referrer = _referrer;
        this.request_properties = _request_properties;
        this.file_str = _file;
        if (this.referrer == null || this.referrer.length() == 0) {
            try {
                this.referrer = this.url_str;
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    public void notifyListener() {
        if (this.iface != null) {
            this.iface.TorrentDownloaderEvent(this.state, this);
        } else if (this.state == 4) {
            System.err.println(this.error);
        }
    }

    private void cleanUpFile() {
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void error(int errCode, String err) {
        try {
            this.this_mon.enter();
            this.state = 4;
            this.setError(errCode, err);
            this.cleanUpFile();
            this.notifyListener();
        }
        finally {
            this.this_mon.exit();
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runSupport() {
        block132: {
            block129: {
                try {
                    new URL(this.url_str);
                }
                catch (Throwable t) {
                    String magnet_uri = UrlUtils.normaliseMagnetURI(this.url_str);
                    if (magnet_uri == null) break block129;
                    this.url_str = magnet_uri;
                }
            }
            try {
                int response;
                this.url = AddressUtils.adjustURL(new URL(this.url_str));
                String protocol = this.url.getProtocol().toLowerCase(Locale.US);
                if (protocol.equals("magnet") || protocol.equals("maggot") || protocol.equals("dht")) {
                    this.url = AddressUtils.adjustURL(new URL(this.url_str + (this.url_str.contains("?") ? "&" : "?") + "pause_on_error=true"));
                }
                HashSet<String> redirect_urls = new HashSet<String>();
                boolean follow_redirect = true;
                URL current_url = this.url;
                Proxy current_proxy = this.proxy;
                AEProxyFactory.PluginProxy current_plugin_proxy = AEProxyFactory.getPluginProxy(current_proxy);
                block54: while (follow_redirect) {
                    follow_redirect = false;
                    boolean dh_hack = false;
                    boolean internal_error_hack = false;
                    for (int connect_loop = 0; connect_loop < 3; ++connect_loop) {
                        protocol = current_url.getProtocol().toLowerCase(Locale.US);
                        try {
                            String move_to;
                            int response2;
                            if (protocol.equals("https")) {
                                HttpsURLConnection ssl_con = current_proxy == null ? (HttpsURLConnection)current_url.openConnection() : (HttpsURLConnection)current_url.openConnection(current_proxy);
                                if (!internal_error_hack) {
                                    ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                        @Override
                                        public boolean verify(String host, SSLSession session) {
                                            return true;
                                        }
                                    });
                                }
                                if (dh_hack) {
                                    UrlUtils.DHHackIt(ssl_con);
                                }
                                if (connect_loop > 0) {
                                    TrustManager[] trustAllCerts = SESecurityManager.getAllTrustingTrustManager();
                                    try {
                                        SSLContext sc = SSLContext.getInstance("SSL");
                                        sc.init(null, trustAllCerts, RandomUtils.SECURE_RANDOM);
                                        SSLSocketFactory factory = sc.getSocketFactory();
                                        ssl_con.setSSLSocketFactory(factory);
                                    }
                                    catch (Throwable e) {
                                        // empty catch block
                                    }
                                }
                                if (internal_error_hack && current_plugin_proxy != null) {
                                    String host = current_plugin_proxy.getURLHostRewrite();
                                    UrlUtils.HTTPSURLConnectionSNIHack(host, ssl_con);
                                }
                                this.con = ssl_con;
                            } else {
                                this.con = current_proxy == null ? current_url.openConnection() : current_url.openConnection(current_proxy);
                            }
                            if (this.con instanceof HttpURLConnection) {
                                ((HttpURLConnection)this.con).setInstanceFollowRedirects(this.proxy == null);
                            }
                            Properties props = new Properties();
                            ClientIDManagerImpl.getSingleton().getGenerator().generateHTTPProperties(null, props);
                            String ua = props.getProperty("User-Agent");
                            this.con.setRequestProperty("User-Agent", ua);
                            if (this.referrer != null && this.referrer.length() > 0) {
                                this.con.setRequestProperty("Referer", this.referrer);
                            }
                            if (this.request_properties != null) {
                                for (Map.Entry entry : this.request_properties.entrySet()) {
                                    String key = (String)entry.getKey();
                                    String value = (String)entry.getValue();
                                    if (key.equalsIgnoreCase("Accept-Encoding")) continue;
                                    this.con.setRequestProperty(key, value);
                                }
                            }
                            this.con.connect();
                            String magnetURI = this.con.getHeaderField("Magnet-Uri");
                            if (magnetURI != null) {
                                this.closeConnection();
                                this.url_str = magnetURI;
                                this.runSupport();
                                return;
                            }
                            int n = response2 = this.con instanceof HttpURLConnection ? ((HttpURLConnection)this.con).getResponseCode() : 200;
                            if (response2 != 302 && response2 != 301 || (move_to = this.con.getHeaderField("location")) == null || redirect_urls.contains(move_to) || redirect_urls.size() > 32) continue block54;
                            redirect_urls.add(move_to);
                            try {
                                AEProxyFactory.PluginProxy child;
                                URL move_to_url = new URL(move_to);
                                boolean follow = false;
                                if (current_plugin_proxy != null && (child = current_plugin_proxy.getChildProxy("redirect", move_to_url)) != null) {
                                    this.request_properties.put("HOST", child.getURLHostRewrite() + (move_to_url.getPort() == -1 ? "" : ":" + move_to_url.getPort()));
                                    current_proxy = child.getProxy();
                                    move_to_url = child.getURL();
                                    follow = true;
                                }
                                String original_protocol = current_url.getProtocol().toLowerCase();
                                String new_protocol = move_to_url.getProtocol().toLowerCase();
                                if (!follow && original_protocol.equals(new_protocol)) continue block54;
                                current_url = move_to_url;
                                try {
                                    List<String> cookies_list = this.con.getHeaderFields().get("Set-cookie");
                                    ArrayList<String> cookies_set = new ArrayList<String>();
                                    if (cookies_list != null) {
                                        for (int i = 0; i < cookies_list.size(); ++i) {
                                            String[] cookie_bits = cookies_list.get(i).split(";");
                                            if (cookie_bits.length <= 0) continue;
                                            cookies_set.add(cookie_bits[0]);
                                        }
                                    }
                                    if (cookies_set.size() > 0) {
                                        String new_cookies = "";
                                        Object obj = this.request_properties.get("Cookie");
                                        if (obj instanceof String) {
                                            new_cookies = (String)obj;
                                        }
                                        for (String s : cookies_set) {
                                            new_cookies = new_cookies + (new_cookies.length() == 0 ? "" : "; ") + s;
                                        }
                                        this.request_properties.put("Cookie", new_cookies);
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                                follow_redirect = true;
                            }
                            catch (Throwable e) {}
                            continue block54;
                        }
                        catch (SSLException e) {
                            if (connect_loop < 3) {
                                String msg = Debug.getNestedExceptionMessage(e);
                                boolean try_again = false;
                                if (msg.contains("DH keypair")) {
                                    if (!dh_hack) {
                                        dh_hack = true;
                                        try_again = true;
                                    }
                                } else if (msg.contains("internal_error") && !internal_error_hack) {
                                    internal_error_hack = true;
                                    try_again = true;
                                }
                                if (current_plugin_proxy == null && SESecurityManager.installServerCertificates(this.url) != null) {
                                    try_again = true;
                                }
                                if (this.url != current_url && current_plugin_proxy == null && SESecurityManager.installServerCertificates(current_url) != null) {
                                    try_again = true;
                                }
                                if (try_again) continue;
                            }
                            throw e;
                        }
                        catch (IOException e) {
                            if (connect_loop == 0) {
                                URL retry_url = UrlUtils.getIPV4Fallback(this.url);
                                if (retry_url != null) {
                                    this.url = retry_url;
                                } else {
                                    throw e;
                                }
                            }
                            if (!(e instanceof UnknownHostException)) continue;
                            throw e;
                        }
                    }
                }
                int n = response = this.con instanceof HttpURLConnection ? ((HttpURLConnection)this.con).getResponseCode() : 200;
                if (!this.ignoreReponseCode && response != 202 && response != 200) {
                    this.error(response, Integer.toString(response) + ": " + ((HttpURLConnection)this.con).getResponseMessage());
                    return;
                }
                this.filename = this.con.getHeaderField("Content-Disposition");
                if (this.filename != null && this.filename.toLowerCase().matches(".*attachment.*")) {
                    while (this.filename.toLowerCase().charAt(0) != 'a') {
                        this.filename = this.filename.substring(1);
                    }
                }
                Pattern p = Pattern.compile(".*filename=\\\"(.*)\\\"");
                Matcher m = null;
                if (this.filename != null && (m = p.matcher(this.filename)) != null && m.matches()) {
                    this.filename = m.group(1).trim();
                } else if (this.filename == null || !this.filename.toLowerCase().startsWith("attachment") || this.filename.indexOf(61) == -1) {
                    String tmp = this.url.getFile();
                    if (tmp.length() == 0 || tmp.equals("/")) {
                        this.filename = this.url.getHost();
                    } else if (tmp.startsWith("?")) {
                        int p2;
                        String query = tmp.toUpperCase();
                        int pos = query.indexOf("XT=URN:SHA1:");
                        if (pos == -1) {
                            pos = query.indexOf("XT=URN:BTIH:");
                        }
                        this.filename = pos != -1 ? ((p2 = query.indexOf("&", pos += 12)) == -1 ? query.substring(pos) : query.substring(pos, p2)) : "Torrent" + (long)(Math.random() * 9.223372036854776E18);
                        this.filename = this.filename + ".tmp";
                    } else {
                        int param_pos;
                        while (tmp.endsWith("/")) {
                            tmp = tmp.substring(0, tmp.length() - 1);
                        }
                        if (tmp.lastIndexOf(47) != -1) {
                            tmp = tmp.substring(tmp.lastIndexOf(47) + 1);
                        }
                        if ((param_pos = tmp.indexOf(63)) != -1) {
                            tmp = tmp.substring(0, param_pos);
                        }
                        this.filename = URLDecoder.decode(tmp, "UTF8");
                        if (this.filename.length() == 0) {
                            this.filename = "Torrent" + (long)(Math.random() * 9.223372036854776E18);
                        }
                    }
                } else {
                    this.filename = this.filename.substring(this.filename.indexOf(61) + 1);
                    if (this.filename.startsWith("\"") && this.filename.endsWith("\"")) {
                        this.filename = this.filename.substring(1, this.filename.lastIndexOf(34));
                    }
                    this.filename = URLDecoder.decode(this.filename, "UTF8");
                    File temp = new File(this.filename);
                    this.filename = temp.getName();
                }
                this.filename = FileUtil.convertOSSpecificChars(this.filename, false);
                this.directoryname = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
                boolean useTorrentSave = COConfigurationManager.getBooleanParameter("Save Torrent Files");
                if (this.file_str != null) {
                    File temp = new File(this.file_str);
                    if (!useTorrentSave || this.directoryname.length() == 0) {
                        this.directoryname = temp.isDirectory() ? temp.getCanonicalPath() : temp.getCanonicalFile().getParent();
                    }
                    if (!temp.isDirectory()) {
                        this.filename = temp.getName();
                    }
                }
                this.state = 0;
                this.notifyListener();
            }
            catch (MalformedURLException e) {
                this.error(0, "Exception while parsing URL '" + this.url_str + "':" + e.getMessage());
            }
            catch (UnknownHostException e) {
                this.error(0, "Exception while initializing download of '" + this.url + "': Unknown Host '" + e.getMessage() + "'");
            }
            catch (IOException ioe) {
                this.error(0, "I/O Exception while initializing download of '" + this.url + "':" + ioe.toString());
            }
            catch (Throwable e) {
                this.error(0, "Exception while initializing download of '" + this.url + "':" + e.toString());
            }
            if (this.state == 4) {
                return;
            }
            try {
                final boolean[] status_reader_run = new boolean[]{true};
                this.state = 1;
                this.notifyListener();
                this.state = 2;
                this.notifyListener();
                if (this.con instanceof HttpURLConnection) {
                    AEThread status_reader = new AEThread("TorrentDownloader:statusreader"){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void runSupport() {
                            HttpURLConnection http_con = (HttpURLConnection)TorrentDownloaderImpl.this.con;
                            boolean changed_status = false;
                            String last_status = "";
                            boolean sleep = false;
                            long last_progress_update = SystemTime.getMonotonousTime();
                            try {
                                while (true) {
                                    block18: {
                                        if (sleep) {
                                            Thread.sleep(50L);
                                            sleep = false;
                                        }
                                        try {
                                            TorrentDownloaderImpl.this.this_mon.enter();
                                            if (status_reader_run[0]) break block18;
                                            break;
                                        }
                                        finally {
                                            TorrentDownloaderImpl.this.this_mon.exit();
                                        }
                                    }
                                    String s = http_con.getResponseMessage();
                                    if (s.equals(last_status)) {
                                        sleep = true;
                                        continue;
                                    }
                                    last_status = s;
                                    String lc_s = s.toLowerCase();
                                    if (!lc_s.startsWith("error:")) {
                                        if (s.toLowerCase().contains("alive") && TorrentDownloaderImpl.this.percentDone < 10) {
                                            TorrentDownloaderImpl.this.percentDone++;
                                        }
                                        boolean progress_update = false;
                                        int pos = s.indexOf(37);
                                        if (pos != -1) {
                                            int i;
                                            for (i = pos - 1; i >= 0; --i) {
                                                char c = s.charAt(i);
                                                if (Character.isDigit(c) || c == ' ') continue;
                                                ++i;
                                                break;
                                            }
                                            try {
                                                TorrentDownloaderImpl.this.percentDone = Integer.parseInt(s.substring(i, pos).trim());
                                                progress_update = true;
                                            }
                                            catch (Throwable e) {
                                                // empty catch block
                                            }
                                        }
                                        if (lc_s.startsWith("received")) {
                                            progress_update = true;
                                        }
                                        if (progress_update) {
                                            long now = SystemTime.getMonotonousTime();
                                            if (now - last_progress_update < 250L) continue;
                                            last_progress_update = now;
                                        }
                                        TorrentDownloaderImpl.this.setStatus(s);
                                    } else {
                                        TorrentDownloaderImpl.this.error(http_con.getResponseCode(), s.substring(6));
                                    }
                                    changed_status = true;
                                }
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            if (changed_status) {
                                TorrentDownloaderImpl.this.setStatus("");
                            }
                        }
                    };
                    status_reader.setDaemon(true);
                    status_reader.start();
                }
                InputStream in = null;
                FileOutputStream fileout = null;
                try {
                    block130: {
                        try {
                            in = this.con.getInputStream();
                        }
                        catch (FileNotFoundException e) {
                            if (this.ignoreReponseCode) {
                                in = this.con instanceof HttpURLConnection ? ((HttpURLConnection)this.con).getErrorStream() : null;
                                break block130;
                            }
                            throw e;
                        }
                        finally {
                            try {
                                this.this_mon.enter();
                                status_reader_run[0] = false;
                            }
                            finally {
                                this.this_mon.exit();
                            }
                        }
                    }
                    String encoding = this.con.getHeaderField("content-encoding");
                    if (encoding != null) {
                        if (encoding.equalsIgnoreCase("gzip")) {
                            in = new GZIPInputStream(in);
                        } else if (encoding.equalsIgnoreCase("deflate")) {
                            in = new InflaterInputStream(in);
                        }
                    }
                    if (this.state == 4) break block132;
                    this.file = new File(this.directoryname, this.filename);
                    boolean useTempFile = this.file.exists();
                    if (!useTempFile) {
                        try {
                            this.file.createNewFile();
                            useTempFile = !this.file.exists();
                        }
                        catch (Throwable t) {
                            useTempFile = true;
                        }
                    }
                    if (useTempFile) {
                        this.file = File.createTempFile("AZU", ".torrent", new File(this.directoryname));
                        this.file.createNewFile();
                    }
                    fileout = new FileOutputStream(this.file, false);
                    this.bufBytes = 0;
                    int size = (int)UrlUtils.getContentLength(this.con);
                    this.percentDone = -1;
                    while (!this.cancel) {
                        try {
                            this.bufBytes = in.read(this.buf);
                            this.readTotal += this.bufBytes;
                            if (size > 0) {
                                this.percentDone = 100 * this.readTotal / size;
                            }
                            this.notifyListener();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        if (this.bufBytes > 0) {
                            fileout.write(this.buf, 0, this.bufBytes);
                        }
                        if (this.bufBytes > 0) continue;
                    }
                    in.close();
                    fileout.flush();
                    fileout.close();
                    if (this.cancel) {
                        this.state = 6;
                        if (this.deleteFileOnCancel) {
                            this.cleanUpFile();
                        }
                    } else {
                        block133: {
                            if (this.readTotal <= 0) {
                                this.error(0, "No data contained in '" + this.url.toString() + "'");
                                return;
                            }
                            try {
                                TOTorrent torrent;
                                String name;
                                File new_file;
                                if (!this.filename.toLowerCase().endsWith(".torrent") && this.file.renameTo(new_file = new File(this.directoryname, name = TorrentUtils.getLocalisedName(torrent = TorrentUtils.readFromFile(this.file, false)) + ".torrent"))) {
                                    this.filename = name;
                                    this.file = new_file;
                                }
                            }
                            catch (Throwable e) {
                                boolean is_vuze_file = false;
                                try {
                                    if (this.filename.toLowerCase().endsWith(".vuze")) {
                                        is_vuze_file = true;
                                    } else if (VuzeFileHandler.getSingleton().loadVuzeFile(this.file) != null) {
                                        is_vuze_file = true;
                                        String name = this.filename + ".vuze";
                                        File new_file = new File(this.directoryname, name);
                                        if (this.file.renameTo(new_file)) {
                                            this.filename = name;
                                            this.file = new_file;
                                        }
                                    }
                                }
                                catch (Throwable f) {
                                    // empty catch block
                                }
                                if (is_vuze_file || RSSUtils.isRSSFeed(this.file)) break block133;
                                Debug.printStackTrace(e);
                            }
                        }
                        if (this.proxy == null) {
                            TorrentUtils.setObtainedFrom(this.file, this.original_url);
                        }
                        this.state = 3;
                    }
                    this.notifyListener();
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable e) {}
                    }
                    if (fileout != null) {
                        try {
                            fileout.close();
                        }
                        catch (Throwable e) {}
                    }
                }
            }
            catch (Throwable e) {
                String url_log_string = this.url_str.toString().replaceAll("\\Q&pause_on_error=true\\E", "");
                String log_msg = MessageText.getString("torrentdownload.error.dl_fail", new String[]{url_log_string, this.file == null ? this.filename : this.file.getAbsolutePath(), e.getMessage()});
                if (!this.cancel) {
                    Debug.out(log_msg);
                }
                this.error(0, log_msg);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TorrentDownloaderImpl) {
            TorrentDownloaderImpl other = (TorrentDownloaderImpl)obj;
            if (other.original_url.equals(this.original_url)) {
                File this_file;
                File other_file = other.getFile();
                if (other_file == (this_file = this.file)) {
                    return true;
                }
                if (other_file == null || this_file == null) {
                    return false;
                }
                return other_file.getAbsolutePath().equals(this_file.getAbsolutePath());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.original_url.hashCode();
    }

    @Override
    public String getError() {
        return this.error;
    }

    public void setError(int errCode, String err) {
        this.error = err;
        this.errCode = errCode;
    }

    public int getErrorCode() {
        return this.errCode;
    }

    protected void setStatus(String str) {
        this.status = str;
        this.notifyListener();
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public File getFile() {
        if (!this.isAlive() || this.file == null) {
            this.file = new File(this.directoryname, this.filename);
        }
        return this.file;
    }

    @Override
    public int getPercentDone() {
        return this.percentDone;
    }

    @Override
    public int getDownloadState() {
        return this.state;
    }

    public void setDownloadState(int state) {
        this.state = state;
    }

    @Override
    public String getURL() {
        return this.url.toString();
    }

    @Override
    public void cancel() {
        this.cancel = true;
        this.closeConnection();
    }

    protected void closeConnection() {
        if (this.con instanceof MagnetConnection) {
            ((MagnetConnection)this.con).disconnect();
        } else if (this.con instanceof MagnetConnection2) {
            ((MagnetConnection2)this.con).disconnect();
        } else if (this.con instanceof HttpURLConnection) {
            ((HttpURLConnection)this.con).disconnect();
        }
    }

    @Override
    public void setDownloadPath(String path, String file) {
        if (!this.isAlive()) {
            if (path != null) {
                this.directoryname = path;
            }
            if (file != null) {
                this.filename = file;
            }
        }
    }

    @Override
    public int getTotalRead() {
        return this.readTotal;
    }

    @Override
    public byte[] getLastReadBytes() {
        if (this.bufBytes <= 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[this.bufBytes];
        System.arraycopy(this.buf, 0, bytes, 0, this.bufBytes);
        return bytes;
    }

    @Override
    public int getLastReadCount() {
        return this.bufBytes;
    }

    @Override
    public void setDeleteFileOnCancel(boolean deleteFileOnCancel) {
        this.deleteFileOnCancel = deleteFileOnCancel;
    }

    @Override
    public boolean getDeleteFileOnCancel() {
        return this.deleteFileOnCancel;
    }

    @Override
    public boolean isIgnoreReponseCode() {
        return this.ignoreReponseCode;
    }

    @Override
    public void setIgnoreReponseCode(boolean ignoreReponseCode) {
        this.ignoreReponseCode = ignoreReponseCode;
    }
}

