/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrentdownloader;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.torrentdownloader.impl.TorrentDownloaderImpl;
import org.gudy.azureus2.core3.torrentdownloader.impl.TorrentDownloaderManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;

public class TorrentDownloaderFactory {
    private static TorrentDownloaderImpl getClass(boolean logged) {
        try {
            return (TorrentDownloaderImpl)Class.forName("org.gudy.azureus2.core3.torrentdownloader.impl.TorrentDownloader" + (logged ? "Logged" : "") + "Impl").newInstance();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface callback, String url, String referrer, String fileordir, boolean logged) {
        return TorrentDownloaderFactory.create(callback, url, referrer, null, fileordir, logged);
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface callback, String url, String referrer, String fileordir) {
        return TorrentDownloaderFactory.create(callback, url, referrer, fileordir, false);
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface callback, String url, String referrer, Map request_properties, String fileordir) {
        return TorrentDownloaderFactory.create(callback, url, referrer, request_properties, fileordir, false);
    }

    private static TorrentDownloader create(TorrentDownloaderCallBackInterface callback, String url, String referrer, Map request_properties, String fileordir, boolean logged) {
        return new TorrentDownloadRetrier(callback, url, referrer, request_properties, fileordir, logged);
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface callback, String url, boolean logged) {
        return TorrentDownloaderFactory.create(callback, url, null, null, logged);
    }

    public static TorrentDownloader create(TorrentDownloaderCallBackInterface callback, String url) {
        return TorrentDownloaderFactory.create(callback, url, null, null, false);
    }

    public static TorrentDownloader create(String url, String fileordir, boolean logged) {
        return TorrentDownloaderFactory.create(null, url, null, fileordir, logged);
    }

    public static TorrentDownloader create(String url, String fileordir) {
        return TorrentDownloaderFactory.create(null, url, null, fileordir, false);
    }

    public static TorrentDownloader create(String url, boolean logged) {
        return TorrentDownloaderFactory.create(null, url, null, null, logged);
    }

    public static TorrentDownloader create(String url) {
        return TorrentDownloaderFactory.create(null, url, null, null, false);
    }

    public static void initManager(GlobalManager gm, boolean logged, boolean autostart, String downloaddir) {
        TorrentDownloaderManager.getInstance().init(gm, logged, autostart, downloaddir);
    }

    public static TorrentDownloader downloadManaged(String url, String fileordir, boolean logged) {
        return TorrentDownloaderManager.getInstance().download(url, fileordir, logged);
    }

    public static TorrentDownloader downloadManaged(String url, String fileordir) {
        return TorrentDownloaderManager.getInstance().download(url, fileordir);
    }

    public static TorrentDownloader downloadManaged(String url, boolean logged) {
        return TorrentDownloaderManager.getInstance().download(url, logged);
    }

    public static TorrentDownloader downloadManaged(String url) {
        return TorrentDownloaderManager.getInstance().download(url);
    }

    private static class TorrentDownloadRetrier
    implements TorrentDownloader {
        private final String url;
        private final String referrer;
        private final Map request_properties;
        private final String fileordir;
        private final boolean logged;
        private volatile TorrentDownloaderImpl delegate;
        private volatile boolean cancelled;
        private volatile boolean sdp_set;
        private volatile String sdp_path;
        private volatile String sdp_file;
        private volatile boolean dfoc_set;
        private volatile boolean dfoc;
        private volatile boolean irc_set;
        private volatile boolean irc;
        private volatile String original_error;

        private TorrentDownloadRetrier(final TorrentDownloaderCallBackInterface _callback, String _url, String _referrer, Map _request_properties, String _fileordir, boolean _logged) {
            this.url = _url;
            this.referrer = _referrer;
            this.request_properties = _request_properties;
            this.fileordir = _fileordir;
            this.logged = _logged;
            TorrentDownloaderCallBackInterface callback = new TorrentDownloaderCallBackInterface(){
                private final TorrentDownloaderCallBackInterface original_callback;
                private boolean no_retry;
                private boolean init_reported;
                private boolean start_reported;
                private boolean finish_reported;
                private boolean proxy_tried;
                private AEProxyFactory.PluginProxy plugin_proxy;
                {
                    this.original_callback = _callback;
                    this.no_retry = this.original_callback == null;
                    this.init_reported = false;
                    this.start_reported = false;
                    this.finish_reported = false;
                    this.proxy_tried = false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void TorrentDownloaderEvent(int state, TorrentDownloader _delegate) {
                    if (_delegate != TorrentDownloadRetrier.this.delegate) {
                        return;
                    }
                    if (state == 4 && TorrentDownloadRetrier.this.original_error == null) {
                        TorrentDownloadRetrier.this.original_error = TorrentDownloadRetrier.this.delegate.getError();
                    }
                    if (this.plugin_proxy != null && (state == 3 || state == 5 || state == 6 || state == 4)) {
                        this.plugin_proxy.setOK(state != 4);
                        this.plugin_proxy = null;
                    }
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        if (state == 0) {
                            if (this.init_reported) {
                                return;
                            }
                            this.init_reported = true;
                        }
                        if (state == 1) {
                            if (this.start_reported) {
                                return;
                            }
                            this.start_reported = true;
                        }
                        if (state == 3) {
                            if (this.finish_reported) {
                                return;
                            }
                            this.finish_reported = true;
                        }
                    }
                    if (TorrentDownloadRetrier.this.cancelled) {
                        this.no_retry = true;
                    }
                    if (this.no_retry) {
                        if (this.original_callback != null) {
                            this.original_callback.TorrentDownloaderEvent(state, TorrentDownloadRetrier.this);
                        }
                        return;
                    }
                    if (state == 3 || state == 5 || state == 6) {
                        if (state == 3 && this.proxy_tried) {
                            TorrentUtils.setObtainedFrom(TorrentDownloadRetrier.this.delegate.getFile(), TorrentDownloadRetrier.this.url);
                        }
                        if (this.original_callback != null) {
                            this.original_callback.TorrentDownloaderEvent(state, TorrentDownloadRetrier.this);
                        }
                        this.no_retry = true;
                        return;
                    }
                    if (state == 4) {
                        String lc_url = TorrentDownloadRetrier.this.url.toLowerCase().trim();
                        if (!this.proxy_tried) {
                            this.proxy_tried = true;
                            boolean tor_hack = lc_url.startsWith("tor:");
                            if (lc_url.startsWith("http") || tor_hack) {
                                try {
                                    URL original_url;
                                    if (tor_hack) {
                                        original_url = new URL(TorrentDownloadRetrier.this.url.substring(4));
                                        HashMap<String, Object> options = new HashMap<String, Object>();
                                        options.put("peer_networks", new String[]{"Tor"});
                                        this.plugin_proxy = AEProxyFactory.getPluginProxy("torrent download", original_url, options, true);
                                    } else {
                                        original_url = new URL(TorrentDownloadRetrier.this.url);
                                    }
                                    this.plugin_proxy = AEProxyFactory.getPluginProxy("torrent download", original_url);
                                    if (this.plugin_proxy != null) {
                                        TorrentDownloadRetrier.this.delegate = TorrentDownloaderFactory.getClass(TorrentDownloadRetrier.this.logged);
                                        if (TorrentDownloadRetrier.this.sdp_set) {
                                            TorrentDownloadRetrier.this.delegate.setDownloadPath(TorrentDownloadRetrier.this.sdp_path, TorrentDownloadRetrier.this.sdp_file);
                                        }
                                        if (TorrentDownloadRetrier.this.dfoc_set) {
                                            TorrentDownloadRetrier.this.delegate.setDeleteFileOnCancel(TorrentDownloadRetrier.this.dfoc);
                                        }
                                        if (TorrentDownloadRetrier.this.irc_set) {
                                            TorrentDownloadRetrier.this.delegate.setIgnoreReponseCode(TorrentDownloadRetrier.this.irc);
                                        }
                                        HashMap<String, String> props = new HashMap<String, String>();
                                        if (TorrentDownloadRetrier.this.request_properties != null) {
                                            props.putAll(TorrentDownloadRetrier.this.request_properties);
                                        }
                                        props.put("HOST", this.plugin_proxy.getURLHostRewrite() + (original_url.getPort() == -1 ? "" : ":" + original_url.getPort()));
                                        TorrentDownloadRetrier.this.delegate.init(this, this.plugin_proxy.getURL().toExternalForm(), this.plugin_proxy.getProxy(), TorrentDownloadRetrier.this.referrer == null ? original_url.toExternalForm() : TorrentDownloadRetrier.this.referrer, props, TorrentDownloadRetrier.this.fileordir);
                                        TorrentDownloadRetrier.this.delegate.start();
                                        return;
                                    }
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                        }
                        String retry_url = null;
                        if (lc_url.startsWith("http")) {
                            retry_url = UrlUtils.parseTextForURL(TorrentDownloadRetrier.this.url.substring(5), true);
                        }
                        if (retry_url != null) {
                            TorrentDownloadRetrier.this.delegate = TorrentDownloaderFactory.getClass(TorrentDownloadRetrier.this.logged);
                            if (TorrentDownloadRetrier.this.sdp_set) {
                                TorrentDownloadRetrier.this.delegate.setDownloadPath(TorrentDownloadRetrier.this.sdp_path, TorrentDownloadRetrier.this.sdp_file);
                            }
                            if (TorrentDownloadRetrier.this.dfoc_set) {
                                TorrentDownloadRetrier.this.delegate.setDeleteFileOnCancel(TorrentDownloadRetrier.this.dfoc);
                            }
                            if (TorrentDownloadRetrier.this.irc_set) {
                                TorrentDownloadRetrier.this.delegate.setIgnoreReponseCode(TorrentDownloadRetrier.this.irc);
                            }
                            TorrentDownloadRetrier.this.delegate.init(this, retry_url, null, TorrentDownloadRetrier.this.referrer, TorrentDownloadRetrier.this.request_properties, TorrentDownloadRetrier.this.fileordir);
                            this.no_retry = true;
                            TorrentDownloadRetrier.this.delegate.start();
                            return;
                        }
                        this.no_retry = true;
                    }
                    if (this.original_callback != null) {
                        this.original_callback.TorrentDownloaderEvent(state, TorrentDownloadRetrier.this);
                    }
                }
            };
            this.delegate = TorrentDownloaderFactory.getClass(this.logged);
            this.delegate.init(callback, this.url, null, this.referrer, this.request_properties, this.fileordir);
        }

        @Override
        public void start() {
            this.delegate.start();
        }

        @Override
        public void cancel() {
            this.cancelled = true;
            this.delegate.cancel();
        }

        @Override
        public void setDownloadPath(String path, String file) {
            this.sdp_set = true;
            this.sdp_path = path;
            this.sdp_file = file;
            this.delegate.setDownloadPath(path, file);
        }

        @Override
        public int getDownloadState() {
            return this.delegate.getDownloadState();
        }

        @Override
        public File getFile() {
            return this.delegate.getFile();
        }

        @Override
        public int getPercentDone() {
            return this.delegate.getPercentDone();
        }

        @Override
        public int getTotalRead() {
            return this.delegate.getTotalRead();
        }

        @Override
        public String getError() {
            if (this.original_error != null) {
                return this.original_error;
            }
            return this.delegate.getError();
        }

        @Override
        public String getStatus() {
            return this.delegate.getStatus();
        }

        @Override
        public String getURL() {
            return this.delegate.getURL();
        }

        @Override
        public int getLastReadCount() {
            return this.delegate.getLastReadCount();
        }

        @Override
        public byte[] getLastReadBytes() {
            return this.delegate.getLastReadBytes();
        }

        @Override
        public boolean getDeleteFileOnCancel() {
            return this.delegate.getDeleteFileOnCancel();
        }

        @Override
        public void setDeleteFileOnCancel(boolean deleteFileOnCancel) {
            this.dfoc_set = true;
            this.dfoc = deleteFileOnCancel;
            this.delegate.setDeleteFileOnCancel(deleteFileOnCancel);
        }

        @Override
        public boolean isIgnoreReponseCode() {
            return this.delegate.isIgnoreReponseCode();
        }

        @Override
        public void setIgnoreReponseCode(boolean ignoreReponseCode) {
            this.irc_set = true;
            this.irc = ignoreReponseCode;
            this.delegate.setIgnoreReponseCode(ignoreReponseCode);
        }
    }
}

