/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.StringInterner;

public class TOTorrentFileImpl
implements TOTorrentFile {
    private final TOTorrent torrent;
    private final int index;
    private final long file_length;
    private final byte[][] path_components;
    private final byte[][] path_components_utf8;
    private final int first_piece_number;
    private final int last_piece_number;
    private Map additional_properties_maybe_null;
    private final boolean is_utf8;

    protected TOTorrentFileImpl(TOTorrent _torrent, int _index, long _torrent_offset, long _len, String _path) throws TOTorrentException {
        this.torrent = _torrent;
        this.index = _index;
        this.file_length = _len;
        this.first_piece_number = (int)(_torrent_offset / this.torrent.getPieceLength());
        this.last_piece_number = (int)((_torrent_offset + this.file_length - 1L) / this.torrent.getPieceLength());
        this.is_utf8 = true;
        try {
            Vector<byte[]> temp = new Vector<byte[]>();
            int pos = 0;
            while (true) {
                int p1;
                if ((p1 = _path.indexOf(File.separator, pos)) == -1) break;
                temp.add(_path.substring(pos, p1).getBytes("UTF8"));
                pos = p1 + 1;
            }
            temp.add(_path.substring(pos).getBytes("UTF8"));
            this.path_components = new byte[temp.size()][];
            temp.copyInto((Object[])this.path_components);
            this.path_components_utf8 = new byte[temp.size()][];
            temp.copyInto((Object[])this.path_components_utf8);
            this.checkComponents();
        }
        catch (UnsupportedEncodingException e) {
            throw new TOTorrentException("Unsupported encoding for '" + _path + "'", 7);
        }
    }

    protected TOTorrentFileImpl(TOTorrent _torrent, int _index, long _torrent_offset, long _len, byte[][] _path_components) throws TOTorrentException {
        this.torrent = _torrent;
        this.index = _index;
        this.file_length = _len;
        this.path_components = _path_components;
        this.path_components_utf8 = null;
        this.first_piece_number = (int)(_torrent_offset / this.torrent.getPieceLength());
        this.last_piece_number = (int)((_torrent_offset + this.file_length - 1L) / this.torrent.getPieceLength());
        this.is_utf8 = false;
        this.checkComponents();
    }

    protected TOTorrentFileImpl(TOTorrent _torrent, int _index, long _torrent_offset, long _len, byte[][] _path_components, byte[][] _path_components_utf8) throws TOTorrentException {
        this.torrent = _torrent;
        this.index = _index;
        this.file_length = _len;
        this.path_components = _path_components;
        this.path_components_utf8 = _path_components_utf8;
        this.first_piece_number = (int)(_torrent_offset / this.torrent.getPieceLength());
        this.last_piece_number = (int)((_torrent_offset + this.file_length - 1L) / this.torrent.getPieceLength());
        this.is_utf8 = false;
        this.checkComponents();
    }

    protected void checkComponents() throws TOTorrentException {
        byte[][][] to_do;
        for (byte[][] pc : to_do = new byte[][][]{this.path_components, this.path_components_utf8}) {
            if (pc == null) continue;
            for (int i = 0; i < pc.length; ++i) {
                byte[] comp2 = pc[i];
                if (comp2.length == 2 && comp2[0] == 46 && comp2[1] == 46) {
                    throw new TOTorrentException("Torrent file contains illegal '..' component", 6);
                }
                if (i >= pc.length - 1) continue;
                pc[i] = StringInterner.internBytes(pc[i]);
            }
        }
    }

    @Override
    public TOTorrent getTorrent() {
        return this.torrent;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public long getLength() {
        return this.file_length;
    }

    public byte[][] getPathComponentsBasic() {
        return this.path_components;
    }

    @Override
    public byte[][] getPathComponents() {
        return this.path_components_utf8 == null ? this.path_components : this.path_components_utf8;
    }

    public byte[][] getPathComponentsUTF8() {
        return this.path_components_utf8;
    }

    protected boolean isUTF8() {
        return this.is_utf8;
    }

    protected void setAdditionalProperty(String name, Object value) {
        if (this.additional_properties_maybe_null == null) {
            this.additional_properties_maybe_null = new LightHashMap();
        }
        this.additional_properties_maybe_null.put(name, value);
    }

    @Override
    public Map getAdditionalProperties() {
        return this.additional_properties_maybe_null;
    }

    @Override
    public int getFirstPieceNumber() {
        return this.first_piece_number;
    }

    @Override
    public int getLastPieceNumber() {
        return this.last_piece_number;
    }

    @Override
    public int getNumberOfPieces() {
        return this.getLastPieceNumber() - this.getFirstPieceNumber() + 1;
    }

    @Override
    public String getRelativePath() {
        if (this.torrent == null) {
            return "";
        }
        byte[][] pathComponentsUTF8 = this.getPathComponentsUTF8();
        if (pathComponentsUTF8 != null) {
            StringBuilder sRelativePathSB = null;
            for (int j = 0; j < pathComponentsUTF8.length; ++j) {
                try {
                    String comp2;
                    try {
                        comp2 = new String(pathComponentsUTF8[j], "utf8");
                    }
                    catch (UnsupportedEncodingException e) {
                        System.out.println("file - unsupported encoding!!!!");
                        comp2 = "UnsupportedEncoding";
                    }
                    comp2 = FileUtil.convertOSSpecificChars(comp2, j != pathComponentsUTF8.length - 1);
                    if (j == 0) {
                        if (pathComponentsUTF8.length == 1) {
                            return comp2;
                        }
                        sRelativePathSB = new StringBuilder(512);
                    } else {
                        sRelativePathSB.append(File.separator);
                    }
                    sRelativePathSB.append(comp2);
                    continue;
                }
                catch (Exception ex) {
                    Debug.out(ex);
                }
            }
            return sRelativePathSB == null ? "" : sRelativePathSB.toString();
        }
        LocaleUtilDecoder decoder = null;
        try {
            decoder = LocaleTorrentUtil.getTorrentEncodingIfAvailable(this.torrent);
            if (decoder == null) {
                LocaleUtil localeUtil = LocaleUtil.getSingleton();
                decoder = localeUtil.getSystemDecoder();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (decoder != null) {
            StringBuilder sRelativePathSB = null;
            byte[][] components = this.getPathComponents();
            for (int j = 0; j < components.length; ++j) {
                try {
                    String comp3;
                    try {
                        comp3 = decoder.decodeString(components[j]);
                    }
                    catch (UnsupportedEncodingException e) {
                        System.out.println("file - unsupported encoding!!!!");
                        try {
                            comp3 = new String(components[j]);
                        }
                        catch (Exception e2) {
                            comp3 = "UnsupportedEncoding";
                        }
                    }
                    comp3 = FileUtil.convertOSSpecificChars(comp3, j != components.length - 1);
                    if (j == 0) {
                        if (components.length == 1) {
                            return comp3;
                        }
                        sRelativePathSB = new StringBuilder(512);
                    } else {
                        sRelativePathSB.append(File.separator);
                    }
                    sRelativePathSB.append(comp3);
                    continue;
                }
                catch (Exception ex) {
                    Debug.out(ex);
                }
            }
            return sRelativePathSB == null ? "" : sRelativePathSB.toString();
        }
        return "";
    }

    public Map serializeToMap() {
        Map file_additional_properties;
        HashMap<String, Serializable> file_map = new HashMap<String, Serializable>();
        file_map.put("length", new Long(this.getLength()));
        ArrayList<byte[]> path = new ArrayList<byte[]>();
        file_map.put("path", path);
        byte[][] path_comps = this.getPathComponentsBasic();
        if (path_comps != null) {
            for (int j = 0; j < path_comps.length; ++j) {
                path.add(path_comps[j]);
            }
        }
        if (path_comps != null && this.isUTF8()) {
            ArrayList<byte[]> utf8_path = new ArrayList<byte[]>();
            file_map.put("path.utf-8", utf8_path);
            for (int j = 0; j < path_comps.length; ++j) {
                utf8_path.add(path_comps[j]);
            }
        } else {
            byte[][] utf8_path_comps = this.getPathComponentsUTF8();
            if (utf8_path_comps != null) {
                ArrayList<byte[]> utf8_path = new ArrayList<byte[]>();
                file_map.put("path.utf-8", utf8_path);
                for (int j = 0; j < utf8_path_comps.length; ++j) {
                    utf8_path.add(utf8_path_comps[j]);
                }
            }
        }
        if ((file_additional_properties = this.getAdditionalProperties()) != null) {
            for (String key : file_additional_properties.keySet()) {
                file_map.put(key, (Serializable)file_additional_properties.get(key));
            }
        }
        return file_map;
    }
}

