/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileHasherListener;
import org.gudy.azureus2.core3.util.ED2KHasher;
import org.gudy.azureus2.core3.util.SHA1Hasher;

public class TOTorrentFileHasher {
    protected final boolean do_other_per_file_hash;
    protected final int piece_length;
    protected final Vector pieces = new Vector();
    protected final byte[] buffer;
    protected int buffer_pos;
    protected SHA1Hasher overall_sha1_hash;
    protected ED2KHasher overall_ed2k_hash;
    protected byte[] sha1_digest;
    protected byte[] ed2k_digest;
    protected byte[] per_file_sha1_digest;
    protected byte[] per_file_ed2k_digest;
    protected final TOTorrentFileHasherListener listener;
    protected boolean cancelled;

    protected TOTorrentFileHasher(boolean _do_other_overall_hashes, boolean _do_other_per_file_hash, int _piece_length, TOTorrentFileHasherListener _listener) {
        if (_do_other_overall_hashes) {
            this.overall_sha1_hash = new SHA1Hasher();
            this.overall_ed2k_hash = new ED2KHasher();
        }
        this.do_other_per_file_hash = _do_other_per_file_hash;
        this.piece_length = _piece_length;
        this.listener = _listener;
        this.buffer = new byte[this.piece_length];
    }

    long add(File _file) throws TOTorrentException {
        long file_length = 0L;
        InputStream is = null;
        SHA1Hasher sha1_hash = null;
        ED2KHasher ed2k_hash = null;
        try {
            if (this.do_other_per_file_hash) {
                sha1_hash = new SHA1Hasher();
                ed2k_hash = new ED2KHasher();
            }
            is = new BufferedInputStream(new FileInputStream(_file), 65536);
            while (true) {
                if (this.cancelled) {
                    throw new TOTorrentException("TOTorrentCreate: operation cancelled", 9);
                }
                int len = is.read(this.buffer, this.buffer_pos, this.piece_length - this.buffer_pos);
                if (len <= 0) break;
                if (this.do_other_per_file_hash) {
                    sha1_hash.update(this.buffer, this.buffer_pos, len);
                    ed2k_hash.update(this.buffer, this.buffer_pos, len);
                }
                file_length += (long)len;
                this.buffer_pos += len;
                if (this.buffer_pos != this.piece_length) continue;
                byte[] hash = new SHA1Hasher().calculateHash(this.buffer);
                if (this.overall_sha1_hash != null) {
                    this.overall_sha1_hash.update(this.buffer);
                    this.overall_ed2k_hash.update(this.buffer);
                }
                this.pieces.add(hash);
                if (this.listener != null) {
                    this.listener.pieceHashed(this.pieces.size());
                }
                this.buffer_pos = 0;
            }
            if (this.do_other_per_file_hash) {
                this.per_file_sha1_digest = sha1_hash.getDigest();
                this.per_file_ed2k_digest = ed2k_hash.getDigest();
            }
        }
        catch (TOTorrentException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new TOTorrentException("TOTorrentFileHasher: file read fails '" + e.toString() + "'", 4);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {}
            }
        }
        return file_length;
    }

    protected byte[] getPerFileSHA1Digest() {
        return this.per_file_sha1_digest;
    }

    protected byte[] getPerFileED2KDigest() {
        return this.per_file_ed2k_digest;
    }

    protected byte[][] getPieces() throws TOTorrentException {
        try {
            if (this.buffer_pos > 0) {
                byte[] rem = new byte[this.buffer_pos];
                System.arraycopy(this.buffer, 0, rem, 0, this.buffer_pos);
                this.pieces.addElement(new SHA1Hasher().calculateHash(rem));
                if (this.overall_sha1_hash != null) {
                    this.overall_sha1_hash.update(rem);
                    this.overall_ed2k_hash.update(rem);
                }
                if (this.listener != null) {
                    this.listener.pieceHashed(this.pieces.size());
                }
                this.buffer_pos = 0;
            }
            if (this.overall_sha1_hash != null && this.sha1_digest == null) {
                this.sha1_digest = this.overall_sha1_hash.getDigest();
                this.ed2k_digest = this.overall_ed2k_hash.getDigest();
            }
            byte[][] res = new byte[this.pieces.size()][];
            this.pieces.copyInto((Object[])res);
            return res;
        }
        catch (Throwable e) {
            throw new TOTorrentException("TOTorrentFileHasher: file read fails '" + e.toString() + "'", 4);
        }
    }

    protected byte[] getED2KDigest() throws TOTorrentException {
        if (this.ed2k_digest == null) {
            this.getPieces();
        }
        return this.ed2k_digest;
    }

    protected byte[] getSHA1Digest() throws TOTorrentException {
        if (this.sha1_digest == null) {
            this.getPieces();
        }
        return this.sha1_digest;
    }

    protected void cancel() {
        this.cancelled = true;
    }
}

