/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import org.gudy.azureus2.core3.html.HTMLUtils;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentImpl;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMapEx;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TOTorrentDeserialiseImpl
extends TOTorrentImpl {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TOTorrentDeserialiseImpl(File file) throws TOTorrentException {
        if (!file.exists()) {
            throw new TOTorrentException("Torrent file '" + file.toString() + "' does not exist", 1);
        }
        if (!file.isFile()) {
            throw new TOTorrentException("Torrent must be a file ('" + file.toString() + "')", 1);
        }
        if (file.length() == 0L) {
            throw new TOTorrentException("Torrent is zero length ('" + file.toString() + "')", 2);
        }
        InputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.construct(fis);
        }
        catch (Throwable e) {
            try {
                if (fis != null) {
                    fis.close();
                    fis = null;
                }
                fis = new GZIPInputStream(new FileInputStream(file));
                this.construct(fis);
            }
            catch (Throwable f) {
                throw new TOTorrentException("Error reading torrent file '" + file.toString() + " - " + Debug.getNestedExceptionMessage(e), 4);
            }
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public TOTorrentDeserialiseImpl(InputStream is) throws TOTorrentException {
        this.construct(is);
    }

    public TOTorrentDeserialiseImpl(byte[] bytes) throws TOTorrentException {
        this.construct(bytes);
    }

    public TOTorrentDeserialiseImpl(Map map) throws TOTorrentException {
        this.construct(map);
    }

    protected void construct(InputStream is) throws TOTorrentException {
        ByteArrayOutputStream metaInfo = new ByteArrayOutputStream(65536);
        try {
            int nbRead;
            byte[] buf = new byte[32768];
            int iFirstByte = is.read();
            if (iFirstByte != 100 && iFirstByte != 101 && iFirstByte != 105 && (iFirstByte < 48 || iFirstByte > 57)) {
                block9: {
                    try {
                        int nbRead2;
                        metaInfo.write(iFirstByte);
                        while ((nbRead2 = is.read(buf)) > 0 && metaInfo.size() < 32000) {
                            metaInfo.write(buf, 0, nbRead2);
                        }
                        String char_data = new String(metaInfo.toByteArray());
                        if (char_data.toLowerCase().contains("html")) {
                            char_data = HTMLUtils.convertHTMLToText2(char_data);
                            if ((char_data = HTMLUtils.splitWithLineLength(char_data, 80)).length() > 400) {
                                char_data = char_data.substring(0, 400) + "...";
                            }
                            throw new TOTorrentException("Contents maybe HTML:\n" + char_data, 6);
                        }
                    }
                    catch (Throwable e) {
                        if (!(e instanceof TOTorrentException)) break block9;
                        throw (TOTorrentException)e;
                    }
                }
                throw new TOTorrentException("Contents invalid - bad header", 6);
            }
            metaInfo.write(iFirstByte);
            while ((nbRead = is.read(buf)) > 0) {
                metaInfo.write(buf, 0, nbRead);
            }
        }
        catch (Throwable e) {
            throw new TOTorrentException("Error reading torrent: " + Debug.getNestedExceptionMessage(e), 4);
        }
        this.construct(metaInfo.toByteArray());
    }

    protected void construct(byte[] bytes) throws TOTorrentException {
        try {
            BDecoder decoder = new BDecoder();
            decoder.setVerifyMapOrder(true);
            Map<String, Object> meta_data = decoder.decodeByteArray(bytes);
            this.construct(meta_data);
        }
        catch (IOException e) {
            throw new TOTorrentException("Error reading torrent: " + Debug.getNestedExceptionMessage(e), 6, e);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void construct(Map meta_data) throws TOTorrentException {
        try {
            Map info;
            String announce_url = null;
            boolean got_announce = false;
            boolean got_announce_list = false;
            boolean bad_announce = false;
            for (String key : meta_data.keySet()) {
                if (key.equalsIgnoreCase("announce")) {
                    got_announce = true;
                    announce_url = this.readStringFromMetaData(meta_data, "announce");
                    if (announce_url == null || announce_url.trim().length() == 0) {
                        bad_announce = true;
                        continue;
                    }
                    announce_url = announce_url.replaceAll(" ", "");
                    try {
                        this.setAnnounceURL(new URL(announce_url));
                    }
                    catch (MalformedURLException e) {
                        if (!announce_url.contains("://")) {
                            announce_url = "http:/" + (announce_url.startsWith("/") ? "" : "/") + announce_url;
                        } else if (announce_url.startsWith("utp:")) {
                            announce_url = "udp" + announce_url.substring(3);
                        }
                        try {
                            this.setAnnounceURL(new URL(announce_url));
                        }
                        catch (MalformedURLException f) {
                            Debug.out("Invalid announce url: " + announce_url);
                            bad_announce = true;
                        }
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("announce-list")) {
                    got_announce_list = true;
                    List announce_list = null;
                    Object ann_list = meta_data.get("announce-list");
                    if (ann_list instanceof List) {
                        announce_list = (List)ann_list;
                    }
                    if (announce_list == null || announce_list.size() <= 0) continue;
                    announce_url = this.readStringFromMetaData(meta_data, "announce");
                    if (announce_url != null) {
                        announce_url = announce_url.replaceAll(" ", "");
                    }
                    boolean announce_url_found = false;
                    for (int i = 0; i < announce_list.size(); ++i) {
                        void var12_26;
                        Object e = announce_list.get(i);
                        if (e instanceof byte[]) {
                            ArrayList l = new ArrayList();
                            l.add(e);
                            ArrayList arrayList = l;
                        }
                        if (var12_26 instanceof List) {
                            Vector<URL> urls = new Vector<URL>();
                            List set = (List)var12_26;
                            while (set.size() > 0) {
                                Object temp2 = set.remove(0);
                                try {
                                    if (temp2 instanceof List) {
                                        List junk = (List)temp2;
                                        if (junk.size() <= 0) continue;
                                        set.add(junk.get(0));
                                        continue;
                                    }
                                    String url_str = this.readStringFromMetaData((byte[])temp2);
                                    url_str = url_str.replaceAll(" ", "");
                                    try {
                                        urls.add(new URL(StringInterner.intern(url_str)));
                                        if (!url_str.equalsIgnoreCase(announce_url)) continue;
                                        announce_url_found = true;
                                    }
                                    catch (MalformedURLException e2) {
                                        if (!url_str.contains("://")) {
                                            url_str = "http:/" + (url_str.startsWith("/") ? "" : "/") + url_str;
                                        } else if (url_str.startsWith("utp:")) {
                                            url_str = "udp" + url_str.substring(3);
                                        }
                                        try {
                                            urls.add(new URL(StringInterner.intern(url_str)));
                                            if (!url_str.equalsIgnoreCase(announce_url)) continue;
                                            announce_url_found = true;
                                        }
                                        catch (MalformedURLException f) {
                                            Debug.out("Invalid url: " + url_str, f);
                                        }
                                    }
                                }
                                catch (Throwable e3) {
                                    Debug.out("Torrent has invalid url-list entry (" + temp2 + ") - ignoring: meta=" + meta_data, e3);
                                }
                            }
                            if (urls.size() <= 0) continue;
                            Object[] url_array = new URL[urls.size()];
                            urls.copyInto(url_array);
                            this.addTorrentAnnounceURLSet((URL[])url_array);
                            continue;
                        }
                        Debug.out("Torrent has invalid url-list entry (" + var12_26 + ") - ignoring: meta=" + meta_data);
                    }
                    if (announce_url_found || announce_url == null || announce_url.length() <= 0) continue;
                    try {
                        Vector<URL> urls = new Vector<URL>();
                        urls.add(new URL(StringInterner.intern(announce_url)));
                        Object[] objectArray = new URL[urls.size()];
                        urls.copyInto(objectArray);
                        this.addTorrentAnnounceURLSet((URL[])objectArray);
                    }
                    catch (Exception e) {
                        Debug.out("Invalid URL '" + announce_url + "' - meta=" + meta_data, e);
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("comment")) {
                    this.setComment((byte[])meta_data.get("comment"));
                    continue;
                }
                if (key.equalsIgnoreCase("created by")) {
                    this.setCreatedBy((byte[])meta_data.get("created by"));
                    continue;
                }
                if (key.equalsIgnoreCase("creation date")) {
                    try {
                        Long creation_date = (Long)meta_data.get("creation date");
                        if (creation_date == null) continue;
                        this.setCreationDate(creation_date);
                    }
                    catch (Exception e) {
                        System.out.println("creation_date extraction fails, ignoring");
                    }
                    continue;
                }
                if (key.equalsIgnoreCase("info")) continue;
                Object prop = meta_data.get(key);
                if (prop instanceof byte[]) {
                    this.setAdditionalByteArrayProperty(key, (byte[])prop);
                    continue;
                }
                if (prop instanceof Long) {
                    this.setAdditionalLongProperty(key, (Long)prop);
                    continue;
                }
                if (prop instanceof List) {
                    this.setAdditionalListProperty(key, (List)prop);
                    continue;
                }
                this.setAdditionalMapProperty(key, (Map)prop);
            }
            if (bad_announce) {
                if (!got_announce_list) throw new TOTorrentException("ANNOUNCE_URL malformed ('" + announce_url + "'", 6);
                TOTorrentAnnounceURLSet[] sets = this.getAnnounceURLGroup().getAnnounceURLSets();
                if (sets.length <= 0) throw new TOTorrentException("ANNOUNCE_URL malformed ('" + announce_url + "' and no usable announce list)", 6);
                this.setAnnounceURL(sets[0].getAnnounceURLs()[0]);
            }
            if (!got_announce_list && !got_announce) {
                this.setAnnounceURL(TorrentUtils.getDecentralisedEmptyURL());
            }
            if (this.getAnnounceURL() == null) {
                TOTorrentAnnounceURLSet[] sets;
                boolean done = false;
                if (got_announce_list && (sets = this.getAnnounceURLGroup().getAnnounceURLSets()).length > 0) {
                    this.setAnnounceURL(sets[0].getAnnounceURLs()[0]);
                    done = true;
                }
                if (!done) {
                    this.setAnnounceURL(TorrentUtils.getDecentralisedEmptyURL());
                }
            }
            if ((info = (Map)meta_data.get("info")) == null) {
                throw new TOTorrentException("Decode fails, 'info' element not found'", 6);
            }
            boolean hasUTF8Keys = info.containsKey("name.utf-8");
            this.setName((byte[])info.get("name"));
            long piece_length = (Long)info.get("piece length");
            if (piece_length <= 0L) {
                throw new TOTorrentException("Decode fails, piece-length is invalid", 6);
            }
            this.setPieceLength(piece_length);
            this.setHashFromInfo(info);
            Long simple_file_length = (Long)info.get("length");
            long l = 0L;
            String encoding = this.getAdditionalStringProperty("encoding");
            hasUTF8Keys &= encoding == null || encoding.equals("utf8 keys");
            if (simple_file_length != null) {
                this.setSimpleTorrent(true);
                l = simple_file_length;
                if (hasUTF8Keys) {
                    this.setNameUTF8((byte[])info.get("name.utf-8"));
                    this.setAdditionalStringProperty("encoding", "utf8 keys");
                }
                this.setFiles(new TOTorrentFileImpl[]{new TOTorrentFileImpl((TOTorrent)this, 0, 0L, l, new byte[][]{this.getName()})});
            } else {
                Map file_map;
                this.setSimpleTorrent(false);
                List meta_files = (List)info.get("files");
                TOTorrentFileImpl[] files = new TOTorrentFileImpl[meta_files.size()];
                if (hasUTF8Keys) {
                    for (int i = 0; i < files.length && (hasUTF8Keys &= (file_map = (Map)meta_files.get(i)).containsKey("path.utf-8")); ++i) {
                    }
                    if (hasUTF8Keys) {
                        this.setNameUTF8((byte[])info.get("name.utf-8"));
                        this.setAdditionalStringProperty("encoding", "utf8 keys");
                    }
                }
                for (int i = 0; i < files.length; ++i) {
                    TOTorrentFileImpl file;
                    void var23_46;
                    file_map = (Map)meta_files.get(i);
                    long len = (Long)file_map.get("length");
                    List paths = (List)file_map.get("path");
                    List paths8 = (List)file_map.get("path.utf-8");
                    byte[][] byArray = null;
                    if (paths != null) {
                        byte[][] byArrayArray = new byte[paths.size()][];
                        for (int j = 0; j < paths.size(); ++j) {
                            byArrayArray[j] = (byte[])paths.get(j);
                        }
                    }
                    if (hasUTF8Keys) {
                        byte[][] path_comps8 = new byte[paths8.size()][];
                        for (int j = 0; j < paths8.size(); ++j) {
                            path_comps8[j] = (byte[])paths8.get(j);
                        }
                        file = files[i] = new TOTorrentFileImpl(this, i, l, len, (byte[][])var23_46, path_comps8);
                    } else {
                        file = files[i] = new TOTorrentFileImpl((TOTorrent)this, i, l, len, (byte[][])var23_46);
                    }
                    l += len;
                    for (String key : file_map.keySet()) {
                        if (key.equals("length") || key.equals("path")) continue;
                        file.setAdditionalProperty(key, file_map.get(key));
                    }
                }
                this.setFiles(files);
            }
            byte[] flat_pieces = (byte[])info.get("pieces");
            int pieces_required = (int)((l + (piece_length - 1L)) / piece_length);
            int pieces_supplied = flat_pieces.length / 20;
            if (pieces_supplied < pieces_required) {
                throw new TOTorrentException("Decode fails, insufficient pieces supplied", 6);
            }
            if (pieces_supplied > pieces_required) {
                Debug.out("Torrent '" + new String(this.getName()) + "' has too many pieces (required=" + pieces_required + ",supplied=" + pieces_supplied + ") - ignoring excess");
            }
            byte[][] pieces = new byte[pieces_supplied][20];
            for (int i = 0; i < pieces.length; ++i) {
                System.arraycopy(flat_pieces, i * 20, pieces[i], 0, 20);
            }
            this.setPieces(pieces);
            for (String key : info.keySet()) {
                if (key.equals("name") || key.equals("length") || key.equals("files") || key.equals("piece length") || key.equals("pieces")) continue;
                this.addAdditionalInfoProperty(key, info.get(key));
            }
            try {
                LightHashMapEx info_ex;
                byte[] ho = (byte[])info.get("hash-override");
                if (ho != null) {
                    this.setHashOverride(ho);
                    return;
                }
                if (!(info instanceof LightHashMapEx) || !(info_ex = (LightHashMapEx)info).getFlag((byte)1)) return;
                String name = this.getUTF8Name();
                if (name == null) {
                    name = new String(this.getName());
                }
                String string = MessageText.getString("torrent.decode.info.order.bad", new String[]{name});
                LogAlert alert = new LogAlert((Object)this, false, 1, string);
                alert.forceNotify = true;
                Logger.log(alert);
                return;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            return;
        }
        catch (Throwable e) {
            if (!(e instanceof TOTorrentException)) throw new TOTorrentException("Torrent decode fails '" + Debug.getNestedExceptionMessageAndStack(e) + "'", 6, e);
            throw (TOTorrentException)e;
        }
    }

    public void printMap() {
        try {
            this.print("", "root", this.serialiseToMap());
        }
        catch (TOTorrentException e) {
            Debug.printStackTrace(e);
        }
    }

    protected void print(String indent, String name, Map map) {
        System.out.println(indent + name + "{map}");
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if (value instanceof Map) {
                this.print(indent + "  ", key, (Map)value);
                continue;
            }
            if (value instanceof List) {
                this.print(indent + "  ", key, (List)value);
                continue;
            }
            if (value instanceof Long) {
                this.print(indent + "  ", key, (Long)value);
                continue;
            }
            this.print(indent + "  ", key, (byte[])value);
        }
    }

    protected void print(String indent, String name, List list) {
        System.out.println(indent + name + "{list}");
        Iterator it = list.iterator();
        int index = 0;
        while (it.hasNext()) {
            Object value = it.next();
            if (value instanceof Map) {
                this.print(indent + "  ", "[" + index + "]", (Map)value);
            } else if (value instanceof List) {
                this.print(indent + "  ", "[" + index + "]", (List)value);
            } else if (value instanceof Long) {
                this.print(indent + "  ", "[" + index + "]", (Long)value);
            } else {
                this.print(indent + "  ", "[" + index + "]", (byte[])value);
            }
            ++index;
        }
    }

    protected void print(String indent, String name, Long value) {
        System.out.println(indent + name + "{long} = " + value);
    }

    protected void print(String indent, String name, byte[] value) {
        String x = new String(value);
        boolean print = true;
        for (int i = 0; i < x.length(); ++i) {
            char c = x.charAt(i);
            if (c < '\u0080') continue;
            print = false;
            break;
        }
        if (print) {
            System.out.println(indent + name + "{byte[]} = " + x);
        } else {
            System.out.println(indent + name + "{byte[], length " + value.length + "}");
        }
    }
}

