/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.stats.transfer.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;

public class OverallStatsImpl
extends GlobalManagerAdapter
implements OverallStats {
    private static final long TEN_YEARS = 315360000L;
    private static final int STATS_PERIOD = 60000;
    private static final int SAVE_PERIOD = 600000;
    private static final int SAVE_TICKS = 10;
    final AzureusCore core;
    final GlobalManagerStats gm_stats;
    private DHT[] dhts;
    private long totalDownloaded;
    private long totalUploaded;
    private long totalUptime;
    private long markTime;
    private long markTotalDownloaded;
    private long markTotalUploaded;
    private long markTotalUptime;
    private long totalDHTUploaded;
    private long totalDHTDownloaded;
    private long lastDownloaded;
    private long lastUploaded;
    private long lastUptime;
    private long lastDHTUploaded;
    private long lastDHTDownloaded;
    private long totalProtocolUploaded;
    private long totalDataUploaded;
    private long totalProtocolDownloaded;
    private long totalDataDownloaded;
    private long lastProtocolUploaded;
    private long lastDataUploaded;
    private long lastProtocolDownloaded;
    private long lastDataDownloaded;
    private long[] lastSnapshot;
    private final long session_start_time = SystemTime.getCurrentTime();
    protected final AEMonitor this_mon = new AEMonitor("OverallStats");
    private int tick_count;

    private Map load(String filename) {
        return FileUtil.readResilientConfigFile(filename);
    }

    private Map load() {
        return this.load("azureus.statistics");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(String filename, Map map) {
        try {
            this.this_mon.enter();
            FileUtil.writeResilientConfigFile(filename, map);
        }
        finally {
            this.this_mon.exit();
        }
    }

    private void save(Map map) {
        this.save("azureus.statistics", map);
    }

    private void validateAndLoadValues(Map statisticsMap) {
        this.lastUptime = SystemTime.getCurrentTime() / 1000L;
        Map overallMap = (Map)statisticsMap.get("all");
        this.totalDownloaded = this.getLong(overallMap, "downloaded");
        this.totalUploaded = this.getLong(overallMap, "uploaded");
        this.totalUptime = this.getLong(overallMap, "uptime");
        this.markTime = this.getLong(overallMap, "mark_time");
        this.markTotalDownloaded = this.getLong(overallMap, "mark_downloaded");
        this.markTotalUploaded = this.getLong(overallMap, "mark_uploaded");
        this.markTotalUptime = this.getLong(overallMap, "mark_uptime");
        this.totalDHTDownloaded = this.getLong(overallMap, "dht_down");
        this.totalDHTUploaded = this.getLong(overallMap, "dht_up");
        this.totalProtocolUploaded = this.getLong(overallMap, "p_uploaded");
        this.totalDataUploaded = this.getLong(overallMap, "d_uploaded");
        this.totalProtocolDownloaded = this.getLong(overallMap, "p_downloaded");
        this.totalDataDownloaded = this.getLong(overallMap, "d_downloaded");
        long current_total_d_received = this.gm_stats.getTotalDataBytesReceived();
        long current_total_p_received = this.gm_stats.getTotalProtocolBytesReceived();
        long current_total_d_sent = this.gm_stats.getTotalDataBytesSent();
        long current_total_p_sent = this.gm_stats.getTotalProtocolBytesSent();
        this.lastSnapshot = new long[]{this.totalProtocolUploaded, this.totalDataUploaded, this.totalProtocolDownloaded, this.totalDataDownloaded, this.totalDHTUploaded, this.totalDHTDownloaded, current_total_p_sent, current_total_d_sent, current_total_p_received, current_total_d_received, 0L, 0L};
    }

    protected long getLong(Map map, String name) {
        if (map == null) {
            return 0L;
        }
        Object obj = map.get(name);
        if (!(obj instanceof Long)) {
            return 0L;
        }
        return (Long)obj;
    }

    public OverallStatsImpl(AzureusCore _core, GlobalManagerStats _gm_stats) {
        this.core = _core;
        this.gm_stats = _gm_stats;
        Map stats2 = this.load();
        this.validateAndLoadValues(stats2);
        HashSet<String> types = new HashSet<String>();
        types.add("xfer.upload.protocol.bytes.total");
        types.add("xfer.upload.data.bytes.total");
        types.add("xfer.download.protocol.bytes.total");
        types.add("xfer.download.data.bytes.total");
        AzureusCoreStats.registerProvider(types, new AzureusCoreStatsProvider(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void updateStats(Set types, Map values) {
                try {
                    OverallStatsImpl.this.this_mon.enter();
                    if (OverallStatsImpl.this.core.isStarted()) {
                        if (types.contains("xfer.upload.protocol.bytes.total")) {
                            values.put("xfer.upload.protocol.bytes.total", new Long(OverallStatsImpl.this.totalProtocolUploaded + (OverallStatsImpl.this.gm_stats.getTotalProtocolBytesSent() - OverallStatsImpl.this.lastProtocolUploaded)));
                        }
                        if (types.contains("xfer.upload.data.bytes.total")) {
                            values.put("xfer.upload.data.bytes.total", new Long(OverallStatsImpl.this.totalDataUploaded + (OverallStatsImpl.this.gm_stats.getTotalDataBytesSent() - OverallStatsImpl.this.lastDataUploaded)));
                        }
                        if (types.contains("xfer.download.protocol.bytes.total")) {
                            values.put("xfer.download.protocol.bytes.total", new Long(OverallStatsImpl.this.totalProtocolDownloaded + (OverallStatsImpl.this.gm_stats.getTotalProtocolBytesReceived() - OverallStatsImpl.this.lastProtocolDownloaded)));
                        }
                        if (types.contains("xfer.download.data.bytes.total")) {
                            values.put("xfer.download.data.bytes.total", new Long(OverallStatsImpl.this.totalDataDownloaded + (OverallStatsImpl.this.gm_stats.getTotalDataBytesReceived() - OverallStatsImpl.this.lastDataDownloaded)));
                        }
                    }
                }
                finally {
                    OverallStatsImpl.this.this_mon.exit();
                }
            }
        });
        this.core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            @Override
            public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                if (component instanceof GlobalManager) {
                    GlobalManager gm = (GlobalManager)component;
                    gm.addListener(OverallStatsImpl.this, false);
                    SimpleTimer.addPeriodicEvent("OverallStats", 60000L, new TimerEventPerformer(){

                        @Override
                        public void perform(TimerEvent event2) {
                            OverallStatsImpl.this.updateStats(false);
                        }
                    });
                }
            }
        });
    }

    @Override
    public int getAverageDownloadSpeed() {
        if (this.totalUptime > 1L) {
            return (int)(this.totalDownloaded / this.totalUptime);
        }
        return 0;
    }

    @Override
    public int getAverageUploadSpeed() {
        if (this.totalUptime > 1L) {
            return (int)(this.totalUploaded / this.totalUptime);
        }
        return 0;
    }

    @Override
    public long getDownloadedBytes() {
        return this.totalDownloaded;
    }

    @Override
    public long getUploadedBytes() {
        return this.totalUploaded;
    }

    @Override
    public long getTotalUpTime() {
        return this.totalUptime;
    }

    @Override
    public long getDownloadedBytes(boolean since_mark) {
        if (since_mark) {
            if (this.markTotalDownloaded > this.totalDownloaded) {
                this.markTotalDownloaded = this.totalDownloaded;
            }
            return this.totalDownloaded - this.markTotalDownloaded;
        }
        return this.totalDownloaded;
    }

    @Override
    public long getUploadedBytes(boolean since_mark) {
        if (since_mark) {
            if (this.markTotalUploaded > this.totalUploaded) {
                this.markTotalUploaded = this.totalUploaded;
            }
            return this.totalUploaded - this.markTotalUploaded;
        }
        return this.totalUploaded;
    }

    @Override
    public long getTotalUpTime(boolean since_mark) {
        if (since_mark) {
            if (this.markTotalUptime > this.totalUptime) {
                this.markTotalUptime = this.totalUptime;
            }
            return this.totalUptime - this.markTotalUptime;
        }
        return this.totalUptime;
    }

    @Override
    public int getAverageDownloadSpeed(boolean since_mark) {
        if (since_mark) {
            long up_time = this.getTotalUpTime(true);
            long down = this.getDownloadedBytes(true);
            if (up_time > 1L) {
                return (int)(down / up_time);
            }
            return 0;
        }
        return this.getAverageDownloadSpeed();
    }

    @Override
    public int getAverageUploadSpeed(boolean since_mark) {
        if (since_mark) {
            long up_time = this.getTotalUpTime(true);
            long up = this.getUploadedBytes(true);
            if (up_time > 1L) {
                return (int)(up / up_time);
            }
            return 0;
        }
        return this.getAverageUploadSpeed();
    }

    @Override
    public long getMarkTime() {
        return this.markTime;
    }

    @Override
    public void setMark() {
        this.markTime = SystemTime.getCurrentTime();
        this.markTotalDownloaded = this.totalDownloaded;
        this.markTotalUploaded = this.totalUploaded;
        this.markTotalUptime = this.totalUptime;
    }

    @Override
    public void clearMark() {
        this.markTime = 0L;
        this.markTotalDownloaded = 0L;
        this.markTotalUploaded = 0L;
        this.markTotalUptime = 0L;
    }

    @Override
    public long getSessionUpTime() {
        return (SystemTime.getCurrentTime() - this.session_start_time) / 1000L;
    }

    @Override
    public void destroyInitiated() {
        this.updateStats(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long[] getLastSnapshot() {
        try {
            this.this_mon.enter();
            long[] lArray = this.lastSnapshot;
            return lArray;
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStats(boolean force) {
        try {
            long delta;
            this.this_mon.enter();
            long current_time = SystemTime.getCurrentTime() / 1000L;
            if (current_time < this.lastUptime) {
                this.lastUptime = current_time;
                return;
            }
            long current_total_d_received = this.gm_stats.getTotalDataBytesReceived();
            long current_total_p_received = this.gm_stats.getTotalProtocolBytesReceived();
            long current_total_d_sent = this.gm_stats.getTotalDataBytesSent();
            long current_total_p_sent = this.gm_stats.getTotalProtocolBytesSent();
            long current_total_received = current_total_d_received + current_total_p_received;
            long current_total_sent = current_total_d_sent + current_total_p_sent;
            this.totalDownloaded += current_total_received - this.lastDownloaded;
            this.lastDownloaded = current_total_received;
            if (this.totalDownloaded < 0L) {
                this.totalDownloaded = 0L;
            }
            this.totalUploaded += current_total_sent - this.lastUploaded;
            this.lastUploaded = current_total_sent;
            if (this.totalUploaded < 0L) {
                this.totalUploaded = 0L;
            }
            this.totalDataDownloaded += current_total_d_received - this.lastDataDownloaded;
            this.lastDataDownloaded = current_total_d_received;
            if (this.totalDataDownloaded < 0L) {
                this.totalDataDownloaded = 0L;
            }
            this.totalProtocolDownloaded += current_total_p_received - this.lastProtocolDownloaded;
            this.lastProtocolDownloaded = current_total_p_received;
            if (this.totalProtocolDownloaded < 0L) {
                this.totalProtocolDownloaded = 0L;
            }
            this.totalDataUploaded += current_total_d_sent - this.lastDataUploaded;
            this.lastDataUploaded = current_total_d_sent;
            if (this.totalDataUploaded < 0L) {
                this.totalDataUploaded = 0L;
            }
            this.totalProtocolUploaded += current_total_p_sent - this.lastProtocolUploaded;
            this.lastProtocolUploaded = current_total_p_sent;
            if (this.totalProtocolUploaded < 0L) {
                this.totalProtocolUploaded = 0L;
            }
            if (this.dhts == null) {
                try {
                    PluginManager pm = this.core.getPluginManager();
                    if (pm.isInitialized()) {
                        PluginInterface dht_pi = pm.getPluginInterfaceByClass(DHTPlugin.class);
                        if (dht_pi == null) {
                            this.dhts = new DHT[0];
                        } else {
                            DHTPlugin plugin = (DHTPlugin)dht_pi.getPlugin();
                            if (!plugin.isInitialising()) {
                                this.dhts = plugin.isEnabled() ? ((DHTPlugin)dht_pi.getPlugin()).getDHTs() : new DHT[0];
                            }
                        }
                    }
                }
                catch (Throwable e) {
                    this.dhts = new DHT[0];
                }
            }
            long current_total_dht_up = 0L;
            long current_total_dht_down = 0L;
            if (this.dhts != null) {
                for (DHT dht : this.dhts) {
                    DHTTransportStats stats2 = dht.getTransport().getStats();
                    current_total_dht_up += stats2.getBytesSent();
                    current_total_dht_down += stats2.getBytesReceived();
                }
            }
            this.totalDHTUploaded += current_total_dht_up - this.lastDHTUploaded;
            this.lastDHTUploaded = current_total_dht_up;
            if (this.totalDHTUploaded < 0L) {
                this.totalDHTUploaded = 0L;
            }
            this.totalDHTDownloaded += current_total_dht_down - this.lastDHTDownloaded;
            this.lastDHTDownloaded = current_total_dht_down;
            if (this.totalDHTDownloaded < 0L) {
                this.totalDHTDownloaded = 0L;
            }
            if ((delta = current_time - this.lastUptime) > 100L || delta < 0L) {
                this.lastUptime = current_time;
                return;
            }
            if (this.totalUptime > 315360000L) {
                this.totalUptime = 0L;
            }
            if (this.totalUptime < 0L) {
                this.totalUptime = 0L;
            }
            this.totalUptime += delta;
            this.lastUptime = current_time;
            this.lastSnapshot = new long[]{this.totalProtocolUploaded, this.totalDataUploaded, this.totalProtocolDownloaded, this.totalDataDownloaded, this.totalDHTUploaded, this.totalDHTDownloaded, current_total_p_sent, current_total_d_sent, current_total_p_received, current_total_d_received, current_total_dht_up, current_total_dht_down};
            HashMap<String, Long> overallMap = new HashMap<String, Long>();
            overallMap.put("downloaded", new Long(this.totalDownloaded));
            overallMap.put("uploaded", new Long(this.totalUploaded));
            overallMap.put("uptime", new Long(this.totalUptime));
            overallMap.put("mark_time", new Long(this.markTime));
            overallMap.put("mark_downloaded", new Long(this.markTotalDownloaded));
            overallMap.put("mark_uploaded", new Long(this.markTotalUploaded));
            overallMap.put("mark_uptime", new Long(this.markTotalUptime));
            overallMap.put("dht_down", new Long(this.totalDHTDownloaded));
            overallMap.put("dht_up", new Long(this.totalDHTUploaded));
            overallMap.put("p_uploaded", new Long(this.totalProtocolUploaded));
            overallMap.put("d_uploaded", new Long(this.totalDataUploaded));
            overallMap.put("p_downloaded", new Long(this.totalProtocolDownloaded));
            overallMap.put("d_downloaded", new Long(this.totalDataDownloaded));
            HashMap<String, HashMap<String, Long>> map = new HashMap<String, HashMap<String, Long>>();
            map.put("all", overallMap);
            ++this.tick_count;
            if (force || this.tick_count % 10 == 0) {
                this.save(map);
            }
        }
        finally {
            this.this_mon.exit();
        }
    }
}

