/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.security.impl;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import org.gudy.azureus2.core3.security.impl.SESecurityManagerImpl;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.bouncycastle.asn1.x509.X509Name;
import org.gudy.bouncycastle.jce.X509V3CertificateGenerator;
import org.gudy.bouncycastle.jce.provider.BouncyCastleProvider;

public class SESecurityManagerBC {
    protected static void initialise() {
        block5: {
            try {
                Security.addProvider(new BouncyCastleProvider());
                KeyFactory kf = KeyFactory.getInstance("ECDSA", BouncyCastleProvider.PROVIDER_NAME);
                if (!Constants.IS_CVS_VERSION) break block5;
                String where = "";
                try {
                    where = BouncyCastleProvider.class.getClassLoader().getResource("org/gudy/bouncycastle/jce/provider/BouncyCastleProvider.class").toExternalForm();
                }
                catch (Throwable e) {
                    ClassLoader cl = BouncyCastleProvider.class.getClassLoader();
                    where = cl == null ? "<bootstrap>" : cl.toString();
                }
                if (!where.contains("Azureus2")) {
                    Debug.outNoStack("BC Provider '" + BouncyCastleProvider.PROVIDER_NAME + "' initialised successfully (loaded from " + where + ")");
                }
            }
            catch (Throwable e) {
                Debug.out("BC Provider initialisation failed", e);
            }
        }
    }

    public static Certificate createSelfSignedCertificate(SESecurityManagerImpl manager, String alias, String cert_dn, int strength) throws Exception {
        KeyPairGenerator kg = KeyPairGenerator.getInstance("RSA");
        kg.initialize(strength, RandomUtils.SECURE_RANDOM);
        KeyPair pair = kg.generateKeyPair();
        X509V3CertificateGenerator certificateGenerator = new X509V3CertificateGenerator();
        certificateGenerator.setSignatureAlgorithm("MD5WithRSAEncryption");
        certificateGenerator.setSerialNumber(new BigInteger("" + SystemTime.getCurrentTime()));
        X509Name issuer_dn = new X509Name(true, cert_dn);
        certificateGenerator.setIssuerDN(issuer_dn);
        X509Name subject_dn = new X509Name(true, cert_dn);
        certificateGenerator.setSubjectDN(subject_dn);
        Calendar not_after = Calendar.getInstance();
        not_after.add(1, 1);
        certificateGenerator.setNotAfter(not_after.getTime());
        certificateGenerator.setNotBefore(Calendar.getInstance().getTime());
        certificateGenerator.setPublicKey(pair.getPublic());
        X509Certificate certificate = certificateGenerator.generateX509Certificate(pair.getPrivate());
        Certificate[] certChain = new Certificate[]{certificate};
        manager.addCertToKeyStore(alias, pair.getPrivate(), certChain);
        return certificate;
    }
}

