/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.control;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Ignore;
import org.gudy.azureus2.core3.util.SystemTime;

public class SuperSeedPiece {
    private final int pieceNumber;
    private int level;
    private long timeFirstDistributed;
    private PEPeer firstReceiver;
    private int timeToReachAnotherPeer;
    private static final AEMonitor class_mon = new AEMonitor("SuperSeedPiece:class");

    public SuperSeedPiece(PEPeerControl manager, int _pieceNumber) {
        Ignore.ignore(manager);
        this.pieceNumber = _pieceNumber;
        this.level = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void peerHasPiece(PEPeer peer) {
        try {
            class_mon.enter();
            if (this.level < 2) {
                this.firstReceiver = peer;
                this.timeFirstDistributed = SystemTime.getCurrentTime();
                this.level = 2;
            } else if (peer != null && this.firstReceiver != null && this.level == 2) {
                this.timeToReachAnotherPeer = (int)(SystemTime.getCurrentTime() - this.timeFirstDistributed);
                this.firstReceiver.setUploadHint(this.timeToReachAnotherPeer);
                this.level = 3;
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public int getLevel() {
        return this.level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pieceRevealedToPeer() {
        try {
            class_mon.enter();
            this.level = 1;
        }
        finally {
            class_mon.exit();
        }
    }

    public int getPieceNumber() {
        return this.pieceNumber;
    }

    public void peerLeft() {
        if (this.level == 1) {
            this.level = 0;
        }
    }

    public void updateTime() {
        if (this.level < 2) {
            return;
        }
        if (this.timeToReachAnotherPeer > 0) {
            return;
        }
        if (this.firstReceiver == null) {
            return;
        }
        int timeToSend = (int)(SystemTime.getCurrentTime() - this.timeFirstDistributed);
        if (timeToSend > this.firstReceiver.getUploadHint()) {
            this.firstReceiver.setUploadHint(timeToSend);
        }
    }
}

