/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.logging.impl;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.ILogAlertListener;
import org.gudy.azureus2.core3.logging.ILogEventListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.Debug;

public class LoggerImpl {
    private static final int MAXHISTORY = 256;
    private static final boolean bLogToStdOut = System.getProperty("azureus.log.stdout") != null;
    private boolean bEventLoggingEnabled = false;
    private PrintStream psOldOut = null;
    private PrintStream psOldErr = null;
    private PrintStream psOut;
    private PrintStream psErr;
    private final List logListeners = new ArrayList();
    private AEDiagnosticsLogger alertLogger;
    private final List alertListeners = new ArrayList();
    private final List alertHistory = new ArrayList();
    private boolean logToStdErrAllowed = true;

    public LoggerImpl() {
        this.doRedirects();
    }

    public void init() {
        boolean overrideLog;
        this.bEventLoggingEnabled = true;
        final ConfigurationManager config = ConfigurationManager.getInstance();
        boolean bl = overrideLog = System.getProperty("azureus.overridelog") != null;
        if (overrideLog) {
            this.bEventLoggingEnabled = true;
        } else {
            this.bEventLoggingEnabled = config.getBooleanParameter("Logger.Enabled");
            config.addParameterListener("Logger.Enabled", new ParameterListener(){

                @Override
                public void parameterChanged(String parameterName) {
                    LoggerImpl.this.bEventLoggingEnabled = config.getBooleanParameter("Logger.Enabled");
                }
            });
        }
    }

    public void doRedirects() {
        try {
            if (System.out != this.psOut) {
                if (this.psOldOut == null) {
                    this.psOldOut = System.out;
                }
                this.psOut = new PrintStream(new RedirectorStream(this.psOldOut, LogIDs.STDOUT, 0));
                System.setOut(this.psOut);
            }
            if (System.err != this.psErr) {
                if (this.psOldErr == null) {
                    this.psOldErr = System.err;
                }
                this.psErr = new PrintStream(new RedirectorStream(this.psOldErr, LogIDs.STDERR, 3));
                System.setErr(this.psErr);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public boolean isEnabled() {
        return this.bEventLoggingEnabled;
    }

    public void log(LogEvent event2) {
        if (bLogToStdOut && this.psOldOut != null) {
            this.psOldOut.println(event2.text);
        }
        if (event2.entryType == 3) {
            if (AEDiagnostics.isStartupComplete()) {
                try {
                    Debug.outDiagLoggerOnly("[" + event2.logID + "] " + event2.text);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (this.logToStdErrAllowed && this.psOldErr != null && event2.logID != LogIDs.STDERR) {
                this.psOldErr.println("[" + event2.logID + "] " + event2.text);
            }
        }
        if (this.bEventLoggingEnabled) {
            for (int i = 0; i < this.logListeners.size(); ++i) {
                try {
                    Object listener = this.logListeners.get(i);
                    if (!(listener instanceof ILogEventListener)) continue;
                    ((ILogEventListener)listener).log(event2);
                    continue;
                }
                catch (Throwable e) {
                    if (!this.logToStdErrAllowed || this.psOldErr == null) continue;
                    this.psOldErr.println("Error while logging: " + e.getMessage());
                    e.printStackTrace(this.psOldErr);
                }
            }
        }
        if (event2.err != null && event2.entryType == 3) {
            Debug.printStackTrace(event2.err);
        }
    }

    public void logTextResource(LogEvent event2) {
        event2.text = MessageText.getString(event2.text);
        this.log(event2);
    }

    public void logTextResource(LogEvent event2, String[] params) {
        event2.text = MessageText.getString(event2.text, params);
        this.log(event2);
    }

    public void addListener(ILogEventListener aListener) {
        this.logListeners.add(aListener);
    }

    public void removeListener(ILogEventListener aListener) {
        this.logListeners.remove(aListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(LogAlert alert) {
        String logText = "Alert:" + alert.entryType + ":" + alert.text;
        LogEvent alertEvent = new LogEvent(LogIDs.ALERT, alert.entryType, logText);
        alertEvent.err = alert.err;
        Logger.log(alertEvent);
        LoggerImpl loggerImpl = this;
        synchronized (loggerImpl) {
            if (this.alertLogger == null) {
                this.alertLogger = AEDiagnostics.getLogger("alerts");
            }
        }
        Throwable error = alert.getError();
        if (error != null) {
            logText = logText + " (" + Debug.getNestedExceptionMessageAndStack(error) + ")";
        }
        this.alertLogger.log(logText);
        this.alertHistory.add(alert);
        if (this.alertHistory.size() > 256) {
            this.alertHistory.remove(0);
        }
        for (int i = 0; i < this.alertListeners.size(); ++i) {
            try {
                Object listener = this.alertListeners.get(i);
                if (!(listener instanceof ILogAlertListener)) continue;
                ((ILogAlertListener)listener).alertRaised(alert);
                continue;
            }
            catch (Throwable f) {
                if (this.psOldErr == null) continue;
                this.psOldErr.println("Error while alerting: " + f.getMessage());
                f.printStackTrace(this.psOldErr);
            }
        }
    }

    public void logTextResource(LogAlert alert) {
        alert.text = MessageText.getString(alert.text);
        this.log(alert);
    }

    public void logTextResource(LogAlert alert, String[] params) {
        alert.text = MessageText.getString(alert.text, params);
        this.log(alert);
    }

    public void addListener(ILogAlertListener l) {
        this.alertListeners.add(l);
        for (int i = 0; i < this.alertHistory.size(); ++i) {
            LogAlert alert = (LogAlert)this.alertHistory.get(i);
            l.alertRaised(alert);
        }
    }

    public void removeListener(ILogAlertListener l) {
        this.alertListeners.remove(l);
    }

    public PrintStream getOldStdErr() {
        return this.psOldErr;
    }

    public void allowLoggingToStdErr(boolean allowed) {
        this.logToStdErrAllowed = allowed;
    }

    private class RedirectorStream
    extends OutputStream {
        protected final PrintStream ps;
        protected final StringBuffer buffer = new StringBuffer(1024);
        protected final LogIDs logID;
        protected final int logType;

        protected RedirectorStream(PrintStream _ps, LogIDs _logID, int _logType) {
            this.ps = _ps;
            this.logType = _logType;
            this.logID = _logID;
        }

        @Override
        public void write(int data) {
            char c = (char)data;
            if (c == '\n') {
                if (!bLogToStdOut) {
                    this.ps.println(this.buffer);
                }
                LoggerImpl.this.log(new LogEvent(this.logID, this.logType, this.buffer.toString()));
                this.buffer.setLength(0);
            } else if (c != '\r') {
                this.buffer.append(c);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) {
            for (int i = off; i < off + len; ++i) {
                int d = b[i];
                if (d < 0) {
                    d += 256;
                }
                this.write(d);
            }
        }
    }
}

