/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.logging;

import com.aelitis.azureus.core.util.GeneralUtils;
import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class LogAlert
implements org.gudy.azureus2.plugins.logging.LogAlert {
    public static final int AT_INFORMATION = 0;
    public static final int AT_WARNING = 1;
    public static final int AT_ERROR = 3;
    public static final boolean REPEATABLE = true;
    public static final boolean UNREPEATABLE = false;
    public final int entryType;
    public Throwable err = null;
    public final boolean repeatable;
    public String text;
    public Object[] relatedTo;
    public int timeoutSecs = -1;
    public String details;
    public boolean forceNotify;

    public LogAlert(boolean repeatable, int type, String text) {
        this.entryType = type;
        this.text = text;
        this.repeatable = repeatable;
    }

    public LogAlert(boolean repeatable, int type, String text, int timeoutSecs) {
        this.entryType = type;
        this.text = text;
        this.repeatable = repeatable;
        this.timeoutSecs = timeoutSecs;
    }

    public LogAlert(Object[] relatedTo, boolean repeatable, int type, String text) {
        this(repeatable, type, text);
        this.relatedTo = relatedTo;
    }

    public LogAlert(Object relatedTo, boolean repeatable, int type, String text) {
        this(repeatable, type, text);
        this.relatedTo = new Object[]{relatedTo};
    }

    public LogAlert(boolean repeatable, String text, Throwable err) {
        this(repeatable, 3, text);
        this.err = err;
    }

    public LogAlert(boolean repeatable, int type, String text, Throwable err) {
        this(repeatable, type, text);
        this.err = err;
    }

    public LogAlert(Object relatedTo, boolean repeatable, String text, Throwable err) {
        this(repeatable, text, err);
        this.relatedTo = new Object[]{relatedTo};
    }

    @Override
    public int getGivenTimeoutSecs() {
        return this.timeoutSecs;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public Throwable getError() {
        return this.err;
    }

    @Override
    public int getType() {
        switch (this.entryType) {
            case 0: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    @Override
    public Object[] getContext() {
        if (this.relatedTo == null) {
            return null;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < this.relatedTo.length; ++i) {
            l.add(PluginCoreUtils.convert(this.relatedTo[i], false));
        }
        return l.toArray();
    }

    @Override
    public int getTimeoutSecs() {
        if (this.timeoutSecs != -1) {
            return this.timeoutSecs;
        }
        return COConfigurationManager.getIntParameter("Message Popup Autoclose in Seconds");
    }

    @Override
    public String getPlainText() {
        return GeneralUtils.stripOutHyperlinks(this.text);
    }
}

