/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipchecker.extipchecker.impl;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Vector;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerService;
import org.gudy.azureus2.core3.ipchecker.extipchecker.ExternalIPCheckerServiceListener;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public abstract class ExternalIPCheckerServiceImpl
implements ExternalIPCheckerService,
Cloneable {
    private static final int MAX_PAGE_SIZE = 4096;
    private static final String MSG_KEY_ROOT = "IPChecker.external";
    private final String name;
    private final String description;
    private final String url;
    private boolean completed;
    private final Vector listeners = new Vector();
    private final AEMonitor this_mon = new AEMonitor("ExtIPCheckServ");
    final AESemaphore timeout_sem = new AESemaphore("ExtIPCheckServ");

    protected ExternalIPCheckerServiceImpl(String name_key) {
        this.name = MessageText.getString(name_key + ".name");
        this.description = MessageText.getString(name_key + ".description");
        this.url = MessageText.getString(name_key + ".url");
    }

    @Override
    public void initiateCheck(long timeout) {
        this._clone().initiateCheckSupport(timeout);
    }

    protected ExternalIPCheckerServiceImpl _clone() {
        try {
            return (ExternalIPCheckerServiceImpl)this.clone();
        }
        catch (CloneNotSupportedException e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    protected void initiateCheckSupport(final long timeout) {
        AEThread t = new AEThread("IPChecker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void runSupport() {
                try {
                    ExternalIPCheckerServiceImpl.this.initiateCheckSupport();
                }
                finally {
                    ExternalIPCheckerServiceImpl.this.setComplete();
                }
            }
        };
        t.setDaemon(true);
        t.start();
        if (timeout > 0L) {
            AEThread t2 = new AEThread("IPChecker2"){

                @Override
                public void runSupport() {
                    try {
                        if (!ExternalIPCheckerServiceImpl.this.timeout_sem.reserve(timeout) && !ExternalIPCheckerServiceImpl.this.completed) {
                            ExternalIPCheckerServiceImpl.this.informFailure("timeout");
                            ExternalIPCheckerServiceImpl.this.setComplete();
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            };
            t2.setDaemon(true);
            t2.start();
        }
    }

    protected abstract void initiateCheckSupport();

    protected void setComplete() {
        this.completed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String loadPage(String url_string) {
        try {
            Object buffer;
            int len;
            String page;
            InputStream is;
            block17: {
                URL url = new URL(url_string);
                HttpURLConnection connection = null;
                is = null;
                connection = (HttpURLConnection)url.openConnection();
                int response = connection.getResponseCode();
                if (response == 202 || response == 200) {
                    is = connection.getInputStream();
                    page = "";
                    break block17;
                } else {
                    this.informFailure("httpinvalidresponse", "" + response);
                    String string = null;
                    return string;
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                        if (connection != null) {
                            connection.disconnect();
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            while (page.length() < 4096 && (len = is.read((byte[])(buffer = (Object)new byte[2048]))) >= 0) {
                page = page + new String((byte[])buffer, 0, len);
            }
            buffer = page;
            return buffer;
        }
        catch (Throwable e) {
            this.informFailure("httploadfail", e.toString());
            return null;
        }
    }

    protected String extractIPAddress(String str) {
        int pos = 0;
        while (pos < str.length()) {
            int p1 = str.indexOf(46, pos);
            if (p1 == -1) {
                this.informFailure("ipnotfound");
                return null;
            }
            if (p1 > 0 && Character.isDigit(str.charAt(p1 - 1))) {
                int p3;
                int p2;
                for (p2 = p1 - 1; p2 >= 0 && Character.isDigit(str.charAt(p2)); --p2) {
                }
                int dots = 0;
                for (p3 = ++p2 + 1; p3 < str.length(); ++p3) {
                    char c = str.charAt(p3);
                    if (c == '.') {
                        ++dots;
                        continue;
                    }
                    if (!Character.isDigit(c)) break;
                }
                if (dots == 3) {
                    return str.substring(p2, p3);
                }
            }
            pos = p1 + 1;
        }
        this.informFailure("ipnotfound");
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informSuccess(String ip) {
        try {
            this.this_mon.enter();
            if (!this.completed) {
                this.timeout_sem.releaseForever();
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ExternalIPCheckerServiceListener)this.listeners.elementAt(i)).checkComplete(this, ip);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informFailure(String msg_key) {
        try {
            this.this_mon.enter();
            this.informFailure(msg_key, null);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void informFailure(String msg_key, String extra) {
        try {
            this.this_mon.enter();
            if (!this.completed) {
                this.timeout_sem.releaseForever();
                String message = MessageText.getString("IPChecker.external." + msg_key);
                if (extra != null) {
                    message = message + ": " + extra;
                }
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ExternalIPCheckerServiceListener)this.listeners.elementAt(i)).checkFailed(this, message);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportProgress(String msg_key) {
        try {
            this.this_mon.enter();
            this.reportProgress(msg_key, null);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportProgress(String msg_key, String extra) {
        try {
            this.this_mon.enter();
            if (!this.completed) {
                String message = MessageText.getString(MSG_KEY_ROOT.concat(".").concat(msg_key));
                if (extra != null) {
                    message = message.concat(": ").concat(extra);
                }
                for (int i = 0; i < this.listeners.size(); ++i) {
                    ((ExternalIPCheckerServiceListener)this.listeners.elementAt(i)).reportProgress(this, message);
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ExternalIPCheckerServiceListener l) {
        try {
            this.this_mon.enter();
            this.listeners.addElement(l);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ExternalIPCheckerServiceListener l) {
        try {
            this.this_mon.enter();
            this.listeners.removeElement(l);
        }
        finally {
            this.this_mon.exit();
        }
    }
}

