/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderCandidate;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderFallback;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderReal;
import org.gudy.azureus2.core3.util.Debug;

public class LocaleUtil {
    private static final String systemEncoding = System.getProperty("file.encoding");
    private static final String[] manual_charset = new String[]{systemEncoding, "Big5", "EUC-JP", "EUC-KR", "GB18030", "GB2312", "GBK", "ISO-2022-JP", "ISO-2022-KR", "Shift_JIS", "KOI8-R", "TIS-620", "UTF8", "windows-1251", "ISO-8859-1"};
    protected static final String[] generalCharsets = new String[]{"ISO-8859-1", "UTF8", systemEncoding};
    private static final LocaleUtil singleton = new LocaleUtil();
    private final LocaleUtilDecoder[] all_decoders;
    private final LocaleUtilDecoder[] general_decoders;
    private LocaleUtilDecoder system_decoder;
    private final LocaleUtilDecoder fallback_decoder;

    public static LocaleUtil getSingleton() {
        return singleton;
    }

    private LocaleUtil() {
        int i;
        ArrayList<LocaleUtilDecoder> decoders = new ArrayList<LocaleUtilDecoder>();
        ArrayList<String> decoder_names = new ArrayList<String>();
        for (i = 0; i < manual_charset.length; ++i) {
            try {
                String name = manual_charset[i];
                CharsetDecoder decoder = Charset.forName(name).newDecoder();
                if (decoder != null) {
                    LocaleUtilDecoderReal lu_decoder = new LocaleUtilDecoderReal(decoders.size(), decoder);
                    decoder_names.add(lu_decoder.getName());
                    if (i == 0) {
                        this.system_decoder = lu_decoder;
                    }
                    decoders.add(lu_decoder);
                    continue;
                }
                if (i != 0) continue;
                Debug.out("System decoder failed to be found!!!!");
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        this.general_decoders = new LocaleUtilDecoder[generalCharsets.length];
        for (i = 0; i < this.general_decoders.length; ++i) {
            int gi = decoder_names.indexOf(generalCharsets[i]);
            if (gi == -1) continue;
            this.general_decoders[i] = (LocaleUtilDecoder)decoders.get(gi);
        }
        boolean show_all = COConfigurationManager.getBooleanParameter("File.Decoder.ShowAll");
        if (show_all) {
            SortedMap<String, Charset> m = Charset.availableCharsets();
            for (String charset_name : m.keySet()) {
                if (decoder_names.contains(charset_name)) continue;
                try {
                    CharsetDecoder decoder = Charset.forName(charset_name).newDecoder();
                    if (decoder == null) continue;
                    LocaleUtilDecoderReal lu_decoder = new LocaleUtilDecoderReal(decoders.size(), decoder);
                    decoders.add(lu_decoder);
                    decoder_names.add(lu_decoder.getName());
                }
                catch (Exception ignore) {}
            }
        }
        this.fallback_decoder = new LocaleUtilDecoderFallback(decoders.size());
        decoders.add(this.fallback_decoder);
        this.all_decoders = new LocaleUtilDecoder[decoders.size()];
        decoders.toArray(this.all_decoders);
    }

    public String getSystemEncoding() {
        return systemEncoding;
    }

    public LocaleUtilDecoder[] getDecoders() {
        return this.all_decoders;
    }

    public LocaleUtilDecoder[] getGeneralDecoders() {
        return this.general_decoders;
    }

    public LocaleUtilDecoder getFallBackDecoder() {
        return this.fallback_decoder;
    }

    public LocaleUtilDecoder getSystemDecoder() {
        return this.system_decoder;
    }

    protected LocaleUtilDecoderCandidate[] getCandidates(byte[] array) {
        LocaleUtilDecoderCandidate[] candidates = new LocaleUtilDecoderCandidate[this.all_decoders.length];
        boolean show_less_likely_conversions = COConfigurationManager.getBooleanParameter("File.Decoder.ShowLax");
        for (int i = 0; i < this.all_decoders.length; ++i) {
            candidates[i] = new LocaleUtilDecoderCandidate(i);
            try {
                LocaleUtilDecoder decoder = this.all_decoders[i];
                String str = decoder.tryDecode(array, show_less_likely_conversions);
                if (str == null) continue;
                candidates[i].setDetails(decoder, str);
                continue;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return candidates;
    }

    protected List getCandidateDecoders(byte[] array) {
        LocaleUtilDecoderCandidate[] candidates = this.getCandidates(array);
        ArrayList<LocaleUtilDecoder> decoders = new ArrayList<LocaleUtilDecoder>();
        for (int i = 0; i < candidates.length; ++i) {
            LocaleUtilDecoder d = candidates[i].getDecoder();
            if (d == null) continue;
            decoders.add(d);
        }
        return decoders;
    }

    protected List getCandidatesAsList(byte[] array) {
        LocaleUtilDecoderCandidate[] candidates = this.getCandidates(array);
        ArrayList<LocaleUtilDecoderCandidate> candidatesList = new ArrayList<LocaleUtilDecoderCandidate>();
        for (int i = 0; i < candidates.length; ++i) {
            if (candidates[i].getDecoder() == null) continue;
            candidatesList.add(candidates[i]);
        }
        return candidatesList;
    }
}

