/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.history.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerFactory;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.download.DownloadManagerStateFactory;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.history.DownloadHistory;
import org.gudy.azureus2.core3.history.DownloadHistoryEvent;
import org.gudy.azureus2.core3.history.DownloadHistoryListener;
import org.gudy.azureus2.core3.history.DownloadHistoryManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class DownloadHistoryManagerImpl
implements DownloadHistoryManager {
    private static final String CONFIG_ENABLED = "Download History Enabled";
    private static final String CONFIG_ACTIVE_FILE = "dlhistorya.config";
    private static final String CONFIG_DEAD_FILE = "dlhistoryd.config";
    private static final String CONFIG_ACTIVE_SIZE = "download.history.active.size";
    private static final String CONFIG_DEAD_SIZE = "download.history.dead.size";
    private static final int UPDATE_TYPE_ACTIVE = 1;
    private static final int UPDATE_TYPE_DEAD = 16;
    private static final int UPDATE_TYPE_BOTH = 17;
    private final AzureusCore azureus_core;
    private final ListenerManager<DownloadHistoryListener> listeners = ListenerManager.createAsyncManager("DHM", new ListenerManagerDispatcher<DownloadHistoryListener>(){

        @Override
        public void dispatch(DownloadHistoryListener listener, int type, Object value) {
            listener.downloadHistoryEventOccurred((DownloadHistoryEvent)value);
        }
    });
    final Object lock = new Object();
    private WeakReference<Map<Long, DownloadHistoryImpl>> history_active = new WeakReference<Object>(null);
    private WeakReference<Map<Long, DownloadHistoryImpl>> history_dead = new WeakReference<Object>(null);
    private volatile int active_history_size = COConfigurationManager.getIntParameter("download.history.active.size", 0);
    private volatile int dead_history_size = COConfigurationManager.getIntParameter("download.history.dead.size", 0);
    private Map<Long, DownloadHistoryImpl> active_dirty;
    private Map<Long, DownloadHistoryImpl> dead_dirty;
    private TimerEvent write_pending_event;
    private long active_load_time;
    private long dead_load_time;
    private boolean history_escaped = false;
    private final Map<Long, Long> redownload_cache = new HashMap<Long, Long>();
    private boolean enabled;

    public DownloadHistoryManagerImpl() {
        this.azureus_core = AzureusCoreFactory.getSingleton();
        COConfigurationManager.addAndFireParameterListener(CONFIG_ENABLED, new ParameterListener(){
            private boolean first_time = true;

            @Override
            public void parameterChanged(String name) {
                DownloadHistoryManagerImpl.this.setEnabledSupport(COConfigurationManager.getBooleanParameter(name), this.first_time);
                this.first_time = false;
            }
        });
        this.azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            @Override
            public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                if (component instanceof GlobalManager) {
                    GlobalManager global_manager = (GlobalManager)component;
                    global_manager.addListener(new GlobalManagerAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void downloadManagerAdded(DownloadManager dm) {
                            Object object = DownloadHistoryManagerImpl.this.lock;
                            synchronized (object) {
                                DownloadHistoryImpl new_dh;
                                long uid;
                                if (!DownloadHistoryManagerImpl.this.enabled || !DownloadHistoryManagerImpl.this.isMonitored(dm)) {
                                    return;
                                }
                                Map active_history = DownloadHistoryManagerImpl.this.getActiveHistory();
                                DownloadHistoryImpl old_dh = active_history.put(uid = (new_dh = new DownloadHistoryImpl(active_history, dm)).getUID(), new_dh);
                                if (old_dh != null) {
                                    DownloadHistoryManagerImpl.this.historyUpdated(old_dh, 2, 1);
                                }
                                if ((old_dh = (DownloadHistoryImpl)DownloadHistoryManagerImpl.this.getDeadHistory().remove(uid)) != null) {
                                    DownloadHistoryManagerImpl.this.historyUpdated(old_dh, 2, 16);
                                }
                                DownloadHistoryManagerImpl.this.historyUpdated(new_dh, 1, 1);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void downloadManagerRemoved(DownloadManager dm) {
                            Object object = DownloadHistoryManagerImpl.this.lock;
                            synchronized (object) {
                                if (!DownloadHistoryManagerImpl.this.enabled || !DownloadHistoryManagerImpl.this.isMonitored(dm)) {
                                    return;
                                }
                                long uid = DownloadHistoryManagerImpl.getUID(dm);
                                DownloadHistoryImpl dh = (DownloadHistoryImpl)DownloadHistoryManagerImpl.this.getActiveHistory().remove(uid);
                                if (dh != null) {
                                    Map dead_history = DownloadHistoryManagerImpl.this.getDeadHistory();
                                    dead_history.put(uid, dh);
                                    dh.setHistoryReference(dead_history);
                                    dh.setRemoveTime(SystemTime.getCurrentTime());
                                    DownloadHistoryManagerImpl.this.historyUpdated(dh, 3, 17);
                                }
                            }
                        }
                    }, false);
                    DownloadManagerFactory.addGlobalDownloadListener(new DownloadManagerAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void completionChanged(DownloadManager dm, boolean comp2) {
                            Object object = DownloadHistoryManagerImpl.this.lock;
                            synchronized (object) {
                                if (!DownloadHistoryManagerImpl.this.enabled || !DownloadHistoryManagerImpl.this.isMonitored(dm)) {
                                    return;
                                }
                                long uid = DownloadHistoryManagerImpl.getUID(dm);
                                DownloadHistoryImpl dh = (DownloadHistoryImpl)DownloadHistoryManagerImpl.this.getActiveHistory().get(uid);
                                if (dh != null && dh.updateCompleteTime(dm.getDownloadState())) {
                                    DownloadHistoryManagerImpl.this.historyUpdated(dh, 3, 1);
                                }
                            }
                        }
                    });
                    DownloadManagerStateFactory.addGlobalListener(new DownloadManagerStateAttributeListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void attributeEventOccurred(DownloadManager dm, String attribute, int event_type) {
                            Object object = DownloadHistoryManagerImpl.this.lock;
                            synchronized (object) {
                                if (!DownloadHistoryManagerImpl.this.enabled || !DownloadHistoryManagerImpl.this.isMonitored(dm)) {
                                    return;
                                }
                                long uid = DownloadHistoryManagerImpl.getUID(dm);
                                DownloadHistoryImpl dh = (DownloadHistoryImpl)DownloadHistoryManagerImpl.this.getActiveHistory().get(uid);
                                if (dh != null && dh.updateSaveLocation(dm)) {
                                    DownloadHistoryManagerImpl.this.historyUpdated(dh, 3, 1);
                                }
                            }
                        }
                    }, "canosavedir", 1);
                    if (DownloadHistoryManagerImpl.this.enabled && !FileUtil.resilientConfigFileExists(DownloadHistoryManagerImpl.CONFIG_ACTIVE_FILE)) {
                        DownloadHistoryManagerImpl.this.resetHistory();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopping(AzureusCore core) {
                Object object = DownloadHistoryManagerImpl.this.lock;
                synchronized (object) {
                    DownloadHistoryManagerImpl.this.writeHistory();
                    COConfigurationManager.setParameter(DownloadHistoryManagerImpl.CONFIG_ACTIVE_SIZE, DownloadHistoryManagerImpl.this.active_history_size);
                    COConfigurationManager.setParameter(DownloadHistoryManagerImpl.CONFIG_DEAD_SIZE, DownloadHistoryManagerImpl.this.dead_history_size);
                }
            }
        });
        SimpleTimer.addPeriodicEvent("DHM:timer", 60000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent event2) {
                Object object = DownloadHistoryManagerImpl.this.lock;
                synchronized (object) {
                    DownloadHistoryManagerImpl.this.checkDiscard();
                }
            }
        });
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        COConfigurationManager.setParameter(CONFIG_ENABLED, enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnabledSupport(boolean b, boolean startup) {
        Object object = this.lock;
        synchronized (object) {
            if (this.enabled == b) {
                return;
            }
            this.enabled = b;
            if (!startup) {
                if (this.enabled) {
                    this.resetHistory();
                } else {
                    this.clearHistory();
                }
            }
        }
    }

    private boolean isMonitored(DownloadManager dm) {
        if (dm.isPersistent()) {
            long flags = dm.getDownloadState().getFlags();
            return (flags & 0x210L) == 0L;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncFromExisting(GlobalManager global_manager) {
        if (global_manager == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            List<DownloadManager> dms = global_manager.getDownloadManagers();
            Map<Long, DownloadHistoryImpl> history = this.getActiveHistory();
            if (history.size() > 0) {
                ArrayList<DownloadHistoryImpl> existing = new ArrayList<DownloadHistoryImpl>(history.values());
                history.clear();
                this.historyUpdated(new ArrayList<DownloadHistory>(existing), 2, 1);
            }
            for (DownloadManager dm : dms) {
                if (!this.isMonitored(dm)) continue;
                DownloadHistoryImpl new_dh = new DownloadHistoryImpl(history, dm);
                history.put(new_dh.getUID(), new_dh);
            }
            this.historyUpdated(new ArrayList<DownloadHistory>(history.values()), 1, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DownloadHistory> getHistory() {
        Object object = this.lock;
        synchronized (object) {
            Map<Long, DownloadHistoryImpl> active = this.getActiveHistory();
            Map<Long, DownloadHistoryImpl> dead = this.getDeadHistory();
            ArrayList<DownloadHistory> result = new ArrayList<DownloadHistory>(active.size() + dead.size());
            result.addAll(active.values());
            result.addAll(dead.values());
            return result;
        }
    }

    @Override
    public int getHistoryCount() {
        return this.active_history_size + this.dead_history_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHistory(List<DownloadHistory> to_remove) {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<DownloadHistory> removed = new ArrayList<DownloadHistory>(to_remove.size());
            int update_type = 0;
            Map<Long, DownloadHistoryImpl> active = this.getActiveHistory();
            Map<Long, DownloadHistoryImpl> dead = this.getDeadHistory();
            for (DownloadHistory h : to_remove) {
                long uid = h.getUID();
                DownloadHistoryImpl r = active.remove(uid);
                if (r != null) {
                    removed.add(r);
                    update_type |= 1;
                    continue;
                }
                r = dead.remove(uid);
                if (r == null) continue;
                removed.add(r);
                update_type |= 0x10;
            }
            if (removed.size() > 0) {
                this.historyUpdated(removed, 2, update_type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearHistory() {
        Object object = this.lock;
        synchronized (object) {
            Map<Long, DownloadHistoryImpl> active = this.getActiveHistory();
            Map<Long, DownloadHistoryImpl> dead = this.getDeadHistory();
            int update_type = 0;
            List<DownloadHistory> entries = this.getHistory();
            if (active.size() > 0) {
                active.clear();
                update_type |= 1;
            }
            if (dead.size() > 0) {
                dead.clear();
                update_type |= 0x10;
            }
            if (update_type != 0) {
                this.historyUpdated(entries, 2, update_type);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetHistory() {
        Object object = this.lock;
        synchronized (object) {
            this.clearHistory();
            this.syncFromExisting(this.azureus_core.getGlobalManager());
        }
    }

    @Override
    public long[] getDates(byte[] hash) {
        List<DownloadHistory> history = this.getHistory();
        for (DownloadHistory dh : history) {
            if (!Arrays.equals(hash, dh.getTorrentHash())) continue;
            Long rdl = this.redownload_cache.remove(dh.getUID());
            long[] result = new long[]{dh.getAddTime(), dh.getCompleteTime(), dh.getRemoveTime(), rdl == null ? 0L : rdl};
            return result;
        }
        return null;
    }

    private void setRedownloading(DownloadHistory dh) {
        this.redownload_cache.put(dh.getUID(), SystemTime.getCurrentTime());
    }

    private static long getUID(DownloadManager dm) {
        long lhs;
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            lhs = 0L;
        } else {
            try {
                byte[] hash = torrent.getHash();
                lhs = hash[0] << 24 & 0xFF000000 | hash[1] << 16 & 0xFF0000 | hash[2] << 8 & 0xFF00 | hash[3] & 0xFF;
            }
            catch (Throwable e) {
                lhs = 0L;
            }
        }
        long date_added = dm.getDownloadState().getLongAttribute("stats.download.added.time");
        long rhs = date_added / 1000L;
        return lhs << 32 | rhs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(DownloadHistoryListener listener, boolean fire_for_existing) {
        Object object = this.lock;
        synchronized (object) {
            this.history_escaped = true;
            this.listeners.addListener(listener);
            if (fire_for_existing) {
                List<DownloadHistory> history = this.getHistory();
                this.listeners.dispatch(listener, 0, new DownloadHistoryEventImpl(1, history));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(DownloadHistoryListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.removeListener(listener);
            if (this.listeners.size() == 0L) {
                this.history_escaped = false;
            }
        }
    }

    private Map<Long, DownloadHistoryImpl> getActiveHistory() {
        Map<Long, DownloadHistoryImpl> ref = (Map<Long, DownloadHistoryImpl>)this.history_active.get();
        if (ref == null) {
            ref = this.loadHistory(CONFIG_ACTIVE_FILE);
            this.active_load_time = SystemTime.getMonotonousTime();
            this.history_active = new WeakReference<Map<Long, DownloadHistoryImpl>>(ref);
            this.active_history_size = ref.size();
        }
        return ref;
    }

    private Map<Long, DownloadHistoryImpl> getDeadHistory() {
        Map<Long, DownloadHistoryImpl> ref = (Map<Long, DownloadHistoryImpl>)this.history_dead.get();
        if (ref == null) {
            ref = this.loadHistory(CONFIG_DEAD_FILE);
            this.dead_load_time = SystemTime.getMonotonousTime();
            this.history_dead = new WeakReference<Map<Long, DownloadHistoryImpl>>(ref);
            this.dead_history_size = ref.size();
        }
        return ref;
    }

    private void historyUpdated(DownloadHistory dh, int action, int type) {
        ArrayList<DownloadHistory> list = new ArrayList<DownloadHistory>(1);
        list.add(dh);
        this.historyUpdated(list, action, type);
    }

    private void historyUpdated(Collection<DownloadHistory> list, int action, int type) {
        if ((type & 1) != 0) {
            Map<Long, DownloadHistoryImpl> active = this.getActiveHistory();
            this.active_history_size = active.size();
            this.active_dirty = active;
        }
        if ((type & 0x10) != 0) {
            Map<Long, DownloadHistoryImpl> dead = this.getDeadHistory();
            this.dead_history_size = dead.size();
            this.dead_dirty = dead;
        }
        if (this.write_pending_event == null) {
            this.write_pending_event = SimpleTimer.addEvent("DHL:write", SystemTime.getOffsetTime(15000L), new TimerEventPerformer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void perform(TimerEvent event2) {
                    Object object = DownloadHistoryManagerImpl.this.lock;
                    synchronized (object) {
                        DownloadHistoryManagerImpl.this.write_pending_event = null;
                        DownloadHistoryManagerImpl.this.writeHistory();
                    }
                }
            });
        }
        this.listeners.dispatch(0, new DownloadHistoryEventImpl(action, new ArrayList<DownloadHistory>(list)));
    }

    private void checkDiscard() {
        if (this.history_escaped) {
            return;
        }
        long now = SystemTime.getMonotonousTime();
        if (now - this.active_load_time > 30000L && this.active_dirty == null && this.history_active.get() != null) {
            this.history_active.clear();
        }
        if (now - this.dead_load_time > 30000L && this.dead_dirty == null && this.history_dead.get() != null) {
            this.history_dead.clear();
        }
    }

    private void writeHistory() {
        if (this.active_dirty != null) {
            this.saveHistory(CONFIG_ACTIVE_FILE, this.active_dirty);
            this.active_dirty = null;
        }
        if (this.dead_dirty != null) {
            this.saveHistory(CONFIG_DEAD_FILE, this.dead_dirty);
            this.dead_dirty = null;
        }
    }

    private Map<Long, DownloadHistoryImpl> loadHistory(String file) {
        HashMap<Long, DownloadHistoryImpl> result = new HashMap<Long, DownloadHistoryImpl>();
        try {
            if (FileUtil.resilientConfigFileExists(file)) {
                Map map = FileUtil.readResilientConfigFile(file);
                List list = (List)map.get("records");
                for (Map m : list) {
                    try {
                        DownloadHistoryImpl record = new DownloadHistoryImpl(result, m);
                        result.put(record.getUID(), record);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return result;
    }

    private void saveHistory(String file, Map<Long, DownloadHistoryImpl> records) {
        try {
            HashMap map = new HashMap();
            ArrayList<Map> list = new ArrayList<Map>(records.size());
            map.put("records", list);
            for (DownloadHistoryImpl record : records.values()) {
                try {
                    Map m = record.exportToMap();
                    list.add(m);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            FileUtil.writeResilientConfigFile(file, map);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    private static class DownloadHistoryEventImpl
    implements DownloadHistoryEvent {
        private final int type;
        private final List<DownloadHistory> history;

        private DownloadHistoryEventImpl(int _type, List<DownloadHistory> _history) {
            this.type = _type;
            this.history = _history;
        }

        @Override
        public int getEventType() {
            return this.type;
        }

        @Override
        public List<DownloadHistory> getHistory() {
            return this.history;
        }
    }

    private class DownloadHistoryImpl
    implements DownloadHistory {
        private final long uid;
        private final byte[] hash;
        private final long size;
        private String name = "test test test";
        private String save_location = "somewhere or other";
        private long add_time = -1L;
        private long complete_time = -1L;
        private long remove_time = -1L;
        private Map<Long, DownloadHistoryImpl> history_ref;

        private DownloadHistoryImpl(Map<Long, DownloadHistoryImpl> _history_ref, DownloadManager dm) {
            this.history_ref = _history_ref;
            this.uid = DownloadHistoryManagerImpl.getUID(dm);
            byte[] h = null;
            TOTorrent torrent = dm.getTorrent();
            if (torrent != null) {
                try {
                    h = torrent.getHash();
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            this.hash = h;
            this.name = dm.getDisplayName();
            this.size = dm.getSize();
            this.save_location = dm.getSaveLocation().getAbsolutePath();
            DownloadManagerState dms = dm.getDownloadState();
            this.add_time = dms.getLongParameter("stats.download.added.time");
            this.updateCompleteTime(dms);
        }

        private DownloadHistoryImpl(Map<Long, DownloadHistoryImpl> _history_ref, Map<String, Object> map) throws IOException {
            this.history_ref = _history_ref;
            try {
                this.uid = (Long)map.get("u");
                this.hash = (byte[])map.get("h");
                this.name = new String((byte[])map.get("n"), "UTF-8");
                this.save_location = new String((byte[])map.get("s"), "UTF-8");
                Long l_size = (Long)map.get("z");
                this.size = l_size == null ? 0L : l_size;
                this.add_time = (Long)map.get("a");
                this.complete_time = (Long)map.get("c");
                this.remove_time = (Long)map.get("r");
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IOException("History decode failed: " + Debug.getNestedExceptionMessage(e));
            }
        }

        private void setHistoryReference(Map<Long, DownloadHistoryImpl> ref) {
            this.history_ref = ref;
        }

        private Map<String, Object> exportToMap() throws IOException {
            LightHashMap<String, Object> map = new LightHashMap<String, Object>();
            map.put("u", this.uid);
            map.put("h", this.hash);
            map.put("n", this.name.getBytes("UTF-8"));
            map.put("z", this.size);
            map.put("s", this.save_location.getBytes("UTF-8"));
            map.put("a", this.add_time);
            map.put("c", this.complete_time);
            map.put("r", this.remove_time);
            return map;
        }

        private boolean updateCompleteTime(DownloadManagerState dms) {
            long old_time = this.complete_time;
            long comp2 = dms.getLongAttribute("complt");
            this.complete_time = comp2 == 0L ? dms.getLongParameter("stats.download.completed.time") : comp2;
            return this.complete_time != old_time;
        }

        private boolean updateSaveLocation(DownloadManager dm) {
            String old_location = this.save_location;
            String loc = dm.getSaveLocation().getAbsolutePath();
            if (!loc.equals(old_location)) {
                this.save_location = loc;
                return true;
            }
            return false;
        }

        @Override
        public long getUID() {
            return this.uid;
        }

        @Override
        public byte[] getTorrentHash() {
            return this.hash;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public long getSize() {
            return this.size;
        }

        @Override
        public String getSaveLocation() {
            return this.save_location;
        }

        @Override
        public long getAddTime() {
            return this.add_time;
        }

        @Override
        public long getCompleteTime() {
            return this.complete_time;
        }

        private void setRemoveTime(long time) {
            this.remove_time = time;
        }

        @Override
        public long getRemoveTime() {
            return this.remove_time;
        }

        @Override
        public void setRedownloading() {
            DownloadHistoryManagerImpl.this.setRedownloading(this);
        }
    }
}

